/**
 * Copyright (c) 2013, Redsolution LTD. All rights reserved.
 *
 * This file is part of Xabber project; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License, Version 3.
 *
 * Xabber is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License,
 * along with this program. If not, see http://www.gnu.org/licenses/.
 */
package com.xabber.xmpp.archive;

import java.io.IOException;

import org.xmlpull.v1.XmlSerializer;

import com.xabber.xmpp.IQ;
import com.xabber.xmpp.SerializerUtils;

/**
 * Packet to change automatic message archive preference.
 * <p/>
 * http://xmpp.org/extensions/xep-0136.html
 *
 * @author alexander.ivanov
 */
public class Auto extends IQ {

    public static final String ELEMENT_NAME = "auto";
    public static final String NAMESPACE = "urn:xmpp:archive";

    public static final String SAVE_ATTRIBUTE = "save";

    private boolean save;

    public Auto() {
    }

    @Override
    public void serializeContent(XmlSerializer serializer) throws IOException {
        SerializerUtils.setBooleanAttribute(serializer, SAVE_ATTRIBUTE, save);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    public boolean isSave() {
        return save;
    }

    public void setSave(boolean save) {
        this.save = save;
    }

}
