/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.bouncycastle.crypto.generators;

import java.math.BigInteger;
import net.java.otr4j.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.java.otr4j.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.java.otr4j.bouncycastle.crypto.KeyGenerationParameters;
import net.java.otr4j.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import net.java.otr4j.bouncycastle.crypto.params.DHKeyGenerationParameters;
import net.java.otr4j.bouncycastle.crypto.params.DHParameters;
import net.java.otr4j.bouncycastle.crypto.params.DHPrivateKeyParameters;
import net.java.otr4j.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

