/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.OtrEngineHost;
import net.java.otr4j.OtrEngineListener;
import net.java.otr4j.OtrException;
import net.java.otr4j.OtrPolicy;
import net.java.otr4j.crypto.OtrCryptoEngineImpl;
import net.java.otr4j.io.OtrInputStream;
import net.java.otr4j.io.OtrOutputStream;
import net.java.otr4j.io.SerializationUtils;
import net.java.otr4j.io.messages.AbstractMessage;
import net.java.otr4j.io.messages.DataMessage;
import net.java.otr4j.io.messages.ErrorMessage;
import net.java.otr4j.io.messages.MysteriousT;
import net.java.otr4j.io.messages.PlainTextMessage;
import net.java.otr4j.io.messages.QueryMessage;
import net.java.otr4j.session.AuthContext;
import net.java.otr4j.session.AuthContextImpl;
import net.java.otr4j.session.OfferStatus;
import net.java.otr4j.session.OtrSm;
import net.java.otr4j.session.Session;
import net.java.otr4j.session.SessionID;
import net.java.otr4j.session.SessionKeys;
import net.java.otr4j.session.SessionKeysImpl;
import net.java.otr4j.session.SessionStatus;
import net.java.otr4j.session.TLV;

public class SessionImpl
implements Session {
    private SessionID sessionID;
    private OtrEngineHost host;
    private SessionStatus sessionStatus;
    private AuthContext authContext;
    private SessionKeys[][] sessionKeys;
    private Vector<byte[]> oldMacKeys;
    private static Logger logger = Logger.getLogger(SessionImpl.class.getName());
    private final OtrSm otrSm;
    private BigInteger ess;
    private OfferStatus offerStatus;
    private PublicKey remotePublicKey;
    private List<OtrEngineListener> listeners = new Vector<OtrEngineListener>();

    public SessionImpl(SessionID sessionID, OtrEngineHost listener) {
        this.setSessionID(sessionID);
        this.setHost(listener);
        this.sessionStatus = SessionStatus.PLAINTEXT;
        this.offerStatus = OfferStatus.idle;
        this.otrSm = new OtrSm(this, listener);
    }

    @Override
    public BigInteger getS() {
        return this.ess;
    }

    private SessionKeys getEncryptionSessionKeys() {
        logger.finest("Getting encryption keys");
        return this.getSessionKeysByIndex(0, 1);
    }

    private SessionKeys getMostRecentSessionKeys() {
        logger.finest("Getting most recent keys.");
        return this.getSessionKeysByIndex(1, 1);
    }

    private SessionKeys getSessionKeysByID(int localKeyID, int remoteKeyID) {
        logger.finest("Searching for session keys with (localKeyID, remoteKeyID) = (" + localKeyID + "," + remoteKeyID + ")");
        int i = 0;
        while (i < this.getSessionKeys().length) {
            int j = 0;
            while (j < this.getSessionKeys()[i].length) {
                SessionKeys current = this.getSessionKeysByIndex(i, j);
                if (current.getLocalKeyID() == localKeyID && current.getRemoteKeyID() == remoteKeyID) {
                    logger.finest("Matching keys found.");
                    return current;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private SessionKeys getSessionKeysByIndex(int localKeyIndex, int remoteKeyIndex) {
        if (this.getSessionKeys()[localKeyIndex][remoteKeyIndex] == null) {
            this.getSessionKeys()[localKeyIndex][remoteKeyIndex] = new SessionKeysImpl(localKeyIndex, remoteKeyIndex);
        }
        return this.getSessionKeys()[localKeyIndex][remoteKeyIndex];
    }

    private void rotateRemoteSessionKeys(DHPublicKey pubKey) throws OtrException {
        SessionKeys sess2;
        logger.finest("Rotating remote keys.");
        SessionKeys sess1 = this.getSessionKeysByIndex(1, 0);
        if (sess1.getIsUsedReceivingMACKey().booleanValue()) {
            logger.finest("Detected used Receiving MAC key. Adding to old MAC keys to reveal it.");
            this.getOldMacKeys().add(sess1.getReceivingMACKey());
        }
        if ((sess2 = this.getSessionKeysByIndex(0, 0)).getIsUsedReceivingMACKey().booleanValue()) {
            logger.finest("Detected used Receiving MAC key. Adding to old MAC keys to reveal it.");
            this.getOldMacKeys().add(sess2.getReceivingMACKey());
        }
        SessionKeys sess3 = this.getSessionKeysByIndex(1, 1);
        sess1.setRemoteDHPublicKey(sess3.getRemoteKey(), sess3.getRemoteKeyID());
        SessionKeys sess4 = this.getSessionKeysByIndex(0, 1);
        sess2.setRemoteDHPublicKey(sess4.getRemoteKey(), sess4.getRemoteKeyID());
        sess3.setRemoteDHPublicKey(pubKey, sess3.getRemoteKeyID() + 1);
        sess4.setRemoteDHPublicKey(pubKey, sess4.getRemoteKeyID() + 1);
    }

    private void rotateLocalSessionKeys() throws OtrException {
        SessionKeys sess2;
        logger.finest("Rotating local keys.");
        SessionKeys sess1 = this.getSessionKeysByIndex(0, 1);
        if (sess1.getIsUsedReceivingMACKey().booleanValue()) {
            logger.finest("Detected used Receiving MAC key. Adding to old MAC keys to reveal it.");
            this.getOldMacKeys().add(sess1.getReceivingMACKey());
        }
        if ((sess2 = this.getSessionKeysByIndex(0, 0)).getIsUsedReceivingMACKey().booleanValue()) {
            logger.finest("Detected used Receiving MAC key. Adding to old MAC keys to reveal it.");
            this.getOldMacKeys().add(sess2.getReceivingMACKey());
        }
        SessionKeys sess3 = this.getSessionKeysByIndex(1, 1);
        sess1.setLocalPair(sess3.getLocalPair(), sess3.getLocalKeyID());
        SessionKeys sess4 = this.getSessionKeysByIndex(1, 0);
        sess2.setLocalPair(sess4.getLocalPair(), sess4.getLocalKeyID());
        KeyPair newPair = new OtrCryptoEngineImpl().generateDHKeyPair();
        sess3.setLocalPair(newPair, sess3.getLocalKeyID() + 1);
        sess4.setLocalPair(newPair, sess4.getLocalKeyID() + 1);
    }

    private byte[] collectOldMacKeys() {
        logger.finest("Collecting old MAC keys to be revealed.");
        int len = 0;
        int i = 0;
        while (i < this.getOldMacKeys().size()) {
            len += this.getOldMacKeys().get(i).length;
            ++i;
        }
        ByteBuffer buff = ByteBuffer.allocate(len);
        int i2 = 0;
        while (i2 < this.getOldMacKeys().size()) {
            buff.put(this.getOldMacKeys().get(i2));
            ++i2;
        }
        this.getOldMacKeys().clear();
        return buff.array();
    }

    private void setSessionStatus(SessionStatus sessionStatus) throws OtrException {
        if (sessionStatus == this.sessionStatus) {
            return;
        }
        switch (sessionStatus) {
            case ENCRYPTED: {
                AuthContext auth = this.getAuthContext();
                this.ess = auth.getS();
                logger.finest("Setting most recent session keys from auth.");
                int i = 0;
                while (i < this.getSessionKeys()[0].length) {
                    SessionKeys current = this.getSessionKeysByIndex(0, i);
                    current.setLocalPair(auth.getLocalDHKeyPair(), 1);
                    current.setRemoteDHPublicKey(auth.getRemoteDHPublicKey(), 1);
                    current.setS(auth.getS());
                    ++i;
                }
                KeyPair nextDH = new OtrCryptoEngineImpl().generateDHKeyPair();
                int i2 = 0;
                while (i2 < this.getSessionKeys()[1].length) {
                    SessionKeys current = this.getSessionKeysByIndex(1, i2);
                    current.setRemoteDHPublicKey(auth.getRemoteDHPublicKey(), 1);
                    current.setLocalPair(nextDH, 2);
                    ++i2;
                }
                this.setRemotePublicKey(auth.getRemoteLongTermPublicKey());
                auth.reset();
                this.otrSm.reset();
            }
        }
        this.sessionStatus = sessionStatus;
        for (OtrEngineListener l : this.listeners) {
            l.sessionStatusChanged(this.getSessionID());
        }
    }

    @Override
    public SessionStatus getSessionStatus() {
        return this.sessionStatus;
    }

    private void setSessionID(SessionID sessionID) {
        this.sessionID = sessionID;
    }

    @Override
    public SessionID getSessionID() {
        return this.sessionID;
    }

    private void setHost(OtrEngineHost host) {
        this.host = host;
    }

    private OtrEngineHost getHost() {
        return this.host;
    }

    private SessionKeys[][] getSessionKeys() {
        if (this.sessionKeys == null) {
            this.sessionKeys = new SessionKeys[2][2];
        }
        return this.sessionKeys;
    }

    private AuthContext getAuthContext() {
        if (this.authContext == null) {
            this.authContext = new AuthContextImpl(this);
        }
        return this.authContext;
    }

    private Vector<byte[]> getOldMacKeys() {
        if (this.oldMacKeys == null) {
            this.oldMacKeys = new Vector();
        }
        return this.oldMacKeys;
    }

    @Override
    public String transformReceiving(String msgText) throws OtrException {
        AbstractMessage m;
        OtrPolicy policy = this.getSessionPolicy();
        if (!policy.getAllowV1() && !policy.getAllowV2()) {
            logger.finest("Policy does not allow neither V1 not V2, ignoring message.");
            return msgText;
        }
        try {
            m = SerializationUtils.toMessage(msgText);
        }
        catch (IOException e) {
            throw new OtrException(e);
        }
        if (m == null) {
            return msgText;
        }
        if (m.messageType != 258) {
            this.offerStatus = OfferStatus.accepted;
        } else if (this.offerStatus == OfferStatus.sent) {
            this.offerStatus = OfferStatus.rejected;
        }
        switch (m.messageType) {
            case 3: {
                return this.handleDataMessage((DataMessage)m);
            }
            case 255: {
                this.handleErrorMessage((ErrorMessage)m);
                return null;
            }
            case 258: {
                return this.handlePlainTextMessage((PlainTextMessage)m);
            }
            case 256: {
                this.handleQueryMessage((QueryMessage)m);
                return null;
            }
            case 2: 
            case 10: 
            case 17: 
            case 18: {
                AuthContext auth = this.getAuthContext();
                auth.handleReceivingMessage(m);
                if (auth.getIsSecure()) {
                    this.setSessionStatus(SessionStatus.ENCRYPTED);
                    logger.finest("Gone Secure.");
                }
                return null;
            }
        }
        throw new UnsupportedOperationException("Received an uknown message type.");
    }

    private void handleQueryMessage(QueryMessage queryMessage) throws OtrException {
        logger.finest(String.valueOf(this.getSessionID().getAccountID()) + " received a query message from " + this.getSessionID().getUserID() + " throught " + this.getSessionID().getProtocolName() + ".");
        this.setSessionStatus(SessionStatus.PLAINTEXT);
        OtrPolicy policy = this.getSessionPolicy();
        if (queryMessage.versions.contains(2) && policy.getAllowV2()) {
            logger.finest("Query message with V2 support found.");
            this.getAuthContext().respondV2Auth();
        } else if (queryMessage.versions.contains(1) && policy.getAllowV1()) {
            throw new UnsupportedOperationException();
        }
    }

    private void handleErrorMessage(ErrorMessage errorMessage) throws OtrException {
        logger.finest(String.valueOf(this.getSessionID().getAccountID()) + " received an error message from " + this.getSessionID().getUserID() + " throught " + this.getSessionID().getUserID() + ".");
        this.getHost().showError(this.getSessionID(), errorMessage.error);
        OtrPolicy policy = this.getSessionPolicy();
        if (policy.getErrorStartAKE()) {
            logger.finest("Error message starts AKE.");
            Vector<Integer> versions = new Vector<Integer>();
            if (policy.getAllowV1()) {
                versions.add(1);
            }
            if (policy.getAllowV2()) {
                versions.add(2);
            }
            logger.finest("Sending Query");
            this.injectMessage(new QueryMessage(versions));
        }
    }

    private String handleDataMessage(DataMessage data) throws OtrException {
        logger.finest(String.valueOf(this.getSessionID().getAccountID()) + " received a data message from " + this.getSessionID().getUserID() + ".");
        switch (this.getSessionStatus()) {
            case ENCRYPTED: {
                String decryptedMsgContent;
                byte[] serializedT;
                logger.finest("Message state is ENCRYPTED. Trying to decrypt message.");
                int senderKeyID = data.senderKeyID;
                int receipientKeyID = data.recipientKeyID;
                SessionKeys matchingKeys = this.getSessionKeysByID(receipientKeyID, senderKeyID);
                if (matchingKeys == null) {
                    logger.finest("No matching keys found.");
                    return null;
                }
                logger.finest("Transforming T to byte[] to calculate it's HmacSHA1.");
                try {
                    serializedT = SerializationUtils.toByteArray(data.getT());
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                OtrCryptoEngineImpl otrCryptoEngine = new OtrCryptoEngineImpl();
                byte[] computedMAC = otrCryptoEngine.sha1Hmac(serializedT, matchingKeys.getReceivingMACKey(), 20);
                if (!Arrays.equals(computedMAC, data.mac)) {
                    logger.finest("MAC verification failed, ignoring message");
                    return null;
                }
                logger.finest("Computed HmacSHA1 value matches sent one.");
                matchingKeys.setIsUsedReceivingMACKey(true);
                matchingKeys.setReceivingCtr(data.ctr);
                byte[] dmc = otrCryptoEngine.aesDecrypt(matchingKeys.getReceivingAESKey(), matchingKeys.getReceivingCtr(), data.encryptedMessage);
                try {
                    decryptedMsgContent = new String(dmc, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new OtrException(e);
                }
                logger.finest("Decrypted message: \"" + decryptedMsgContent + "\"");
                SessionKeys mostRecent = this.getMostRecentSessionKeys();
                if (mostRecent.getLocalKeyID() == receipientKeyID) {
                    this.rotateLocalSessionKeys();
                }
                if (mostRecent.getRemoteKeyID() == senderKeyID) {
                    this.rotateRemoteSessionKeys(data.nextDH);
                }
                Vector<TLV> tlvs = null;
                int tlvIndex = decryptedMsgContent.indexOf(0);
                if (tlvIndex > -1) {
                    decryptedMsgContent = decryptedMsgContent.substring(0, tlvIndex);
                    byte[] tlvsb = new byte[dmc.length - ++tlvIndex];
                    System.arraycopy(dmc, tlvIndex, tlvsb, 0, tlvsb.length);
                    tlvs = new Vector<TLV>();
                    ByteArrayInputStream tin = new ByteArrayInputStream(tlvsb);
                    while (tin.available() > 0) {
                        byte[] tdata;
                        int type;
                        OtrInputStream eois = new OtrInputStream(tin);
                        try {
                            type = eois.readShort();
                            tdata = eois.readTlvData();
                            eois.close();
                        }
                        catch (IOException e) {
                            throw new OtrException(e);
                        }
                        tlvs.add(new TLV(type, tdata));
                    }
                }
                if (tlvs != null && tlvs.size() > 0) {
                    for (TLV tlv : tlvs) {
                        switch (tlv.getType()) {
                            case 1: {
                                this.setSessionStatus(SessionStatus.FINISHED);
                                return null;
                            }
                        }
                        if (!this.otrSm.doProcessTlv(tlv)) continue;
                        return null;
                    }
                }
                return decryptedMsgContent;
            }
            case PLAINTEXT: 
            case FINISHED: {
                this.getHost().unreadableMessageReceived(this.getSessionID());
                this.injectMessage(new ErrorMessage(255, this.getHost().getReplyForUnreadableMessage()));
            }
        }
        return null;
    }

    @Override
    public void injectMessage(AbstractMessage m) throws OtrException {
        String msg;
        try {
            msg = SerializationUtils.toString(m);
        }
        catch (IOException e) {
            throw new OtrException(e);
        }
        if (m instanceof QueryMessage) {
            msg = String.valueOf(msg) + this.getHost().getFallbackMessage();
        }
        this.getHost().injectMessage(this.getSessionID(), msg);
    }

    private String handlePlainTextMessage(PlainTextMessage plainTextMessage) throws OtrException {
        logger.finest(String.valueOf(this.getSessionID().getAccountID()) + " received a plaintext message from " + this.getSessionID().getUserID() + " throught " + this.getSessionID().getProtocolName() + ".");
        OtrPolicy policy = this.getSessionPolicy();
        List versions = plainTextMessage.versions;
        if (versions == null || versions.size() < 1) {
            logger.finest("Received plaintext message without the whitespace tag.");
            switch (this.getSessionStatus()) {
                case ENCRYPTED: 
                case FINISHED: {
                    this.getHost().unencryptedMessageReceived(this.sessionID, plainTextMessage.cleanText);
                    return plainTextMessage.cleanText;
                }
                case PLAINTEXT: {
                    if (policy.getRequireEncryption()) {
                        this.getHost().unencryptedMessageReceived(this.sessionID, plainTextMessage.cleanText);
                    }
                    return plainTextMessage.cleanText;
                }
            }
        } else {
            logger.finest("Received plaintext message with the whitespace tag.");
            switch (this.getSessionStatus()) {
                case ENCRYPTED: 
                case FINISHED: {
                    this.getHost().unencryptedMessageReceived(this.sessionID, plainTextMessage.cleanText);
                }
                case PLAINTEXT: {
                    if (!policy.getRequireEncryption()) break;
                    this.getHost().unencryptedMessageReceived(this.sessionID, plainTextMessage.cleanText);
                }
            }
            if (policy.getWhitespaceStartAKE()) {
                logger.finest("WHITESPACE_START_AKE is set");
                if (plainTextMessage.versions.contains(2) && policy.getAllowV2()) {
                    logger.finest("V2 tag found.");
                    try {
                        this.getAuthContext().respondV2Auth();
                    }
                    catch (OtrException otrException) {}
                } else if (plainTextMessage.versions.contains(1) && policy.getAllowV1()) {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return plainTextMessage.cleanText;
    }

    @Override
    public String transformSending(String msgText, List<TLV> tlvs) throws OtrException {
        switch (this.getSessionStatus()) {
            case PLAINTEXT: {
                OtrPolicy otrPolicy = this.getSessionPolicy();
                if (otrPolicy.getRequireEncryption()) {
                    this.startSession();
                    this.getHost().requireEncryptedMessage(this.sessionID, msgText);
                    return null;
                }
                if (otrPolicy.getSendWhitespaceTag() && this.offerStatus != OfferStatus.rejected) {
                    this.offerStatus = OfferStatus.sent;
                    Vector<Integer> versions = new Vector<Integer>();
                    if (otrPolicy.getAllowV1()) {
                        versions.add(1);
                    }
                    if (otrPolicy.getAllowV2()) {
                        versions.add(2);
                    }
                    if (versions.isEmpty()) {
                        versions = null;
                    }
                    PlainTextMessage abstractMessage = new PlainTextMessage(versions, msgText);
                    try {
                        return SerializationUtils.toString(abstractMessage);
                    }
                    catch (IOException e) {
                        throw new OtrException(e);
                    }
                }
                return msgText;
            }
            case ENCRYPTED: {
                byte[] serializedT;
                logger.finest(String.valueOf(this.getSessionID().getAccountID()) + " sends an encrypted message to " + this.getSessionID().getUserID() + " throught " + this.getSessionID().getProtocolName() + ".");
                SessionKeys encryptionKeys = this.getEncryptionSessionKeys();
                int senderKeyID = encryptionKeys.getLocalKeyID();
                int receipientKeyID = encryptionKeys.getRemoteKeyID();
                encryptionKeys.incrementSendingCtr();
                byte[] ctr = encryptionKeys.getSendingCtr();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (msgText != null && msgText.length() > 0) {
                    try {
                        out.write(msgText.getBytes("UTF8"));
                    }
                    catch (IOException e) {
                        throw new OtrException(e);
                    }
                }
                if (tlvs != null && tlvs.size() > 0) {
                    out.write(0);
                    OtrOutputStream eoos = new OtrOutputStream(out);
                    for (TLV tlv : tlvs) {
                        try {
                            eoos.writeShort(tlv.type);
                            eoos.writeTlvData(tlv.value);
                        }
                        catch (IOException e) {
                            throw new OtrException(e);
                        }
                    }
                }
                OtrCryptoEngineImpl otrCryptoEngine = new OtrCryptoEngineImpl();
                byte[] data = out.toByteArray();
                logger.finest("Encrypting message with keyids (localKeyID, remoteKeyID) = (" + senderKeyID + ", " + receipientKeyID + ")");
                byte[] encryptedMsg = otrCryptoEngine.aesEncrypt(encryptionKeys.getSendingAESKey(), ctr, data);
                SessionKeys mostRecentKeys = this.getMostRecentSessionKeys();
                DHPublicKey nextDH = (DHPublicKey)mostRecentKeys.getLocalPair().getPublic();
                MysteriousT t = new MysteriousT(2, 0, senderKeyID, receipientKeyID, nextDH, ctr, encryptedMsg);
                byte[] sendingMACKey = encryptionKeys.getSendingMACKey();
                logger.finest("Transforming T to byte[] to calculate it's HmacSHA1.");
                try {
                    serializedT = SerializationUtils.toByteArray(t);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                byte[] mac = otrCryptoEngine.sha1Hmac(serializedT, sendingMACKey, 20);
                byte[] oldKeys = this.collectOldMacKeys();
                DataMessage m = new DataMessage(t, mac, oldKeys);
                try {
                    return SerializationUtils.toString(m);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
            }
            case FINISHED: {
                this.getHost().finishedSessionMessage(this.sessionID);
                return null;
            }
        }
        logger.finest("Uknown message state, not processing.");
        return msgText;
    }

    @Override
    public void startSession() throws OtrException {
        if (this.getSessionStatus() == SessionStatus.ENCRYPTED) {
            return;
        }
        if (!this.getSessionPolicy().getAllowV2()) {
            throw new UnsupportedOperationException();
        }
        this.getAuthContext().startV2Auth();
    }

    @Override
    public void endSession() throws OtrException {
        SessionStatus status = this.getSessionStatus();
        switch (status) {
            case ENCRYPTED: {
                Vector<TLV> tlvs = new Vector<TLV>();
                tlvs.add(new TLV(1, null));
                String msg = this.transformSending(null, tlvs);
                this.getHost().injectMessage(this.getSessionID(), msg);
                this.setSessionStatus(SessionStatus.PLAINTEXT);
                break;
            }
            case FINISHED: {
                this.setSessionStatus(SessionStatus.PLAINTEXT);
                break;
            }
            case PLAINTEXT: {
                return;
            }
        }
    }

    @Override
    public void refreshSession() throws OtrException {
        this.endSession();
        this.startSession();
    }

    private void setRemotePublicKey(PublicKey pubKey) {
        this.remotePublicKey = pubKey;
    }

    @Override
    public PublicKey getRemotePublicKey() {
        return this.remotePublicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOtrEngineListener(OtrEngineListener l) {
        List<OtrEngineListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOtrEngineListener(OtrEngineListener l) {
        List<OtrEngineListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    @Override
    public OtrPolicy getSessionPolicy() {
        return this.getHost().getSessionPolicy(this.getSessionID());
    }

    @Override
    public KeyPair getLocalKeyPair() throws OtrException {
        return this.getHost().getLocalKeyPair(this.getSessionID());
    }

    @Override
    public void initSmp(String question, String secret) throws OtrException {
        if (this.getSessionStatus() != SessionStatus.ENCRYPTED) {
            return;
        }
        List<TLV> tlvs = this.otrSm.initRespondSmp(question, secret, true);
        String msg = this.transformSending("", tlvs);
        this.getHost().injectMessage(this.getSessionID(), msg);
    }

    @Override
    public void respondSmp(String question, String secret) throws OtrException {
        if (this.getSessionStatus() != SessionStatus.ENCRYPTED) {
            return;
        }
        List<TLV> tlvs = this.otrSm.initRespondSmp(question, secret, false);
        String msg = this.transformSending("", tlvs);
        this.getHost().injectMessage(this.getSessionID(), msg);
    }

    @Override
    public void abortSmp() throws OtrException {
        if (this.getSessionStatus() != SessionStatus.ENCRYPTED) {
            return;
        }
        List<TLV> tlvs = this.otrSm.abortSmp();
        String msg = this.transformSending("", tlvs);
        this.getHost().injectMessage(this.getSessionID(), msg);
    }
}

