/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.crypto.OtrCryptoEngineImpl;
import net.java.otr4j.io.SerializationConstants;
import net.java.otr4j.io.messages.SignatureX;

public class OtrInputStream
extends FilterInputStream
implements SerializationConstants {
    public OtrInputStream(InputStream in) {
        super(in);
    }

    private int readNumber(int length) throws IOException {
        byte[] b = new byte[length];
        this.read(b);
        int value = 0;
        int i = 0;
        while (i < b.length) {
            int shift = (b.length - 1 - i) * 8;
            value += (b[i] & 0xFF) << shift;
            ++i;
        }
        return value;
    }

    public int readByte() throws IOException {
        return this.readNumber(1);
    }

    public int readInt() throws IOException {
        return this.readNumber(4);
    }

    public int readShort() throws IOException {
        return this.readNumber(2);
    }

    public byte[] readCtr() throws IOException {
        byte[] b = new byte[8];
        this.read(b);
        return b;
    }

    public byte[] readMac() throws IOException {
        byte[] b = new byte[20];
        this.read(b);
        return b;
    }

    public BigInteger readBigInt() throws IOException {
        byte[] b = this.readData();
        return new BigInteger(1, b);
    }

    public byte[] readData() throws IOException {
        int dataLen = this.readNumber(4);
        byte[] b = new byte[dataLen];
        this.read(b);
        return b;
    }

    public PublicKey readPublicKey() throws IOException {
        int type = this.readShort();
        switch (type) {
            case 0: {
                KeyFactory keyFactory;
                BigInteger p = this.readBigInt();
                BigInteger q = this.readBigInt();
                BigInteger g = this.readBigInt();
                BigInteger y = this.readBigInt();
                DSAPublicKeySpec keySpec = new DSAPublicKeySpec(y, p, q, g);
                try {
                    keyFactory = KeyFactory.getInstance("DSA");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException();
                }
                try {
                    return keyFactory.generatePublic(keySpec);
                }
                catch (InvalidKeySpecException e) {
                    throw new IOException();
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    public DHPublicKey readDHPublicKey() throws IOException {
        BigInteger gyMpi = this.readBigInt();
        try {
            return new OtrCryptoEngineImpl().getDHPublicKey(gyMpi);
        }
        catch (Exception ex) {
            throw new IOException();
        }
    }

    public byte[] readTlvData() throws IOException {
        int len = this.readNumber(2);
        byte[] b = new byte[len];
        this.in.read(b);
        return b;
    }

    public byte[] readSignature(PublicKey pubKey) throws IOException {
        if (!pubKey.getAlgorithm().equals("DSA")) {
            throw new UnsupportedOperationException();
        }
        DSAPublicKey dsaPubKey = (DSAPublicKey)pubKey;
        DSAParams dsaParams = dsaPubKey.getParams();
        byte[] sig = new byte[dsaParams.getQ().bitLength() / 4];
        this.read(sig);
        return sig;
    }

    public SignatureX readMysteriousX() throws IOException {
        PublicKey pubKey = this.readPublicKey();
        int dhKeyID = this.readInt();
        byte[] sig = this.readSignature(pubKey);
        return new SignatureX(pubKey, dhKeyID, sig);
    }
}

