/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.bouncycastle.util.encoders.Base64;
import net.java.otr4j.io.OtrInputStream;
import net.java.otr4j.io.OtrOutputStream;
import net.java.otr4j.io.messages.AbstractMessage;
import net.java.otr4j.io.messages.DHCommitMessage;
import net.java.otr4j.io.messages.DHKeyMessage;
import net.java.otr4j.io.messages.DataMessage;
import net.java.otr4j.io.messages.ErrorMessage;
import net.java.otr4j.io.messages.MysteriousT;
import net.java.otr4j.io.messages.PlainTextMessage;
import net.java.otr4j.io.messages.QueryMessage;
import net.java.otr4j.io.messages.RevealSignatureMessage;
import net.java.otr4j.io.messages.SignatureM;
import net.java.otr4j.io.messages.SignatureMessage;
import net.java.otr4j.io.messages.SignatureX;

public class SerializationUtils {
    static final Pattern patternWhitespace = Pattern.compile("( \\t  \\t\\t\\t\\t \\t \\t \\t  )(  \\t\\t  \\t )?( \\t \\t  \\t )?");
    private static final char[] HEX_ENCODER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String HEX_DECODER = "0123456789ABCDEF";

    public static SignatureX toMysteriousX(byte[] b) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        OtrInputStream ois = new OtrInputStream(in);
        SignatureX x = ois.readMysteriousX();
        ois.close();
        return x;
    }

    public static byte[] toByteArray(SignatureX x) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OtrOutputStream oos = new OtrOutputStream(out);
        oos.writeMysteriousX(x);
        byte[] b = out.toByteArray();
        oos.close();
        return b;
    }

    public static byte[] toByteArray(SignatureM m) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OtrOutputStream oos = new OtrOutputStream(out);
        oos.writeMysteriousX(m);
        byte[] b = out.toByteArray();
        oos.close();
        return b;
    }

    public static byte[] toByteArray(MysteriousT t) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OtrOutputStream oos = new OtrOutputStream(out);
        oos.writeMysteriousT(t);
        byte[] b = out.toByteArray();
        out.close();
        return b;
    }

    public static byte[] writeData(byte[] b) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OtrOutputStream oos = new OtrOutputStream(out);
        oos.writeData(b);
        byte[] otrb = out.toByteArray();
        out.close();
        return otrb;
    }

    public static byte[] writeMpi(BigInteger bigInt) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OtrOutputStream oos = new OtrOutputStream(out);
        oos.writeBigInt(bigInt);
        byte[] b = out.toByteArray();
        oos.close();
        return b;
    }

    public static BigInteger readMpi(byte[] b) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        OtrInputStream ois = new OtrInputStream(in);
        BigInteger bigint = ois.readBigInt();
        ois.close();
        return bigint;
    }

    public static byte[] writePublicKey(PublicKey pubKey) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OtrOutputStream oos = new OtrOutputStream(out);
        oos.writePublicKey(pubKey);
        byte[] b = out.toByteArray();
        oos.close();
        return b;
    }

    public static String toString(AbstractMessage m) throws IOException {
        StringWriter writer = new StringWriter();
        if (m.messageType != 258) {
            writer.write("?OTR");
        }
        switch (m.messageType) {
            case 255: {
                ErrorMessage error = (ErrorMessage)m;
                writer.write(32);
                writer.write("Error:");
                writer.write(error.error);
                break;
            }
            case 258: {
                PlainTextMessage plaintxt = (PlainTextMessage)m;
                writer.write(plaintxt.cleanText);
                if (plaintxt.versions == null || plaintxt.versions.size() <= 0) break;
                writer.write(" \t  \t\t\t\t \t \t \t  ");
                Iterator iterator = plaintxt.versions.iterator();
                while (iterator.hasNext()) {
                    int version = (Integer)iterator.next();
                    if (version == 1) {
                        writer.write(" \t \t  \t ");
                    }
                    if (version != 2) continue;
                    writer.write("  \t\t  \t ");
                }
                break;
            }
            case 256: {
                QueryMessage query = (QueryMessage)m;
                if (query.versions.size() == 1 && query.versions.get(0) == 1) {
                    writer.write(63);
                    break;
                }
                writer.write(118);
                for (int version : query.versions) {
                    writer.write(String.valueOf(version));
                }
                writer.write(63);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 17: 
            case 18: {
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                OtrOutputStream s = new OtrOutputStream(o);
                switch (m.messageType) {
                    case 10: {
                        DHKeyMessage dhkey = (DHKeyMessage)m;
                        s.writeShort(dhkey.protocolVersion);
                        s.writeByte(dhkey.messageType);
                        s.writeDHPublicKey(dhkey.dhPublicKey);
                        break;
                    }
                    case 17: {
                        RevealSignatureMessage revealsig = (RevealSignatureMessage)m;
                        s.writeShort(revealsig.protocolVersion);
                        s.writeByte(revealsig.messageType);
                        s.writeData(revealsig.revealedKey);
                        s.writeData(revealsig.xEncrypted);
                        s.writeMac(revealsig.xEncryptedMAC);
                        break;
                    }
                    case 18: {
                        SignatureMessage sig = (SignatureMessage)m;
                        s.writeShort(sig.protocolVersion);
                        s.writeByte(sig.messageType);
                        s.writeData(sig.xEncrypted);
                        s.writeMac(sig.xEncryptedMAC);
                        break;
                    }
                    case 2: {
                        DHCommitMessage dhcommit = (DHCommitMessage)m;
                        s.writeShort(dhcommit.protocolVersion);
                        s.writeByte(dhcommit.messageType);
                        s.writeData(dhcommit.dhPublicKeyEncrypted);
                        s.writeData(dhcommit.dhPublicKeyHash);
                        break;
                    }
                    case 3: {
                        DataMessage data = (DataMessage)m;
                        s.writeShort(data.protocolVersion);
                        s.writeByte(data.messageType);
                        s.writeByte(data.flags);
                        s.writeInt(data.senderKeyID);
                        s.writeInt(data.recipientKeyID);
                        s.writeDHPublicKey(data.nextDH);
                        s.writeCtr(data.ctr);
                        s.writeData(data.encryptedMessage);
                        s.writeMac(data.mac);
                        s.writeData(data.oldMACKeys);
                    }
                }
                writer.write(58);
                writer.write(new String(Base64.encode(o.toByteArray())));
                writer.write(".");
                break;
            }
            default: {
                throw new IOException("Illegal message type.");
            }
        }
        return writer.toString();
    }

    public static AbstractMessage toMessage(String s) throws IOException {
        if (s == null || s.length() == 0) {
            return null;
        }
        if (s.indexOf("?OTR") != 0) {
            Vector<Integer> versions;
            Matcher matcher = patternWhitespace.matcher(s);
            boolean v1 = false;
            boolean v2 = false;
            while (matcher.find()) {
                if (!v1 && matcher.start(2) > -1) {
                    v1 = true;
                }
                if (!v2 && matcher.start(3) > -1) {
                    v2 = true;
                }
                if (v1 && v2) break;
            }
            String cleanText = matcher.replaceAll("");
            if (v1 && v2) {
                versions = new Vector<Integer>(2);
                versions.add(0, 1);
                versions.add(0, 2);
            } else if (v1) {
                versions = new Vector(1);
                versions.add(0, 1);
            } else if (v2) {
                versions = new Vector(1);
                versions.add(2);
            } else {
                versions = null;
            }
            return new PlainTextMessage(versions, cleanText);
        }
        char contentType = s.charAt("?OTR".length());
        String content = s.substring("?OTR".length() + 1);
        if (contentType == ' ' && content.startsWith("Error:")) {
            content = content.substring("Error:".length());
            return new ErrorMessage(255, content);
        }
        switch (contentType) {
            case ':': {
                ByteArrayInputStream bin = new ByteArrayInputStream(Base64.decode(content.getBytes()));
                OtrInputStream otr = new OtrInputStream(bin);
                int protocolVersion = otr.readShort();
                int messageType = otr.readByte();
                switch (messageType) {
                    case 3: {
                        int flags = otr.readByte();
                        int senderKeyID = otr.readInt();
                        int recipientKeyID = otr.readInt();
                        DHPublicKey nextDH = otr.readDHPublicKey();
                        byte[] ctr = otr.readCtr();
                        byte[] encryptedMessage = otr.readData();
                        byte[] mac = otr.readMac();
                        byte[] oldMacKeys = otr.readMac();
                        return new DataMessage(protocolVersion, flags, senderKeyID, recipientKeyID, nextDH, ctr, encryptedMessage, mac, oldMacKeys);
                    }
                    case 2: {
                        byte[] dhPublicKeyEncrypted = otr.readData();
                        byte[] dhPublicKeyHash = otr.readData();
                        return new DHCommitMessage(protocolVersion, dhPublicKeyHash, dhPublicKeyEncrypted);
                    }
                    case 10: {
                        DHPublicKey dhPublicKey = otr.readDHPublicKey();
                        return new DHKeyMessage(protocolVersion, dhPublicKey);
                    }
                    case 17: {
                        byte[] revealedKey = otr.readData();
                        byte[] xEncrypted = otr.readData();
                        byte[] xEncryptedMac = otr.readMac();
                        return new RevealSignatureMessage(protocolVersion, xEncrypted, xEncryptedMac, revealedKey);
                    }
                    case 18: {
                        byte[] xEncryted = otr.readData();
                        byte[] xEncryptedMac = otr.readMac();
                        return new SignatureMessage(protocolVersion, xEncryted, xEncryptedMac);
                    }
                }
                throw new IOException("Illegal message type.");
            }
            case '?': 
            case 'v': {
                Vector<Integer> versions = new Vector<Integer>();
                String versionString = null;
                if ('?' == contentType) {
                    versions.add(1);
                    if (content.charAt(0) == 'v') {
                        versionString = content.substring(1, content.indexOf(63));
                    }
                } else if ('v' == contentType) {
                    versionString = content.substring(0, content.indexOf(63));
                }
                if (versionString != null) {
                    int c;
                    StringReader sr = new StringReader(versionString);
                    while ((c = sr.read()) != -1) {
                        if (versions.contains(c)) continue;
                        versions.add(Integer.parseInt(String.valueOf((char)c)));
                    }
                }
                QueryMessage query = new QueryMessage(versions);
                return query;
            }
        }
        throw new IOException("Uknown message type.");
    }

    public static String byteArrayToHexString(byte[] in) {
        int i = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        StringBuffer out = new StringBuffer(in.length * 2);
        while (i < in.length) {
            out.append(HEX_ENCODER[in[i] >>> 4 & 0xF]);
            out.append(HEX_ENCODER[in[i] & 0xF]);
            ++i;
        }
        return out.toString();
    }

    public static byte[] hexStringToByteArray(String value) {
        value = value.toUpperCase();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int index = 0;
        while (index < value.length()) {
            int high = HEX_DECODER.indexOf(value.charAt(index));
            int low = HEX_DECODER.indexOf(value.charAt(index + 1));
            out.write((high << 4) + low);
            index += 2;
        }
        return out.toByteArray();
    }
}

