/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.session;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import net.java.otr4j.OtrEngineHost;
import net.java.otr4j.OtrException;
import net.java.otr4j.crypto.OtrCryptoEngineImpl;
import net.java.otr4j.crypto.OtrCryptoException;
import net.java.otr4j.crypto.SM;
import net.java.otr4j.io.OtrOutputStream;
import net.java.otr4j.session.Session;
import net.java.otr4j.session.TLV;

public class OtrSm {
    private SM.SMState smstate;
    private OtrEngineHost engineHost;
    private Session session;

    public OtrSm(Session session, OtrEngineHost engineHost) {
        this.session = session;
        this.engineHost = engineHost;
        this.reset();
    }

    public void reset() {
        this.smstate = new SM.SMState();
    }

    private static byte[] computeSessionId(BigInteger s) throws SM.SMException {
        MessageDigest sha256;
        byte[] sdata;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OtrOutputStream oos = new OtrOutputStream(out);
            oos.write(0);
            oos.writeBigInt(s);
            sdata = out.toByteArray();
            oos.close();
        }
        catch (IOException e1) {
            throw new SM.SMException(e1);
        }
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SM.SMException("cannot find SHA-256");
        }
        byte[] res = sha256.digest(sdata);
        byte[] secure_session_id = new byte[8];
        System.arraycopy(res, 0, secure_session_id, 0, 8);
        return secure_session_id;
    }

    public List<TLV> initRespondSmp(String question, String secret, boolean initiating) throws OtrException {
        byte[] smpmsg;
        MessageDigest sha256;
        byte[] sessionId;
        byte[] their_fp;
        if (!initiating && !this.smstate.asked) {
            throw new OtrException(new IllegalStateException("There is no question to be answered."));
        }
        byte[] our_fp = this.engineHost.getLocalFingerprintRaw(this.session.getSessionID());
        PublicKey remotePublicKey = this.session.getRemotePublicKey();
        try {
            their_fp = new OtrCryptoEngineImpl().getFingerprintRaw(remotePublicKey);
        }
        catch (OtrCryptoException e) {
            throw new OtrException(e);
        }
        try {
            sessionId = OtrSm.computeSessionId(this.session.getS());
        }
        catch (SM.SMException ex) {
            throw new OtrException(ex);
        }
        byte[] bytes = secret.getBytes();
        int combined_buf_len = 41 + sessionId.length + bytes.length;
        byte[] combined_buf = new byte[combined_buf_len];
        combined_buf[0] = 1;
        if (initiating) {
            System.arraycopy(our_fp, 0, combined_buf, 1, 20);
            System.arraycopy(their_fp, 0, combined_buf, 21, 20);
        } else {
            System.arraycopy(their_fp, 0, combined_buf, 1, 20);
            System.arraycopy(our_fp, 0, combined_buf, 21, 20);
        }
        System.arraycopy(sessionId, 0, combined_buf, 41, sessionId.length);
        System.arraycopy(bytes, 0, combined_buf, 41 + sessionId.length, bytes.length);
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new OtrException(ex);
        }
        byte[] combined_secret = sha256.digest(combined_buf);
        try {
            smpmsg = initiating ? SM.step1(this.smstate, combined_secret) : SM.step2b(this.smstate, combined_secret);
        }
        catch (SM.SMException ex) {
            throw new OtrException(ex);
        }
        if (question != null && initiating) {
            bytes = question.getBytes();
            byte[] qsmpmsg = new byte[bytes.length + 1 + smpmsg.length];
            System.arraycopy(bytes, 0, qsmpmsg, 0, bytes.length);
            System.arraycopy(smpmsg, 0, qsmpmsg, bytes.length + 1, smpmsg.length);
            smpmsg = qsmpmsg;
        }
        TLV sendtlv = new TLV(initiating ? (question != null ? 7 : 2) : 3, smpmsg);
        this.smstate.nextExpected = initiating ? 1 : 2;
        this.smstate.approved = initiating || question == null;
        return this.makeTlvList(sendtlv);
    }

    public List<TLV> abortSmp() throws OtrException {
        TLV sendtlv = new TLV(6, new byte[0]);
        this.smstate.nextExpected = 0;
        return this.makeTlvList(sendtlv);
    }

    public boolean doProcessTlv(TLV tlv) throws OtrException {
        int nextMsg = this.smstate.nextExpected;
        int tlvType = tlv.getType();
        if (tlvType == 7 && nextMsg == 0) {
            byte[] question = tlv.getValue();
            int qlen = 0;
            while (qlen != question.length && question[qlen] != 0) {
                ++qlen;
            }
            qlen = qlen == question.length ? 0 : ++qlen;
            byte[] input = new byte[question.length - qlen];
            System.arraycopy(question, qlen, input, 0, question.length - qlen);
            try {
                SM.step2a(this.smstate, input, 1);
            }
            catch (SM.SMException e) {
                throw new OtrException(e);
            }
            if (qlen != 0) {
                --qlen;
            }
            byte[] plainq = new byte[qlen];
            System.arraycopy(question, 0, plainq, 0, qlen);
            if (this.smstate.smProgState != -2) {
                this.smstate.asked = true;
                this.engineHost.askForSecret(this.session.getSessionID(), new String(plainq));
            } else {
                this.engineHost.smpError(this.session.getSessionID(), tlvType, true);
                this.reset();
            }
        } else if (tlvType == 7) {
            this.engineHost.smpError(this.session.getSessionID(), tlvType, false);
        } else if (tlvType == 2 && nextMsg == 0) {
            try {
                SM.step2a(this.smstate, tlv.getValue(), 0);
            }
            catch (SM.SMException e) {
                throw new OtrException(e);
            }
            if (this.smstate.smProgState != -2) {
                this.smstate.asked = true;
                this.engineHost.askForSecret(this.session.getSessionID(), null);
            } else {
                this.engineHost.smpError(this.session.getSessionID(), tlvType, true);
                this.reset();
            }
        } else if (tlvType == 2) {
            this.engineHost.smpError(this.session.getSessionID(), tlvType, false);
        } else if (tlvType == 3 && nextMsg == 1) {
            byte[] nextmsg;
            try {
                nextmsg = SM.step3(this.smstate, tlv.getValue());
            }
            catch (SM.SMException e) {
                throw new OtrException(e);
            }
            if (this.smstate.smProgState != -2) {
                TLV sendtlv = new TLV(4, nextmsg);
                this.smstate.nextExpected = 3;
                this.engineHost.injectMessage(this.session.getSessionID(), this.session.transformSending("", this.makeTlvList(sendtlv)));
            } else {
                this.engineHost.smpError(this.session.getSessionID(), tlvType, true);
                this.reset();
            }
        } else if (tlvType == 3) {
            this.engineHost.smpError(this.session.getSessionID(), tlvType, false);
        } else if (tlvType == 4 && nextMsg == 2) {
            byte[] nextmsg;
            try {
                nextmsg = SM.step4(this.smstate, tlv.getValue());
            }
            catch (SM.SMException e) {
                throw new OtrException(e);
            }
            if (this.smstate.smProgState == 1) {
                this.engineHost.verify(this.session.getSessionID(), this.smstate.approved);
            } else {
                this.engineHost.unverify(this.session.getSessionID());
            }
            if (this.smstate.smProgState != -2) {
                TLV sendtlv = new TLV(5, nextmsg);
                this.engineHost.injectMessage(this.session.getSessionID(), this.session.transformSending("", this.makeTlvList(sendtlv)));
            } else {
                this.engineHost.smpError(this.session.getSessionID(), tlvType, true);
            }
            this.reset();
        } else if (tlvType == 4) {
            this.engineHost.smpError(this.session.getSessionID(), tlvType, false);
        } else if (tlvType == 5 && nextMsg == 3) {
            try {
                SM.step5(this.smstate, tlv.getValue());
            }
            catch (SM.SMException e) {
                throw new OtrException(e);
            }
            if (this.smstate.smProgState == 1) {
                this.engineHost.verify(this.session.getSessionID(), this.smstate.approved);
            } else {
                this.engineHost.unverify(this.session.getSessionID());
            }
            if (this.smstate.smProgState == -2) {
                this.engineHost.smpError(this.session.getSessionID(), tlvType, true);
            }
            this.reset();
        } else if (tlvType == 5) {
            this.engineHost.smpError(this.session.getSessionID(), tlvType, false);
        } else if (tlvType == 6) {
            this.engineHost.smpAborted(this.session.getSessionID());
            this.reset();
        } else {
            return false;
        }
        return true;
    }

    private List<TLV> makeTlvList(TLV sendtlv) {
        ArrayList<TLV> tlvs = new ArrayList<TLV>(1);
        tlvs.add(sendtlv);
        return tlvs;
    }
}

