/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.io.messages;

import java.io.IOException;
import java.util.Arrays;
import net.java.otr4j.OtrException;
import net.java.otr4j.crypto.OtrCryptoEngineImpl;
import net.java.otr4j.io.SerializationUtils;
import net.java.otr4j.io.messages.AbstractEncodedMessage;

public class SignatureMessage
extends AbstractEncodedMessage {
    public byte[] xEncrypted;
    public byte[] xEncryptedMAC;

    protected SignatureMessage(int messageType, int protocolVersion, byte[] xEncrypted, byte[] xEncryptedMAC) {
        super(messageType, protocolVersion);
        this.xEncrypted = xEncrypted;
        this.xEncryptedMAC = xEncryptedMAC;
    }

    public SignatureMessage(int protocolVersion, byte[] xEncrypted, byte[] xEncryptedMAC) {
        this(18, protocolVersion, xEncrypted, xEncryptedMAC);
    }

    public byte[] decrypt(byte[] key) throws OtrException {
        return new OtrCryptoEngineImpl().aesDecrypt(key, null, this.xEncrypted);
    }

    public boolean verify(byte[] key) throws OtrException {
        byte[] xbEncrypted;
        try {
            xbEncrypted = SerializationUtils.writeData(this.xEncrypted);
        }
        catch (IOException e) {
            throw new OtrException(e);
        }
        byte[] xEncryptedMAC = new OtrCryptoEngineImpl().sha256Hmac160(xbEncrypted, key);
        return Arrays.equals(xEncryptedMAC, xEncryptedMAC);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.xEncrypted);
        result = 31 * result + Arrays.hashCode(this.xEncryptedMAC);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignatureMessage other = (SignatureMessage)obj;
        if (!Arrays.equals(this.xEncrypted, other.xEncrypted)) {
            return false;
        }
        return Arrays.equals(this.xEncryptedMAC, other.xEncryptedMAC);
    }
}

