/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.session;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Logger;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.OtrException;
import net.java.otr4j.crypto.OtrCryptoEngine;
import net.java.otr4j.crypto.OtrCryptoEngineImpl;
import net.java.otr4j.io.SerializationUtils;
import net.java.otr4j.io.messages.AbstractMessage;
import net.java.otr4j.io.messages.DHCommitMessage;
import net.java.otr4j.io.messages.DHKeyMessage;
import net.java.otr4j.io.messages.QueryMessage;
import net.java.otr4j.io.messages.RevealSignatureMessage;
import net.java.otr4j.io.messages.SignatureM;
import net.java.otr4j.io.messages.SignatureMessage;
import net.java.otr4j.io.messages.SignatureX;
import net.java.otr4j.session.AuthContext;
import net.java.otr4j.session.Session;
import net.java.otr4j.session.SessionID;

class AuthContextImpl
implements AuthContext {
    private Session session;
    private int authenticationState;
    private byte[] r;
    private DHPublicKey remoteDHPublicKey;
    private byte[] remoteDHPublicKeyEncrypted;
    private byte[] remoteDHPublicKeyHash;
    private KeyPair localDHKeyPair;
    private int localDHPrivateKeyID;
    private byte[] localDHPublicKeyBytes;
    private byte[] localDHPublicKeyHash;
    private byte[] localDHPublicKeyEncrypted;
    private BigInteger s;
    private byte[] c;
    private byte[] m1;
    private byte[] m2;
    private byte[] cp;
    private byte[] m1p;
    private byte[] m2p;
    private KeyPair localLongTermKeyPair;
    private Boolean isSecure = false;
    private int protocolVersion;
    private static Logger logger = Logger.getLogger(AuthContextImpl.class.getName());
    private MessageFactory messageFactory = new MessageFactory();
    private PublicKey remoteLongTermPublicKey;

    public AuthContextImpl(Session session) {
        this.setSession(session);
        this.reset();
    }

    private int getProtocolVersion() {
        return this.protocolVersion;
    }

    private void setProtocolVersion(int protoVersion) {
        this.protocolVersion = protoVersion;
    }

    @Override
    public void reset() {
        logger.finest("Resetting authentication state.");
        this.authenticationState = 0;
        this.r = null;
        this.remoteDHPublicKey = null;
        this.remoteDHPublicKeyEncrypted = null;
        this.remoteDHPublicKeyHash = null;
        this.localDHKeyPair = null;
        this.localDHPrivateKeyID = 1;
        this.localDHPublicKeyBytes = null;
        this.localDHPublicKeyHash = null;
        this.localDHPublicKeyEncrypted = null;
        this.s = null;
        this.m2p = null;
        this.m1p = null;
        this.cp = null;
        this.m2 = null;
        this.m1 = null;
        this.c = null;
        this.localLongTermKeyPair = null;
        this.protocolVersion = 0;
        this.setIsSecure(false);
    }

    private void setIsSecure(Boolean isSecure) {
        this.isSecure = isSecure;
    }

    @Override
    public boolean getIsSecure() {
        return this.isSecure;
    }

    private void setAuthenticationState(int authenticationState) {
        this.authenticationState = authenticationState;
    }

    private int getAuthenticationState() {
        return this.authenticationState;
    }

    private byte[] getR() {
        if (this.r == null) {
            logger.finest("Picking random key r.");
            this.r = new byte[16];
            new Random().nextBytes(this.r);
        }
        return this.r;
    }

    private void setRemoteDHPublicKey(DHPublicKey dhPublicKey) throws OtrException {
        if (dhPublicKey.getY().compareTo(OtrCryptoEngine.MODULUS_MINUS_TWO) > 0) {
            throw new OtrException(new IllegalArgumentException("Illegal D-H Public Key value, Ignoring message."));
        }
        if (dhPublicKey.getY().compareTo(OtrCryptoEngine.BIGINTEGER_TWO) < 0) {
            throw new OtrException(new IllegalArgumentException("Illegal D-H Public Key value, Ignoring message."));
        }
        logger.finest("Received D-H Public Key is a legal value.");
        this.remoteDHPublicKey = dhPublicKey;
    }

    @Override
    public DHPublicKey getRemoteDHPublicKey() {
        return this.remoteDHPublicKey;
    }

    private void setRemoteDHPublicKeyEncrypted(byte[] remoteDHPublicKeyEncrypted) {
        logger.finest("Storing encrypted remote public key.");
        this.remoteDHPublicKeyEncrypted = remoteDHPublicKeyEncrypted;
    }

    private byte[] getRemoteDHPublicKeyEncrypted() {
        return this.remoteDHPublicKeyEncrypted;
    }

    private void setRemoteDHPublicKeyHash(byte[] remoteDHPublicKeyHash) {
        logger.finest("Storing encrypted remote public key hash.");
        this.remoteDHPublicKeyHash = remoteDHPublicKeyHash;
    }

    private byte[] getRemoteDHPublicKeyHash() {
        return this.remoteDHPublicKeyHash;
    }

    @Override
    public KeyPair getLocalDHKeyPair() throws OtrException {
        if (this.localDHKeyPair == null) {
            this.localDHKeyPair = new OtrCryptoEngineImpl().generateDHKeyPair();
            logger.finest("Generated local D-H key pair.");
        }
        return this.localDHKeyPair;
    }

    private int getLocalDHKeyPairID() {
        return this.localDHPrivateKeyID;
    }

    private byte[] getLocalDHPublicKeyHash() throws OtrException {
        if (this.localDHPublicKeyHash == null) {
            this.localDHPublicKeyHash = new OtrCryptoEngineImpl().sha256Hash(this.getLocalDHPublicKeyBytes());
            logger.finest("Hashed local D-H public key.");
        }
        return this.localDHPublicKeyHash;
    }

    private byte[] getLocalDHPublicKeyEncrypted() throws OtrException {
        if (this.localDHPublicKeyEncrypted == null) {
            this.localDHPublicKeyEncrypted = new OtrCryptoEngineImpl().aesEncrypt(this.getR(), null, this.getLocalDHPublicKeyBytes());
            logger.finest("Encrypted our D-H public key.");
        }
        return this.localDHPublicKeyEncrypted;
    }

    @Override
    public BigInteger getS() throws OtrException {
        if (this.s == null) {
            this.s = new OtrCryptoEngineImpl().generateSecret(this.getLocalDHKeyPair().getPrivate(), this.getRemoteDHPublicKey());
            logger.finest("Generated shared secret.");
        }
        return this.s;
    }

    private byte[] getC() throws OtrException {
        if (this.c != null) {
            return this.c;
        }
        byte[] h2 = this.h2((byte)1);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        this.c = new byte[16];
        buff.get(this.c);
        logger.finest("Computed c.");
        return this.c;
    }

    private byte[] getM1() throws OtrException {
        if (this.m1 != null) {
            return this.m1;
        }
        byte[] h2 = this.h2((byte)2);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] m1 = new byte[32];
        buff.get(m1);
        logger.finest("Computed m1.");
        this.m1 = m1;
        return m1;
    }

    private byte[] getM2() throws OtrException {
        if (this.m2 != null) {
            return this.m2;
        }
        byte[] h2 = this.h2((byte)3);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] m2 = new byte[32];
        buff.get(m2);
        logger.finest("Computed m2.");
        this.m2 = m2;
        return m2;
    }

    private byte[] getCp() throws OtrException {
        if (this.cp != null) {
            return this.cp;
        }
        byte[] h2 = this.h2((byte)1);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] cp = new byte[16];
        buff.position(16);
        buff.get(cp);
        logger.finest("Computed c'.");
        this.cp = cp;
        return cp;
    }

    private byte[] getM1p() throws OtrException {
        if (this.m1p != null) {
            return this.m1p;
        }
        byte[] h2 = this.h2((byte)4);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] m1p = new byte[32];
        buff.get(m1p);
        this.m1p = m1p;
        logger.finest("Computed m1'.");
        return m1p;
    }

    private byte[] getM2p() throws OtrException {
        if (this.m2p != null) {
            return this.m2p;
        }
        byte[] h2 = this.h2((byte)5);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] m2p = new byte[32];
        buff.get(m2p);
        this.m2p = m2p;
        logger.finest("Computed m2'.");
        return m2p;
    }

    @Override
    public KeyPair getLocalLongTermKeyPair() throws OtrException {
        if (this.localLongTermKeyPair == null) {
            this.localLongTermKeyPair = this.getSession().getLocalKeyPair();
        }
        return this.localLongTermKeyPair;
    }

    private byte[] h2(byte b) throws OtrException {
        byte[] secbytes;
        try {
            secbytes = SerializationUtils.writeMpi(this.getS());
        }
        catch (IOException e) {
            throw new OtrException(e);
        }
        int len = secbytes.length + 1;
        ByteBuffer buff = ByteBuffer.allocate(len);
        buff.put(b);
        buff.put(secbytes);
        byte[] sdata = buff.array();
        return new OtrCryptoEngineImpl().sha256Hash(sdata);
    }

    private byte[] getLocalDHPublicKeyBytes() throws OtrException {
        if (this.localDHPublicKeyBytes == null) {
            try {
                this.localDHPublicKeyBytes = SerializationUtils.writeMpi(((DHPublicKey)this.getLocalDHKeyPair().getPublic()).getY());
            }
            catch (IOException e) {
                throw new OtrException(e);
            }
        }
        return this.localDHPublicKeyBytes;
    }

    @Override
    public void handleReceivingMessage(AbstractMessage m) throws OtrException {
        switch (m.messageType) {
            case 2: {
                this.handleDHCommitMessage((DHCommitMessage)m);
                break;
            }
            case 10: {
                this.handleDHKeyMessage((DHKeyMessage)m);
                break;
            }
            case 17: {
                this.handleRevealSignatureMessage((RevealSignatureMessage)m);
                break;
            }
            case 18: {
                this.handleSignatureMessage((SignatureMessage)m);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void handleSignatureMessage(SignatureMessage m) throws OtrException {
        Session session = this.getSession();
        SessionID sessionID = session.getSessionID();
        logger.finest(String.valueOf(sessionID.getAccountID()) + " received a signature message from " + sessionID.getUserID() + " throught " + sessionID.getProtocolName() + ".");
        if (!session.getSessionPolicy().getAllowV2()) {
            logger.finest("Policy does not allow OTRv2, ignoring message.");
            return;
        }
        switch (this.getAuthenticationState()) {
            case 3: {
                byte[] signature;
                SignatureX remoteX;
                if (!m.verify(this.getM2p())) {
                    logger.finest("Signature MACs are not equal, ignoring message.");
                    return;
                }
                byte[] remoteXDecrypted = m.decrypt(this.getCp());
                try {
                    remoteX = SerializationUtils.toMysteriousX(remoteXDecrypted);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                PublicKey remoteLongTermPublicKey = remoteX.longTermPublicKey;
                SignatureM remoteM = new SignatureM(this.getRemoteDHPublicKey(), (DHPublicKey)this.getLocalDHKeyPair().getPublic(), remoteLongTermPublicKey, remoteX.dhKeyID);
                OtrCryptoEngineImpl otrCryptoEngine = new OtrCryptoEngineImpl();
                try {
                    signature = otrCryptoEngine.sha256Hmac(SerializationUtils.toByteArray(remoteM), this.getM1p());
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                if (!otrCryptoEngine.verify(signature, remoteLongTermPublicKey, remoteX.signature)) {
                    logger.finest("Signature verification failed.");
                    return;
                }
                this.setIsSecure(true);
                this.setRemoteLongTermPublicKey(remoteLongTermPublicKey);
                break;
            }
            default: {
                logger.finest("We were not expecting a signature, ignoring message.");
                return;
            }
        }
    }

    private void handleRevealSignatureMessage(RevealSignatureMessage m) throws OtrException {
        Session session = this.getSession();
        SessionID sessionID = session.getSessionID();
        logger.finest(String.valueOf(sessionID.getAccountID()) + " received a reveal signature message from " + sessionID.getUserID() + " throught " + sessionID.getProtocolName() + ".");
        if (!session.getSessionPolicy().getAllowV2()) {
            logger.finest("Policy does not allow OTRv2, ignoring message.");
            return;
        }
        switch (this.getAuthenticationState()) {
            case 2: {
                byte[] signature;
                SignatureX remoteX;
                BigInteger remoteDHPublicKeyMpi;
                OtrCryptoEngineImpl otrCryptoEngine = new OtrCryptoEngineImpl();
                byte[] remoteDHPublicKeyDecrypted = otrCryptoEngine.aesDecrypt(m.revealedKey, null, this.getRemoteDHPublicKeyEncrypted());
                byte[] remoteDHPublicKeyHash = otrCryptoEngine.sha256Hash(remoteDHPublicKeyDecrypted);
                if (!Arrays.equals(remoteDHPublicKeyHash, this.getRemoteDHPublicKeyHash())) {
                    logger.finest("Hashes don't match, ignoring message.");
                    return;
                }
                try {
                    remoteDHPublicKeyMpi = SerializationUtils.readMpi(remoteDHPublicKeyDecrypted);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                this.setRemoteDHPublicKey(otrCryptoEngine.getDHPublicKey(remoteDHPublicKeyMpi));
                if (!m.verify(this.getM2())) {
                    logger.finest("Signature MACs are not equal, ignoring message.");
                    return;
                }
                byte[] remoteXDecrypted = m.decrypt(this.getC());
                try {
                    remoteX = SerializationUtils.toMysteriousX(remoteXDecrypted);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                PublicKey remoteLongTermPublicKey = remoteX.longTermPublicKey;
                SignatureM remoteM = new SignatureM(this.getRemoteDHPublicKey(), (DHPublicKey)this.getLocalDHKeyPair().getPublic(), remoteLongTermPublicKey, remoteX.dhKeyID);
                try {
                    signature = otrCryptoEngine.sha256Hmac(SerializationUtils.toByteArray(remoteM), this.getM1());
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                if (!otrCryptoEngine.verify(signature, remoteLongTermPublicKey, remoteX.signature)) {
                    logger.finest("Signature verification failed.");
                    return;
                }
                logger.finest("Signature verification succeeded.");
                this.setAuthenticationState(0);
                this.setIsSecure(true);
                this.setRemoteLongTermPublicKey(remoteLongTermPublicKey);
                this.getSession().injectMessage(this.messageFactory.getSignatureMessage());
                break;
            }
            default: {
                logger.finest("Ignoring message.");
            }
        }
    }

    private void handleDHKeyMessage(DHKeyMessage m) throws OtrException {
        Session session = this.getSession();
        SessionID sessionID = session.getSessionID();
        logger.finest(String.valueOf(sessionID.getAccountID()) + " received a D-H key message from " + sessionID.getUserID() + " throught " + sessionID.getProtocolName() + ".");
        if (!session.getSessionPolicy().getAllowV2()) {
            logger.finest("If ALLOW_V2 is not set, ignore this message.");
            return;
        }
        switch (this.getAuthenticationState()) {
            case 0: 
            case 1: {
                this.setRemoteDHPublicKey(m.dhPublicKey);
                this.setAuthenticationState(3);
                this.getSession().injectMessage(this.messageFactory.getRevealSignatureMessage());
                logger.finest("Sent Reveal Signature.");
                break;
            }
            case 3: {
                if (m.dhPublicKey.getY().equals(this.getRemoteDHPublicKey().getY())) {
                    this.getSession().injectMessage(this.messageFactory.getRevealSignatureMessage());
                    logger.finest("Resent Reveal Signature.");
                    break;
                }
                logger.finest("Ignoring message.");
                break;
            }
        }
    }

    private void handleDHCommitMessage(DHCommitMessage m) throws OtrException {
        Session session = this.getSession();
        SessionID sessionID = session.getSessionID();
        logger.finest(String.valueOf(sessionID.getAccountID()) + " received a D-H commit message from " + sessionID.getUserID() + " throught " + sessionID.getProtocolName() + ".");
        if (!session.getSessionPolicy().getAllowV2()) {
            logger.finest("ALLOW_V2 is not set, ignore this message.");
            return;
        }
        switch (this.getAuthenticationState()) {
            case 0: {
                this.reset();
                this.setProtocolVersion(2);
                this.setRemoteDHPublicKeyEncrypted(m.dhPublicKeyEncrypted);
                this.setRemoteDHPublicKeyHash(m.dhPublicKeyHash);
                this.setAuthenticationState(2);
                this.getSession().injectMessage(this.messageFactory.getDHKeyMessage());
                logger.finest("Sent D-H key.");
                break;
            }
            case 1: {
                BigInteger ourHash = new BigInteger(1, this.getLocalDHPublicKeyHash());
                BigInteger theirHash = new BigInteger(1, m.dhPublicKeyHash);
                if (theirHash.compareTo(ourHash) == -1) {
                    this.getSession().injectMessage(this.messageFactory.getDHCommitMessage());
                    logger.finest("Ignored the incoming D-H Commit message, but resent our D-H Commit message.");
                    break;
                }
                this.reset();
                this.setProtocolVersion(2);
                this.setRemoteDHPublicKeyEncrypted(m.dhPublicKeyEncrypted);
                this.setRemoteDHPublicKeyHash(m.dhPublicKeyHash);
                this.setAuthenticationState(2);
                this.getSession().injectMessage(this.messageFactory.getDHKeyMessage());
                logger.finest("Forgot our old gx value that we sent (encrypted) earlier, and pretended we're in AUTHSTATE_NONE -> Sent D-H key.");
                break;
            }
            case 2: {
                this.setRemoteDHPublicKeyEncrypted(m.dhPublicKeyEncrypted);
                this.setRemoteDHPublicKeyHash(m.dhPublicKeyHash);
                this.getSession().injectMessage(this.messageFactory.getDHKeyMessage());
                logger.finest("Sent D-H key.");
                break;
            }
            case 3: {
                this.reset();
                this.setRemoteDHPublicKeyEncrypted(m.dhPublicKeyEncrypted);
                this.setRemoteDHPublicKeyHash(m.dhPublicKeyHash);
                this.setAuthenticationState(2);
                this.getSession().injectMessage(this.messageFactory.getDHKeyMessage());
                logger.finest("Sent D-H key.");
                break;
            }
            case 4: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void startV2Auth() throws OtrException {
        logger.finest("Starting Authenticated Key Exchange, sending query message");
        this.getSession().injectMessage(this.messageFactory.getQueryMessage());
    }

    @Override
    public void respondV2Auth() throws OtrException {
        logger.finest("Responding to Query Message");
        this.reset();
        this.setProtocolVersion(2);
        this.setAuthenticationState(1);
        logger.finest("Sending D-H Commit.");
        this.getSession().injectMessage(this.messageFactory.getDHCommitMessage());
    }

    private void setSession(Session session) {
        this.session = session;
    }

    private Session getSession() {
        return this.session;
    }

    @Override
    public PublicKey getRemoteLongTermPublicKey() {
        return this.remoteLongTermPublicKey;
    }

    private void setRemoteLongTermPublicKey(PublicKey pubKey) {
        this.remoteLongTermPublicKey = pubKey;
    }

    class MessageFactory {
        MessageFactory() {
        }

        private QueryMessage getQueryMessage() {
            Vector<Integer> versions = new Vector<Integer>();
            versions.add(2);
            return new QueryMessage(versions);
        }

        private DHCommitMessage getDHCommitMessage() throws OtrException {
            return new DHCommitMessage(AuthContextImpl.this.getProtocolVersion(), AuthContextImpl.this.getLocalDHPublicKeyHash(), AuthContextImpl.this.getLocalDHPublicKeyEncrypted());
        }

        private DHKeyMessage getDHKeyMessage() throws OtrException {
            return new DHKeyMessage(AuthContextImpl.this.getProtocolVersion(), (DHPublicKey)AuthContextImpl.this.getLocalDHKeyPair().getPublic());
        }

        private RevealSignatureMessage getRevealSignatureMessage() throws OtrException {
            try {
                SignatureM m = new SignatureM((DHPublicKey)AuthContextImpl.this.getLocalDHKeyPair().getPublic(), AuthContextImpl.this.getRemoteDHPublicKey(), AuthContextImpl.this.getLocalLongTermKeyPair().getPublic(), AuthContextImpl.this.getLocalDHKeyPairID());
                OtrCryptoEngineImpl otrCryptoEngine = new OtrCryptoEngineImpl();
                byte[] mhash = otrCryptoEngine.sha256Hmac(SerializationUtils.toByteArray(m), AuthContextImpl.this.getM1());
                byte[] signature = otrCryptoEngine.sign(mhash, AuthContextImpl.this.getLocalLongTermKeyPair().getPrivate());
                SignatureX mysteriousX = new SignatureX(AuthContextImpl.this.getLocalLongTermKeyPair().getPublic(), AuthContextImpl.this.getLocalDHKeyPairID(), signature);
                byte[] xEncrypted = otrCryptoEngine.aesEncrypt(AuthContextImpl.this.getC(), null, SerializationUtils.toByteArray(mysteriousX));
                byte[] tmp = SerializationUtils.writeData(xEncrypted);
                byte[] xEncryptedHash = otrCryptoEngine.sha256Hmac160(tmp, AuthContextImpl.this.getM2());
                return new RevealSignatureMessage(AuthContextImpl.this.getProtocolVersion(), xEncrypted, xEncryptedHash, AuthContextImpl.this.getR());
            }
            catch (IOException e) {
                throw new OtrException(e);
            }
        }

        private SignatureMessage getSignatureMessage() throws OtrException {
            byte[] mhash;
            SignatureM m = new SignatureM((DHPublicKey)AuthContextImpl.this.getLocalDHKeyPair().getPublic(), AuthContextImpl.this.getRemoteDHPublicKey(), AuthContextImpl.this.getLocalLongTermKeyPair().getPublic(), AuthContextImpl.this.getLocalDHKeyPairID());
            OtrCryptoEngineImpl otrCryptoEngine = new OtrCryptoEngineImpl();
            try {
                mhash = otrCryptoEngine.sha256Hmac(SerializationUtils.toByteArray(m), AuthContextImpl.this.getM1p());
            }
            catch (IOException e) {
                throw new OtrException(e);
            }
            byte[] signature = otrCryptoEngine.sign(mhash, AuthContextImpl.this.getLocalLongTermKeyPair().getPrivate());
            SignatureX mysteriousX = new SignatureX(AuthContextImpl.this.getLocalLongTermKeyPair().getPublic(), AuthContextImpl.this.getLocalDHKeyPairID(), signature);
            try {
                byte[] xEncrypted = otrCryptoEngine.aesEncrypt(AuthContextImpl.this.getCp(), null, SerializationUtils.toByteArray(mysteriousX));
                byte[] tmp = SerializationUtils.writeData(xEncrypted);
                byte[] xEncryptedHash = otrCryptoEngine.sha256Hmac160(tmp, AuthContextImpl.this.getM2p());
                return new SignatureMessage(AuthContextImpl.this.getProtocolVersion(), xEncrypted, xEncryptedHash);
            }
            catch (IOException e) {
                throw new OtrException(e);
            }
        }
    }
}

