Ext.data.JsonP.Ext_util_Format({"tagname":"class","html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/Format.html#Ext-util-Format' target='_blank'>Format.js</a></div></pre><div class='doc-contents'><p>This class is a centralized place for formatting functions. It includes\nfunctions to format various different types of data, such as text, dates and numeric values.</p>\n\n<p><strong>Localization</strong>\nThis class contains several options for localization. These can be set once the library has loaded,\nall calls to the functions from that point will use the locale settings that were specified.\nOptions include:\n- thousandSeparator\n- decimalSeparator\n- currenyPrecision\n- currencySign\n- currencyAtEnd\nThis class also uses the default date format defined here: <a href=\"#!/api/Ext.Date-property-defaultFormat\" rel=\"Ext.Date-property-defaultFormat\" class=\"docClass\">Ext.Date.defaultFormat</a>.</p>\n\n<p><strong>Using with renderers</strong>\nThere are two helper functions that return a new function that can be used in conjunction with\ngrid renderers:</p>\n\n<pre><code>columns: [{\n    dataIndex: 'date',\n    renderer: Ext.util.Format.dateRenderer('Y-m-d')\n}, {\n    dataIndex: 'time',\n    renderer: Ext.util.Format.numberRenderer('0.000')\n}]\n</code></pre>\n\n<p>Functions that only take a single argument can also be passed directly:</p>\n\n<pre><code>columns: [{\n    dataIndex: 'cost',\n    renderer: Ext.util.Format.usMoney\n}, {\n    dataIndex: 'productCode',\n    renderer: Ext.util.Format.uppercase\n}]\n</code></pre>\n\n<p><strong>Using with XTemplates</strong>\nXTemplates can also directly use <a href=\"#!/api/Ext.util.Format\" rel=\"Ext.util.Format\" class=\"docClass\">Ext.util.Format</a> functions:</p>\n\n<pre><code>new Ext.XTemplate([\n    'Date: {startDate:date(\"Y-m-d\")}',\n    'Cost: {cost:usMoney}'\n]);\n</code></pre>\n</div><div class='members'><div id='m-property'><div class='definedBy'>Defined By</div><h3 class='members-title'>Properties</h3><div class='subsection'><div id='property-currencyAtEnd' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-property-currencyAtEnd' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-property-currencyAtEnd' class='name expandable'>currencyAtEnd</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>This may be set to true to make the currency function\nappend the currency sign to the formatted value. ...</div><div class='long'><p>This may be set to <code>true</code> to make the <a href=\"#!/api/Ext.util.Format-method-currency\" rel=\"Ext.util.Format-method-currency\" class=\"docClass\">currency</a> function\nappend the currency sign to the formatted value.</p>\n\n\n<p>This may be overridden in a locale file.</p>\n\n</div></div></div><div id='property-currencyPrecision' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-property-currencyPrecision' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-property-currencyPrecision' class='name expandable'>currencyPrecision</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The number of decimal places that the currency function displays. ...</div><div class='long'><p>The number of decimal places that the <a href=\"#!/api/Ext.util.Format-method-currency\" rel=\"Ext.util.Format-method-currency\" class=\"docClass\">currency</a> function displays.</p>\n\n\n<p>This may be overridden in a locale file.</p>\n\n</div></div></div><div id='property-currencySign' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-property-currencySign' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-property-currencySign' class='name expandable'>currencySign</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The currency sign that the currency function displays. ...</div><div class='long'><p>The currency sign that the <a href=\"#!/api/Ext.util.Format-method-currency\" rel=\"Ext.util.Format-method-currency\" class=\"docClass\">currency</a> function displays.</p>\n\n\n<p>This may be overridden in a locale file.</p>\n\n</div></div></div><div id='property-decimalSeparator' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-property-decimalSeparator' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-property-decimalSeparator' class='name expandable'>decimalSeparator</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The character that the number function uses as a decimal point. ...</div><div class='long'><p>The character that the <a href=\"#!/api/Ext.util.Format-method-number\" rel=\"Ext.util.Format-method-number\" class=\"docClass\">number</a> function uses as a decimal point.</p>\n\n\n<p>This may be overridden in a locale file.</p>\n\n</div></div></div><div id='property-thousandSeparator' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-property-thousandSeparator' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-property-thousandSeparator' class='name expandable'>thousandSeparator</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The character that the number function uses as a thousand separator. ...</div><div class='long'><p>The character that the <a href=\"#!/api/Ext.util.Format-method-number\" rel=\"Ext.util.Format-method-number\" class=\"docClass\">number</a> function uses as a thousand separator.</p>\n\n\n<p>This may be overridden in a locale file.</p>\n\n</div></div></div></div></div><div id='m-method'><div class='definedBy'>Defined By</div><h3 class='members-title'>Methods</h3><div class='subsection'><div id='method-capitalize' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-capitalize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-capitalize' class='name expandable'>capitalize</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> string</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Alias for Ext.String.capitalize. ...</div><div class='long'><p>Alias for <a href=\"#!/api/Ext.String-method-capitalize\" rel=\"Ext.String-method-capitalize\" class=\"docClass\">Ext.String.capitalize</a>.</p>\n\n<p>Capitalize the given string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>string</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-currency' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-currency' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-currency' class='name expandable'>currency</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> sign, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> decimals, <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> end</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Format a number as a currency ...</div><div class='long'><p>Format a number as a currency</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The numeric value to format</p>\n</div></li><li><span class='pre'>sign</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The currency sign to use (defaults to <a href=\"#!/api/Ext.util.Format-property-currencySign\" rel=\"Ext.util.Format-property-currencySign\" class=\"docClass\">currencySign</a>)</p>\n</div></li><li><span class='pre'>decimals</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The number of decimals to use for the currency (defaults to <a href=\"#!/api/Ext.util.Format-property-currencyPrecision\" rel=\"Ext.util.Format-property-currencyPrecision\" class=\"docClass\">currencyPrecision</a>)</p>\n</div></li><li><span class='pre'>end</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True if the currency sign should be at the end of the string (defaults to <a href=\"#!/api/Ext.util.Format-property-currencyAtEnd\" rel=\"Ext.util.Format-property-currencyAtEnd\" class=\"docClass\">currencyAtEnd</a>)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The formatted currency string</p>\n</div></li></ul></div></div></div><div id='method-date' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-date' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-date' class='name expandable'>date</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> value, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> format]</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Formats the passed date using the specified format pattern. ...</div><div class='long'><p>Formats the passed date using the specified format pattern.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The value to format. If a string is passed, it is converted to a Date by the Javascript\nDate object's <a href=\"http://www.w3schools.com/jsref/jsref_parse.asp\">parse()</a> method.</p>\n</div></li><li><span class='pre'>format</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Any valid date format string. Defaults to <a href=\"#!/api/Ext.Date-property-defaultFormat\" rel=\"Ext.Date-property-defaultFormat\" class=\"docClass\">Ext.Date.defaultFormat</a>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The formatted date string.</p>\n</div></li></ul></div></div></div><div id='method-dateRenderer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-dateRenderer' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-dateRenderer' class='name expandable'>dateRenderer</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> format</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></div><div class='description'><div class='short'>Returns a date rendering function that can be reused to apply a date format multiple times efficiently ...</div><div class='long'><p>Returns a date rendering function that can be reused to apply a date format multiple times efficiently</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>format</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Any valid date format string. Defaults to <a href=\"#!/api/Ext.Date-property-defaultFormat\" rel=\"Ext.Date-property-defaultFormat\" class=\"docClass\">Ext.Date.defaultFormat</a>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The date formatting function</p>\n</div></li></ul></div></div></div><div id='method-defaultValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-defaultValue' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-defaultValue' class='name expandable'>defaultValue</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> defaultValue</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Checks a reference and converts it to the default value if it's empty ...</div><div class='long'><p>Checks a reference and converts it to the default value if it's empty</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Reference to check</p>\n</div></li><li><span class='pre'>defaultValue</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The value to insert of it's undefined (defaults to \"\")</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-ellipsis' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-ellipsis' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-ellipsis' class='name expandable'>ellipsis</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> length, <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> word</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Alias for Ext.String.ellipsis. ...</div><div class='long'><p>Alias for <a href=\"#!/api/Ext.String-method-ellipsis\" rel=\"Ext.String-method-ellipsis\" class=\"docClass\">Ext.String.ellipsis</a>.</p>\n\n<p>Truncate a string and add an ellipsis ('...') to the end if it exceeds the specified length</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The string to truncate</p>\n</div></li><li><span class='pre'>length</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The maximum length to allow before truncating</p>\n</div></li><li><span class='pre'>word</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True to try to find a common word break</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The converted text</p>\n</div></li></ul></div></div></div><div id='method-escapeRegex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-escapeRegex' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-escapeRegex' class='name expandable'>escapeRegex</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> str</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Escapes the passed string for use in a regular expression ...</div><div class='long'><p>Escapes the passed string for use in a regular expression</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-fileSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-fileSize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-fileSize' class='name expandable'>fileSize</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> size</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Simple format for a file size (xxx bytes, xxx KB, xxx MB) ...</div><div class='long'><p>Simple format for a file size (xxx bytes, xxx KB, xxx MB)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>size</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The numeric value to format</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The formatted file size</p>\n</div></li></ul></div></div></div><div id='method-format' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-format' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-format' class='name expandable'>format</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> string, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value1, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value2</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Alias for Ext.String.format. ...</div><div class='long'><p>Alias for <a href=\"#!/api/Ext.String-method-format\" rel=\"Ext.String-method-format\" class=\"docClass\">Ext.String.format</a>.</p>\n\n<p>Allows you to define a tokenized string and pass an arbitrary number of arguments to replace the tokens.  Each\ntoken must be unique, and must increment in the format {0}, {1}, etc.  Example usage:</p>\n\n<pre><code>var cls = 'my-class', text = 'Some text';\nvar s = Ext.String.format('&lt;div class=\"{0}\">{1}&lt;/div>', cls, text);\n// s now contains the string: '&lt;div class=\"my-class\">Some text&lt;/div>'\n       </code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>string</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The tokenized string to be formatted</p>\n</div></li><li><span class='pre'>value1</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The value to replace token {0}</p>\n</div></li><li><span class='pre'>value2</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Etc...</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The formatted string</p>\n</div></li></ul></div></div></div><div id='method-htmlDecode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-htmlDecode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-htmlDecode' class='name expandable'>htmlDecode</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Alias for Ext.String.htmlDecode. ...</div><div class='long'><p>Alias for <a href=\"#!/api/Ext.String-method-htmlDecode\" rel=\"Ext.String-method-htmlDecode\" class=\"docClass\">Ext.String.htmlDecode</a>.</p>\n\n<p>Convert certain characters (&amp;, &lt;, >, and \") from their HTML character equivalents.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The string to decode</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The decoded text</p>\n</div></li></ul></div></div></div><div id='method-htmlEncode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-htmlEncode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-htmlEncode' class='name expandable'>htmlEncode</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Alias for Ext.String.htmlEncode. ...</div><div class='long'><p>Alias for <a href=\"#!/api/Ext.String-method-htmlEncode\" rel=\"Ext.String-method-htmlEncode\" class=\"docClass\">Ext.String.htmlEncode</a>.</p>\n\n<p>Convert certain characters (&amp;, &lt;, >, and \") to their HTML character equivalents for literal display in web pages.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The string to encode</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The encoded text</p>\n</div></li></ul></div></div></div><div id='method-leftPad' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-leftPad' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-leftPad' class='name expandable'>leftPad</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> string, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> size, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> character]</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Alias for Ext.String.leftPad. ...</div><div class='long'><p>Alias for <a href=\"#!/api/Ext.String-method-leftPad\" rel=\"Ext.String-method-leftPad\" class=\"docClass\">Ext.String.leftPad</a>.</p>\n\n<p>Pads the left side of a string with a specified character.  This is especially useful\nfor normalizing number and date strings.  Example usage:</p>\n\n<pre><code>var s = Ext.String.leftPad('123', 5, '0');\n// s now contains the string: '00123'\n       </code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>string</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The original string</p>\n</div></li><li><span class='pre'>size</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The total length of the output string</p>\n</div></li><li><span class='pre'>character</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The character with which to pad the original string (defaults to empty string \" \")</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The padded string</p>\n</div></li></ul></div></div></div><div id='method-lowercase' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-lowercase' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-lowercase' class='name expandable'>lowercase</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Converts a string to all lower case letters ...</div><div class='long'><p>Converts a string to all lower case letters</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The text to convert</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The converted text</p>\n</div></li></ul></div></div></div><div id='method-math' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-math' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-math' class='name expandable'>math</a>( <span class='pre'></span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></div><div class='description'><div class='short'>It does simple math for use in a template, for example:\n\nvar tpl = new Ext.Template('{value} * 10 = {value:math(\"* 10...</div><div class='long'><p>It does simple math for use in a template, for example:</p>\n\n<pre><code>var tpl = new Ext.Template('{value} * 10 = {value:math(\"* 10\")}');\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>A function that operates on the passed value.</p>\n</div></li></ul></div></div></div><div id='method-nl2br' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-nl2br' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-nl2br' class='name expandable'>nl2br</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> The</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Converts newline characters to the HTML tag &lt;br/> ...</div><div class='long'><p>Converts newline characters to the HTML tag &lt;br/></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>The</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>string value to format.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The string with embedded &lt;br/> tags in place of newlines.</p>\n</div></li></ul></div></div></div><div id='method-number' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-number' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-number' class='name expandable'>number</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> v, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> format</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Formats the passed number according to the passed format string. ...</div><div class='long'><p>Formats the passed number according to the passed format string.</p>\n\n\n<p>The number of digits after the decimal separator character specifies the number of\ndecimal places in the resulting string. The <u>local-specific</u> decimal character is used in the result.</p>\n\n\n<p>The <i>presence</i> of a thousand separator character in the format string specifies that\nthe <u>locale-specific</u> thousand separator (if any) is inserted separating thousand groups.</p>\n\n\n<p>By default, \",\" is expected as the thousand separator, and \".\" is expected as the decimal separator.</p>\n\n\n<p><b>New to Ext JS 4</b></p>\n\n\n<p>Locale-specific characters are always used in the formatted output when inserting\nthousand and decimal separators.</p>\n\n\n<p>The format string must specify separator characters according to US/UK conventions (\",\" as the\nthousand separator, and \".\" as the decimal separator)</p>\n\n\n<p>To allow specification of format strings according to local conventions for separator characters, add\nthe string <code>/i</code> to the end of the format string.</p>\n\n\n<div style=\"margin-left:40px\">examples (123456.789):\n<div style=\"margin-left:10px\">\n0 - (123456) show only digits, no precision<br>\n0.00 - (123456.78) show only digits, 2 precision<br>\n0.0000 - (123456.7890) show only digits, 4 precision<br>\n0,000 - (123,456) show comma and digits, no precision<br>\n0,000.00 - (123,456.78) show comma and digits, 2 precision<br>\n0,0.00 - (123,456.78) shortcut method, show comma and digits, 2 precision<br>\nTo allow specification of the formatting string using UK/US grouping characters (,) and decimal (.) for international numbers, add /i to the end.\nFor example: 0.000,00/i\n</div></div>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>v</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The number to format.</p>\n</div></li><li><span class='pre'>format</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The way you would like to format this text.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The formatted number.</p>\n</div></li></ul></div></div></div><div id='method-numberRenderer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-numberRenderer' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-numberRenderer' class='name expandable'>numberRenderer</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> format</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></div><div class='description'><div class='short'>Returns a number rendering function that can be reused to apply a number format multiple times efficiently ...</div><div class='long'><p>Returns a number rendering function that can be reused to apply a number format multiple times efficiently</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>format</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Any valid number format string for <a href=\"#!/api/Ext.util.Format-method-number\" rel=\"Ext.util.Format-method-number\" class=\"docClass\">number</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The number formatting function</p>\n</div></li></ul></div></div></div><div id='method-parseBox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-parseBox' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-parseBox' class='name expandable'>parseBox</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> v</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Parses a number or string representing margin sizes into an object. ...</div><div class='long'><p>Parses a number or string representing margin sizes into an object. Supports CSS-style margin declarations\n(e.g. 10, \"10\", \"10 10\", \"10 10 10\" and \"10 10 10 10\" are all valid options and would return the same result)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>v</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The encoded margins</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>An object with margin sizes for top, right, bottom and left</p>\n</div></li></ul></div></div></div><div id='method-plural' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-plural' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-plural' class='name expandable'>plural</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> value, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> singular, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> plural]</span> )</div><div class='description'><div class='short'>Selectively do a plural form of a word based on a numeric value. ...</div><div class='long'><p>Selectively do a plural form of a word based on a numeric value. For example, in a template,\n{commentCount:plural(\"Comment\")}  would result in \"1 Comment\" if commentCount was 1 or would be \"x Comments\"\nif the value is 0 or greater than 1.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The value to compare against</p>\n</div></li><li><span class='pre'>singular</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The singular form of the word</p>\n</div></li><li><span class='pre'>plural</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The plural form of the word (defaults to the singular with an \"s\")</p>\n</div></li></ul></div></div></div><div id='method-round' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-round' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-round' class='name expandable'>round</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> precision</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Rounds the passed number to the required decimal precision. ...</div><div class='long'><p>Rounds the passed number to the required decimal precision.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The numeric value to round.</p>\n</div></li><li><span class='pre'>precision</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The number of decimal places to which to round the first parameter's value.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The rounded value.</p>\n</div></li></ul></div></div></div><div id='method-stripScripts' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-stripScripts' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-stripScripts' class='name expandable'>stripScripts</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Strips all script tags ...</div><div class='long'><p>Strips all script tags</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The text from which to strip script tags</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The stripped text</p>\n</div></li></ul></div></div></div><div id='method-stripTags' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-stripTags' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-stripTags' class='name expandable'>stripTags</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Strips all HTML tags ...</div><div class='long'><p>Strips all HTML tags</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The text from which to strip tags</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The stripped text</p>\n</div></li></ul></div></div></div><div id='method-substr' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-substr' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-substr' class='name expandable'>substr</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> start, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> length</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns a substring from within an original string ...</div><div class='long'><p>Returns a substring from within an original string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The original text</p>\n</div></li><li><span class='pre'>start</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The start index of the substring</p>\n</div></li><li><span class='pre'>length</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The length of the substring</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The substring</p>\n</div></li></ul></div></div></div><div id='method-trim' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-trim' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-trim' class='name expandable'>trim</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> string</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Alias for Ext.String.trim. ...</div><div class='long'><p>Alias for <a href=\"#!/api/Ext.String-method-trim\" rel=\"Ext.String-method-trim\" class=\"docClass\">Ext.String.trim</a>.</p>\n\n<p>Trims whitespace from either end of a string, leaving spaces within the string intact.  Example:\n@example\nvar s = '  foo bar  ';\nalert('-' + s + '-');         //alerts \"- foo bar -\"\nalert('-' + Ext.String.trim(s) + '-');  //alerts \"-foo bar-\"</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>string</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The string to escape</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The trimmed string</p>\n</div></li></ul></div></div></div><div id='method-undef' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-undef' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-undef' class='name expandable'>undef</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Checks a reference and converts it to empty string if it is undefined ...</div><div class='long'><p>Checks a reference and converts it to empty string if it is undefined</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Reference to check</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Empty string if converted, otherwise the original value</p>\n</div></li></ul></div></div></div><div id='method-uppercase' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-uppercase' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-uppercase' class='name expandable'>uppercase</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Converts a string to all upper case letters ...</div><div class='long'><p>Converts a string to all upper case letters</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The text to convert</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The converted text</p>\n</div></li></ul></div></div></div><div id='method-usMoney' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Format' rel='Ext.util.Format' class='definedIn docClass'>Ext.util.Format</a><br/><a href='source/Format.html#Ext-util-Format-method-usMoney' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Format-method-usMoney' class='name expandable'>usMoney</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Format a number as US currency ...</div><div class='long'><p>Format a number as US currency</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The numeric value to format</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The formatted currency string</p>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"meta":{},"requires":[],"deprecated":null,"extends":null,"inheritable":false,"static":false,"superclasses":[],"singleton":true,"code_type":"nop","alias":null,"statics":{"property":[],"css_var":[],"css_mixin":[],"cfg":[],"method":[],"event":[]},"subclasses":[],"uses":[],"protected":false,"mixins":[],"members":{"property":[{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.util.Format","template":null,"required":null,"protected":false,"name":"currencyAtEnd","id":"property-currencyAtEnd"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.util.Format","template":null,"required":null,"protected":false,"name":"currencyPrecision","id":"property-currencyPrecision"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.util.Format","template":null,"required":null,"protected":false,"name":"currencySign","id":"property-currencySign"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.util.Format","template":null,"required":null,"protected":false,"name":"decimalSeparator","id":"property-decimalSeparator"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.util.Format","template":null,"required":null,"protected":false,"name":"thousandSeparator","id":"property-thousandSeparator"}],"css_var":[],"css_mixin":[],"cfg":[],"method":[{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"capitalize","id":"method-capitalize"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"currency","id":"method-currency"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"date","id":"method-date"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"dateRenderer","id":"method-dateRenderer"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"defaultValue","id":"method-defaultValue"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"ellipsis","id":"method-ellipsis"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"escapeRegex","id":"method-escapeRegex"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"fileSize","id":"method-fileSize"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"format","id":"method-format"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"htmlDecode","id":"method-htmlDecode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"htmlEncode","id":"method-htmlEncode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"leftPad","id":"method-leftPad"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"lowercase","id":"method-lowercase"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"math","id":"method-math"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"nl2br","id":"method-nl2br"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"number","id":"method-number"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"numberRenderer","id":"method-numberRenderer"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"parseBox","id":"method-parseBox"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"plural","id":"method-plural"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"round","id":"method-round"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"stripScripts","id":"method-stripScripts"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"stripTags","id":"method-stripTags"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"substr","id":"method-substr"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"trim","id":"method-trim"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"undef","id":"method-undef"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"uppercase","id":"method-uppercase"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Format","template":false,"required":null,"protected":false,"name":"usMoney","id":"method-usMoney"}],"event":[]},"private":false,"component":false,"name":"Ext.util.Format","alternateClassNames":[],"id":"class-Ext.util.Format","mixedInto":[],"xtypes":{},"files":[{"href":"Format.html#Ext-util-Format","filename":"Format.js"}]});