Ext.data.JsonP.Ext_tree_plugin_TreeViewDragDrop({"tagname":"class","html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.Base' rel='Ext.Base' class='docClass'>Ext.Base</a><div class='subclass '><a href='#!/api/Ext.AbstractPlugin' rel='Ext.AbstractPlugin' class='docClass'>Ext.AbstractPlugin</a><div class='subclass '><strong>Ext.tree.plugin.TreeViewDragDrop</strong></div></div></div><h4>Uses</h4><div class='dependency'><a href='#!/api/Ext.tree.ViewDragZone' rel='Ext.tree.ViewDragZone' class='docClass'>Ext.tree.ViewDragZone</a></div><div class='dependency'><a href='#!/api/Ext.tree.ViewDropZone' rel='Ext.tree.ViewDropZone' class='docClass'>Ext.tree.ViewDropZone</a></div><h4>Files</h4><div class='dependency'><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop' target='_blank'>TreeViewDragDrop.js</a></div></pre><div class='doc-contents'><p>This plugin provides drag and/or drop functionality for a TreeView.</p>\n\n<p>It creates a specialized instance of <a href=\"#!/api/Ext.dd.DragZone\" rel=\"Ext.dd.DragZone\" class=\"docClass\">DragZone</a> which knows how to drag out of a\n<a href=\"#!/api/Ext.tree.View\" rel=\"Ext.tree.View\" class=\"docClass\">TreeView</a> and loads the data object which is passed to a cooperating\n<a href=\"#!/api/Ext.dd.DragZone\" rel=\"Ext.dd.DragZone\" class=\"docClass\">DragZone</a>'s methods with the following properties:</p>\n\n<ul>\n<li><p>copy : Boolean</p>\n\n<p>The value of the TreeView's <code>copy</code> property, or <code>true</code> if the TreeView was configured with <code>allowCopy: true</code> <em>and</em>\nthe control key was pressed when the drag operation was begun.</p></li>\n<li><p>view : TreeView</p>\n\n<p>The source TreeView from which the drag originated.</p></li>\n<li><p>ddel : HtmlElement</p>\n\n<p>The drag proxy element which moves with the mouse</p></li>\n<li><p>item : HtmlElement</p>\n\n<p>The TreeView node upon which the mousedown event was registered.</p></li>\n<li><p>records : Array</p>\n\n<p>An Array of <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Models</a> representing the selected data being dragged from the source TreeView.</p></li>\n</ul>\n\n\n<p>It also creates a specialized instance of <a href=\"#!/api/Ext.dd.DropZone\" rel=\"Ext.dd.DropZone\" class=\"docClass\">Ext.dd.DropZone</a> which cooperates with other DropZones which are\nmembers of the same ddGroup which processes such data objects.</p>\n\n<p>Adding this plugin to a view means that two new events may be fired from the client TreeView, <a href=\"#!/api/Ext.tree.plugin.TreeViewDragDrop-event-beforedrop\" rel=\"Ext.tree.plugin.TreeViewDragDrop-event-beforedrop\" class=\"docClass\">beforedrop</a> and\n<a href=\"#!/api/Ext.tree.plugin.TreeViewDragDrop-event-drop\" rel=\"Ext.tree.plugin.TreeViewDragDrop-event-drop\" class=\"docClass\">drop</a>.</p>\n\n<p>Note that the plugin must be added to the tree view, not to the tree panel. For example using viewConfig:</p>\n\n<pre><code>viewConfig: {\n    plugins: { ptype: 'treeviewdragdrop' }\n}\n</code></pre>\n</div><div class='members'><div id='m-cfg'><div class='definedBy'>Defined By</div><h3 class='members-title'>Config options</h3><div class='subsection'><div id='cfg-allowContainerDrop' class='member first-child not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-cfg-allowContainerDrop' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-allowContainerDrop' class='name not-expandable'>allowContainerDrop</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>True if drops on the tree container (outside of a specific tree node) are allowed.</p>\n</div><div class='long'><p>True if drops on the tree container (outside of a specific tree node) are allowed.</p>\n</div></div></div><div id='cfg-allowParentInsert' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-cfg-allowParentInsert' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-allowParentInsert' class='name expandable'>allowParentInsert</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Allow inserting a dragged node between an expanded parent node and its first child that will become a sibling of\nthe ...</div><div class='long'><p>Allow inserting a dragged node between an expanded parent node and its first child that will become a sibling of\nthe parent when dropped.</p>\n</div></div></div><div id='cfg-appendOnly' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-cfg-appendOnly' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-appendOnly' class='name expandable'>appendOnly</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>True if the tree should only allow append drops (use for trees which are sorted). ...</div><div class='long'><p>True if the tree should only allow append drops (use for trees which are sorted).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-ddGroup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-cfg-ddGroup' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-ddGroup' class='name expandable'>ddGroup</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A named drag drop group to which this object belongs. ...</div><div class='long'><p>A named drag drop group to which this object belongs. If a group is specified, then both the DragZones and\nDropZone used by this plugin will only interact with other drag drop objects in the same group.</p>\n<p>Defaults to: <code>&quot;TreeDD&quot;</code></p></div></div></div><div id='cfg-dragGroup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-cfg-dragGroup' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-dragGroup' class='name expandable'>dragGroup</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The ddGroup to which the DragZone will belong. ...</div><div class='long'><p>The ddGroup to which the DragZone will belong.</p>\n\n<p>This defines which other DropZones the DragZone will interact with. Drag/DropZones only interact with other\nDrag/DropZones which are members of the same ddGroup.</p>\n</div></div></div><div id='cfg-dropGroup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-cfg-dropGroup' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-dropGroup' class='name expandable'>dropGroup</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The ddGroup to which the DropZone will belong. ...</div><div class='long'><p>The ddGroup to which the DropZone will belong.</p>\n\n<p>This defines which other DragZones the DropZone will interact with. Drag/DropZones only interact with other\nDrag/DropZones which are members of the same ddGroup.</p>\n</div></div></div><div id='cfg-enableDrag' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-cfg-enableDrag' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-enableDrag' class='name expandable'>enableDrag</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Set to false to disallow dragging items from the View. ...</div><div class='long'><p>Set to <code>false</code> to disallow dragging items from the View.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-enableDrop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-cfg-enableDrop' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-enableDrop' class='name expandable'>enableDrop</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Set to false to disallow the View from accepting drop gestures. ...</div><div class='long'><p>Set to <code>false</code> to disallow the View from accepting drop gestures.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-expandDelay' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-cfg-expandDelay' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-expandDelay' class='name expandable'>expandDelay</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The delay in milliseconds to wait before expanding a target tree node while dragging a droppable node over the\ntarget. ...</div><div class='long'><p>The delay in milliseconds to wait before expanding a target tree node while dragging a droppable node over the\ntarget.</p>\n<p>Defaults to: <code>1000</code></p></div></div></div><div id='cfg-nodeHighlightColor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-cfg-nodeHighlightColor' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightColor' class='name expandable'>nodeHighlightColor</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The color to use when visually highlighting the dragged or dropped node (default value is light blue). ...</div><div class='long'><p>The color to use when visually highlighting the dragged or dropped node (default value is light blue).\nThe color must be a 6 digit hex value, without a preceding '#'. See also <a href=\"#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightOnDrop\" rel=\"Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightOnDrop\" class=\"docClass\">nodeHighlightOnDrop</a> and\n<a href=\"#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightOnRepair\" rel=\"Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightOnRepair\" class=\"docClass\">nodeHighlightOnRepair</a>.</p>\n<p>Defaults to: <code>&quot;c3daf9&quot;</code></p></div></div></div><div id='cfg-nodeHighlightOnDrop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-cfg-nodeHighlightOnDrop' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightOnDrop' class='name expandable'>nodeHighlightOnDrop</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Whether or not to highlight any nodes after they are\nsuccessfully dropped on their target. ...</div><div class='long'><p>Whether or not to highlight any nodes after they are\nsuccessfully dropped on their target. Defaults to the value of <code>Ext.enableFx</code>.\nSee also <a href=\"#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightColor\" rel=\"Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightColor\" class=\"docClass\">nodeHighlightColor</a> and <a href=\"#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightOnRepair\" rel=\"Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightOnRepair\" class=\"docClass\">nodeHighlightOnRepair</a>.</p>\n</div></div></div><div id='cfg-nodeHighlightOnRepair' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-cfg-nodeHighlightOnRepair' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightOnRepair' class='name expandable'>nodeHighlightOnRepair</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Whether or not to highlight any nodes after they are\nrepaired from an unsuccessful drag/drop. ...</div><div class='long'><p>Whether or not to highlight any nodes after they are\nrepaired from an unsuccessful drag/drop. Defaults to the value of <code>Ext.enableFx</code>.\nSee also <a href=\"#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightColor\" rel=\"Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightColor\" class=\"docClass\">nodeHighlightColor</a> and <a href=\"#!/api/Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightOnDrop\" rel=\"Ext.tree.plugin.TreeViewDragDrop-cfg-nodeHighlightOnDrop\" class=\"docClass\">nodeHighlightOnDrop</a>.</p>\n</div></div></div></div></div><div id='m-property'><div class='definedBy'>Defined By</div><h3 class='members-title'>Properties</h3><div class='subsection'><div id='property-self' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-property-self' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-property-self' class='name expandable'>self</a><span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the current class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>\nfor a detailed comparison</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); / dependent on 'this'\n\n        return this;\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n</div></div></div></div></div><div id='m-method'><h3 class='members-title'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-callOverridden' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callOverridden' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callOverridden' class='name expandable'>callOverridden</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the original method that was previously overridden with override\n\nExt.define('My.Cat', {\n    constructor: functi...</div><div class='long'><p>Call the original method that was previously overridden with <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">override</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result after calling the overridden method</p>\n</div></li></ul></div></div></div><div id='method-callParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callParent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callParent' class='name expandable'>callParent</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the parent's overridden method. ...</div><div class='long'><p>Call the parent's overridden method. For example:</p>\n\n<pre><code>Ext.define('My.own.A', {\n    constructor: function(test) {\n        alert(test);\n    }\n});\n\nExt.define('My.own.B', {\n    extend: 'My.own.A',\n\n    constructor: function(test) {\n        alert(test);\n\n        this.callParent([test + 1]);\n    }\n});\n\nExt.define('My.own.C', {\n    extend: 'My.own.B',\n\n    constructor: function() {\n        alert(\"Going to call parent's overriden constructor...\");\n\n        this.callParent(arguments);\n    }\n});\n\nvar a = new My.own.A(1); // alerts '1'\nvar b = new My.own.B(1); // alerts '1', then alerts '2'\nvar c = new My.own.C(2); // alerts \"Going to call parent's overriden constructor...\"\n                         // alerts '2', then alerts '3'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callParent(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result from the superclass' method</p>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractPlugin' rel='Ext.AbstractPlugin' class='definedIn docClass'>Ext.AbstractPlugin</a><br/><a href='source/AbstractPlugin.html#Ext-AbstractPlugin-method-destroy' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractPlugin-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>The destroy method is invoked by the owning Component at the time the Component is being destroyed. ...</div><div class='long'><p>The destroy method is invoked by the owning Component at the time the Component is being destroyed.</p>\n\n<p>The supplied implementation is empty. Subclasses should perform plugin cleanup in their own implementation of\nthis method.</p>\n</div></div></div><div id='method-disable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractPlugin' rel='Ext.AbstractPlugin' class='definedIn docClass'>Ext.AbstractPlugin</a><br/><a href='source/AbstractPlugin.html#Ext-AbstractPlugin-method-disable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractPlugin-method-disable' class='name expandable'>disable</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>The base implementation just sets the plugin's disabled flag to true\n\nPlugin subclasses which need more complex proce...</div><div class='long'><p>The base implementation just sets the plugin's <code>disabled</code> flag to <code>true</code></p>\n\n<p>Plugin subclasses which need more complex processing may implement an overriding implementation.</p>\n</div></div></div><div id='method-enable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractPlugin' rel='Ext.AbstractPlugin' class='definedIn docClass'>Ext.AbstractPlugin</a><br/><a href='source/AbstractPlugin.html#Ext-AbstractPlugin-method-enable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractPlugin-method-enable' class='name expandable'>enable</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>The base implementation just sets the plugin's disabled flag to false\n\nPlugin subclasses which need more complex proc...</div><div class='long'><p>The base implementation just sets the plugin's <code>disabled</code> flag to <code>false</code></p>\n\n<p>Plugin subclasses which need more complex processing may implement an overriding implementation.</p>\n</div></div></div><div id='method-init' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractPlugin' rel='Ext.AbstractPlugin' class='definedIn docClass'>Ext.AbstractPlugin</a><br/><a href='source/AbstractPlugin.html#Ext-AbstractPlugin-method-init' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractPlugin-method-init' class='name expandable'>init</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> client</span> )</div><div class='description'><div class='short'>The init method is invoked after initComponent method has been run for the client Component. ...</div><div class='long'><p>The init method is invoked after initComponent method has been run for the client Component.</p>\n\n<p>The supplied implementation is empty. Subclasses should perform plugin initialization, and set up bidirectional\nlinks between the plugin and its client Component in their own implementation of this method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>client</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>The client Component which owns this plugin.</p>\n</div></li></ul></div></div></div><div id='method-initConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-initConfig' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-initConfig' class='name expandable'>initConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Initialize configuration for this class. ...</div><div class='long'><p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code>Ext.define('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n\n        return this;\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>mixins The mixin prototypes as key - value pairs</p>\n</div></li></ul></div></div></div><div id='method-statics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-statics' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-statics' class='name expandable'>statics</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n\n        return this;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-addStatics' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-addStatics' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-addStatics' class='name expandable'>addStatics</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Add / override static properties of this class. ...</div><div class='long'><p>Add / override static properties of this class.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.addStatics({\n    someProperty: 'someValue',      // My.cool.Class.someProperty = 'someValue'\n    method1: function() { ... },    // My.cool.Class.method1 = function() { ... };\n    method2: function() { ... }     // My.cool.Class.method2 = function() { ... };\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-borrow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-borrow' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-borrow' class='name expandable'>borrow</a>( <span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a> fromClass, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Borrow another class' members to the prototype of this class. ...</div><div class='long'><p>Borrow another class' members to the prototype of this class.</p>\n\n<pre><code>Ext.define('Bank', {\n    money: '$$$',\n    printMoney: function() {\n        alert('$$$$$$$');\n    }\n});\n\nExt.define('Thief', {\n    ...\n});\n\nThief.borrow(Bank, ['money', 'printMoney']);\n\nvar steve = new Thief();\n\nalert(steve.money); // alerts '$$$'\nsteve.printMoney(); // alerts '$$$$$$$'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fromClass</span> : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><div class='sub-desc'><p>The class to borrow members from</p>\n</div></li><li><span class='pre'>members</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The names of the members to borrow</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-create' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-create' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-create' class='name expandable'>create</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Create a new instance of this Class. ...</div><div class='long'><p>Create a new instance of this Class.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.create({\n    someConfig: true\n});\n</code></pre>\n\n<p>All parameters are passed to the constructor of the class.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>the created instance.</p>\n</div></li></ul></div></div></div><div id='static-method-createAlias' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-createAlias' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-createAlias' class='name expandable'>createAlias</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> alias, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> origin</span> )<strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Create aliases for existing prototype methods. ...</div><div class='long'><p>Create aliases for existing prototype methods. Example:</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    method1: function() { ... },\n    method2: function() { ... }\n});\n\nvar test = new My.cool.Class();\n\nMy.cool.Class.createAlias({\n    method3: 'method1',\n    method4: 'method2'\n});\n\ntest.method3(); // test.method1()\n\nMy.cool.Class.createAlias('method5', 'method3');\n\ntest.method5(); // test.method3() -&gt; test.method1()\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>alias</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The new method name, or an object to set multiple aliases. See\n<a href=\"#!/api/Ext.Function-method-flexSetter\" rel=\"Ext.Function-method-flexSetter\" class=\"docClass\">flexSetter</a></p>\n</div></li><li><span class='pre'>origin</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The original method name</p>\n</div></li></ul></div></div></div><div id='static-method-getName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-getName' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-getName' class='name expandable'>getName</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Get the current class' name in string format. ...</div><div class='long'><p>Get the current class' name in string format.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    constructor: function() {\n        alert(this.self.getName()); // alerts 'My.cool.Class'\n    }\n});\n\nMy.cool.Class.getName(); // 'My.cool.Class'\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>className</p>\n</div></li></ul></div></div></div><div id='static-method-implement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-implement' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-implement' class='name expandable'>implement</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> )<strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Add methods / properties to the prototype of this class. ...</div><div class='long'><p>Add methods / properties to the prototype of this class.</p>\n\n<pre><code>Ext.define('My.awesome.Cat', {\n    constructor: function() {\n        ...\n    }\n});\n\n My.awesome.Cat.implement({\n     meow: function() {\n        alert('Meowww...');\n     }\n });\n\n var kitty = new My.awesome.Cat;\n kitty.meow();\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-override' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-override' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-override' class='name expandable'>override</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Override prototype members of this class. ...</div><div class='long'><p>Override prototype members of this class. Overridden methods can be invoked via\n<a href=\"#!/api/Ext.Base-method-callOverridden\" rel=\"Ext.Base-method-callOverridden\" class=\"docClass\">callOverridden</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div></div></div><div id='m-event'><div class='definedBy'>Defined By</div><h3 class='members-title'>Events</h3><div class='subsection'><div id='event-beforedrop' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-event-beforedrop' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-event-beforedrop' class='name expandable'>beforedrop</a>( <span class='pre'>HTMLElement node, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> data, <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> overModel, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> dropPosition, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> dropFunction, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>This event is fired through the TreeView. ...</div><div class='long'><p><strong>This event is fired through the TreeView. Add listeners to the TreeView object</strong></p>\n\n<p>Fired when a drop gesture has been triggered by a mouseup event in a valid drop position in the TreeView.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : HTMLElement<div class='sub-desc'><p>The TreeView node <strong>if any</strong> over which the mouse was positioned.</p>\n\n<p>Returning <code>false</code> to this event signals that the drop gesture was invalid, and if the drag proxy will animate\nback to the point from which the drag began.</p>\n\n<p>Returning <code>0</code> To this event signals that the data transfer operation should not take place, but that the gesture\nwas valid, and that the repair operation should not take place.</p>\n\n<p>Any other return value continues with the data transfer operation.</p>\n</div></li><li><span class='pre'>data</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The data object gathered at mousedown time by the cooperating\n<a href=\"#!/api/Ext.dd.DragZone\" rel=\"Ext.dd.DragZone\" class=\"docClass\">DragZone</a>'s <a href=\"#!/api/Ext.dd.DragZone-method-getDragData\" rel=\"Ext.dd.DragZone-method-getDragData\" class=\"docClass\">getDragData</a> method it contains the following\nproperties:</p>\n<ul><li><span class='pre'>copy</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>The value of the TreeView's <code>copy</code> property, or <code>true</code> if the TreeView was configured with\n<code>allowCopy: true</code> and the control key was pressed when the drag operation was begun</p>\n</div></li><li><span class='pre'>view</span> : <a href=\"#!/api/Ext.tree.View\" rel=\"Ext.tree.View\" class=\"docClass\">Ext.tree.View</a><div class='sub-desc'><p>The source TreeView from which the drag originated.</p>\n</div></li><li><span class='pre'>ddel</span> : HTMLElement<div class='sub-desc'><p>The drag proxy element which moves with the mouse</p>\n</div></li><li><span class='pre'>item</span> : HTMLElement<div class='sub-desc'><p>The TreeView node upon which the mousedown event was registered.</p>\n</div></li><li><span class='pre'>records</span> : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>[]<div class='sub-desc'><p>An Array of <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a>s representing the selected data being\ndragged from the source TreeView.</p>\n</div></li></ul></div></li><li><span class='pre'>overModel</span> : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a><div class='sub-desc'><p>The Model over which the drop gesture took place.</p>\n</div></li><li><span class='pre'>dropPosition</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p><code>\"before\"</code>, <code>\"after\"</code> or <code>\"append\"</code> depending on whether the mouse is above or below\nthe midline of the node, or the node is a branch node which accepts new child nodes.</p>\n</div></li><li><span class='pre'>dropFunction</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>A function to call to complete the data transfer operation and either move or copy\nModel instances from the source View's Store to the destination View's Store.</p>\n\n<p>This is useful when you want to perform some kind of asynchronous processing before confirming the drop, such as\nan <a href=\"#!/api/Ext.window.MessageBox-method-confirm\" rel=\"Ext.window.MessageBox-method-confirm\" class=\"docClass\">confirm</a> call, or an Ajax request.</p>\n\n<p>Return <code>0</code> from this event handler, and call the <code>dropFunction</code> at any time to perform the data transfer.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-drop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop' rel='Ext.tree.plugin.TreeViewDragDrop' class='definedIn docClass'>Ext.tree.plugin.TreeViewDragDrop</a><br/><a href='source/TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop-event-drop' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.tree.plugin.TreeViewDragDrop-event-drop' class='name expandable'>drop</a>( <span class='pre'>HTMLElement node, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> data, <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> overModel, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> dropPosition, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>This event is fired through the TreeView. ...</div><div class='long'><p><strong>This event is fired through the TreeView. Add listeners to the TreeView object</strong> Fired when a drop operation\nhas been completed and the data has been moved or copied.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : HTMLElement<div class='sub-desc'><p>The TreeView node <strong>if any</strong> over which the mouse was positioned.</p>\n</div></li><li><span class='pre'>data</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The data object gathered at mousedown time by the cooperating\n<a href=\"#!/api/Ext.dd.DragZone\" rel=\"Ext.dd.DragZone\" class=\"docClass\">DragZone</a>'s <a href=\"#!/api/Ext.dd.DragZone-method-getDragData\" rel=\"Ext.dd.DragZone-method-getDragData\" class=\"docClass\">getDragData</a> method it contains the following\nproperties:</p>\n<ul><li><span class='pre'>copy</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>The value of the TreeView's <code>copy</code> property, or <code>true</code> if the TreeView was configured with\n<code>allowCopy: true</code> and the control key was pressed when the drag operation was begun</p>\n</div></li><li><span class='pre'>view</span> : <a href=\"#!/api/Ext.tree.View\" rel=\"Ext.tree.View\" class=\"docClass\">Ext.tree.View</a><div class='sub-desc'><p>The source TreeView from which the drag originated.</p>\n</div></li><li><span class='pre'>ddel</span> : HTMLElement<div class='sub-desc'><p>The drag proxy element which moves with the mouse</p>\n</div></li><li><span class='pre'>item</span> : HTMLElement<div class='sub-desc'><p>The TreeView node upon which the mousedown event was registered.</p>\n</div></li><li><span class='pre'>records</span> : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>[]<div class='sub-desc'><p>An Array of <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a>s representing the selected data being\ndragged from the source TreeView.</p>\n</div></li></ul></div></li><li><span class='pre'>overModel</span> : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a><div class='sub-desc'><p>The Model over which the drop gesture took place.</p>\n</div></li><li><span class='pre'>dropPosition</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p><code>\"before\"</code>, <code>\"after\"</code> or <code>\"append\"</code> depending on whether the mouse is above or below\nthe midline of the node, or the node is a branch node which accepts new child nodes.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"meta":{},"requires":[],"deprecated":null,"extends":"Ext.AbstractPlugin","inheritable":false,"static":false,"superclasses":["Ext.Base","Ext.AbstractPlugin","Ext.tree.plugin.TreeViewDragDrop"],"singleton":false,"code_type":"ext_define","alias":null,"statics":{"property":[],"css_var":[],"css_mixin":[],"cfg":[],"method":[{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"addStatics","id":"static-method-addStatics"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"borrow","id":"static-method-borrow"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"create","id":"static-method-create"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"createAlias","id":"static-method-createAlias"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"getName","id":"static-method-getName"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"implement","id":"static-method-implement"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"override","id":"static-method-override"}],"event":[]},"subclasses":[],"uses":["Ext.tree.ViewDragZone","Ext.tree.ViewDropZone"],"protected":false,"mixins":[],"members":{"property":[{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Base","template":null,"required":null,"protected":true,"name":"self","id":"property-self"}],"css_var":[],"css_mixin":[],"cfg":[{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":false,"protected":false,"name":"allowContainerDrop","id":"cfg-allowContainerDrop"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":false,"protected":false,"name":"allowParentInsert","id":"cfg-allowParentInsert"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":false,"protected":false,"name":"appendOnly","id":"cfg-appendOnly"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":false,"protected":false,"name":"ddGroup","id":"cfg-ddGroup"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":false,"protected":false,"name":"dragGroup","id":"cfg-dragGroup"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":false,"protected":false,"name":"dropGroup","id":"cfg-dropGroup"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":false,"protected":false,"name":"enableDrag","id":"cfg-enableDrag"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":false,"protected":false,"name":"enableDrop","id":"cfg-enableDrop"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":false,"protected":false,"name":"expandDelay","id":"cfg-expandDelay"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":false,"protected":false,"name":"nodeHighlightColor","id":"cfg-nodeHighlightColor"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":false,"protected":false,"name":"nodeHighlightOnDrop","id":"cfg-nodeHighlightOnDrop"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":false,"protected":false,"name":"nodeHighlightOnRepair","id":"cfg-nodeHighlightOnRepair"}],"method":[{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callOverridden","id":"method-callOverridden"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callParent","id":"method-callParent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractPlugin","template":false,"required":null,"protected":false,"name":"destroy","id":"method-destroy"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractPlugin","template":false,"required":null,"protected":false,"name":"disable","id":"method-disable"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractPlugin","template":false,"required":null,"protected":false,"name":"enable","id":"method-enable"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractPlugin","template":false,"required":null,"protected":false,"name":"init","id":"method-init"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"initConfig","id":"method-initConfig"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"statics","id":"method-statics"}],"event":[{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":null,"protected":false,"name":"beforedrop","id":"event-beforedrop"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.tree.plugin.TreeViewDragDrop","template":null,"required":null,"protected":false,"name":"drop","id":"event-drop"}]},"private":false,"component":false,"name":"Ext.tree.plugin.TreeViewDragDrop","alternateClassNames":[],"id":"class-Ext.tree.plugin.TreeViewDragDrop","mixedInto":[],"xtypes":{"plugin":["treeviewdragdrop"]},"files":[{"href":"TreeViewDragDrop.html#Ext-tree-plugin-TreeViewDragDrop","filename":"TreeViewDragDrop.js"}]});