Ext.data.JsonP.Ext_data_Operation({"tagname":"class","html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.Base' rel='Ext.Base' class='docClass'>Ext.Base</a><div class='subclass '><strong>Ext.data.Operation</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/Operation.html#Ext-data-Operation' target='_blank'>Operation.js</a></div></pre><div class='doc-contents'><p>Represents a single read or write operation performed by a <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a>. Operation objects are\nused to enable communication between Stores and Proxies. Application developers should rarely need to interact with\nOperation objects directly.</p>\n\n<p>Several Operations can be batched together in a <a href=\"#!/api/Ext.data.Batch\" rel=\"Ext.data.Batch\" class=\"docClass\">batch</a>.</p>\n</div><div class='members'><div id='m-cfg'><div class='definedBy'>Defined By</div><h3 class='members-title'>Config options</h3><div class='subsection'><div id='cfg-action' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-cfg-action' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-cfg-action' class='name expandable'>action</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The action being performed by this Operation. ...</div><div class='long'><p>The action being performed by this Operation. Should be one of 'create', 'read', 'update' or 'destroy'.</p>\n</div></div></div><div id='cfg-batch' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-cfg-batch' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-cfg-batch' class='name expandable'>batch</a><span> : <a href=\"#!/api/Ext.data.Batch\" rel=\"Ext.data.Batch\" class=\"docClass\">Ext.data.Batch</a></span></div><div class='description'><div class='short'>The batch that this Operation is a part of. ...</div><div class='long'><p>The batch that this Operation is a part of.</p>\n</div></div></div><div id='cfg-callback' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-cfg-callback' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-cfg-callback' class='name expandable'>callback</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>Function to execute when operation completed. ...</div><div class='long'><p>Function to execute when operation completed.  Will be called with the following parameters:</p>\n\n<ul>\n<li>records : Array of <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> objects.</li>\n<li>operation : The Ext.data.Operation itself.</li>\n<li>success : True when operation completed successfully.</li>\n</ul>\n\n</div></div></div><div id='cfg-filters' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-cfg-filters' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-cfg-filters' class='name expandable'>filters</a><span> : <a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Ext.util.Filter</a>[]</span></div><div class='description'><div class='short'>Optional array of filter objects. ...</div><div class='long'><p>Optional array of filter objects. Only applies to 'read' actions.</p>\n</div></div></div><div id='cfg-group' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-cfg-group' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-cfg-group' class='name expandable'>group</a><span> : <a href=\"#!/api/Ext.util.Grouper\" rel=\"Ext.util.Grouper\" class=\"docClass\">Ext.util.Grouper</a></span></div><div class='description'><div class='short'>Optional grouping configuration. ...</div><div class='long'><p>Optional grouping configuration. Only applies to 'read' actions where grouping is desired.</p>\n</div></div></div><div id='cfg-limit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-cfg-limit' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-cfg-limit' class='name expandable'>limit</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The number of records to load. ...</div><div class='long'><p>The number of records to load. Used on 'read' actions when paging is being used.</p>\n</div></div></div><div id='cfg-scope' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-cfg-scope' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-cfg-scope' class='name expandable'>scope</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>Scope for the callback function. ...</div><div class='long'><p>Scope for the <a href=\"#!/api/Ext.data.Operation-cfg-callback\" rel=\"Ext.data.Operation-cfg-callback\" class=\"docClass\">callback</a> function.</p>\n</div></div></div><div id='cfg-sorters' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-cfg-sorters' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-cfg-sorters' class='name expandable'>sorters</a><span> : <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Ext.util.Sorter</a>[]</span></div><div class='description'><div class='short'>Optional array of sorter objects. ...</div><div class='long'><p>Optional array of sorter objects. Only applies to 'read' actions.</p>\n</div></div></div><div id='cfg-start' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-cfg-start' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-cfg-start' class='name expandable'>start</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The start index (offset), used in paging when running a 'read' action. ...</div><div class='long'><p>The start index (offset), used in paging when running a 'read' action.</p>\n</div></div></div><div id='cfg-synchronous' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-cfg-synchronous' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-cfg-synchronous' class='name expandable'>synchronous</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True if this Operation is to be executed synchronously. ...</div><div class='long'><p>True if this Operation is to be executed synchronously. This property is inspected by a\n<a href=\"#!/api/Ext.data.Batch\" rel=\"Ext.data.Batch\" class=\"docClass\">Batch</a> to see if a series of Operations can be executed in parallel or not.</p>\n<p>Defaults to: <code>true</code></p></div></div></div></div></div><div id='m-property'><div class='definedBy'>Defined By</div><h3 class='members-title'>Properties</h3><div class='subsection'><div id='property-actionCommitRecordsRe' class='member first-child not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-property-actionCommitRecordsRe' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-property-actionCommitRecordsRe' class='name not-expandable'>actionCommitRecordsRe</a><span> : <a href=\"#!/api/RegExp\" rel=\"RegExp\" class=\"docClass\">RegExp</a></span></div><div class='description'><div class='short'><p>The RegExp used to categorize actions that require record commits.</p>\n</div><div class='long'><p>The RegExp used to categorize actions that require record commits.</p>\n</div></div></div><div id='property-actionSkipSyncRe' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-property-actionSkipSyncRe' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-property-actionSkipSyncRe' class='name expandable'>actionSkipSyncRe</a><span> : <a href=\"#!/api/RegExp\" rel=\"RegExp\" class=\"docClass\">RegExp</a></span></div><div class='description'><div class='short'>The RegExp used to categorize actions that skip local record synchronization. ...</div><div class='long'><p>The RegExp used to categorize actions that skip local record synchronization. This defaults\nto match 'destroy'.</p>\n</div></div></div><div id='property-self' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-property-self' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-property-self' class='name expandable'>self</a><span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the current class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>\nfor a detailed comparison</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); / dependent on 'this'\n\n        return this;\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n</div></div></div></div></div><div id='m-method'><h3 class='members-title'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-constructor' target='_blank' class='viewSource'>view source</a></div><strong class='constructor-signature'>new</strong><a href='#!/api/Ext.data.Operation-method-constructor' class='name expandable'>Ext.data.Operation</a>( <span class='pre'>[<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Creates new Operation object. ...</div><div class='long'><p>Creates new Operation object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Config object.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-allowWrite' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-allowWrite' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-allowWrite' class='name expandable'>allowWrite</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks whether this operation should cause writing to occur. ...</div><div class='long'><p>Checks whether this operation should cause writing to occur.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>Whether the operation should cause a write to occur.</p>\n</div></li></ul></div></div></div><div id='method-callOverridden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callOverridden' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callOverridden' class='name expandable'>callOverridden</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the original method that was previously overridden with override\n\nExt.define('My.Cat', {\n    constructor: functi...</div><div class='long'><p>Call the original method that was previously overridden with <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">override</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result after calling the overridden method</p>\n</div></li></ul></div></div></div><div id='method-callParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callParent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callParent' class='name expandable'>callParent</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the parent's overridden method. ...</div><div class='long'><p>Call the parent's overridden method. For example:</p>\n\n<pre><code>Ext.define('My.own.A', {\n    constructor: function(test) {\n        alert(test);\n    }\n});\n\nExt.define('My.own.B', {\n    extend: 'My.own.A',\n\n    constructor: function(test) {\n        alert(test);\n\n        this.callParent([test + 1]);\n    }\n});\n\nExt.define('My.own.C', {\n    extend: 'My.own.B',\n\n    constructor: function() {\n        alert(\"Going to call parent's overriden constructor...\");\n\n        this.callParent(arguments);\n    }\n});\n\nvar a = new My.own.A(1); // alerts '1'\nvar b = new My.own.B(1); // alerts '1', then alerts '2'\nvar c = new My.own.C(2); // alerts \"Going to call parent's overriden constructor...\"\n                         // alerts '2', then alerts '3'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callParent(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result from the superclass' method</p>\n</div></li></ul></div></div></div><div id='method-commitRecords' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-commitRecords' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-commitRecords' class='name expandable'>commitRecords</a>( <span class='pre'><a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>[] serverRecords</span> )</div><div class='description'><div class='short'>This method is called to commit data to this instance's records given the records in\nthe server response. ...</div><div class='long'><p>This method is called to commit data to this instance's records given the records in\nthe server response. This is followed by calling <a href=\"#!/api/Ext.data.Model-method-commit\" rel=\"Ext.data.Model-method-commit\" class=\"docClass\">Ext.data.Model.commit</a> on all\nthose records (for 'create' and 'update' actions).</p>\n\n<p>If this <a href=\"#!/api/Ext.data.Operation-cfg-action\" rel=\"Ext.data.Operation-cfg-action\" class=\"docClass\">action</a> is 'destroy', any server records are ignored and the\n<a href=\"#!/api/Ext.data.Model-method-commit\" rel=\"Ext.data.Model-method-commit\" class=\"docClass\">Ext.data.Model.commit</a> method is not called.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>serverRecords</span> : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>[]<div class='sub-desc'><p>An array of <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> objects returned by\nthe server.</p>\n</div></li></ul></div></div></div><div id='method-getError' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-getError' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-getError' class='name expandable'>getError</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the error string or object that was set using setException ...</div><div class='long'><p>Returns the error string or object that was set using <a href=\"#!/api/Ext.data.Operation-method-setException\" rel=\"Ext.data.Operation-method-setException\" class=\"docClass\">setException</a></p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The error object</p>\n</div></li></ul></div></div></div><div id='method-getRecords' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-getRecords' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-getRecords' class='name expandable'>getRecords</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>[]</div><div class='description'><div class='short'>Returns an array of Ext.data.Model instances as set by the Proxy. ...</div><div class='long'><p>Returns an array of <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> instances as set by the Proxy.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>[]</span><div class='sub-desc'><p>Any loaded Records</p>\n</div></li></ul></div></div></div><div id='method-getResultSet' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-getResultSet' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-getResultSet' class='name expandable'>getResultSet</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.data.ResultSet\" rel=\"Ext.data.ResultSet\" class=\"docClass\">Ext.data.ResultSet</a></div><div class='description'><div class='short'>Returns the ResultSet object (if set by the Proxy). ...</div><div class='long'><p>Returns the ResultSet object (if set by the Proxy). This object will contain the <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">model</a>\ninstances as well as meta data such as number of instances fetched, number available etc</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.ResultSet\" rel=\"Ext.data.ResultSet\" class=\"docClass\">Ext.data.ResultSet</a></span><div class='sub-desc'><p>The ResultSet object</p>\n</div></li></ul></div></div></div><div id='method-hasException' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-hasException' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-hasException' class='name expandable'>hasException</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if this Operation encountered an exception (see also getError) ...</div><div class='long'><p>Returns true if this Operation encountered an exception (see also <a href=\"#!/api/Ext.data.Operation-method-getError\" rel=\"Ext.data.Operation-method-getError\" class=\"docClass\">getError</a>)</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if there was an exception</p>\n</div></li></ul></div></div></div><div id='method-initConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-initConfig' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-initConfig' class='name expandable'>initConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Initialize configuration for this class. ...</div><div class='long'><p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code>Ext.define('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n\n        return this;\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>mixins The mixin prototypes as key - value pairs</p>\n</div></li></ul></div></div></div><div id='method-isComplete' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-isComplete' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-isComplete' class='name expandable'>isComplete</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the Operation has been completed ...</div><div class='long'><p>Returns true if the Operation has been completed</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the Operation is complete</p>\n</div></li></ul></div></div></div><div id='method-isRunning' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-isRunning' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-isRunning' class='name expandable'>isRunning</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the Operation has been started but has not yet completed. ...</div><div class='long'><p>Returns true if the Operation has been started but has not yet completed.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the Operation is currently running</p>\n</div></li></ul></div></div></div><div id='method-isStarted' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-isStarted' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-isStarted' class='name expandable'>isStarted</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the Operation has been started. ...</div><div class='long'><p>Returns true if the Operation has been started. Note that the Operation may have started AND completed, see\n<a href=\"#!/api/Ext.data.Operation-method-isRunning\" rel=\"Ext.data.Operation-method-isRunning\" class=\"docClass\">isRunning</a> to test if the Operation is currently running.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the Operation has started</p>\n</div></li></ul></div></div></div><div id='method-setCompleted' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-setCompleted' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-setCompleted' class='name expandable'>setCompleted</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Marks the Operation as completed. ...</div><div class='long'><p>Marks the Operation as completed.</p>\n</div></div></div><div id='method-setException' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-setException' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-setException' class='name expandable'>setException</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> error]</span> )</div><div class='description'><div class='short'>Marks the Operation as having experienced an exception. ...</div><div class='long'><p>Marks the Operation as having experienced an exception. Can be supplied with an option error message/object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>error</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>error string/object</p>\n</div></li></ul></div></div></div><div id='method-setStarted' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-setStarted' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-setStarted' class='name expandable'>setStarted</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Marks the Operation as started. ...</div><div class='long'><p>Marks the Operation as started.</p>\n</div></div></div><div id='method-setSuccessful' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-setSuccessful' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-setSuccessful' class='name expandable'>setSuccessful</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Marks the Operation as successful. ...</div><div class='long'><p>Marks the Operation as successful.</p>\n</div></div></div><div id='method-statics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-statics' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-statics' class='name expandable'>statics</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n\n        return this;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-wasSuccessful' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.Operation' rel='Ext.data.Operation' class='definedIn docClass'>Ext.data.Operation</a><br/><a href='source/Operation.html#Ext-data-Operation-method-wasSuccessful' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.data.Operation-method-wasSuccessful' class='name expandable'>wasSuccessful</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the Operation has completed and was successful ...</div><div class='long'><p>Returns true if the Operation has completed and was successful</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if successful</p>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-addStatics' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-addStatics' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-addStatics' class='name expandable'>addStatics</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Add / override static properties of this class. ...</div><div class='long'><p>Add / override static properties of this class.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.addStatics({\n    someProperty: 'someValue',      // My.cool.Class.someProperty = 'someValue'\n    method1: function() { ... },    // My.cool.Class.method1 = function() { ... };\n    method2: function() { ... }     // My.cool.Class.method2 = function() { ... };\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-borrow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-borrow' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-borrow' class='name expandable'>borrow</a>( <span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a> fromClass, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Borrow another class' members to the prototype of this class. ...</div><div class='long'><p>Borrow another class' members to the prototype of this class.</p>\n\n<pre><code>Ext.define('Bank', {\n    money: '$$$',\n    printMoney: function() {\n        alert('$$$$$$$');\n    }\n});\n\nExt.define('Thief', {\n    ...\n});\n\nThief.borrow(Bank, ['money', 'printMoney']);\n\nvar steve = new Thief();\n\nalert(steve.money); // alerts '$$$'\nsteve.printMoney(); // alerts '$$$$$$$'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fromClass</span> : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><div class='sub-desc'><p>The class to borrow members from</p>\n</div></li><li><span class='pre'>members</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The names of the members to borrow</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-create' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-create' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-create' class='name expandable'>create</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Create a new instance of this Class. ...</div><div class='long'><p>Create a new instance of this Class.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.create({\n    someConfig: true\n});\n</code></pre>\n\n<p>All parameters are passed to the constructor of the class.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>the created instance.</p>\n</div></li></ul></div></div></div><div id='static-method-createAlias' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-createAlias' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-createAlias' class='name expandable'>createAlias</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> alias, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> origin</span> )<strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Create aliases for existing prototype methods. ...</div><div class='long'><p>Create aliases for existing prototype methods. Example:</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    method1: function() { ... },\n    method2: function() { ... }\n});\n\nvar test = new My.cool.Class();\n\nMy.cool.Class.createAlias({\n    method3: 'method1',\n    method4: 'method2'\n});\n\ntest.method3(); // test.method1()\n\nMy.cool.Class.createAlias('method5', 'method3');\n\ntest.method5(); // test.method3() -&gt; test.method1()\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>alias</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The new method name, or an object to set multiple aliases. See\n<a href=\"#!/api/Ext.Function-method-flexSetter\" rel=\"Ext.Function-method-flexSetter\" class=\"docClass\">flexSetter</a></p>\n</div></li><li><span class='pre'>origin</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The original method name</p>\n</div></li></ul></div></div></div><div id='static-method-getName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-getName' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-getName' class='name expandable'>getName</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Get the current class' name in string format. ...</div><div class='long'><p>Get the current class' name in string format.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    constructor: function() {\n        alert(this.self.getName()); // alerts 'My.cool.Class'\n    }\n});\n\nMy.cool.Class.getName(); // 'My.cool.Class'\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>className</p>\n</div></li></ul></div></div></div><div id='static-method-implement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-implement' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-implement' class='name expandable'>implement</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> )<strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Add methods / properties to the prototype of this class. ...</div><div class='long'><p>Add methods / properties to the prototype of this class.</p>\n\n<pre><code>Ext.define('My.awesome.Cat', {\n    constructor: function() {\n        ...\n    }\n});\n\n My.awesome.Cat.implement({\n     meow: function() {\n        alert('Meowww...');\n     }\n });\n\n var kitty = new My.awesome.Cat;\n kitty.meow();\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-override' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-override' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-override' class='name expandable'>override</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Override prototype members of this class. ...</div><div class='long'><p>Override prototype members of this class. Overridden methods can be invoked via\n<a href=\"#!/api/Ext.Base-method-callOverridden\" rel=\"Ext.Base-method-callOverridden\" class=\"docClass\">callOverridden</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"meta":{"author":["Ed Spencer"]},"requires":[],"deprecated":null,"extends":"Ext.Base","inheritable":false,"static":false,"superclasses":["Ext.Base","Ext.data.Operation"],"singleton":false,"code_type":"ext_define","alias":null,"statics":{"property":[],"css_var":[],"css_mixin":[],"cfg":[],"method":[{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"addStatics","id":"static-method-addStatics"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"borrow","id":"static-method-borrow"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"create","id":"static-method-create"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"createAlias","id":"static-method-createAlias"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"getName","id":"static-method-getName"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"implement","id":"static-method-implement"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"override","id":"static-method-override"}],"event":[]},"subclasses":[],"uses":[],"protected":false,"mixins":[],"members":{"property":[{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":null,"required":null,"protected":false,"name":"actionCommitRecordsRe","id":"property-actionCommitRecordsRe"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":null,"required":null,"protected":false,"name":"actionSkipSyncRe","id":"property-actionSkipSyncRe"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Base","template":null,"required":null,"protected":true,"name":"self","id":"property-self"}],"css_var":[],"css_mixin":[],"cfg":[{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":null,"required":false,"protected":false,"name":"action","id":"cfg-action"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":null,"required":false,"protected":false,"name":"batch","id":"cfg-batch"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":null,"required":false,"protected":false,"name":"callback","id":"cfg-callback"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":null,"required":false,"protected":false,"name":"filters","id":"cfg-filters"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":null,"required":false,"protected":false,"name":"group","id":"cfg-group"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":null,"required":false,"protected":false,"name":"limit","id":"cfg-limit"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":null,"required":false,"protected":false,"name":"scope","id":"cfg-scope"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":null,"required":false,"protected":false,"name":"sorters","id":"cfg-sorters"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":null,"required":false,"protected":false,"name":"start","id":"cfg-start"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":null,"required":false,"protected":false,"name":"synchronous","id":"cfg-synchronous"}],"method":[{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"constructor","id":"method-constructor"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"allowWrite","id":"method-allowWrite"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callOverridden","id":"method-callOverridden"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callParent","id":"method-callParent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"commitRecords","id":"method-commitRecords"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"getError","id":"method-getError"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"getRecords","id":"method-getRecords"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"getResultSet","id":"method-getResultSet"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"hasException","id":"method-hasException"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"initConfig","id":"method-initConfig"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"isComplete","id":"method-isComplete"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"isRunning","id":"method-isRunning"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"isStarted","id":"method-isStarted"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"setCompleted","id":"method-setCompleted"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"setException","id":"method-setException"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"setStarted","id":"method-setStarted"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"setSuccessful","id":"method-setSuccessful"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"statics","id":"method-statics"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.data.Operation","template":false,"required":null,"protected":false,"name":"wasSuccessful","id":"method-wasSuccessful"}],"event":[]},"private":false,"component":false,"name":"Ext.data.Operation","alternateClassNames":[],"id":"class-Ext.data.Operation","mixedInto":[],"xtypes":{},"files":[{"href":"Operation.html#Ext-data-Operation","filename":"Operation.js"}]});