Ext.data.JsonP.Ext_CompositeElement({"tagname":"class","html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='docClass'>Ext.CompositeElementLite</a><div class='subclass '><strong>Ext.CompositeElement</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/CompositeElement2.html#Ext-CompositeElement' target='_blank'>CompositeElement.js</a></div></pre><div class='doc-contents'><p>This class encapsulates a <i>collection</i> of DOM elements, providing methods to filter\nmembers, or to perform collective actions upon the whole set.</p>\n\n\n<p>Although they are not listed, this class supports all of the methods of <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> and\n<a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a>. The methods from these classes will be performed on all the elements in this collection.</p>\n\n\n<p>All methods return <i>this</i> and can be chained.</p>\n\n\n<p>Usage:</p>\n\n<pre><code>var els = Ext.select(\"#some-el div.some-class\", true);\n// or select directly from an existing element\nvar el = Ext.get('some-el');\nel.select('div.some-class', true);\n\nels.setWidth(100); // all elements become 100 width\nels.hide(true); // all elements fade out and hide\n// or\nels.setWidth(100).hide(true);\n</code></pre>\n\n</div><div class='members'><div id='m-property'><div class='definedBy'>Defined By</div><h3 class='members-title'>Properties</h3><div class='subsection'><div id='property-elements' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite.html#Ext-CompositeElementLite-property-elements' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-property-elements' class='name expandable'>elements</a><span> : HTMLElement</span></div><div class='description'><div class='short'>The Array of DOM elements which this CompositeElement encapsulates. ...</div><div class='long'><p>The Array of DOM elements which this CompositeElement encapsulates. Read-only.</p>\n\n\n<p>This will not <i>usually</i> be accessed in developers' code, but developers wishing\nto augment the capabilities of the CompositeElementLite class may use it when adding\nmethods to the class.</p>\n\n\n<p>For example to add the <code>nextAll</code> method to the class to <b>add</b> all\nfollowing siblings of selected elements, the code would be</p>\n\n\n<p><code></p>\n\n<pre>Ext.override(Ext.CompositeElementLite, {\n    nextAll: function() {\n        var els = this.elements, i, l = els.length, n, r = [], ri = -1;\n\n//      Loop through all elements in this Composite, accumulating\n//      an Array of all siblings.\n        for (i = 0; i < l; i++) {\n            for (n = els[i].nextSibling; n; n = n.nextSibling) {\n                r[++ri] = n;\n            }\n        }\n\n//      Add all found siblings to this Composite\n        return this.add(r);\n    }\n});</pre>\n\n\n<p></code></p>\n</div></div></div></div></div><div id='m-method'><div class='definedBy'>Defined By</div><h3 class='members-title'>Methods</h3><div class='subsection'><div id='method-add' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite.html#Ext-CompositeElementLite-method-add' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-method-add' class='name expandable'>add</a>( <span class='pre'>HTMLElement[]/<a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a> els</span> ) : <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></div><div class='description'><div class='short'>Adds elements to this Composite object. ...</div><div class='long'><p>Adds elements to this Composite object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>els</span> : HTMLElement[]/<a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a><div class='sub-desc'><p>Either an Array of DOM elements to add, or another Composite object who's elements should be added.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></span><div class='sub-desc'><p>This Composite object.</p>\n</div></li></ul></div></div></div><div id='method-clear' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite.html#Ext-CompositeElementLite-method-clear' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-method-clear' class='name expandable'>clear</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all elements. ...</div><div class='long'><p>Removes all elements.</p>\n</div></div></div><div id='method-contains' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite-more.html#Ext-CompositeElementLite-method-contains' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-method-contains' class='name expandable'>contains</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> el</span> )</div><div class='description'><div class='short'>Returns true if this composite contains the passed element ...</div><div class='long'><p>Returns true if this composite contains the passed element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>{String/HTMLElement/Ext.Element/Number} The id of an element, or an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>, or an HtmlElement to find within the composite collection.</p>\n</div></li></ul></div></div></div><div id='method-each' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite.html#Ext-CompositeElementLite-method-each' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-method-each' class='name expandable'>each</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope]</span> ) : <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></div><div class='description'><div class='short'>Calls the passed function for each element in this composite. ...</div><div class='long'><p>Calls the passed function for each element in this composite.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call. The function is passed the following parameters:<ul>\n<li><b>el</b> : Element<div class=\"sub-desc\">The current Element in the iteration.\n<b>This is the flyweight (shared) <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> instance, so if you require a\na reference to the dom node, use el.dom.</b></div></li>\n<li><b>c</b> : Composite<div class=\"sub-desc\">This Composite object.</div></li>\n<li><b>idx</b> : Number<div class=\"sub-desc\">The zero-based index in the iteration.</div></li>\n</ul></p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<i>this</i> reference) in which the function is executed. (defaults to the Element)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-fill' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite.html#Ext-CompositeElementLite-method-fill' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-method-fill' class='name expandable'>fill</a>( <span class='pre'>HTMLElement[]/<a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a> els</span> ) : <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></div><div class='description'><div class='short'>Clears this Composite and adds the elements passed. ...</div><div class='long'><p>Clears this Composite and adds the elements passed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>els</span> : HTMLElement[]/<a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a><div class='sub-desc'><p>Either an array of DOM elements, or another Composite from which to fill this Composite.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-filter' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite.html#Ext-CompositeElementLite-method-filter' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-method-filter' class='name expandable'>filter</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> selector</span> ) : <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></div><div class='description'><div class='short'>Filters this composite to only elements that match the passed selector. ...</div><div class='long'><p>Filters this composite to only elements that match the passed selector.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>A string CSS selector or a comparison function.\nThe comparison function will be called with the following arguments:<ul>\n<li><code>el</code> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class=\"sub-desc\">The current DOM element.</div></li>\n<li><code>index</code> : Number<div class=\"sub-desc\">The current index within the collection.</div></li>\n</ul></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-first' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite-more.html#Ext-CompositeElementLite-method-first' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-method-first' class='name expandable'>first</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns the first Element ...</div><div class='long'><p>Returns the first Element</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getCount' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite.html#Ext-CompositeElementLite-method-getCount' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-method-getCount' class='name expandable'>getCount</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Returns the number of elements in this Composite. ...</div><div class='long'><p>Returns the number of elements in this Composite.</p>\n</div></div></div><div id='method-indexOf' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite.html#Ext-CompositeElementLite-method-indexOf' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-method-indexOf' class='name expandable'>indexOf</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> el</span> )</div><div class='description'><div class='short'>Find the index of the passed element within the composite collection. ...</div><div class='long'><p>Find the index of the passed element within the composite collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>{Mixed} The id of an element, or an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>, or an HtmlElement to find within the composite collection.</p>\n</div></li></ul></div></div></div><div id='method-item' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite.html#Ext-CompositeElementLite-method-item' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-method-item' class='name expandable'>item</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> index</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns a flyweight Element of the dom element object at the specified index ...</div><div class='long'><p>Returns a flyweight Element of the dom element object at the specified index</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-last' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite-more.html#Ext-CompositeElementLite-method-last' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-method-last' class='name expandable'>last</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns the last Element ...</div><div class='long'><p>Returns the last Element</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-removeElement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite-more.html#Ext-CompositeElementLite-method-removeElement' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-method-removeElement' class='name expandable'>removeElement</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> el, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> removeDom]</span> ) : <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></div><div class='description'><div class='short'>Removes the specified element(s). ...</div><div class='long'><p>Removes the specified element(s).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The id of an element, the Element itself, the index of the element in this composite\nor an array of any of those.</p>\n</div></li><li><span class='pre'>removeDom</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to also remove the element from the document</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-replaceElement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.CompositeElementLite' rel='Ext.CompositeElementLite' class='definedIn docClass'>Ext.CompositeElementLite</a><br/><a href='source/CompositeElementLite.html#Ext-CompositeElementLite-method-replaceElement' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.CompositeElementLite-method-replaceElement' class='name expandable'>replaceElement</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> el, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> replacement, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> domReplace]</span> ) : <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></div><div class='description'><div class='short'>Replaces the specified element with the passed element. ...</div><div class='long'><p>Replaces the specified element with the passed element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The id of an element, the Element itself, the index of the element in this composite\nto replace.</p>\n</div></li><li><span class='pre'>replacement</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The id of an element or the Element itself.</p>\n</div></li><li><span class='pre'>domReplace</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to remove and replace the element in the document too.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"meta":{},"requires":[],"deprecated":null,"extends":"Ext.CompositeElementLite","inheritable":false,"static":false,"superclasses":["Ext.CompositeElementLite","Ext.CompositeElement"],"singleton":false,"code_type":"assignment","alias":null,"statics":{"property":[],"css_var":[],"css_mixin":[],"cfg":[],"method":[],"event":[]},"subclasses":[],"uses":[],"protected":false,"mixins":[],"members":{"property":[{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":null,"required":null,"protected":false,"name":"elements","id":"property-elements"}],"css_var":[],"css_mixin":[],"cfg":[],"method":[{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":false,"required":null,"protected":false,"name":"add","id":"method-add"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":false,"required":null,"protected":false,"name":"clear","id":"method-clear"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":false,"required":null,"protected":false,"name":"contains","id":"method-contains"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":false,"required":null,"protected":false,"name":"each","id":"method-each"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":false,"required":null,"protected":false,"name":"fill","id":"method-fill"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":false,"required":null,"protected":false,"name":"filter","id":"method-filter"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":false,"required":null,"protected":false,"name":"first","id":"method-first"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":false,"required":null,"protected":false,"name":"getCount","id":"method-getCount"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":false,"required":null,"protected":false,"name":"indexOf","id":"method-indexOf"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":false,"required":null,"protected":false,"name":"item","id":"method-item"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":false,"required":null,"protected":false,"name":"last","id":"method-last"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":false,"required":null,"protected":false,"name":"removeElement","id":"method-removeElement"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.CompositeElementLite","template":false,"required":null,"protected":false,"name":"replaceElement","id":"method-replaceElement"}],"event":[]},"private":false,"component":false,"name":"Ext.CompositeElement","alternateClassNames":[],"id":"class-Ext.CompositeElement","mixedInto":[],"xtypes":{},"files":[{"href":"CompositeElement2.html#Ext-CompositeElement","filename":"CompositeElement.js"}]});