Ext.data.JsonP.Ext_Component({"tagname":"class","html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.Base' rel='Ext.Base' class='docClass'>Ext.Base</a><div class='subclass '><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='docClass'>Ext.AbstractComponent</a><div class='subclass '><strong>Ext.Component</strong></div></div></div><h4>Mixins</h4><div class='dependency'><a href='#!/api/Ext.util.Floating' rel='Ext.util.Floating' class='docClass'>Ext.util.Floating</a></div><div class='dependency'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a></div><div class='dependency'><a href='#!/api/Ext.util.Animate' rel='Ext.util.Animate' class='docClass'>Ext.util.Animate</a></div><div class='dependency'><a href='#!/api/Ext.state.Stateful' rel='Ext.state.Stateful' class='docClass'>Ext.state.Stateful</a></div><h4>Requires</h4><div class='dependency'><a href='#!/api/Ext.util.DelayedTask' rel='Ext.util.DelayedTask' class='docClass'>Ext.util.DelayedTask</a></div><h4>Uses</h4><div class='dependency'><a href='#!/api/Ext.Layer' rel='Ext.Layer' class='docClass'>Ext.Layer</a></div><div class='dependency'><a href='#!/api/Ext.resizer.Resizer' rel='Ext.resizer.Resizer' class='docClass'>Ext.resizer.Resizer</a></div><div class='dependency'><a href='#!/api/Ext.util.ComponentDragger' rel='Ext.util.ComponentDragger' class='docClass'>Ext.util.ComponentDragger</a></div><h4>Files</h4><div class='dependency'><a href='source/Component.html#Ext-Component' target='_blank'>Component.js</a></div></pre><div class='doc-contents'><p>Base class for all Ext components. All subclasses of Component may participate in the automated Ext component\nlifecycle of creation, rendering and destruction which is provided by the <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a>\nclass. Components may be added to a Container through the <a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a> config option\nat the time the Container is created, or they may be added dynamically via the\n<a href=\"#!/api/Ext.container.Container-event-add\" rel=\"Ext.container.Container-event-add\" class=\"docClass\">add</a> method.</p>\n\n<p>The Component base class has built-in support for basic hide/show and enable/disable and size control behavior.</p>\n\n<p>All Components are registered with the <a href=\"#!/api/Ext.ComponentManager\" rel=\"Ext.ComponentManager\" class=\"docClass\">Ext.ComponentManager</a> on construction so that they can be referenced at\nany time via <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp</a>, passing the <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a>.</p>\n\n<p>All user-developed visual widgets that are required to participate in automated lifecycle and size management should\nsubclass Component.</p>\n\n<p>See the <a href=\"http://sencha.com/learn/Tutorial:Creating_new_UI_controls\">Creating new UI controls</a> tutorial for details on how and to either extend or augment ExtJs base classes\nto create custom Components.</p>\n\n<p>Every component has a specific xtype, which is its Ext-specific type name, along with methods for checking the xtype\nlike <a href=\"#!/api/Ext.Component-method-getXType\" rel=\"Ext.Component-method-getXType\" class=\"docClass\">getXType</a> and <a href=\"#!/api/Ext.Component-method-isXType\" rel=\"Ext.Component-method-isXType\" class=\"docClass\">isXType</a>. See the [Component Guide][2] for more information on xtypes and the\nComponent hierarchy.</p>\n\n<p>This is the list of all valid xtypes:</p>\n\n<pre><code>xtype            Class\n-------------    ------------------\nbutton           <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>\nbuttongroup      <a href=\"#!/api/Ext.container.ButtonGroup\" rel=\"Ext.container.ButtonGroup\" class=\"docClass\">Ext.container.ButtonGroup</a>\ncolorpalette     <a href=\"#!/api/Ext.picker.Color\" rel=\"Ext.picker.Color\" class=\"docClass\">Ext.picker.Color</a>\ncomponent        <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\ncontainer        <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>\ncycle            <a href=\"#!/api/Ext.button.Cycle\" rel=\"Ext.button.Cycle\" class=\"docClass\">Ext.button.Cycle</a>\ndataview         <a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">Ext.view.View</a>\ndatepicker       <a href=\"#!/api/Ext.picker.Date\" rel=\"Ext.picker.Date\" class=\"docClass\">Ext.picker.Date</a>\neditor           <a href=\"#!/api/Ext.Editor\" rel=\"Ext.Editor\" class=\"docClass\">Ext.Editor</a>\neditorgrid       <a href=\"#!/api/Ext.grid.plugin.Editing\" rel=\"Ext.grid.plugin.Editing\" class=\"docClass\">Ext.grid.plugin.Editing</a>\ngrid             <a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">Ext.grid.Panel</a>\nmultislider      <a href=\"#!/api/Ext.slider.Multi\" rel=\"Ext.slider.Multi\" class=\"docClass\">Ext.slider.Multi</a>\npanel            <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>\nprogressbar      <a href=\"#!/api/Ext.ProgressBar\" rel=\"Ext.ProgressBar\" class=\"docClass\">Ext.ProgressBar</a>\nslider           <a href=\"#!/api/Ext.slider.Single\" rel=\"Ext.slider.Single\" class=\"docClass\">Ext.slider.Single</a>\nsplitbutton      <a href=\"#!/api/Ext.button.Split\" rel=\"Ext.button.Split\" class=\"docClass\">Ext.button.Split</a>\ntabpanel         <a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">Ext.tab.Panel</a>\ntreepanel        <a href=\"#!/api/Ext.tree.Panel\" rel=\"Ext.tree.Panel\" class=\"docClass\">Ext.tree.Panel</a>\nviewport         <a href=\"#!/api/Ext.container.Viewport\" rel=\"Ext.container.Viewport\" class=\"docClass\">Ext.container.Viewport</a>\nwindow           <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>\n\nToolbar components\n---------------------------------------\npagingtoolbar    <a href=\"#!/api/Ext.toolbar.Paging\" rel=\"Ext.toolbar.Paging\" class=\"docClass\">Ext.toolbar.Paging</a>\ntoolbar          <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Ext.toolbar.Toolbar</a>\ntbfill           <a href=\"#!/api/Ext.toolbar.Fill\" rel=\"Ext.toolbar.Fill\" class=\"docClass\">Ext.toolbar.Fill</a>\ntbitem           <a href=\"#!/api/Ext.toolbar.Item\" rel=\"Ext.toolbar.Item\" class=\"docClass\">Ext.toolbar.Item</a>\ntbseparator      <a href=\"#!/api/Ext.toolbar.Separator\" rel=\"Ext.toolbar.Separator\" class=\"docClass\">Ext.toolbar.Separator</a>\ntbspacer         <a href=\"#!/api/Ext.toolbar.Spacer\" rel=\"Ext.toolbar.Spacer\" class=\"docClass\">Ext.toolbar.Spacer</a>\ntbtext           <a href=\"#!/api/Ext.toolbar.TextItem\" rel=\"Ext.toolbar.TextItem\" class=\"docClass\">Ext.toolbar.TextItem</a>\n\nMenu components\n---------------------------------------\nmenu             <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Ext.menu.Menu</a>\nmenucheckitem    <a href=\"#!/api/Ext.menu.CheckItem\" rel=\"Ext.menu.CheckItem\" class=\"docClass\">Ext.menu.CheckItem</a>\nmenuitem         <a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">Ext.menu.Item</a>\nmenuseparator    <a href=\"#!/api/Ext.menu.Separator\" rel=\"Ext.menu.Separator\" class=\"docClass\">Ext.menu.Separator</a>\nmenutextitem     <a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">Ext.menu.Item</a>\n\nForm components\n---------------------------------------\nform             <a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a>\ncheckbox         <a href=\"#!/api/Ext.form.field.Checkbox\" rel=\"Ext.form.field.Checkbox\" class=\"docClass\">Ext.form.field.Checkbox</a>\ncombo            <a href=\"#!/api/Ext.form.field.ComboBox\" rel=\"Ext.form.field.ComboBox\" class=\"docClass\">Ext.form.field.ComboBox</a>\ndatefield        <a href=\"#!/api/Ext.form.field.Date\" rel=\"Ext.form.field.Date\" class=\"docClass\">Ext.form.field.Date</a>\ndisplayfield     <a href=\"#!/api/Ext.form.field.Display\" rel=\"Ext.form.field.Display\" class=\"docClass\">Ext.form.field.Display</a>\nfield            <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a>\nfieldset         <a href=\"#!/api/Ext.form.FieldSet\" rel=\"Ext.form.FieldSet\" class=\"docClass\">Ext.form.FieldSet</a>\nhidden           <a href=\"#!/api/Ext.form.field.Hidden\" rel=\"Ext.form.field.Hidden\" class=\"docClass\">Ext.form.field.Hidden</a>\nhtmleditor       <a href=\"#!/api/Ext.form.field.HtmlEditor\" rel=\"Ext.form.field.HtmlEditor\" class=\"docClass\">Ext.form.field.HtmlEditor</a>\nlabel            <a href=\"#!/api/Ext.form.Label\" rel=\"Ext.form.Label\" class=\"docClass\">Ext.form.Label</a>\nnumberfield      <a href=\"#!/api/Ext.form.field.Number\" rel=\"Ext.form.field.Number\" class=\"docClass\">Ext.form.field.Number</a>\nradio            <a href=\"#!/api/Ext.form.field.Radio\" rel=\"Ext.form.field.Radio\" class=\"docClass\">Ext.form.field.Radio</a>\nradiogroup       <a href=\"#!/api/Ext.form.RadioGroup\" rel=\"Ext.form.RadioGroup\" class=\"docClass\">Ext.form.RadioGroup</a>\ntextarea         <a href=\"#!/api/Ext.form.field.TextArea\" rel=\"Ext.form.field.TextArea\" class=\"docClass\">Ext.form.field.TextArea</a>\ntextfield        <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>\ntimefield        <a href=\"#!/api/Ext.form.field.Time\" rel=\"Ext.form.field.Time\" class=\"docClass\">Ext.form.field.Time</a>\ntrigger          <a href=\"#!/api/Ext.form.field.Trigger\" rel=\"Ext.form.field.Trigger\" class=\"docClass\">Ext.form.field.Trigger</a>\n\nChart components\n---------------------------------------\nchart            <a href=\"#!/api/Ext.chart.Chart\" rel=\"Ext.chart.Chart\" class=\"docClass\">Ext.chart.Chart</a>\nbarchart         <a href=\"#!/api/Ext.chart.series.Bar\" rel=\"Ext.chart.series.Bar\" class=\"docClass\">Ext.chart.series.Bar</a>\ncolumnchart      <a href=\"#!/api/Ext.chart.series.Column\" rel=\"Ext.chart.series.Column\" class=\"docClass\">Ext.chart.series.Column</a>\nlinechart        <a href=\"#!/api/Ext.chart.series.Line\" rel=\"Ext.chart.series.Line\" class=\"docClass\">Ext.chart.series.Line</a>\npiechart         <a href=\"#!/api/Ext.chart.series.Pie\" rel=\"Ext.chart.series.Pie\" class=\"docClass\">Ext.chart.series.Pie</a>\n</code></pre>\n\n<p>It should not usually be necessary to instantiate a Component because there are provided subclasses which implement\nspecialized Component use cases which cover most application needs. However it is possible to instantiate a base\nComponent, and it will be renderable, or will particpate in layouts as the child item of a Container:</p>\n\n<pre class='inline-example '><code>Ext.create('Ext.Component', {\n    html: 'Hello world!',\n    width: 300,\n    height: 200,\n    padding: 20,\n    style: {\n        color: '#FFFFFF',\n        backgroundColor:'#000000'\n    },\n    renderTo: Ext.getBody()\n});\n</code></pre>\n\n<p>The Component above creates its encapsulating <code>div</code> upon render, and use the configured HTML as content. More complex\ninternal structure may be created using the <a href=\"#!/api/Ext.Component-cfg-renderTpl\" rel=\"Ext.Component-cfg-renderTpl\" class=\"docClass\">renderTpl</a> configuration, although to display database-derived\nmass data, it is recommended that an ExtJS data-backed Component such as a <a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">View</a>, or <a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">GridPanel</a>, or <a href=\"#!/api/Ext.tree.Panel\" rel=\"Ext.tree.Panel\" class=\"docClass\">TreePanel</a> be used.</p>\n</div><div class='members'><div id='m-cfg'><div class='definedBy'>Defined By</div><h3 class='members-title'>Config options</h3><div class='subsection'><div id='cfg-autoEl' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-autoEl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-autoEl' class='name expandable'>autoEl</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>A tag name or DomHelper spec used to create the Element which will\nencapsulate this Component. ...</div><div class='long'><p>A tag name or <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> spec used to create the <a href=\"#!/api/Ext.AbstractComponent-method-getEl\" rel=\"Ext.AbstractComponent-method-getEl\" class=\"docClass\">Element</a> which will\nencapsulate this Component.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong>'div'</strong>. The more complex Sencha classes use a more\ncomplex DOM structure specified by their own <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTpl\" rel=\"Ext.AbstractComponent-cfg-renderTpl\" class=\"docClass\">renderTpl</a>s.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components encapsulated by\ndifferent DOM elements. Example usage:</p>\n\n<pre><code>{\n    xtype: 'component',\n    autoEl: {\n        tag: 'img',\n        src: 'http://www.example.com/example.jpg'\n    }\n}, {\n    xtype: 'component',\n    autoEl: {\n        tag: 'blockquote',\n        html: 'autoEl is cool!'\n    }\n}, {\n    xtype: 'container',\n    autoEl: 'ul',\n    cls: 'ux-unordered-list',\n    items: {\n        xtype: 'component',\n        autoEl: 'li',\n        html: 'First list item'\n    }\n}\n</code></pre>\n</div></div></div><div id='cfg-autoRender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-autoRender' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-autoRender' class='name expandable'>autoRender</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>This config is intended mainly for non-floating Components which may or may not be shown. ...</div><div class='long'><p>This config is intended mainly for non-<a href=\"#!/api/Ext.AbstractComponent-cfg-floating\" rel=\"Ext.AbstractComponent-cfg-floating\" class=\"docClass\">floating</a> Components which may or may not be shown. Instead of using\n<a href=\"#!/api/Ext.AbstractComponent-cfg-renderTo\" rel=\"Ext.AbstractComponent-cfg-renderTo\" class=\"docClass\">renderTo</a> in the configuration, and rendering upon construction, this allows a Component to render itself\nupon first <em><a href=\"#!/api/Ext.AbstractComponent-event-show\" rel=\"Ext.AbstractComponent-event-show\" class=\"docClass\">show</a></em>. If <a href=\"#!/api/Ext.AbstractComponent-cfg-floating\" rel=\"Ext.AbstractComponent-cfg-floating\" class=\"docClass\">floating</a> is true, the value of this config is omited as if it is <code>true</code>.</p>\n\n<p>Specify as <code>true</code> to have this Component render to the document body upon first show.</p>\n\n<p>Specify as an element, or the ID of an element to have this Component render to a specific element upon first\nshow.</p>\n\n<p><strong>This defaults to <code>true</code> for the <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Window</a> class.</strong></p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-autoScroll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-autoScroll' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-cfg-autoScroll' class='name expandable'>autoScroll</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>true to use overflow:'auto' on the components layout element and show scroll bars automatically when necessary,\nfalse...</div><div class='long'><p><code>true</code> to use overflow:'auto' on the components layout element and show scroll bars automatically when necessary,\n<code>false</code> to clip any overflowing content.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-autoShow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-autoShow' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-autoShow' class='name expandable'>autoShow</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True to automatically show the component upon creation. ...</div><div class='long'><p>True to automatically show the component upon creation. This config option may only be used for\n<a href=\"#!/api/Ext.AbstractComponent-cfg-floating\" rel=\"Ext.AbstractComponent-cfg-floating\" class=\"docClass\">floating</a> components or components that use <a href=\"#!/api/Ext.AbstractComponent-cfg-autoRender\" rel=\"Ext.AbstractComponent-cfg-autoRender\" class=\"docClass\">autoRender</a>. Defaults to false.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-baseCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-baseCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-baseCls' class='name expandable'>baseCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The base CSS class to apply to this components's element. ...</div><div class='long'><p>The base CSS class to apply to this components's element. This will also be prepended to elements within this\ncomponent like Panel's body will get a class x-panel-body. This means that if you create a subclass of Panel, and\nyou want it to get all the Panels styling for the element and the body, you leave the baseCls x-panel and use\ncomponentCls to add specific styling for this component.</p>\n<p>Defaults to: <code>&quot;x-component&quot;</code></p></div></div></div><div id='cfg-border' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-border' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-border' class='name expandable'>border</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Specifies the border for this component. ...</div><div class='long'><p>Specifies the border for this component. The border can be a single numeric value to apply to all sides or it can\nbe a CSS style specification for each style, for example: '10 5 3 10'.</p>\n</div></div></div><div id='cfg-childEls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-childEls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-childEls' class='name expandable'>childEls</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]</span></div><div class='description'><div class='short'>An array describing the child elements of the Component. ...</div><div class='long'><p>An array describing the child elements of the Component. Each member of the array\nis an object with these properties:</p>\n\n<ul>\n<li><code>name</code> - The property name on the Component for the child element.</li>\n<li><code>itemId</code> - The id to combine with the Component's id that is the id of the child element.</li>\n<li><code>id</code> - The id of the child element.</li>\n</ul>\n\n\n<p>If the array member is a string, it is equivalent to <code>{ name: m, itemId: m }</code>.</p>\n\n<p>For example, a Component which renders a title and body text:</p>\n\n<pre><code>Ext.create('Ext.Component', {\n    renderTo: Ext.getBody(),\n    renderTpl: [\n        '&lt;h1 id=\"{id}-title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{msg}&lt;/p&gt;',\n    ],\n    renderData: {\n        title: \"Error\",\n        msg: \"Something went wrong\"\n    },\n    childEls: [\"title\"],\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a title property\n            cmp.title.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>A more flexible, but somewhat slower, approach is <a href=\"#!/api/Ext.AbstractComponent-cfg-renderSelectors\" rel=\"Ext.AbstractComponent-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a>.</p>\n</div></div></div><div id='cfg-cls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-cls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-cls' class='name expandable'>cls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional extra CSS class that will be added to this component's Element. ...</div><div class='long'><p>An optional extra CSS class that will be added to this component's Element. This can be useful\nfor adding customized styles to the component or any of its children using standard CSS rules.</p>\n<p>Defaults to: <code>&quot;&quot;</code></p></div></div></div><div id='cfg-componentCls' class='member  inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-componentCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-componentCls' class='name not-expandable'>componentCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>CSS Class to be added to a components root level element to give distinction to it via styling.</p>\n</div><div class='long'><p>CSS Class to be added to a components root level element to give distinction to it via styling.</p>\n</div></div></div><div id='cfg-componentLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-componentLayout' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-componentLayout' class='name expandable'>componentLayout</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>The sizing and positioning of a Component's internal Elements is the responsibility of the Component's layout\nmanager...</div><div class='long'><p>The sizing and positioning of a Component's internal Elements is the responsibility of the Component's layout\nmanager which sizes a Component's internal structure in response to the Component being sized.</p>\n\n<p>Generally, developers will not use this configuration as all provided Components which need their internal\nelements sizing (Such as <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">input fields</a>) come with their own componentLayout managers.</p>\n\n<p>The <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used on instances of the base <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nclass which simply sizes the Component's encapsulating element to the height and width specified in the\n<a href=\"#!/api/Ext.AbstractComponent-method-setSize\" rel=\"Ext.AbstractComponent-method-setSize\" class=\"docClass\">setSize</a> method.</p>\n</div></div></div><div id='cfg-contentEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-contentEl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-contentEl' class='name expandable'>contentEl</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Specify an existing HTML element, or the id of an existing HTML element to use as the content for this component. ...</div><div class='long'><p>Specify an existing HTML element, or the <code>id</code> of an existing HTML element to use as the content for this component.</p>\n\n<p>This config option is used to take an existing HTML element and place it in the layout element of a new component\n(it simply moves the specified DOM element <em>after the Component is rendered</em> to use as the content.</p>\n\n<p><strong>Notes:</strong></p>\n\n<p>The specified HTML element is appended to the layout element of the component <em>after any configured\n<a href=\"#!/api/Ext.AbstractComponent-cfg-html\" rel=\"Ext.AbstractComponent-cfg-html\" class=\"docClass\">HTML</a> has been inserted</em>, and so the document will not contain this element at the time\nthe <a href=\"#!/api/Ext.AbstractComponent-event-render\" rel=\"Ext.AbstractComponent-event-render\" class=\"docClass\">render</a> event is fired.</p>\n\n<p>The specified HTML element used will not participate in any <strong><code><a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a></code></strong>\nscheme that the Component may use. It is just HTML. Layouts operate on child\n<strong><code><a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a></code></strong>.</p>\n\n<p>Add either the <code>x-hidden</code> or the <code>x-hide-display</code> CSS class to prevent a brief flicker of the content before it\nis rendered to the panel.</p>\n</div></div></div><div id='cfg-data' class='member  inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-data' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-data' class='name not-expandable'>data</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'><p>The initial set of data to apply to the <code><a href=\"#!/api/Ext.AbstractComponent-cfg-tpl\" rel=\"Ext.AbstractComponent-cfg-tpl\" class=\"docClass\">tpl</a></code> to update the content area of the Component.</p>\n</div><div class='long'><p>The initial set of data to apply to the <code><a href=\"#!/api/Ext.AbstractComponent-cfg-tpl\" rel=\"Ext.AbstractComponent-cfg-tpl\" class=\"docClass\">tpl</a></code> to update the content area of the Component.</p>\n</div></div></div><div id='cfg-disabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-disabled' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-disabled' class='name expandable'>disabled</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True to disable the component. ...</div><div class='long'><p>True to disable the component.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-disabledCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-disabledCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-disabledCls' class='name expandable'>disabledCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>CSS class to add when the Component is disabled. ...</div><div class='long'><p>CSS class to add when the Component is disabled. Defaults to 'x-item-disabled'.</p>\n<p>Defaults to: <code>&quot;x-item-disabled&quot;</code></p></div></div></div><div id='cfg-draggable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-draggable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-cfg-draggable' class='name expandable'>draggable</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>Specify as true to make a floating Component draggable using the Component's encapsulating element as\nthe drag handle. ...</div><div class='long'><p>Specify as true to make a <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Component draggable using the Component's encapsulating element as\nthe drag handle.</p>\n\n<p>This may also be specified as a config object for the <a href=\"#!/api/Ext.util.ComponentDragger\" rel=\"Ext.util.ComponentDragger\" class=\"docClass\">ComponentDragger</a> which is\ninstantiated to perform dragging.</p>\n\n<p>For example to create a Component which may only be dragged around using a certain internal element as the drag\nhandle, use the delegate option:</p>\n\n<pre><code>new Ext.Component({\n    constrain: true,\n    floating: true,\n    style: {\n        backgroundColor: '#fff',\n        border: '1px solid black'\n    },\n    html: '&lt;h1 style=\"cursor:move\"&gt;The title&lt;/h1&gt;&lt;p&gt;The content&lt;/p&gt;',\n    draggable: {\n        delegate: 'h1'\n    }\n}).show();\n</code></pre>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-floating' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-floating' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-cfg-floating' class='name expandable'>floating</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Specify as true to float the Component outside of the document flow using CSS absolute positioning. ...</div><div class='long'><p>Specify as true to float the Component outside of the document flow using CSS absolute positioning.</p>\n\n<p>Components such as <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Window</a>s and <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Menu</a>s are floating by default.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-event-render\" rel=\"Ext.Component-event-render\" class=\"docClass\">rendered</a> will register themselves with\nthe global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a></p>\n\n<h3>Floating Components as child items of a Container</h3>\n\n<p>A floating Component may be used as a child item of a Container. This just allows the floating Component to seek\na ZIndexManager by examining the ownerCt chain.</p>\n\n<p>When configured as floating, Components acquire, at render time, a <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> which\nmanages a stack of related floating Components. The ZIndexManager brings a single floating Component to the top\nof its stack when the Component's <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">toFront</a> method is called.</p>\n\n<p>The ZIndexManager is found by traversing up the <a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a> chain to find an ancestor which itself is\nfloating. This is so that descendant floating Components of floating <em>Containers</em> (Such as a ComboBox dropdown\nwithin a Window) can have its zIndex managed relative to any siblings, but always <strong>above</strong> that floating\nancestor Container.</p>\n\n<p>If no floating ancestor is found, a floating Component registers itself with the default <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a>.</p>\n\n<p>Floating components <em>do not participate in the Container's layout</em>. Because of this, they are not rendered until\nyou explicitly <a href=\"#!/api/Ext.Component-event-show\" rel=\"Ext.Component-event-show\" class=\"docClass\">show</a> them.</p>\n\n<p>After rendering, the ownerCt reference is deleted, and the <a href=\"#!/api/Ext.Component-property-floatParent\" rel=\"Ext.Component-property-floatParent\" class=\"docClass\">floatParent</a> property is set to the found\nfloating ancestor Container. If no floating ancestor Container was found the <a href=\"#!/api/Ext.Component-property-floatParent\" rel=\"Ext.Component-property-floatParent\" class=\"docClass\">floatParent</a> property will\nnot be set.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-focusOnToFront' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Floating' rel='Ext.util.Floating' class='definedIn docClass'>Ext.util.Floating</a><br/><a href='source/Floating.html#Ext-util-Floating-cfg-focusOnToFront' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Floating-cfg-focusOnToFront' class='name expandable'>focusOnToFront</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Specifies whether the floated component should be automatically focused when\nit is brought to the front. ...</div><div class='long'><p>Specifies whether the floated component should be automatically <a href=\"#!/api/Ext.Component-method-focus\" rel=\"Ext.Component-method-focus\" class=\"docClass\">focused</a> when\nit is <a href=\"#!/api/Ext.util.Floating-method-toFront\" rel=\"Ext.util.Floating-method-toFront\" class=\"docClass\">brought to the front</a>.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-frame' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-frame' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-frame' class='name expandable'>frame</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Specify as true to have the Component inject framing elements within the Component at render time to provide a\ngraphi...</div><div class='long'><p>Specify as <code>true</code> to have the Component inject framing elements within the Component at render time to provide a\ngraphical rounded frame around the Component content.</p>\n\n<p>This is only necessary when running on outdated, or non standard-compliant browsers such as Microsoft's Internet\nExplorer prior to version 9 which do not support rounded corners natively.</p>\n\n<p>The extra space taken up by this framing is available from the read only property <a href=\"#!/api/Ext.AbstractComponent-property-frameSize\" rel=\"Ext.AbstractComponent-property-frameSize\" class=\"docClass\">frameSize</a>.</p>\n</div></div></div><div id='cfg-height' class='member  inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-height' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-height' class='name not-expandable'>height</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The height of this component in pixels.</p>\n</div><div class='long'><p>The height of this component in pixels.</p>\n</div></div></div><div id='cfg-hidden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-hidden' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-hidden' class='name expandable'>hidden</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True to hide the component. ...</div><div class='long'><p>True to hide the component.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-hideMode' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-hideMode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-hideMode' class='name expandable'>hideMode</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A String which specifies how this Component's encapsulating DOM element will be hidden. ...</div><div class='long'><p>A String which specifies how this Component's encapsulating DOM element will be hidden. Values may be:</p>\n\n<ul>\n<li><code>'display'</code> : The Component will be hidden using the <code>display: none</code> style.</li>\n<li><code>'visibility'</code> : The Component will be hidden using the <code>visibility: hidden</code> style.</li>\n<li><code>'offsets'</code> : The Component will be hidden by absolutely positioning it out of the visible area of the document.\nThis is useful when a hidden Component must maintain measurable dimensions. Hiding using <code>display</code> results in a\nComponent having zero dimensions.</li>\n</ul>\n\n<p>Defaults to: <code>&quot;display&quot;</code></p></div></div></div><div id='cfg-html' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-html' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-html' class='name expandable'>html</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>An HTML fragment, or a DomHelper specification to use as the layout element content. ...</div><div class='long'><p>An HTML fragment, or a <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> specification to use as the layout element content.\nThe HTML content is added after the component is rendered, so the document will not contain this HTML at the time\nthe <a href=\"#!/api/Ext.AbstractComponent-event-render\" rel=\"Ext.AbstractComponent-event-render\" class=\"docClass\">render</a> event is fired. This content is inserted into the body <em>before</em> any configured <a href=\"#!/api/Ext.AbstractComponent-cfg-contentEl\" rel=\"Ext.AbstractComponent-cfg-contentEl\" class=\"docClass\">contentEl</a>\nis appended.</p>\n<p>Defaults to: <code>&quot;&quot;</code></p></div></div></div><div id='cfg-id' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-id' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-id' class='name expandable'>id</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The unique id of this component instance. ...</div><div class='long'><p>The <strong>unique id of this component instance.</strong></p>\n\n<p>It should not be necessary to use this configuration except for singleton objects in your application. Components\ncreated with an id may be accessed globally using <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp</a>.</p>\n\n<p>Instead of using assigned ids, use the <a href=\"#!/api/Ext.AbstractComponent-cfg-itemId\" rel=\"Ext.AbstractComponent-cfg-itemId\" class=\"docClass\">itemId</a> config, and <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a>\nwhich provides selector-based searching for Sencha Components analogous to DOM querying. The <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> class contains <a href=\"#!/api/Ext.container.Container-method-down\" rel=\"Ext.container.Container-method-down\" class=\"docClass\">shortcut methods</a> to query\nits descendant Components by selector.</p>\n\n<p>Note that this id will also be used as the element id for the containing HTML element that is rendered to the\npage for this component. This allows you to write id-based CSS rules to style the specific instance of this\ncomponent uniquely, and also to select sub-elements using this component's id as the parent.</p>\n\n<p><strong>Note</strong>: to avoid complications imposed by a unique id also see <code><a href=\"#!/api/Ext.AbstractComponent-cfg-itemId\" rel=\"Ext.AbstractComponent-cfg-itemId\" class=\"docClass\">itemId</a></code>.</p>\n\n<p><strong>Note</strong>: to access the container of a Component see <code><a href=\"#!/api/Ext.AbstractComponent-property-ownerCt\" rel=\"Ext.AbstractComponent-property-ownerCt\" class=\"docClass\">ownerCt</a></code>.</p>\n\n<p>Defaults to an <a href=\"#!/api/Ext.AbstractComponent-method-getId\" rel=\"Ext.AbstractComponent-method-getId\" class=\"docClass\">auto-assigned id</a>.</p>\n</div></div></div><div id='cfg-itemId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-itemId' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-itemId' class='name expandable'>itemId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An itemId can be used as an alternative way to get a reference to a component when no object reference is\navailable. ...</div><div class='long'><p>An itemId can be used as an alternative way to get a reference to a component when no object reference is\navailable. Instead of using an <code><a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a></code> with <a href=\"#!/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a>.<a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">getCmp</a>, use <code>itemId</code> with\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>.<a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a> which will retrieve\n<code>itemId</code>'s or <a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a>'s. Since <code>itemId</code>'s are an index to the container's internal MixedCollection, the\n<code>itemId</code> is scoped locally to the container -- avoiding potential conflicts with <a href=\"#!/api/Ext.ComponentManager\" rel=\"Ext.ComponentManager\" class=\"docClass\">Ext.ComponentManager</a>\nwhich requires a <strong>unique</strong> <code><a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a></code>.</p>\n\n<pre><code>var c = new Ext.panel.Panel({ //\n    <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 300,\n    <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTo\" rel=\"Ext.AbstractComponent-cfg-renderTo\" class=\"docClass\">renderTo</a>: document.body,\n    <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a>: 'auto',\n    <a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a>: [\n        {\n            itemId: 'p1',\n            <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 1',\n            <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 150\n        },\n        {\n            itemId: 'p2',\n            <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 2',\n            <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 150\n        }\n    ]\n})\np1 = c.<a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p1'); // not the same as <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp()</a>\np2 = p1.<a href=\"#!/api/Ext.AbstractComponent-property-ownerCt\" rel=\"Ext.AbstractComponent-property-ownerCt\" class=\"docClass\">ownerCt</a>.<a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p2'); // reference via a sibling\n</code></pre>\n\n<p>Also see <a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a>, <code><a href=\"#!/api/Ext.container.Container-method-query\" rel=\"Ext.container.Container-method-query\" class=\"docClass\">Ext.container.Container.query</a></code>, <code><a href=\"#!/api/Ext.container.Container-method-down\" rel=\"Ext.container.Container-method-down\" class=\"docClass\">Ext.container.Container.down</a></code> and\n<code><a href=\"#!/api/Ext.container.Container-method-child\" rel=\"Ext.container.Container-method-child\" class=\"docClass\">Ext.container.Container.child</a></code>.</p>\n\n<p><strong>Note</strong>: to access the container of an item see <a href=\"#!/api/Ext.AbstractComponent-property-ownerCt\" rel=\"Ext.AbstractComponent-property-ownerCt\" class=\"docClass\">ownerCt</a>.</p>\n</div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>A config object containing one or more event handlers to be added to this object during initialization. ...</div><div class='long'><p>A config object containing one or more event handlers to be added to this object during initialization. This\nshould be a valid listeners config object as specified in the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple\nhandlers at once.</p>\n\n<p><strong>DOM events from Ext JS <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></strong></p>\n\n<p>While <em>some</em> Ext JS Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this is usually\nonly done when extra value can be added. For example the <a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">DataView</a>'s <strong><code><a href=\"#!/api/Ext.view.View-event-itemclick\" rel=\"Ext.view.View-event-itemclick\" class=\"docClass\">itemclick</a></code></strong> event passing the node clicked on. To access DOM events directly from a\nchild element of a Component, we need to specify the <code>element</code> option to identify the Component property to add a\nDOM listener to:</p>\n\n<pre><code>new Ext.panel.Panel({\n    width: 400,\n    height: 200,\n    dockedItems: [{\n        xtype: 'toolbar'\n    }],\n    listeners: {\n        click: {\n            element: 'el', //bind to the underlying el property on the panel\n            fn: function(){ console.log('click el'); }\n        },\n        dblclick: {\n            element: 'body', //bind to the underlying body property on the panel\n            fn: function(){ console.log('dblclick body'); }\n        }\n    }\n});\n</code></pre>\n</div></div></div><div id='cfg-loader' class='member  inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-loader' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-loader' class='name not-expandable'>loader</a><span> : <a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'><p>A configuration object or an instance of a <a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a> to load remote content for this Component.</p>\n</div><div class='long'><p>A configuration object or an instance of a <a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a> to load remote content for this Component.</p>\n</div></div></div><div id='cfg-maintainFlex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-maintainFlex' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-cfg-maintainFlex' class='name expandable'>maintainFlex</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Only valid when a sibling element of a Splitter within a\nVBox or HBox layout. ...</div><div class='long'><p><strong>Only valid when a sibling element of a <a href=\"#!/api/Ext.resizer.Splitter\" rel=\"Ext.resizer.Splitter\" class=\"docClass\">Splitter</a> within a\n<a href=\"#!/api/Ext.layout.container.VBox\" rel=\"Ext.layout.container.VBox\" class=\"docClass\">VBox</a> or <a href=\"#!/api/Ext.layout.container.HBox\" rel=\"Ext.layout.container.HBox\" class=\"docClass\">HBox</a> layout.</strong></p>\n\n<p>Specifies that if an immediate sibling Splitter is moved, the Component on the <em>other</em> side is resized, and this\nComponent maintains its configured <a href=\"#!/api/Ext.layout.container.Box-cfg-flex\" rel=\"Ext.layout.container.Box-cfg-flex\" class=\"docClass\">flex</a> value.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-margin' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-margin' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-margin' class='name expandable'>margin</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Specifies the margin for this component. ...</div><div class='long'><p>Specifies the margin for this component. The margin can be a single numeric value to apply to all sides or it can\nbe a CSS style specification for each style, for example: '10 5 3 10'.</p>\n</div></div></div><div id='cfg-maxHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-maxHeight' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-maxHeight' class='name expandable'>maxHeight</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The maximum value in pixels which this Component will set its height to. ...</div><div class='long'><p>The maximum value in pixels which this Component will set its height to.</p>\n\n<p><strong>Warning:</strong> This will override any size management applied by layout managers.</p>\n</div></div></div><div id='cfg-maxWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-maxWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-maxWidth' class='name expandable'>maxWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The maximum value in pixels which this Component will set its width to. ...</div><div class='long'><p>The maximum value in pixels which this Component will set its width to.</p>\n\n<p><strong>Warning:</strong> This will override any size management applied by layout managers.</p>\n</div></div></div><div id='cfg-minHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-minHeight' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-minHeight' class='name expandable'>minHeight</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum value in pixels which this Component will set its height to. ...</div><div class='long'><p>The minimum value in pixels which this Component will set its height to.</p>\n\n<p><strong>Warning:</strong> This will override any size management applied by layout managers.</p>\n</div></div></div><div id='cfg-minWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-minWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-minWidth' class='name expandable'>minWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum value in pixels which this Component will set its width to. ...</div><div class='long'><p>The minimum value in pixels which this Component will set its width to.</p>\n\n<p><strong>Warning:</strong> This will override any size management applied by layout managers.</p>\n</div></div></div><div id='cfg-overCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-overCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-overCls' class='name expandable'>overCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional extra CSS class that will be added to this component's Element when the mouse moves over the Element,\nand...</div><div class='long'><p>An optional extra CSS class that will be added to this component's Element when the mouse moves over the Element,\nand removed when the mouse moves out. This can be useful for adding customized 'active' or 'hover' styles to the\ncomponent or any of its children using standard CSS rules.</p>\n<p>Defaults to: <code>&quot;&quot;</code></p></div></div></div><div id='cfg-padding' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-padding' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-padding' class='name expandable'>padding</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Specifies the padding for this component. ...</div><div class='long'><p>Specifies the padding for this component. The padding can be a single numeric value to apply to all sides or it\ncan be a CSS style specification for each style, for example: '10 5 3 10'.</p>\n</div></div></div><div id='cfg-plugins' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-plugins' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-plugins' class='name expandable'>plugins</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]</span></div><div class='description'><div class='short'>An object or array of objects that will provide custom functionality for this component. ...</div><div class='long'><p>An object or array of objects that will provide custom functionality for this component. The only requirement for\na valid plugin is that it contain an init method that accepts a reference of type <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>. When a component\nis created, if any plugins are available, the component will call the init method on each plugin, passing a\nreference to itself. Each plugin can then call methods or respond to events on the component as needed to provide\nits functionality.</p>\n</div></div></div><div id='cfg-renderData' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-renderData' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-renderData' class='name expandable'>renderData</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>The data used by renderTpl in addition to the following property values of the component:\n\n\nid\nui\nuiCls\nbaseCls\ncompo...</div><div class='long'><p>The data used by <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTpl\" rel=\"Ext.AbstractComponent-cfg-renderTpl\" class=\"docClass\">renderTpl</a> in addition to the following property values of the component:</p>\n\n<ul>\n<li>id</li>\n<li>ui</li>\n<li>uiCls</li>\n<li>baseCls</li>\n<li>componentCls</li>\n<li>frame</li>\n</ul>\n\n\n<p>See <a href=\"#!/api/Ext.AbstractComponent-cfg-renderSelectors\" rel=\"Ext.AbstractComponent-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.AbstractComponent-cfg-childEls\" rel=\"Ext.AbstractComponent-cfg-childEls\" class=\"docClass\">childEls</a> for usage examples.</p>\n</div></div></div><div id='cfg-renderSelectors' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-renderSelectors' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-renderSelectors' class='name expandable'>renderSelectors</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>An object containing properties specifying DomQuery selectors which identify child elements\ncreated by the render pro...</div><div class='long'><p>An object containing properties specifying <a href=\"#!/api/Ext.DomQuery\" rel=\"Ext.DomQuery\" class=\"docClass\">DomQuery</a> selectors which identify child elements\ncreated by the render process.</p>\n\n<p>After the Component's internal structure is rendered according to the <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTpl\" rel=\"Ext.AbstractComponent-cfg-renderTpl\" class=\"docClass\">renderTpl</a>, this object is iterated through,\nand the found Elements are added as properties to the Component using the <code>renderSelector</code> property name.</p>\n\n<p>For example, a Component which renderes a title and description into its element:</p>\n\n<pre><code>Ext.create('Ext.Component', {\n    renderTo: Ext.getBody(),\n    renderTpl: [\n        '&lt;h1 class=\"title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{desc}&lt;/p&gt;'\n    ],\n    renderData: {\n        title: \"Error\",\n        desc: \"Something went wrong\"\n    },\n    renderSelectors: {\n        titleEl: 'h1.title',\n        descEl: 'p'\n    },\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a titleEl and descEl properties\n            cmp.titleEl.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>For a faster, but less flexible, alternative that achieves the same end result (properties for child elements on the\nComponent after render), see <a href=\"#!/api/Ext.AbstractComponent-cfg-childEls\" rel=\"Ext.AbstractComponent-cfg-childEls\" class=\"docClass\">childEls</a> and <a href=\"#!/api/Ext.AbstractComponent-method-addChildEls\" rel=\"Ext.AbstractComponent-method-addChildEls\" class=\"docClass\">addChildEls</a>.</p>\n</div></div></div><div id='cfg-renderTo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-renderTo' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-renderTo' class='name expandable'>renderTo</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>Specify the id of the element, a DOM element or an existing Element that this component will be rendered into. ...</div><div class='long'><p>Specify the id of the element, a DOM element or an existing Element that this component will be rendered into.</p>\n\n<p><strong>Notes:</strong></p>\n\n<p>Do <em>not</em> use this option if the Component is to be a child item of a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a>.\nIt is the responsibility of the <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a>'s\n<a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout manager</a> to render and manage its child items.</p>\n\n<p>When using this config, a call to render() is not required.</p>\n\n<p>See <code><a href=\"#!/api/Ext.AbstractComponent-event-render\" rel=\"Ext.AbstractComponent-event-render\" class=\"docClass\">render</a></code> also.</p>\n</div></div></div><div id='cfg-renderTpl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-renderTpl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-renderTpl' class='name expandable'>renderTpl</a><span> : <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</span></div><div class='description'><div class='short'>An XTemplate used to create the internal structure inside this Component's encapsulating\nElement. ...</div><div class='long'><p>An <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">XTemplate</a> used to create the internal structure inside this Component's encapsulating\n<a href=\"#!/api/Ext.AbstractComponent-method-getEl\" rel=\"Ext.AbstractComponent-method-getEl\" class=\"docClass\">Element</a>.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong><code>null</code></strong> which means that they will be initially rendered\nwith no internal structure; they render their <a href=\"#!/api/Ext.AbstractComponent-method-getEl\" rel=\"Ext.AbstractComponent-method-getEl\" class=\"docClass\">Element</a> empty. The more specialized ExtJS and Touch\nclasses which use a more complex DOM structure, provide their own template definitions.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components with customized\ninternal structure.</p>\n\n<p>Upon rendering, any created child elements may be automatically imported into object properties using the\n<a href=\"#!/api/Ext.AbstractComponent-cfg-renderSelectors\" rel=\"Ext.AbstractComponent-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.AbstractComponent-cfg-childEls\" rel=\"Ext.AbstractComponent-cfg-childEls\" class=\"docClass\">childEls</a> options.</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-resizable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-resizable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-cfg-resizable' class='name expandable'>resizable</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>Specify as true to apply a Resizer to this Component after rendering. ...</div><div class='long'><p>Specify as <code>true</code> to apply a <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Resizer</a> to this Component after rendering.</p>\n\n<p>May also be specified as a config object to be passed to the constructor of <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Resizer</a>\nto override any defaults. By default the Component passes its minimum and maximum size, and uses\n<code><a href=\"#!/api/Ext.resizer.Resizer-cfg-dynamic\" rel=\"Ext.resizer.Resizer-cfg-dynamic\" class=\"docClass\">Ext.resizer.Resizer.dynamic</a>: false</code></p>\n</div></div></div><div id='cfg-resizeHandles' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-resizeHandles' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-cfg-resizeHandles' class='name expandable'>resizeHandles</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A valid Ext.resizer.Resizer handles config string. ...</div><div class='long'><p>A valid <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Ext.resizer.Resizer</a> handles config string. Only applies when resizable = true.</p>\n<p>Defaults to: <code>&quot;all&quot;</code></p></div></div></div><div id='cfg-saveDelay' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.state.Stateful' rel='Ext.state.Stateful' class='definedIn docClass'>Ext.state.Stateful</a><br/><a href='source/Stateful.html#Ext-state-Stateful-cfg-saveDelay' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.state.Stateful-cfg-saveDelay' class='name expandable'>saveDelay</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>A buffer to be applied if many state events are fired within a short period. ...</div><div class='long'><p>A buffer to be applied if many state events are fired within a short period.</p>\n<p>Defaults to: <code>100</code></p></div></div></div><div id='cfg-shadow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Floating' rel='Ext.util.Floating' class='definedIn docClass'>Ext.util.Floating</a><br/><a href='source/Floating.html#Ext-util-Floating-cfg-shadow' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Floating-cfg-shadow' class='name expandable'>shadow</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Specifies whether the floating component should be given a shadow. ...</div><div class='long'><p>Specifies whether the floating component should be given a shadow. Set to true to automatically create an <a href=\"#!/api/Ext.Shadow\" rel=\"Ext.Shadow\" class=\"docClass\">Ext.Shadow</a>, or a string indicating the shadow's display <a href=\"#!/api/Ext.Shadow-cfg-mode\" rel=\"Ext.Shadow-cfg-mode\" class=\"docClass\">Ext.Shadow.mode</a>. Set to false to disable the\nshadow.</p>\n<p>Defaults to: <code>&quot;sides&quot;</code></p></div></div></div><div id='cfg-stateEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.state.Stateful' rel='Ext.state.Stateful' class='definedIn docClass'>Ext.state.Stateful</a><br/><a href='source/Stateful.html#Ext-state-Stateful-cfg-stateEvents' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.state.Stateful-cfg-stateEvents' class='name expandable'>stateEvents</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</span></div><div class='description'><div class='short'>An array of events that, when fired, should trigger this object to\nsave its state. ...</div><div class='long'><p>An array of events that, when fired, should trigger this object to\nsave its state. Defaults to none. <code>stateEvents</code> may be any type\nof event supported by this object, including browser or custom events\n(e.g., <tt>['click', 'customerchange']</tt>).</p>\n\n\n<p>See <code><a href=\"#!/api/Ext.state.Stateful-cfg-stateful\" rel=\"Ext.state.Stateful-cfg-stateful\" class=\"docClass\">stateful</a></code> for an explanation of saving and\nrestoring object state.</p>\n\n</div></div></div><div id='cfg-stateId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.state.Stateful' rel='Ext.state.Stateful' class='definedIn docClass'>Ext.state.Stateful</a><br/><a href='source/Stateful.html#Ext-state-Stateful-cfg-stateId' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.state.Stateful-cfg-stateId' class='name expandable'>stateId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The unique id for this object to use for state management purposes. ...</div><div class='long'><p>The unique id for this object to use for state management purposes.</p>\n\n<p>See <a href=\"#!/api/Ext.state.Stateful-cfg-stateful\" rel=\"Ext.state.Stateful-cfg-stateful\" class=\"docClass\">stateful</a> for an explanation of saving and restoring state.</p>\n\n</div></div></div><div id='cfg-stateful' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.state.Stateful' rel='Ext.state.Stateful' class='definedIn docClass'>Ext.state.Stateful</a><br/><a href='source/Stateful.html#Ext-state-Stateful-cfg-stateful' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.state.Stateful-cfg-stateful' class='name expandable'>stateful</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>A flag which causes the object to attempt to restore the state of\ninternal properties from a saved state on startup. ...</div><div class='long'><p>A flag which causes the object to attempt to restore the state of\ninternal properties from a saved state on startup. The object must have\na <code><a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a></code> for state to be managed.\nAuto-generated ids are not guaranteed to be stable across page loads and\ncannot be relied upon to save and restore the same state for a object.<p>\n<p>For state saving to work, the state manager's provider must have been\nset to an implementation of <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> which overrides the\n<a href=\"#!/api/Ext.state.Provider-method-set\" rel=\"Ext.state.Provider-method-set\" class=\"docClass\">set</a> and <a href=\"#!/api/Ext.state.Provider-method-get\" rel=\"Ext.state.Provider-method-get\" class=\"docClass\">get</a>\nmethods to save and recall name/value pairs. A built-in implementation,\n<a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a> is available.</p>\n<p>To set the state provider for the current page:</p>\n<pre><code>Ext.state.Manager.setProvider(new Ext.state.CookieProvider({\n    expires: new Date(new Date().getTime()+(1000*60*60*24*7)), //7 days from now\n}));\n</code></pre>\n<p>A stateful object attempts to save state when one of the events\nlisted in the <code><a href=\"#!/api/Ext.state.Stateful-cfg-stateEvents\" rel=\"Ext.state.Stateful-cfg-stateEvents\" class=\"docClass\">stateEvents</a></code> configuration fires.</p>\n<p>To save state, a stateful object first serializes its state by\ncalling <b><code><a href=\"#!/api/Ext.state.Stateful-method-getState\" rel=\"Ext.state.Stateful-method-getState\" class=\"docClass\">getState</a></code></b>. By default, this function does\nnothing. The developer must provide an implementation which returns an\nobject hash which represents the restorable state of the object.</p>\n<p>The value yielded by getState is passed to <a href=\"#!/api/Ext.state.Manager-method-set\" rel=\"Ext.state.Manager-method-set\" class=\"docClass\">Ext.state.Manager.set</a>\nwhich uses the configured <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> to save the object\nkeyed by the <code><a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a></code>.</p>\n<p>During construction, a stateful object attempts to <i>restore</i>\nits state by calling <a href=\"#!/api/Ext.state.Manager-method-get\" rel=\"Ext.state.Manager-method-get\" class=\"docClass\">Ext.state.Manager.get</a> passing the\n<code><a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a></code></p>\n<p>The resulting object is passed to <b><code><a href=\"#!/api/Ext.state.Stateful-method-applyState\" rel=\"Ext.state.Stateful-method-applyState\" class=\"docClass\">applyState</a></code></b>.\nThe default implementation of <code><a href=\"#!/api/Ext.state.Stateful-method-applyState\" rel=\"Ext.state.Stateful-method-applyState\" class=\"docClass\">applyState</a></code> simply copies\nproperties into the object, but a developer may override this to support\nmore behaviour.</p>\n<p>You can perform extra processing on state save and restore by attaching\nhandlers to the <a href=\"#!/api/Ext.state.Stateful-event-beforestaterestore\" rel=\"Ext.state.Stateful-event-beforestaterestore\" class=\"docClass\">beforestaterestore</a>, <a href=\"#!/api/Ext.state.Stateful-event-staterestore\" rel=\"Ext.state.Stateful-event-staterestore\" class=\"docClass\">staterestore</a>,\n<a href=\"#!/api/Ext.state.Stateful-event-beforestatesave\" rel=\"Ext.state.Stateful-event-beforestatesave\" class=\"docClass\">beforestatesave</a> and <a href=\"#!/api/Ext.state.Stateful-event-statesave\" rel=\"Ext.state.Stateful-event-statesave\" class=\"docClass\">statesave</a> events.</p>\n\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-style' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-style' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-style' class='name expandable'>style</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A custom style specification to be applied to this component's Element. ...</div><div class='long'><p>A custom style specification to be applied to this component's Element. Should be a valid argument to\n<a href=\"#!/api/Ext.Element-method-applyStyles\" rel=\"Ext.Element-method-applyStyles\" class=\"docClass\">Ext.Element.applyStyles</a>.</p>\n\n<pre><code>new Ext.panel.Panel({\n    title: 'Some Title',\n    renderTo: Ext.getBody(),\n    width: 400, height: 300,\n    layout: 'form',\n    items: [{\n        xtype: 'textarea',\n        style: {\n            width: '95%',\n            marginBottom: '10px'\n        }\n    },\n    new Ext.button.Button({\n        text: 'Send',\n        minWidth: '100',\n        style: {\n            marginBottom: '10px'\n        }\n    })\n    ]\n});\n</code></pre>\n</div></div></div><div id='cfg-styleHtmlCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-styleHtmlCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-styleHtmlCls' class='name expandable'>styleHtmlCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The class that is added to the content target when you set styleHtmlContent to true. ...</div><div class='long'><p>The class that is added to the content target when you set styleHtmlContent to true.</p>\n<p>Defaults to: <code>&quot;x-html&quot;</code></p></div></div></div><div id='cfg-styleHtmlContent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-styleHtmlContent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-styleHtmlContent' class='name expandable'>styleHtmlContent</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True to automatically style the html inside the content target of this component (body for panels). ...</div><div class='long'><p>True to automatically style the html inside the content target of this component (body for panels).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-toFrontOnShow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-toFrontOnShow' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-cfg-toFrontOnShow' class='name expandable'>toFrontOnShow</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True to automatically call toFront when the show method is called on an already visible,\nfloating component. ...</div><div class='long'><p>True to automatically call <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">toFront</a> when the <a href=\"#!/api/Ext.Component-event-show\" rel=\"Ext.Component-event-show\" class=\"docClass\">show</a> method is called on an already visible,\nfloating component.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-tpl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-tpl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-tpl' class='name expandable'>tpl</a><span> : <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>/<a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</span></div><div class='description'><div class='short'>An Ext.Template, Ext.XTemplate or an array of strings to form an Ext.XTemplate. ...</div><div class='long'><p>An <a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a>, <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a> or an array of strings to form an <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>. Used in\nconjunction with the <code><a href=\"#!/api/Ext.AbstractComponent-cfg-data\" rel=\"Ext.AbstractComponent-cfg-data\" class=\"docClass\">data</a></code> and <code><a href=\"#!/api/Ext.AbstractComponent-cfg-tplWriteMode\" rel=\"Ext.AbstractComponent-cfg-tplWriteMode\" class=\"docClass\">tplWriteMode</a></code> configurations.</p>\n</div></div></div><div id='cfg-tplWriteMode' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-tplWriteMode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-tplWriteMode' class='name expandable'>tplWriteMode</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The Ext.(X)Template method to use when updating the content area of the Component. ...</div><div class='long'><p>The Ext.(X)Template method to use when updating the content area of the Component.\nSee <code><a href=\"#!/api/Ext.XTemplate-method-overwrite\" rel=\"Ext.XTemplate-method-overwrite\" class=\"docClass\">Ext.XTemplate.overwrite</a></code> for information on default mode.</p>\n<p>Defaults to: <code>&quot;overwrite&quot;</code></p></div></div></div><div id='cfg-ui' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-ui' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-ui' class='name expandable'>ui</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</span></div><div class='description'><div class='short'>A set style for a component. ...</div><div class='long'><p>A set style for a component. Can be a string or an Array of multiple strings (UIs)</p>\n<p>Defaults to: <code>&quot;default&quot;</code></p></div></div></div><div id='cfg-width' class='member  inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-width' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-width' class='name not-expandable'>width</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The width of this component in pixels.</p>\n</div><div class='long'><p>The width of this component in pixels.</p>\n</div></div></div><div id='cfg-xtype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-cfg-xtype' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-cfg-xtype' class='name expandable'>xtype</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The xtype configuration option can be used to optimize Component creation and rendering. ...</div><div class='long'><p>The <code>xtype</code> configuration option can be used to optimize Component creation and rendering. It serves as a\nshortcut to the full componet name. For example, the component <code>Ext.button.Button</code> has an xtype of <code>button</code>.</p>\n\n<p>You can define your own xtype on a custom <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">component</a> by specifying the\n<a href=\"#!/api/Ext.Class-cfg-alias\" rel=\"Ext.Class-cfg-alias\" class=\"docClass\">alias</a> config option with a prefix of <code>widget</code>. For example:</p>\n\n<pre><code>Ext.define('PressMeButton', {\n    extend: 'Ext.button.Button',\n    alias: 'widget.pressmebutton',\n    text: 'Press Me'\n})\n</code></pre>\n\n<p>Any Component can be created implicitly as an object config with an xtype specified, allowing it to be\ndeclared and passed into the rendering pipeline without actually being instantiated as an object. Not only is\nrendering deferred, but the actual creation of the object itself is also deferred, saving memory and resources\nuntil they are actually needed. In complex, nested layouts containing many Components, this can make a\nnoticeable improvement in performance.</p>\n\n<pre><code>// Explicit creation of contained Components:\nvar panel = new Ext.Panel({\n   ...\n   items: [\n      Ext.create('Ext.button.Button', {\n         text: 'OK'\n      })\n   ]\n};\n\n// Implicit creation using xtype:\nvar panel = new Ext.Panel({\n   ...\n   items: [{\n      xtype: 'button',\n      text: 'OK'\n   }]\n};\n</code></pre>\n\n<p>In the first example, the button will always be created immediately during the panel's initialization. With\nmany added Components, this approach could potentially slow the rendering of the page. In the second example,\nthe button will not be created or rendered until the panel is actually displayed in the browser. If the panel\nis never displayed (for example, if it is a tab that remains hidden) then the button will never be created and\nwill never consume any resources whatsoever.</p>\n</div></div></div></div></div><div id='m-property'><div class='definedBy'>Defined By</div><h3 class='members-title'>Properties</h3><div class='subsection'><div id='property-draggable' class='member first-child inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-property-draggable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-property-draggable' class='name not-expandable'>draggable</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>Read-only property indicating whether or not the component can be dragged</p>\n</div><div class='long'><p>Read-only property indicating whether or not the component can be dragged</p>\n</div></div></div><div id='property-floatParent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-floatParent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-property-floatParent' class='name expandable'>floatParent</a><span> : <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.Container</a></span></div><div class='description'><div class='short'>Only present for floating Components which were inserted as descendant items of floating Containers. ...</div><div class='long'><p>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which were inserted as descendant items of floating Containers.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-event-render\" rel=\"Ext.Component-event-render\" class=\"docClass\">rendered</a> will not have a <code>floatParent</code>\nproperty.</p>\n\n<p>For <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which are child items of a Container, the floatParent will be the floating\nancestor Container which is responsible for the base z-index value of all its floating descendants. It provides\na <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> which provides z-indexing services for all its descendant floating\nComponents.</p>\n\n<p>For example, the dropdown <a href=\"#!/api/Ext.view.BoundList\" rel=\"Ext.view.BoundList\" class=\"docClass\">BoundList</a> of a ComboBox which is in a Window will have the\nWindow as its <code>floatParent</code></p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-zIndexManager\" rel=\"Ext.Component-property-zIndexManager\" class=\"docClass\">zIndexManager</a></p>\n</div></div></div><div id='property-frameSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-property-frameSize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-property-frameSize' class='name expandable'>frameSize</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>Read-only property indicating the width of any framing elements which were added within the encapsulating element\nto ...</div><div class='long'><p>Read-only property indicating the width of any framing elements which were added within the encapsulating element\nto provide graphical, rounded borders. See the <a href=\"#!/api/Ext.AbstractComponent-cfg-frame\" rel=\"Ext.AbstractComponent-cfg-frame\" class=\"docClass\">frame</a> config.</p>\n\n<p>This is an object containing the frame width in pixels for all four sides of the Component containing the\nfollowing properties:</p>\n<ul><li><span class='pre'>top</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The width of the top framing element in pixels.</p>\n</div></li><li><span class='pre'>right</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The width of the right framing element in pixels.</p>\n</div></li><li><span class='pre'>bottom</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The width of the bottom framing element in pixels.</p>\n</div></li><li><span class='pre'>left</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The width of the left framing element in pixels.</p>\n</div></li></ul></div></div></div><div id='property-maskOnDisable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-property-maskOnDisable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-property-maskOnDisable' class='name expandable'>maskOnDisable</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>This is an internal flag that you use when creating custom components. ...</div><div class='long'><p>This is an internal flag that you use when creating custom components. By default this is set to true which means\nthat every component gets a mask when its disabled. Components like FieldContainer, FieldSet, Field, Button, Tab\noverride this property to false since they want to implement custom disable logic.</p>\n</div></div></div><div id='property-ownerCt' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-property-ownerCt' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-property-ownerCt' class='name expandable'>ownerCt</a><span> : <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.Container</a></span></div><div class='description'><div class='short'>This Component's owner Container (is set automatically\nwhen this Component is added to a Container). ...</div><div class='long'><p>This Component's owner <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> (is set automatically\nwhen this Component is added to a Container). Read-only.</p>\n\n<p><strong>Note</strong>: to access items within the Container see <a href=\"#!/api/Ext.AbstractComponent-cfg-itemId\" rel=\"Ext.AbstractComponent-cfg-itemId\" class=\"docClass\">itemId</a>.</p>\n</div></div></div><div id='property-rendered' class='member  inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-property-rendered' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-property-rendered' class='name not-expandable'>rendered</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>Read-only property indicating whether or not the component has been rendered.</p>\n</div><div class='long'><p>Read-only property indicating whether or not the component has been rendered.</p>\n</div></div></div><div id='property-self' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-property-self' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-property-self' class='name expandable'>self</a><span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the current class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>\nfor a detailed comparison</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); / dependent on 'this'\n\n        return this;\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n</div></div></div><div id='property-zIndexManager' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-zIndexManager' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-property-zIndexManager' class='name expandable'>zIndexManager</a><span> : <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">Ext.ZIndexManager</a></span></div><div class='description'><div class='short'>Only present for floating Components after they have been rendered. ...</div><div class='long'><p>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components after they have been rendered.</p>\n\n<p>A reference to the ZIndexManager which is managing this Component's z-index.</p>\n\n<p>The <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> maintains a stack of floating Component z-indices, and also provides\na single modal mask which is insert just beneath the topmost visible modal floating Component.</p>\n\n<p>Floating Components may be <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">brought to the front</a> or <a href=\"#!/api/Ext.Component-method-toBack\" rel=\"Ext.Component-method-toBack\" class=\"docClass\">sent to the back</a> of the\nz-index stack.</p>\n\n<p>This defaults to the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a> for floating Components that are\nprogramatically <a href=\"#!/api/Ext.Component-event-render\" rel=\"Ext.Component-event-render\" class=\"docClass\">rendered</a>.</p>\n\n<p>For <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which are added to a Container, the ZIndexManager is acquired from the first\nancestor Container found which is floating, or if not found the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a> is\nused.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-floatParent\" rel=\"Ext.Component-property-floatParent\" class=\"docClass\">floatParent</a></p>\n</div></div></div></div></div><div id='m-method'><h3 class='members-title'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-constructor' target='_blank' class='viewSource'>view source</a></div><strong class='constructor-signature'>new</strong><a href='#!/api/Ext.Component-method-constructor' class='name expandable'>Ext.Component</a>( <span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Creates new Component. ...</div><div class='long'><p>Creates new Component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The configuration options may be specified as either:</p>\n\n<ul>\n<li><strong>an element</strong> : it is set as the internal element and its id used as the component id</li>\n<li><strong>a string</strong> : it is assumed to be the id of an existing element and is used as the component id</li>\n<li><strong>anything else</strong> : it is assumed to be a standard config object and is applied to the component</li>\n</ul>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addChildEls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-addChildEls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-addChildEls' class='name expandable'>addChildEls</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Adds each argument passed to this method to the childEls array. ...</div><div class='long'><p>Adds each argument passed to this method to the <a href=\"#!/api/Ext.AbstractComponent-cfg-childEls\" rel=\"Ext.AbstractComponent-cfg-childEls\" class=\"docClass\">childEls</a> array.</p>\n</div></div></div><div id='method-addClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-addClass' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-addClass' class='name expandable'>addClass</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> cls</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Adds a CSS class to the top level element representing this component. ...</div><div class='long'><p>Adds a CSS class to the top level element representing this component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS class name to add</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>Returns the Component to allow method chaining.</p>\n</div></li></ul></div></div></div><div id='method-addCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-addCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-addCls' class='name expandable'>addCls</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> cls</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Adds a CSS class to the top level element representing this component. ...</div><div class='long'><p>Adds a CSS class to the top level element representing this component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS class name to add</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>Returns the Component to allow method chaining.</p>\n</div></li></ul></div></div></div><div id='method-addClsWithUI' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-addClsWithUI' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-addClsWithUI' class='name expandable'>addClsWithUI</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] cls, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> skip</span> )</div><div class='description'><div class='short'>Adds a cls to the uiCls array, which will also call addUIClsToElement and adds to all elements of this\ncomponent. ...</div><div class='long'><p>Adds a cls to the uiCls array, which will also call <a href=\"#!/api/Ext.AbstractComponent-method-addUIClsToElement\" rel=\"Ext.AbstractComponent-method-addUIClsToElement\" class=\"docClass\">addUIClsToElement</a> and adds to all elements of this\ncomponent.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>A string or an array of strings to add to the uiCls</p>\n</div></li><li><span class='pre'>skip</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>(Boolean) skip True to skip adding it to the class and do it later (via the return)</p>\n</div></li></ul></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> o, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>... more]</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code> or the first\nevent name string if multiple event names are being passed as separate parameters. Usage:</p>\n\n<pre><code>this.addEvents({\n    storeloaded: true,\n    storecleared: true\n});\n</code></pre>\n</div></li><li><span class='pre'>more</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>... (optional)<div class='sub-desc'><p>Additional event names if multiple event names are being passed as separate\nparameters. Usage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for. May also be an object who's property names are\nevent names.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.  Will be called with arguments given to\n<a href=\"#!/api/Ext.util.Observable-method-fireEvent\" rel=\"Ext.util.Observable-method-fireEvent\" class=\"docClass\">fireEvent</a> plus the <code>options</code> parameter described below.</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the handler function is executed. <strong>If\nomitted, defaults to the object which fired the event.</strong></p>\n\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n\n\n\n\n<p><strong>Note:</strong> Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.</p>\n\n\n\n\n<p>This object may contain any of the following properties:</p>\n\n\n\n\n<ul>\n<li><p><strong>scope</strong> : Object</p>\n\n<p>The scope (<code>this</code> reference) in which the handler function is executed. <strong>If omitted, defaults to the object\nwhich fired the event.</strong></p></li>\n<li><p><strong>delay</strong> : Number</p>\n\n<p>The number of milliseconds to delay the invocation of the handler after the event fires.</p></li>\n<li><p><strong>single</strong> : Boolean</p>\n\n<p>True to add a handler to handle just the next firing of the event, and then remove itself.</p></li>\n<li><p><strong>buffer</strong> : Number</p>\n\n<p>Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed by the specified number of\nmilliseconds. If the event fires again within that time, the original handler is <em>not</em> invoked, but the new\nhandler is scheduled in its place.</p></li>\n<li><p><strong>target</strong> : Observable</p>\n\n<p>Only call the handler if the event was fired on the target Observable, <em>not</em> if the event was bubbled up from a\nchild Observable.</p></li>\n<li><p><strong>element</strong> : String</p>\n\n<p><strong>This option is only valid for listeners bound to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a>.</strong> The name of a Component\nproperty which references an element to add a listener to.</p>\n\n<p>This option is useful during Component construction to add DOM event listeners to elements of\n<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a> which will exist only after the Component is rendered.\nFor example, to add a click listener to a Panel's body:</p>\n\n<pre><code>new Ext.panel.Panel({\n    title: 'The title',\n    listeners: {\n        click: this.handlePanelClick,\n        element: 'body'\n    }\n});\n</code></pre></li>\n</ul>\n\n\n\n\n<p><strong>Combining Options</strong></p>\n\n\n\n\n<p>Using the options argument, it is possible to combine different types of listeners:</p>\n\n\n\n\n<p>A delayed, one-time listener.</p>\n\n\n\n\n<pre><code>myPanel.on('hide', this.handleClick, this, {\n    single: true,\n    delay: 100\n});\n</code></pre>\n\n\n\n\n<p><strong>Attaching multiple handlers in 1 call</strong></p>\n\n\n\n\n<p>The method also allows for a single argument to be passed which is a config object containing properties which\nspecify multiple events. For example:</p>\n\n\n\n\n<pre><code>myGridPanel.on({\n    cellClick: this.onCellClick,\n    mouseover: this.onMouseOver,\n    mouseout: this.onMouseOut,\n    scope: this // Important. Ensure \"this\" is correct during handler execution\n});\n</code></pre>\n\n\n\n\n<p>One can also specify options for each event handler separately:</p>\n\n\n\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: this.onCellClick, scope: this, single: true},\n    mouseover: {fn: panel.onMouseOver, scope: panel}\n});\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addManagedListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addManagedListener' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addManagedListener' class='name expandable'>addManagedListener</a>( <span class='pre'><a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> item, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> ename, [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> opt]</span> )</div><div class='description'><div class='short'>Adds listeners to any Observable object (or Ext.Element) which are automatically removed when this Component is\ndestr...</div><div class='long'><p>Adds listeners to any Observable object (or Ext.Element) which are automatically removed when this Component is\ndestroyed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The item to which to add a listener/listeners.</p>\n\n</div></li><li><span class='pre'>ename</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the handler function.</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the scope (<code>this</code> reference)\nin which the handler function is executed.</p>\n\n</div></li><li><span class='pre'>opt</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> options.</p>\n\n</div></li></ul></div></div></div><div id='method-addStateEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.state.Stateful' rel='Ext.state.Stateful' class='definedIn docClass'>Ext.state.Stateful</a><br/><a href='source/Stateful.html#Ext-state-Stateful-method-addStateEvents' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.state.Stateful-method-addStateEvents' class='name expandable'>addStateEvents</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] events</span> )</div><div class='description'><div class='short'>Add events that will trigger the state to be saved. ...</div><div class='long'><p>Add events that will trigger the state to be saved.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The event name or an array of event names.</p>\n</div></li></ul></div></div></div><div id='method-addUIClsToElement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-addUIClsToElement' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-addUIClsToElement' class='name expandable'>addUIClsToElement</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> ui</span> )</div><div class='description'><div class='short'>Method which adds a specified UI + uiCls to the components element. ...</div><div class='long'><p>Method which adds a specified UI + uiCls to the components element. Can be overridden to remove the UI from more\nthan just the components element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ui</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The UI to remove from the element</p>\n</div></li></ul></div></div></div><div id='method-afterComponentLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-afterComponentLayout' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-afterComponentLayout' class='name expandable'>afterComponentLayout</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> adjWidth, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> adjHeight, <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> isSetSize, <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> callingContainer</span> )</div><div class='description'><div class='short'>Occurs after componentLayout is run. ...</div><div class='long'><p>Occurs after componentLayout is run.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>adjWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted width that was set</p>\n</div></li><li><span class='pre'>adjHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted height that was set</p>\n</div></li><li><span class='pre'>isSetSize</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>Whether or not the height/width are stored on the component permanently</p>\n</div></li><li><span class='pre'>callingContainer</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>Container requesting the layout. Only used when isSetSize is false.</p>\n</div></li></ul></div></div></div><div id='method-alignTo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Floating' rel='Ext.util.Floating' class='definedIn docClass'>Ext.util.Floating</a><br/><a href='source/Floating.html#Ext-util-Floating-method-alignTo' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Floating-method-alignTo' class='name expandable'>alignTo</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> element, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> position], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[] offsets]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Aligns this floating Component to the specified element ...</div><div class='long'><p>Aligns this floating Component to the specified element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The element or <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> to align to. If passing a component, it must be a\nomponent instance. If a string id is passed, it will be used as an element id.</p>\n</div></li><li><span class='pre'>position</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The position to align to (see <a href=\"#!/api/Ext.Element-method-alignTo\" rel=\"Ext.Element-method-alignTo\" class=\"docClass\">Ext.Element.alignTo</a> for more details).</p>\n<p>Defaults to: <code>&quot;tl-bl?&quot;</code></p></div></li><li><span class='pre'>offsets</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[] (optional)<div class='sub-desc'><p>Offset the positioning by [x, y]</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-animate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Animate' rel='Ext.util.Animate' class='definedIn docClass'>Ext.util.Animate</a><br/><a href='source/Animate.html#Ext-util-Animate-method-animate' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Animate-method-animate' class='name expandable'>animate</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Perform custom animation on this object. ...</div><div class='long'><p>Perform custom animation on this object.<p>\n<p>This method is applicable to both the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> class and the <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Element</a> class.\nIt performs animated transitions of certain properties of this object over a specified timeline.</p>\n<p>The sole parameter is an object which specifies start property values, end property values, and properties which\ndescribe the timeline. Of the properties listed below, only <b><code>to</code></b> is mandatory.</p>\n<p>Properties include<ul>\n<li><code>from</code> <div class=\"sub-desc\">An object which specifies start values for the properties being animated.\nIf not supplied, properties are animated from current settings. The actual properties which may be animated depend upon\nths object being animated. See the sections below on Element and Component animation.<div></li>\n<li><code>to</code> <div class=\"sub-desc\">An object which specifies end values for the properties being animated.</div></li>\n<li><code>duration</code><div class=\"sub-desc\">The duration <b>in milliseconds</b> for which the animation will run.</div></li>\n<li><code>easing</code> <div class=\"sub-desc\">A string value describing an easing type to modify the rate of change from the default linear to non-linear. Values may be one of:<code><ul>\n<li>ease</li>\n<li>easeIn</li>\n<li>easeOut</li>\n<li>easeInOut</li>\n<li>backIn</li>\n<li>backOut</li>\n<li>elasticIn</li>\n<li>elasticOut</li>\n<li>bounceIn</li>\n<li>bounceOut</li>\n</ul></code></div></li>\n<li><code>keyframes</code> <div class=\"sub-desc\">This is an object which describes the state of animated properties at certain points along the timeline.\nit is an object containing properties who's names are the percentage along the timeline being described and who's values specify the animation state at that point.</div></li>\n<li><code>listeners</code> <div class=\"sub-desc\">This is a standard <a href=\"#!/api/Ext.util.Observable-cfg-listeners\" rel=\"Ext.util.Observable-cfg-listeners\" class=\"docClass\">listeners</a> configuration object which may be used\nto inject behaviour at either the <code>beforeanimate</code> event or the <code>afteranimate</code> event.</div></li>\n</ul></p>\n<h3>Animating an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Element</a></h3>\nWhen animating an Element, the following properties may be specified in <code>from</code>, <code>to</code>, and <code>keyframe</code> objects:<ul>\n<li><code>x</code> <div class=\"sub-desc\">The page X position in pixels.</div></li>\n<li><code>y</code> <div class=\"sub-desc\">The page Y position in pixels</div></li>\n<li><code>left</code> <div class=\"sub-desc\">The element's CSS <code>left</code> value. Units must be supplied.</div></li>\n<li><code>top</code> <div class=\"sub-desc\">The element's CSS <code>top</code> value. Units must be supplied.</div></li>\n<li><code>width</code> <div class=\"sub-desc\">The element's CSS <code>width</code> value. Units must be supplied.</div></li>\n<li><code>height</code> <div class=\"sub-desc\">The element's CSS <code>height</code> value. Units must be supplied.</div></li>\n<li><code>scrollLeft</code> <div class=\"sub-desc\">The element's <code>scrollLeft</code> value.</div></li>\n<li><code>scrollTop</code> <div class=\"sub-desc\">The element's <code>scrollLeft</code> value.</div></li>\n<li><code>opacity</code> <div class=\"sub-desc\">The element's <code>opacity</code> value. This must be a value between <code>0</code> and <code>1</code>.</div></li>\n</ul>\n<p><b>Be aware than animating an Element which is being used by an Ext Component without in some way informing the Component about the changed element state\nwill result in incorrect Component behaviour. This is because the Component will be using the old state of the element. To avoid this problem, it is now possible to\ndirectly animate certain properties of Components.</b></p>\n<h3>Animating a <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a></h3>\nWhen animating an Element, the following properties may be specified in <code>from</code>, <code>to</code>, and <code>keyframe</code> objects:<ul>\n<li><code>x</code> <div class=\"sub-desc\">The Component's page X position in pixels.</div></li>\n<li><code>y</code> <div class=\"sub-desc\">The Component's page Y position in pixels</div></li>\n<li><code>left</code> <div class=\"sub-desc\">The Component's <code>left</code> value in pixels.</div></li>\n<li><code>top</code> <div class=\"sub-desc\">The Component's <code>top</code> value in pixels.</div></li>\n<li><code>width</code> <div class=\"sub-desc\">The Component's <code>width</code> value in pixels.</div></li>\n<li><code>width</code> <div class=\"sub-desc\">The Component's <code>width</code> value in pixels.</div></li>\n<li><code>dynamic</code> <div class=\"sub-desc\">Specify as true to update the Component's layout (if it is a Container) at every frame\nof the animation. <i>Use sparingly as laying out on every intermediate size change is an expensive operation</i>.</div></li>\n</ul>\n<p>For example, to animate a Window to a new size, ensuring that its internal layout, and any shadow is correct:</p>\n<pre><code>myWindow = Ext.create('Ext.window.Window', {\n    title: 'Test Component animation',\n    width: 500,\n    height: 300,\n    layout: {\n        type: 'hbox',\n        align: 'stretch'\n    },\n    items: [{\n        title: 'Left: 33%',\n        margins: '5 0 5 5',\n        flex: 1\n    }, {\n        title: 'Left: 66%',\n        margins: '5 5 5 5',\n        flex: 2\n    }]\n});\nmyWindow.show();\nmyWindow.header.el.on('click', function() {\n    myWindow.animate({\n        to: {\n            width: (myWindow.getWidth() == 500) ? 700 : 500,\n            height: (myWindow.getHeight() == 300) ? 400 : 300,\n        }\n    });\n});\n</code></pre>\n<p>For performance reasons, by default, the internal layout is only updated when the Window reaches its final <code>\"to\"</code> size. If dynamic updating of the Window's child\nComponents is required, then configure the animation with <code>dynamic: true</code> and the two child items will maintain their proportions during the animation.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>An object containing properties which describe the animation's start and end states, and the timeline of the animation.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-applyState' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.state.Stateful' rel='Ext.state.Stateful' class='definedIn docClass'>Ext.state.Stateful</a><br/><a href='source/Stateful.html#Ext-state-Stateful-method-applyState' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.state.Stateful-method-applyState' class='name expandable'>applyState</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> state</span> )</div><div class='description'><div class='short'>Applies the state to the object. ...</div><div class='long'><p>Applies the state to the object. This should be overridden in subclasses to do\nmore complex state operations. By default it applies the state properties onto\nthe current object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>state</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The state</p>\n</div></li></ul></div></div></div><div id='method-beforeComponentLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-beforeComponentLayout' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-beforeComponentLayout' class='name expandable'>beforeComponentLayout</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> adjWidth, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> adjHeight, <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> isSetSize, <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> callingContainer</span> )</div><div class='description'><div class='short'>Occurs before componentLayout is run. ...</div><div class='long'><p>Occurs before componentLayout is run. Returning false from this method will prevent the componentLayout from\nbeing executed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>adjWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted width that was set</p>\n</div></li><li><span class='pre'>adjHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted height that was set</p>\n</div></li><li><span class='pre'>isSetSize</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>Whether or not the height/width are stored on the component permanently</p>\n</div></li><li><span class='pre'>callingContainer</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>Container requesting sent the layout. Only used when isSetSize is false.</p>\n</div></li></ul></div></div></div><div id='method-bubble' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-bubble' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-bubble' class='name expandable'>bubble</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> args]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Bubbles up the component/container heirarchy, calling the specified function with each component. ...</div><div class='long'><p>Bubbles up the component/container heirarchy, calling the specified function with each component. The scope\n(<em>this</em>) of function call will be the scope provided or the current component. The arguments to the function will\nbe the args provided or the current component. If the function returns false at any point, the bubble is stopped.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope of the function. Defaults to current node.</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>The args to call the function with. Defaults to passing the current component.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-callOverridden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callOverridden' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callOverridden' class='name expandable'>callOverridden</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the original method that was previously overridden with override\n\nExt.define('My.Cat', {\n    constructor: functi...</div><div class='long'><p>Call the original method that was previously overridden with <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">override</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result after calling the overridden method</p>\n</div></li></ul></div></div></div><div id='method-callParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callParent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callParent' class='name expandable'>callParent</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the parent's overridden method. ...</div><div class='long'><p>Call the parent's overridden method. For example:</p>\n\n<pre><code>Ext.define('My.own.A', {\n    constructor: function(test) {\n        alert(test);\n    }\n});\n\nExt.define('My.own.B', {\n    extend: 'My.own.A',\n\n    constructor: function(test) {\n        alert(test);\n\n        this.callParent([test + 1]);\n    }\n});\n\nExt.define('My.own.C', {\n    extend: 'My.own.B',\n\n    constructor: function() {\n        alert(\"Going to call parent's overriden constructor...\");\n\n        this.callParent(arguments);\n    }\n});\n\nvar a = new My.own.A(1); // alerts '1'\nvar b = new My.own.B(1); // alerts '1', then alerts '2'\nvar c = new My.own.C(2); // alerts \"Going to call parent's overriden constructor...\"\n                         // alerts '2', then alerts '3'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callParent(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result from the superclass' method</p>\n</div></li></ul></div></div></div><div id='method-center' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Floating' rel='Ext.util.Floating' class='definedIn docClass'>Ext.util.Floating</a><br/><a href='source/Floating.html#Ext-util-Floating-method-center' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Floating-method-center' class='name expandable'>center</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Center this Component in its container. ...</div><div class='long'><p>Center this Component in its container.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-clearListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-clearListeners' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-clearListeners' class='name expandable'>clearListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object including the managed listeners ...</div><div class='long'><p>Removes all listeners for this object including the managed listeners</p>\n</div></div></div><div id='method-clearManagedListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-clearManagedListeners' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-clearManagedListeners' class='name expandable'>clearManagedListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all managed listeners for this object. ...</div><div class='long'><p>Removes all managed listeners for this object.</p>\n</div></div></div><div id='method-cloneConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-cloneConfig' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-cloneConfig' class='name expandable'>cloneConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> overrides</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Clone the current component using the original config values passed into this instance by default. ...</div><div class='long'><p>Clone the current component using the original config values passed into this instance by default.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>overrides</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>A new config containing any properties to override in the cloned version.\nAn id property can be passed on this object, otherwise one will be generated to avoid duplicates.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>clone The cloned copy of this component</p>\n</div></li></ul></div></div></div><div id='method-constructPlugins' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-constructPlugins' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-constructPlugins' class='name expandable'>constructPlugins</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Ensures that the plugins array contains fully constructed plugin instances. ...</div><div class='long'><p>Ensures that the plugins array contains fully constructed plugin instances. This converts any configs into their\nappropriate instances.</p>\n</div></div></div><div id='method-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-destroy' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Destroys the Component. ...</div><div class='long'><p>Destroys the Component.</p>\n</div></div></div><div id='method-disable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-disable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-disable' class='name expandable'>disable</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> silent]</span> )</div><div class='description'><div class='short'>Disable the component. ...</div><div class='long'><p>Disable the component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>silent</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>Passing true will supress the 'disable' event from being fired.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></div></div><div id='method-doAutoRender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-doAutoRender' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-doAutoRender' class='name expandable'>doAutoRender</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Handles autoRender. ...</div><div class='long'><p>Handles autoRender. Floating Components may have an ownerCt. If they are asking to be constrained, constrain them\nwithin that ownerCt, and have their z-index managed locally. Floating Components are always rendered to\ndocument.body</p>\n</div></div></div><div id='method-doComponentLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-doComponentLayout' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-doComponentLayout' class='name expandable'>doComponentLayout</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> width, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> height, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> isSetSize, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> callingContainer</span> ) : <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></div><div class='description'><div class='short'>This method needs to be called whenever you change something on this component that requires the Component's\nlayout t...</div><div class='long'><p>This method needs to be called whenever you change something on this component that requires the Component's\nlayout to be recalculated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>height</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>isSetSize</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>callingContainer</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-doConstrain' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Floating' rel='Ext.util.Floating' class='definedIn docClass'>Ext.util.Floating</a><br/><a href='source/Floating.html#Ext-util-Floating-method-doConstrain' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Floating-method-doConstrain' class='name expandable'>doConstrain</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Ext.util.Region</a> constrainTo]</span> )</div><div class='description'><div class='short'>Moves this floating Component into a constrain region. ...</div><div class='long'><p>Moves this floating Component into a constrain region.</p>\n\n<p>By default, this Component is constrained to be within the container it was added to, or the element it was\nrendered to.</p>\n\n<p>An alternative constraint may be passed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>constrainTo</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Ext.util.Region</a> (optional)<div class='sub-desc'><p>The Element or <a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Region</a> into which this Component is\nto be constrained. Defaults to the element into which this floating Component was rendered.</p>\n</div></li></ul></div></div></div><div id='method-enable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-enable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-enable' class='name expandable'>enable</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> silent]</span> )</div><div class='description'><div class='short'>Enable the component ...</div><div class='long'><p>Enable the component</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>silent</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>Passing true will supress the 'enable' event from being fired.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-enableBubble' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling this.getBubbleTarget() if\npresent. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling <code>this.getBubbleTarget()</code> if\npresent. There is no implementation in the Observable base class.</p>\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers.\nSee <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>. The default implementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the\nComponent's immediate owner. But if a known target is required, this can be overridden to access the\nrequired target more quickly.</p>\n\n<p>Example:</p>\n\n<pre><code>Ext.override(Ext.form.field.Base, {\n    //  Add functionality to Field's initComponent to enable the change event to bubble\n    initComponent : Ext.Function.createSequence(Ext.form.field.Base.prototype.initComponent, function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field's events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-findLayoutController' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-findLayoutController' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-findLayoutController' class='name expandable'>findLayoutController</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>This method finds the topmost active layout who's processing will eventually determine the size and position of\nthis ...</div><div class='long'><p>This method finds the topmost active layout who's processing will eventually determine the size and position of\nthis Component.</p>\n\n<p>This method is useful when dynamically adding Components into Containers, and some processing must take place\nafter the final sizing and positioning of the Component has been performed.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-findParentBy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-findParentBy' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-findParentBy' class='name expandable'>findParentBy</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn</span> ) : <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></div><div class='description'><div class='short'>Find a container above this component at any level by a custom function. ...</div><div class='long'><p>Find a container above this component at any level by a custom function. If the passed function returns true, the\ncontainer will be returned.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The custom function to call with the arguments (container, this component).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></span><div class='sub-desc'><p>The first Container for which the custom function returns true</p>\n</div></li></ul></div></div></div><div id='method-findParentByType' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-findParentByType' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-findParentByType' class='name expandable'>findParentByType</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a> xtype</span> ) : <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></div><div class='description'><div class='short'>Find a container above this component at any level by xtype or class\n\nSee also the up method. ...</div><div class='long'><p>Find a container above this component at any level by xtype or class</p>\n\n<p>See also the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a><div class='sub-desc'><p>The xtype string for a component, or the class of the component directly</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></span><div class='sub-desc'><p>The first Container which matches the given xtype or class</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>... args</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name, plus the options object passed\nto addList...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name, plus the <code>options</code> object passed\nto <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>).</p>\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>) by\ncalling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-focus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-focus' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-focus' class='name expandable'>focus</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> selectText], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> delay]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Try to focus this component. ...</div><div class='long'><p>Try to focus this component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selectText</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>If applicable, true to also select the text in this component</p>\n</div></li><li><span class='pre'>delay</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Delay the focus this number of milliseconds (true for 10 milliseconds).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-forceComponentLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-forceComponentLayout' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-forceComponentLayout' class='name expandable'>forceComponentLayout</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Forces this component to redo its componentLayout. ...</div><div class='long'><p>Forces this component to redo its componentLayout.</p>\n</div></div></div><div id='method-getActiveAnimation' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Animate' rel='Ext.util.Animate' class='definedIn docClass'>Ext.util.Animate</a><br/><a href='source/Animate.html#Ext-util-Animate-method-getActiveAnimation' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Animate-method-getActiveAnimation' class='name expandable'>getActiveAnimation</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a>/<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns the current animation if this object has any effects actively running or queued, else returns false. ...</div><div class='long'><p>Returns the current animation if this object has any effects actively running or queued, else returns false.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a>/<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>Anim if element has active effects, else false</p>\n\n</div></li></ul></div></div></div><div id='method-getBox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getBox' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-getBox' class='name expandable'>getBox</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> local]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Gets the current box measurements of the component's underlying element. ...</div><div class='long'><p>Gets the current box measurements of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>If true the element's left and top are returned instead of page XY.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>box An object in the format {x, y, width, height}</p>\n</div></li></ul></div></div></div><div id='method-getBubbleTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-getBubbleTarget' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-getBubbleTarget' class='name expandable'>getBubbleTarget</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></div><div class='description'><div class='short'>Provides the link for Observable's fireEvent method to bubble up the ownership hierarchy. ...</div><div class='long'><p>Provides the link for Observable's fireEvent method to bubble up the ownership hierarchy.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></span><div class='sub-desc'><p>the Container which owns this Component.</p>\n</div></li></ul></div></div></div><div id='method-getEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-getEl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-getEl' class='name expandable'>getEl</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.core.Element</a></div><div class='description'><div class='short'>Retrieves the top level element representing this component. ...</div><div class='long'><p>Retrieves the top level element representing this component.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.core.Element</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-getHeight' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-getHeight' class='name expandable'>getHeight</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current height of the component's underlying element. ...</div><div class='long'><p>Gets the current height of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-getId' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-getId' class='name expandable'>getId</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Retrieves the id of this component. ...</div><div class='long'><p>Retrieves the id of this component. Will autogenerate an id if one has not already been set.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getInsertPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-getInsertPosition' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-getInsertPosition' class='name expandable'>getInsertPosition</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement position</span> ) : HTMLElement</div><div class='description'><div class='short'>This function takes the position argument passed to onRender and returns a DOM element that you can use in the\ninsert...</div><div class='long'><p>This function takes the position argument passed to onRender and returns a DOM element that you can use in the\ninsertBefore.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>position</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement<div class='sub-desc'><p>Index, element id or element you want to put this\ncomponent before.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>DOM element that you can use in the insertBefore</p>\n</div></li></ul></div></div></div><div id='method-getLoader' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-getLoader' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-getLoader' class='name expandable'>getLoader</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a></div><div class='description'><div class='short'>Gets the Ext.ComponentLoader for this Component. ...</div><div class='long'><p>Gets the <a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a> for this Component.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a></span><div class='sub-desc'><p>The loader instance, null if it doesn't exist.</p>\n</div></li></ul></div></div></div><div id='method-getPlugin' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-getPlugin' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-getPlugin' class='name expandable'>getPlugin</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> pluginId</span> ) : <a href=\"#!/api/Ext.AbstractPlugin\" rel=\"Ext.AbstractPlugin\" class=\"docClass\">Ext.AbstractPlugin</a></div><div class='description'><div class='short'>Retrieves a plugin by its pluginId which has been bound to this component. ...</div><div class='long'><p>Retrieves a plugin by its pluginId which has been bound to this component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>pluginId</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.AbstractPlugin\" rel=\"Ext.AbstractPlugin\" class=\"docClass\">Ext.AbstractPlugin</a></span><div class='sub-desc'><p>plugin instance.</p>\n</div></li></ul></div></div></div><div id='method-getPosition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getPosition' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-getPosition' class='name expandable'>getPosition</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> local]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</div><div class='description'><div class='short'>Gets the current XY position of the component's underlying element. ...</div><div class='long'><p>Gets the current XY position of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>If true the element's left and top are returned instead of page XY.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</span><div class='sub-desc'><p>The XY position of the element (e.g., [100, 200])</p>\n</div></li></ul></div></div></div><div id='method-getSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-getSize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-getSize' class='name expandable'>getSize</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Gets the current size of the component's underlying element. ...</div><div class='long'><p>Gets the current size of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>An object containing the element's size {width: (element width), height: (element height)}</p>\n</div></li></ul></div></div></div><div id='method-getState' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-getState' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-getState' class='name expandable'>getState</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>The supplied default state gathering method for the AbstractComponent class. ...</div><div class='long'><p>The supplied default state gathering method for the AbstractComponent class.</p>\n\n<p>This method returns dimension settings such as <code>flex</code>, <code>anchor</code>, <code>width</code> and <code>height</code> along with <code>collapsed</code>\nstate.</p>\n\n<p>Subclasses which implement more complex state should call the superclass's implementation, and apply their state\nto the result if this basic state is to be saved.</p>\n\n<p>Note that Component state will only be saved if the Component has a <a href=\"#!/api/Ext.AbstractComponent-cfg-stateId\" rel=\"Ext.AbstractComponent-cfg-stateId\" class=\"docClass\">stateId</a> and there as a StateProvider\nconfigured for the document.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getStateId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.state.Stateful' rel='Ext.state.Stateful' class='definedIn docClass'>Ext.state.Stateful</a><br/><a href='source/Stateful.html#Ext-state-Stateful-method-getStateId' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.state.Stateful-method-getStateId' class='name expandable'>getStateId</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Gets the state id for this object. ...</div><div class='long'><p>Gets the state id for this object.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The state id, null if not found.</p>\n</div></li></ul></div></div></div><div id='method-getWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-getWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-getWidth' class='name expandable'>getWidth</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current width of the component's underlying element. ...</div><div class='long'><p>Gets the current width of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getXType' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getXType' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-getXType' class='name expandable'>getXType</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Gets the xtype for this component as registered with Ext.ComponentManager. ...</div><div class='long'><p>Gets the xtype for this component as registered with <a href=\"#!/api/Ext.ComponentManager\" rel=\"Ext.ComponentManager\" class=\"docClass\">Ext.ComponentManager</a>. For a list of all available\nxtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header. Example usage:</p>\n\n<pre><code>var t = new Ext.form.field.Text();\nalert(t.getXType());  // alerts 'textfield'\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The xtype</p>\n</div></li></ul></div></div></div><div id='method-getXTypes' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-getXTypes' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-getXTypes' class='name expandable'>getXTypes</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns this Component's xtype hierarchy as a slash-delimited string. ...</div><div class='long'><p>Returns this Component's xtype hierarchy as a slash-delimited string. For a list of all available xtypes, see the\n<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n<p><strong>If using your own subclasses, be aware that a Component must register its own xtype to participate in\ndetermination of inherited xtypes.</strong></p>\n\n<p>Example usage:</p>\n\n<pre><code>var t = new Ext.form.field.Text();\nalert(t.getXTypes());  // alerts 'component/field/textfield'\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The xtype hierarchy string</p>\n</div></li></ul></div></div></div><div id='method-hasActiveFx' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Animate' rel='Ext.util.Animate' class='definedIn docClass'>Ext.util.Animate</a><br/><a href='source/Animate.html#Ext-util-Animate-method-hasActiveFx' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Animate-method-hasActiveFx' class='name expandable'>hasActiveFx</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a>/<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Returns the current animation if this object has any effects actively running or queued, else returns false. ...</div><div class='long'><p>Returns the current animation if this object has any effects actively running or queued, else returns false.</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0</p><p>Replaced by <a href=\"#!/api/Ext.util.Animate-method-getActiveAnimation\" rel=\"Ext.util.Animate-method-getActiveAnimation\" class=\"docClass\">getActiveAnimation</a></p>\n</div><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a>/<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>Anim if element has active effects, else false</p>\n\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-hasUICls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-hasUICls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-hasUICls' class='name expandable'>hasUICls</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> cls</span> )</div><div class='description'><div class='short'>Checks if there is currently a specified uiCls ...</div><div class='long'><p>Checks if there is currently a specified uiCls</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The cls to check</p>\n</div></li></ul></div></div></div><div id='method-hide' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-hide' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-hide' class='name expandable'>hide</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> animateTarget], [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> callback], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Hides this Component, setting it to invisible using the configured hideMode. ...</div><div class='long'><p>Hides this Component, setting it to invisible using the configured <a href=\"#!/api/Ext.Component-cfg-hideMode\" rel=\"Ext.Component-cfg-hideMode\" class=\"docClass\">hideMode</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>animateTarget</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> (optional)<div class='sub-desc'><p><strong>only valid for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components\nsuch as <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Window</a>s or <a href=\"#!/api/Ext.tip.ToolTip\" rel=\"Ext.tip.ToolTip\" class=\"docClass\">ToolTip</a>s, or regular Components which have\nbeen configured with <code>floating: true</code>.</strong>. The target to which the Component should animate while hiding.</p>\n<p>Defaults to: <code>null</code></p></div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>A callback function to call after the Component is hidden.</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the callback is executed.\nDefaults to this Component.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-initComponent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-initComponent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-initComponent' class='name expandable'>initComponent</a>( <span class='pre'></span> )<strong class='template-signature'>template</strong></div><div class='description'><div class='short'>The initComponent template method is an important initialization step for a Component. ...</div><div class='long'><p>The initComponent template method is an important initialization step for a Component. It is intended to be\nimplemented by each subclass of <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> to provide any needed constructor logic. The\ninitComponent method of the class being created is called first, with each initComponent method\nup the hierarchy to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> being called thereafter. This makes it easy to implement and,\nif needed, override the constructor logic of the Component at any step in the hierarchy.</p>\n\n<p>The initComponent method <strong>must</strong> contain a call to <a href=\"#!/api/Ext.Base-method-callParent\" rel=\"Ext.Base-method-callParent\" class=\"docClass\">callParent</a> in order\nto ensure that the parent class' initComponent method is also called.</p>\n\n<p>The following example demonstrates using a dynamic string for the text of a button at the time of\ninstantiation of the class.</p>\n\n<pre><code>Ext.define('DynamicButtonText', {\n    extend: 'Ext.button.Button',\n\n    initComponent: function() {\n        this.text = new Date();\n        this.renderTo = Ext.getBody();\n        this.callParent();\n    }\n});\n\nExt.onReady(function() {\n    Ext.create('DynamicButtonText');\n});\n</code></pre>\n<div class='template'><p>This is a template method. A hook into the functionality of this class.Feel free to override it in child classes.</p></div></div></div></div><div id='method-initConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-initConfig' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-initConfig' class='name expandable'>initConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Initialize configuration for this class. ...</div><div class='long'><p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code>Ext.define('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n\n        return this;\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>mixins The mixin prototypes as key - value pairs</p>\n</div></li></ul></div></div></div><div id='method-is' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-is' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-is' class='name expandable'>is</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Tests whether this Component matches the selector string. ...</div><div class='long'><p>Tests whether this Component matches the selector string.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The selector string to test against.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if this Component matches the selector.</p>\n</div></li></ul></div></div></div><div id='method-isDescendantOf' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-isDescendantOf' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-isDescendantOf' class='name expandable'>isDescendantOf</a>( <span class='pre'><a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.Container</a> container</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Determines whether this component is the descendant of a particular container. ...</div><div class='long'><p>Determines whether this component is the descendant of a particular container.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>container</span> : <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if it is.</p>\n</div></li></ul></div></div></div><div id='method-isDisabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-isDisabled' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-isDisabled' class='name expandable'>isDisabled</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Method to determine whether this Component is currently disabled. ...</div><div class='long'><p>Method to determine whether this Component is currently disabled.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>the disabled state of this Component.</p>\n</div></li></ul></div></div></div><div id='method-isDraggable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-isDraggable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-isDraggable' class='name expandable'>isDraggable</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Method to determine whether this Component is draggable. ...</div><div class='long'><p>Method to determine whether this Component is draggable.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>the draggable state of this component.</p>\n</div></li></ul></div></div></div><div id='method-isDroppable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-isDroppable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-isDroppable' class='name expandable'>isDroppable</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Method to determine whether this Component is droppable. ...</div><div class='long'><p>Method to determine whether this Component is droppable.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>the droppable state of this component.</p>\n</div></li></ul></div></div></div><div id='method-isFloating' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-isFloating' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-isFloating' class='name expandable'>isFloating</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Method to determine whether this Component is floating. ...</div><div class='long'><p>Method to determine whether this Component is floating.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>the floating state of this component.</p>\n</div></li></ul></div></div></div><div id='method-isHidden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-isHidden' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-isHidden' class='name expandable'>isHidden</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Method to determine whether this Component is currently set to hidden. ...</div><div class='long'><p>Method to determine whether this Component is currently set to hidden.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>the hidden state of this Component.</p>\n</div></li></ul></div></div></div><div id='method-isVisible' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-isVisible' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-isVisible' class='name expandable'>isVisible</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> deep]</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if this component is visible. ...</div><div class='long'><p>Returns true if this component is visible.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>deep</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>Pass <code>true</code> to interrogate the visibility status of all parent Containers to\ndetermine whether this Component is truly visible to the user.</p>\n\n<p>Generally, to determine whether a Component is hidden, the no argument form is needed. For example when creating\ndynamically laid out UIs in a hidden Container before showing them.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if this component is visible, false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-isXType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-isXType' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-isXType' class='name expandable'>isXType</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> xtype, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> shallow]</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Tests whether or not this Component is of a specific xtype. ...</div><div class='long'><p>Tests whether or not this Component is of a specific xtype. This can test whether this Component is descended\nfrom the xtype (default) or whether it is directly of the xtype specified (shallow = true).</p>\n\n<p><strong>If using your own subclasses, be aware that a Component must register its own xtype to participate in\ndetermination of inherited xtypes.</strong></p>\n\n<p>For a list of all available xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n<p>Example usage:</p>\n\n<pre><code>var t = new Ext.form.field.Text();\nvar isText = t.isXType('textfield');        // true\nvar isBoxSubclass = t.isXType('field');       // true, descended from <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a>\nvar isBoxInstance = t.isXType('field', true); // false, not a direct <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a> instance\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The xtype to check for this Component</p>\n</div></li><li><span class='pre'>shallow</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to check whether this Component is directly of the specified xtype, false to\ncheck whether this Component is descended from the xtype.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if this component descends from the specified xtype, false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-mon' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-mon' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-mon' class='name expandable'>mon</a>( <span class='pre'><a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> item, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> ename, [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> opt]</span> )</div><div class='description'><div class='short'>Shorthand for addManagedListener. ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-addManagedListener\" rel=\"Ext.util.Observable-method-addManagedListener\" class=\"docClass\">addManagedListener</a>.</p>\n\n<p>Adds listeners to any Observable object (or Ext.Element) which are automatically removed when this Component is\ndestroyed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The item to which to add a listener/listeners.</p>\n\n</div></li><li><span class='pre'>ename</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the handler function.</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the scope (<code>this</code> reference)\nin which the handler function is executed.</p>\n\n</div></li><li><span class='pre'>opt</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> options.</p>\n\n</div></li></ul></div></div></div><div id='method-mun' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-mun' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-mun' class='name expandable'>mun</a>( <span class='pre'><a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> item, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> ename, [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope]</span> )</div><div class='description'><div class='short'>Shorthand for removeManagedListener. ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeManagedListener\" rel=\"Ext.util.Observable-method-removeManagedListener\" class=\"docClass\">removeManagedListener</a>.</p>\n\n<p>Removes listeners that were added by the <a href=\"#!/api/Ext.util.Observable-method-mon\" rel=\"Ext.util.Observable-method-mon\" class=\"docClass\">mon</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The item from which to remove a listener/listeners.</p>\n\n</div></li><li><span class='pre'>ename</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the handler function.</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the scope (<code>this</code> reference)\nin which the handler function is executed.</p>\n\n</div></li></ul></div></div></div><div id='method-nextNode' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-nextNode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-nextNode' class='name expandable'>nextNode</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Returns the next node in the Component tree in tree traversal order. ...</div><div class='long'><p>Returns the next node in the Component tree in tree traversal order.</p>\n\n<p>Note that this is not limited to siblings, and if invoked upon a node with no matching siblings, will walk the\ntree to attempt to find a match. Contrast with <a href=\"#!/api/Ext.AbstractComponent-method-nextSibling\" rel=\"Ext.AbstractComponent-method-nextSibling\" class=\"docClass\">nextSibling</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a> selector to filter the following nodes.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>The next node (or the next node which matches the selector).\nReturns null if there is no matching node.</p>\n</div></li></ul></div></div></div><div id='method-nextSibling' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-nextSibling' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-nextSibling' class='name expandable'>nextSibling</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Returns the next sibling of this Component. ...</div><div class='long'><p>Returns the next sibling of this Component.</p>\n\n<p>Optionally selects the next sibling which matches the passed <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a> selector.</p>\n\n<p>May also be refered to as <strong><code>next()</code></strong></p>\n\n<p>Note that this is limited to siblings, and if no siblings of the item match, <code>null</code> is returned. Contrast with\n<a href=\"#!/api/Ext.AbstractComponent-method-nextNode\" rel=\"Ext.AbstractComponent-method-nextNode\" class=\"docClass\">nextNode</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a> selector to filter the following items.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>The next sibling (or the next sibling which matches the selector).\nReturns null if there is no matching sibling.</p>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> )</div><div class='description'><div class='short'>Shorthand for addListener. ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.</p>\n\n<p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for. May also be an object who's property names are\nevent names.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.  Will be called with arguments given to\n<a href=\"#!/api/Ext.util.Observable-method-fireEvent\" rel=\"Ext.util.Observable-method-fireEvent\" class=\"docClass\">fireEvent</a> plus the <code>options</code> parameter described below.</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the handler function is executed. <strong>If\nomitted, defaults to the object which fired the event.</strong></p>\n\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n\n\n\n\n<p><strong>Note:</strong> Unlike in ExtJS 3.x, the options object will also be passed as the last argument to every event handler.</p>\n\n\n\n\n<p>This object may contain any of the following properties:</p>\n\n\n\n\n<ul>\n<li><p><strong>scope</strong> : Object</p>\n\n<p>The scope (<code>this</code> reference) in which the handler function is executed. <strong>If omitted, defaults to the object\nwhich fired the event.</strong></p></li>\n<li><p><strong>delay</strong> : Number</p>\n\n<p>The number of milliseconds to delay the invocation of the handler after the event fires.</p></li>\n<li><p><strong>single</strong> : Boolean</p>\n\n<p>True to add a handler to handle just the next firing of the event, and then remove itself.</p></li>\n<li><p><strong>buffer</strong> : Number</p>\n\n<p>Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed by the specified number of\nmilliseconds. If the event fires again within that time, the original handler is <em>not</em> invoked, but the new\nhandler is scheduled in its place.</p></li>\n<li><p><strong>target</strong> : Observable</p>\n\n<p>Only call the handler if the event was fired on the target Observable, <em>not</em> if the event was bubbled up from a\nchild Observable.</p></li>\n<li><p><strong>element</strong> : String</p>\n\n<p><strong>This option is only valid for listeners bound to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a>.</strong> The name of a Component\nproperty which references an element to add a listener to.</p>\n\n<p>This option is useful during Component construction to add DOM event listeners to elements of\n<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a> which will exist only after the Component is rendered.\nFor example, to add a click listener to a Panel's body:</p>\n\n<pre><code>new Ext.panel.Panel({\n    title: 'The title',\n    listeners: {\n        click: this.handlePanelClick,\n        element: 'body'\n    }\n});\n</code></pre></li>\n</ul>\n\n\n\n\n<p><strong>Combining Options</strong></p>\n\n\n\n\n<p>Using the options argument, it is possible to combine different types of listeners:</p>\n\n\n\n\n<p>A delayed, one-time listener.</p>\n\n\n\n\n<pre><code>myPanel.on('hide', this.handleClick, this, {\n    single: true,\n    delay: 100\n});\n</code></pre>\n\n\n\n\n<p><strong>Attaching multiple handlers in 1 call</strong></p>\n\n\n\n\n<p>The method also allows for a single argument to be passed which is a config object containing properties which\nspecify multiple events. For example:</p>\n\n\n\n\n<pre><code>myGridPanel.on({\n    cellClick: this.onCellClick,\n    mouseover: this.onMouseOver,\n    mouseout: this.onMouseOut,\n    scope: this // Important. Ensure \"this\" is correct during handler execution\n});\n</code></pre>\n\n\n\n\n<p>One can also specify options for each event handler separately:</p>\n\n\n\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: this.onCellClick, scope: this, single: true},\n    mouseover: {fn: panel.onMouseOver, scope: panel}\n});\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-previousNode' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-previousNode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-previousNode' class='name expandable'>previousNode</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Returns the previous node in the Component tree in tree traversal order. ...</div><div class='long'><p>Returns the previous node in the Component tree in tree traversal order.</p>\n\n<p>Note that this is not limited to siblings, and if invoked upon a node with no matching siblings, will walk the\ntree in reverse order to attempt to find a match. Contrast with <a href=\"#!/api/Ext.AbstractComponent-method-previousSibling\" rel=\"Ext.AbstractComponent-method-previousSibling\" class=\"docClass\">previousSibling</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a> selector to filter the preceding nodes.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>The previous node (or the previous node which matches the selector).\nReturns null if there is no matching node.</p>\n</div></li></ul></div></div></div><div id='method-previousSibling' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-previousSibling' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-previousSibling' class='name expandable'>previousSibling</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Returns the previous sibling of this Component. ...</div><div class='long'><p>Returns the previous sibling of this Component.</p>\n\n<p>Optionally selects the previous sibling which matches the passed <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a>\nselector.</p>\n\n<p>May also be refered to as <strong><code>prev()</code></strong></p>\n\n<p>Note that this is limited to siblings, and if no siblings of the item match, <code>null</code> is returned. Contrast with\n<a href=\"#!/api/Ext.AbstractComponent-method-previousNode\" rel=\"Ext.AbstractComponent-method-previousNode\" class=\"docClass\">previousNode</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a> selector to filter the preceding items.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>The previous sibling (or the previous sibling which matches the selector).\nReturns null if there is no matching sibling.</p>\n</div></li></ul></div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-relayEvents' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> origin, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] events, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> prefix</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <code>this</code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>origin</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li><li><span class='pre'>prefix</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-removeChildEls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-removeChildEls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-removeChildEls' class='name expandable'>removeChildEls</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> testFn</span> )</div><div class='description'><div class='short'>Removes items in the childEls array based on the return value of a supplied test function. ...</div><div class='long'><p>Removes items in the childEls array based on the return value of a supplied test function. The function is called\nwith a entry in childEls and if the test function return true, that entry is removed. If false, that entry is\nkept.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>testFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The test function.</p>\n</div></li></ul></div></div></div><div id='method-removeCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-removeCls' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-removeCls' class='name expandable'>removeCls</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> className</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Removes a CSS class from the top level element representing this component. ...</div><div class='long'><p>Removes a CSS class from the top level element representing this component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>Returns the Component to allow method chaining.</p>\n</div></li></ul></div></div></div><div id='method-removeClsWithUI' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-removeClsWithUI' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-removeClsWithUI' class='name expandable'>removeClsWithUI</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] cls</span> )</div><div class='description'><div class='short'>Removes a cls to the uiCls array, which will also call removeUIClsFromElement and removes it from all\nelements of thi...</div><div class='long'><p>Removes a cls to the uiCls array, which will also call <a href=\"#!/api/Ext.AbstractComponent-method-removeUIClsFromElement\" rel=\"Ext.AbstractComponent-method-removeUIClsFromElement\" class=\"docClass\">removeUIClsFromElement</a> and removes it from all\nelements of this component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>A string or an array of strings to remove to the uiCls</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <strong>This must be a reference to the function passed into the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</strong></p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope originally specified for the handler. It must be the same as the\nscope argument specified in the original call to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> or the listener will not be removed.</p>\n\n</div></li></ul></div></div></div><div id='method-removeManagedListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeManagedListener' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeManagedListener' class='name expandable'>removeManagedListener</a>( <span class='pre'><a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> item, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> ename, [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope]</span> )</div><div class='description'><div class='short'>Removes listeners that were added by the mon method. ...</div><div class='long'><p>Removes listeners that were added by the <a href=\"#!/api/Ext.util.Observable-method-mon\" rel=\"Ext.util.Observable-method-mon\" class=\"docClass\">mon</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The item from which to remove a listener/listeners.</p>\n\n</div></li><li><span class='pre'>ename</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the handler function.</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>If the <code>ename</code> parameter was an event name, this is the scope (<code>this</code> reference)\nin which the handler function is executed.</p>\n\n</div></li></ul></div></div></div><div id='method-removeUIClsFromElement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-removeUIClsFromElement' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-removeUIClsFromElement' class='name expandable'>removeUIClsFromElement</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> ui</span> )</div><div class='description'><div class='short'>Method which removes a specified UI + uiCls from the components element. ...</div><div class='long'><p>Method which removes a specified UI + uiCls from the components element. The cls which is added to the element\nwill be: <code>this.baseCls + '-' + ui</code></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ui</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The UI to add to the element</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resumes firing events (see suspendEvents). ...</div><div class='long'><p>Resumes firing events (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>).</p>\n\n<p>If events were suspended using the <code>queueSuspended</code> parameter, then all events fired\nduring event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-savePropToState' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.state.Stateful' rel='Ext.state.Stateful' class='definedIn docClass'>Ext.state.Stateful</a><br/><a href='source/Stateful.html#Ext-state-Stateful-method-savePropToState' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.state.Stateful-method-savePropToState' class='name expandable'>savePropToState</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> propName, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> state, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> stateName]</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Conditionally saves a single property from this object to the given state object. ...</div><div class='long'><p>Conditionally saves a single property from this object to the given state object.\nThe idea is to only save state which has changed from the initial state so that\ncurrent software settings do not override future software settings. Only those\nvalues that are user-changed state should be saved.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>propName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the property to save.</p>\n</div></li><li><span class='pre'>state</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The state object in to which to save the property.</p>\n</div></li><li><span class='pre'>stateName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The name to use for the property in state.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the property was saved, false if not.</p>\n</div></li></ul></div></div></div><div id='method-sequenceFx' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Animate' rel='Ext.util.Animate' class='definedIn docClass'>Ext.util.Animate</a><br/><a href='source/Animate.html#Ext-util-Animate-method-sequenceFx' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Animate-method-sequenceFx' class='name expandable'>sequenceFx</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Ensures that all effects queued after sequenceFx is called on this object are\nrun in sequence. ...</div><div class='long'><p>Ensures that all effects queued after sequenceFx is called on this object are\nrun in sequence.  This is the opposite of <a href=\"#!/api/Ext.util.Animate-method-syncFx\" rel=\"Ext.util.Animate-method-syncFx\" class=\"docClass\">syncFx</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setActive' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Floating' rel='Ext.util.Floating' class='definedIn docClass'>Ext.util.Floating</a><br/><a href='source/Floating.html#Ext-util-Floating-method-setActive' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Floating-method-setActive' class='name expandable'>setActive</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> active], [<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> newActive]</span> )</div><div class='description'><div class='short'>This method is called internally by Ext.ZIndexManager to signal that a floating Component has either been\nmoved to th...</div><div class='long'><p>This method is called internally by <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">Ext.ZIndexManager</a> to signal that a floating Component has either been\nmoved to the top of its zIndex stack, or pushed from the top of its zIndex stack.</p>\n\n<p>If a <em>Window</em> is superceded by another Window, deactivating it hides its shadow.</p>\n\n<p>This method also fires the <a href=\"#!/api/Ext.Component-event-activate\" rel=\"Ext.Component-event-activate\" class=\"docClass\">activate</a> or\n<a href=\"#!/api/Ext.Component-event-deactivate\" rel=\"Ext.Component-event-deactivate\" class=\"docClass\">deactivate</a> event depending on which action occurred.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>active</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to activate the Component, false to deactivate it.</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>newActive</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> (optional)<div class='sub-desc'><p>The newly active Component which is taking over topmost zIndex position.</p>\n</div></li></ul></div></div></div><div id='method-setAutoScroll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-setAutoScroll' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-setAutoScroll' class='name expandable'>setAutoScroll</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> scroll</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Sets the overflow on the content element of the component. ...</div><div class='long'><p>Sets the overflow on the content element of the component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>scroll</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True to allow the Component to auto scroll.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setDisabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-setDisabled' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-setDisabled' class='name expandable'>setDisabled</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> disabled</span> )</div><div class='description'><div class='short'>Enable or disable the component. ...</div><div class='long'><p>Enable or disable the component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>disabled</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True to disable.</p>\n</div></li></ul></div></div></div><div id='method-setDocked' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-setDocked' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-setDocked' class='name expandable'>setDocked</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> dock, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> layoutParent]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Sets the dock position of this component in its parent panel. ...</div><div class='long'><p>Sets the dock position of this component in its parent panel. Note that this only has effect if this item is part\nof the dockedItems collection of a parent that has a DockLayout (note that any Panel has a DockLayout by default)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dock</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The dock position.</p>\n</div></li><li><span class='pre'>layoutParent</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to re-layout parent.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-setHeight' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-setHeight' class='name expandable'>setHeight</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> height</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Sets the height of the component. ...</div><div class='long'><p>Sets the height of the component. This method fires the <a href=\"#!/api/Ext.AbstractComponent-event-resize\" rel=\"Ext.AbstractComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>height</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new height to set. This may be one of:</p>\n\n<ul>\n<li>A Number specifying the new height in the <a href=\"#!/api/Ext.AbstractComponent-method-getEl\" rel=\"Ext.AbstractComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">Ext.Element.defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS height style.</li>\n<li><em>undefined</em> to leave the height unchanged.</li>\n</ul>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setLoading' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-setLoading' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-setLoading' class='name expandable'>setLoading</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> load, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> targetEl]</span> ) : <a href=\"#!/api/Ext.LoadMask\" rel=\"Ext.LoadMask\" class=\"docClass\">Ext.LoadMask</a></div><div class='description'><div class='short'>This method allows you to show or hide a LoadMask on top of this component. ...</div><div class='long'><p>This method allows you to show or hide a LoadMask on top of this component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>load</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>True to show the default LoadMask, a config object that will be passed to the\nLoadMask constructor, or a message String to show. False to hide the current LoadMask.</p>\n</div></li><li><span class='pre'>targetEl</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to mask the targetEl of this Component instead of the <code>this.el</code>. For example,\nsetting this to true on a Panel will cause only the body to be masked.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.LoadMask\" rel=\"Ext.LoadMask\" class=\"docClass\">Ext.LoadMask</a></span><div class='sub-desc'><p>The LoadMask instance that has just been shown.</p>\n</div></li></ul></div></div></div><div id='method-setPagePosition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-setPagePosition' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-setPagePosition' class='name expandable'>setPagePosition</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> x, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> y, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Sets the page XY position of the component. ...</div><div class='long'><p>Sets the page XY position of the component. To set the left and top instead, use <a href=\"#!/api/Ext.Component-method-setPosition\" rel=\"Ext.Component-method-setPosition\" class=\"docClass\">setPosition</a>.\nThis method fires the <a href=\"#!/api/Ext.Component-event-move\" rel=\"Ext.Component-event-move\" class=\"docClass\">move</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>True to animate the Component into its new position. You may also pass an\nanimation configuration.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setPosition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-setPosition' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-setPosition' class='name expandable'>setPosition</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> left, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> top, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Sets the left and top of the component. ...</div><div class='long'><p>Sets the left and top of the component. To set the page XY position instead, use <a href=\"#!/api/Ext.Component-method-setPagePosition\" rel=\"Ext.Component-method-setPagePosition\" class=\"docClass\">setPagePosition</a>. This\nmethod fires the <a href=\"#!/api/Ext.Component-event-move\" rel=\"Ext.Component-event-move\" class=\"docClass\">move</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>left</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new left</p>\n</div></li><li><span class='pre'>top</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new top</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>If true, the Component is <em>animated</em> into its new position. You may also pass an\nanimation configuration.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-setSize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-setSize' class='name expandable'>setSize</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> width, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> height</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Sets the width and height of this Component. ...</div><div class='long'><p>Sets the width and height of this Component. This method fires the <a href=\"#!/api/Ext.AbstractComponent-event-resize\" rel=\"Ext.AbstractComponent-event-resize\" class=\"docClass\">resize</a> event. This method can accept\neither width and height as separate arguments, or you can pass a size object like <code>{width:10, height:20}</code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The new width to set. This may be one of:</p>\n\n<ul>\n<li>A Number specifying the new width in the <a href=\"#!/api/Ext.AbstractComponent-method-getEl\" rel=\"Ext.AbstractComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">Ext.Element.defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style.</li>\n<li>A size object in the format <code>{width: widthValue, height: heightValue}</code>.</li>\n<li><code>undefined</code> to leave the width unchanged.</li>\n</ul>\n\n</div></li><li><span class='pre'>height</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new height to set (not required if a size object is passed as the first arg).\nThis may be one of:</p>\n\n<ul>\n<li>A Number specifying the new height in the <a href=\"#!/api/Ext.AbstractComponent-method-getEl\" rel=\"Ext.AbstractComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">Ext.Element.defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS height style. Animation may <strong>not</strong> be used.</li>\n<li><code>undefined</code> to leave the height unchanged.</li>\n</ul>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setUI' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-setUI' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-setUI' class='name expandable'>setUI</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> ui</span> )</div><div class='description'><div class='short'>Sets the UI for the component. ...</div><div class='long'><p>Sets the UI for the component. This will remove any existing UIs on the component. It will also loop through any\nuiCls set on the component and rename them so they include the new UI</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ui</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new UI for the component</p>\n</div></li></ul></div></div></div><div id='method-setVisible' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-setVisible' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-setVisible' class='name expandable'>setVisible</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> visible</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Convenience function to hide or show this component by boolean. ...</div><div class='long'><p>Convenience function to hide or show this component by boolean.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>visible</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True to show, false to hide</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-setWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-setWidth' class='name expandable'>setWidth</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> width</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Sets the width of the component. ...</div><div class='long'><p>Sets the width of the component. This method fires the <a href=\"#!/api/Ext.AbstractComponent-event-resize\" rel=\"Ext.AbstractComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new width to setThis may be one of:</p>\n\n<ul>\n<li>A Number specifying the new width in the <a href=\"#!/api/Ext.AbstractComponent-method-getEl\" rel=\"Ext.AbstractComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">Ext.Element.defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style.</li>\n</ul>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-show' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-show' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-show' class='name expandable'>show</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> animateTarget], [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> callback], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Shows this Component, rendering it first if autoRender or floating are true. ...</div><div class='long'><p>Shows this Component, rendering it first if <a href=\"#!/api/Ext.Component-cfg-autoRender\" rel=\"Ext.Component-cfg-autoRender\" class=\"docClass\">autoRender</a> or <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> are <code>true</code>.</p>\n\n<p>After being shown, a <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Component (such as a <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>), is activated it and\nbrought to the front of its <a href=\"#!/api/Ext.Component-property-zIndexManager\" rel=\"Ext.Component-property-zIndexManager\" class=\"docClass\">z-index stack</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>animateTarget</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (optional)<div class='sub-desc'><p><strong>only valid for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components such as <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Window</a>s or <a href=\"#!/api/Ext.tip.ToolTip\" rel=\"Ext.tip.ToolTip\" class=\"docClass\">ToolTip</a>s, or regular Components which have been configured\nwith <code>floating: true</code>.</strong> The target from which the Component should animate from while opening.</p>\n<p>Defaults to: <code>null</code></p></div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>A callback function to call after the Component is displayed.\nOnly necessary if animation was specified.</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the callback is executed.\nDefaults to this Component.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-showAt' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-showAt' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-showAt' class='name expandable'>showAt</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> x, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> y, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> animate]</span> )</div><div class='description'><div class='short'>Displays component at specific xy position. ...</div><div class='long'><p>Displays component at specific xy position.\nA floating component (like a menu) is positioned relative to its ownerCt if any.\nUseful for popping up a context menu:</p>\n\n<pre><code>listeners: {\n    itemcontextmenu: function(view, record, item, index, event, options) {\n        Ext.create('Ext.menu.Menu', {\n            width: 100,\n            height: 100,\n            margin: '0 0 10 0',\n            items: [{\n                text: 'regular item 1'\n            },{\n                text: 'regular item 2'\n            },{\n                text: 'regular item 3'\n            }]\n        }).showAt(event.getXY());\n    }\n}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n</div></li><li><span class='pre'>animate</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>True to animate the Component into its new position. You may also pass an\nanimation configuration.</p>\n</div></li></ul></div></div></div><div id='method-statics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-statics' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-statics' class='name expandable'>statics</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n\n        return this;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-stopAnimation' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Animate' rel='Ext.util.Animate' class='definedIn docClass'>Ext.util.Animate</a><br/><a href='source/Animate.html#Ext-util-Animate-method-stopAnimation' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Animate-method-stopAnimation' class='name expandable'>stopAnimation</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Stops any running effects and clears this object's internal effects queue if it contains\nany additional effects that ...</div><div class='long'><p>Stops any running effects and clears this object's internal effects queue if it contains\nany additional effects that haven't started yet.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-stopFx' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Animate' rel='Ext.util.Animate' class='definedIn docClass'>Ext.util.Animate</a><br/><a href='source/Animate.html#Ext-util-Animate-method-stopFx' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Animate-method-stopFx' class='name expandable'>stopFx</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Stops any running effects and clears this object's internal effects queue if it contains\nany additional effects that ...</div><div class='long'><p>Stops any running effects and clears this object's internal effects queue if it contains\nany additional effects that haven't started yet.</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0</p><p>Replaced by <a href=\"#!/api/Ext.util.Animate-method-stopAnimation\" rel=\"Ext.util.Animate-method-stopAnimation\" class=\"docClass\">stopAnimation</a></p>\n</div><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element</p>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> queueSuspended</span> )</div><div class='description'><div class='short'>Suspends the firing of all events. ...</div><div class='long'><p>Suspends the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events.</p>\n</div></li></ul></div></div></div><div id='method-syncFx' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Animate' rel='Ext.util.Animate' class='definedIn docClass'>Ext.util.Animate</a><br/><a href='source/Animate.html#Ext-util-Animate-method-syncFx' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Animate-method-syncFx' class='name expandable'>syncFx</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Ensures that all effects queued after syncFx is called on this object are\nrun concurrently. ...</div><div class='long'><p>Ensures that all effects queued after syncFx is called on this object are\nrun concurrently.  This is the opposite of <a href=\"#!/api/Ext.util.Animate-method-sequenceFx\" rel=\"Ext.util.Animate-method-sequenceFx\" class=\"docClass\">sequenceFx</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-toBack' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Floating' rel='Ext.util.Floating' class='definedIn docClass'>Ext.util.Floating</a><br/><a href='source/Floating.html#Ext-util-Floating-method-toBack' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Floating-method-toBack' class='name expandable'>toBack</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Sends this Component to the back of (lower z-index than) any other visible windows ...</div><div class='long'><p>Sends this Component to the back of (lower z-index than) any other visible windows</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-toFront' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Floating' rel='Ext.util.Floating' class='definedIn docClass'>Ext.util.Floating</a><br/><a href='source/Floating.html#Ext-util-Floating-method-toFront' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Floating-method-toFront' class='name expandable'>toFront</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> preventFocus]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Brings this floating Component to the front of any other visible, floating Components managed by the same ZIndexManag...</div><div class='long'><p>Brings this floating Component to the front of any other visible, floating Components managed by the same <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a></p>\n\n<p>If this Component is modal, inserts the modal mask just below this Component in the z-index stack.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>preventFocus</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>Specify <code>true</code> to prevent the Component from being focused.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='definedIn docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope]</span> )</div><div class='description'><div class='short'>Shorthand for removeListener. ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.</p>\n\n<p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <strong>This must be a reference to the function passed into the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</strong></p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope originally specified for the handler. It must be the same as the\nscope argument specified in the original call to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> or the listener will not be removed.</p>\n\n</div></li></ul></div></div></div><div id='method-up' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-up' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-up' class='name expandable'>up</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> selector]</span> ) : <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></div><div class='description'><div class='short'>Walks up the ownerCt axis looking for an ancestor Container which matches the passed simple selector. ...</div><div class='long'><p>Walks up the <code>ownerCt</code> axis looking for an ancestor Container which matches the passed simple selector.</p>\n\n<p>Example:</p>\n\n<pre><code>var owningTabPanel = grid.up('tabpanel');\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The simple selector to test.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></span><div class='sub-desc'><p>The matching ancestor Container (or <code>undefined</code> if no match was found).</p>\n</div></li></ul></div></div></div><div id='method-update' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-method-update' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-method-update' class='name expandable'>update</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> htmlOrData, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> loadScripts], [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> callback]</span> )</div><div class='description'><div class='short'>Update the content area of a component. ...</div><div class='long'><p>Update the content area of a component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>htmlOrData</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>If this component has been configured with a template via the tpl config then\nit will use this argument as data to populate the template. If this component was not configured with a template,\nthe components content area will be updated via <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> update</p>\n</div></li><li><span class='pre'>loadScripts</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>Only legitimate when using the html configuration.</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>Only legitimate when using the html configuration. Callback to execute when\nscripts have finished loading</p>\n</div></li></ul></div></div></div><div id='method-updateBox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='definedIn docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-updateBox' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Component-method-updateBox' class='name expandable'>updateBox</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> box</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Sets the current box measurements of the component's underlying element. ...</div><div class='long'><p>Sets the current box measurements of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>box</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>An object in the format {x, y, width, height}</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-addStatics' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-addStatics' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-addStatics' class='name expandable'>addStatics</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Add / override static properties of this class. ...</div><div class='long'><p>Add / override static properties of this class.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.addStatics({\n    someProperty: 'someValue',      // My.cool.Class.someProperty = 'someValue'\n    method1: function() { ... },    // My.cool.Class.method1 = function() { ... };\n    method2: function() { ... }     // My.cool.Class.method2 = function() { ... };\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-borrow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-borrow' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-borrow' class='name expandable'>borrow</a>( <span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a> fromClass, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Borrow another class' members to the prototype of this class. ...</div><div class='long'><p>Borrow another class' members to the prototype of this class.</p>\n\n<pre><code>Ext.define('Bank', {\n    money: '$$$',\n    printMoney: function() {\n        alert('$$$$$$$');\n    }\n});\n\nExt.define('Thief', {\n    ...\n});\n\nThief.borrow(Bank, ['money', 'printMoney']);\n\nvar steve = new Thief();\n\nalert(steve.money); // alerts '$$$'\nsteve.printMoney(); // alerts '$$$$$$$'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fromClass</span> : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><div class='sub-desc'><p>The class to borrow members from</p>\n</div></li><li><span class='pre'>members</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The names of the members to borrow</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-create' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-create' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-create' class='name expandable'>create</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Create a new instance of this Class. ...</div><div class='long'><p>Create a new instance of this Class.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.create({\n    someConfig: true\n});\n</code></pre>\n\n<p>All parameters are passed to the constructor of the class.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>the created instance.</p>\n</div></li></ul></div></div></div><div id='static-method-createAlias' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-createAlias' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-createAlias' class='name expandable'>createAlias</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> alias, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> origin</span> )<strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Create aliases for existing prototype methods. ...</div><div class='long'><p>Create aliases for existing prototype methods. Example:</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    method1: function() { ... },\n    method2: function() { ... }\n});\n\nvar test = new My.cool.Class();\n\nMy.cool.Class.createAlias({\n    method3: 'method1',\n    method4: 'method2'\n});\n\ntest.method3(); // test.method1()\n\nMy.cool.Class.createAlias('method5', 'method3');\n\ntest.method5(); // test.method3() -&gt; test.method1()\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>alias</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The new method name, or an object to set multiple aliases. See\n<a href=\"#!/api/Ext.Function-method-flexSetter\" rel=\"Ext.Function-method-flexSetter\" class=\"docClass\">flexSetter</a></p>\n</div></li><li><span class='pre'>origin</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The original method name</p>\n</div></li></ul></div></div></div><div id='static-method-getName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-getName' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-getName' class='name expandable'>getName</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Get the current class' name in string format. ...</div><div class='long'><p>Get the current class' name in string format.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    constructor: function() {\n        alert(this.self.getName()); // alerts 'My.cool.Class'\n    }\n});\n\nMy.cool.Class.getName(); // 'My.cool.Class'\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>className</p>\n</div></li></ul></div></div></div><div id='static-method-implement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-implement' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-implement' class='name expandable'>implement</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> )<strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Add methods / properties to the prototype of this class. ...</div><div class='long'><p>Add methods / properties to the prototype of this class.</p>\n\n<pre><code>Ext.define('My.awesome.Cat', {\n    constructor: function() {\n        ...\n    }\n});\n\n My.awesome.Cat.implement({\n     meow: function() {\n        alert('Meowww...');\n     }\n });\n\n var kitty = new My.awesome.Cat;\n kitty.meow();\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-override' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-override' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-override' class='name expandable'>override</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Override prototype members of this class. ...</div><div class='long'><p>Override prototype members of this class. Overridden methods can be invoked via\n<a href=\"#!/api/Ext.Base-method-callOverridden\" rel=\"Ext.Base-method-callOverridden\" class=\"docClass\">callOverridden</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div></div></div><div id='m-event'><div class='definedBy'>Defined By</div><h3 class='members-title'>Events</h3><div class='subsection'><div id='event-activate' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-activate' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-activate' class='name expandable'>activate</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after a Component has been visually activated. ...</div><div class='long'><p>Fires after a Component has been visually activated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-added' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-added' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-added' class='name expandable'>added</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a> container, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> pos, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after a Component had been added to a Container. ...</div><div class='long'><p>Fires after a Component had been added to a Container.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>container</span> : <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a><div class='sub-desc'><p>Parent Container</p>\n</div></li><li><span class='pre'>pos</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>position of Component</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-afterrender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-afterrender' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-afterrender' class='name expandable'>afterrender</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after the component rendering is finished. ...</div><div class='long'><p>Fires after the component rendering is finished.</p>\n\n<p>The afterrender event is fired after this Component has been <a href=\"#!/api/Ext.AbstractComponent-property-rendered\" rel=\"Ext.AbstractComponent-property-rendered\" class=\"docClass\">rendered</a>, been postprocesed by any\nafterRender method defined for the Component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-beforeactivate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-beforeactivate' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-beforeactivate' class='name expandable'>beforeactivate</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires before a Component has been visually activated. ...</div><div class='long'><p>Fires before a Component has been visually activated. Returning false from an event listener can prevent\nthe activate from occurring.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-beforedeactivate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-beforedeactivate' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-beforedeactivate' class='name expandable'>beforedeactivate</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires before a Component has been visually deactivated. ...</div><div class='long'><p>Fires before a Component has been visually deactivated. Returning false from an event listener can\nprevent the deactivate from occurring.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-beforedestroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-beforedestroy' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-beforedestroy' class='name expandable'>beforedestroy</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires before the component is destroyed. ...</div><div class='long'><p>Fires before the component is <a href=\"#!/api/Ext.AbstractComponent-event-destroy\" rel=\"Ext.AbstractComponent-event-destroy\" class=\"docClass\">destroy</a>ed. Return false from an event handler to stop the\n<a href=\"#!/api/Ext.AbstractComponent-event-destroy\" rel=\"Ext.AbstractComponent-event-destroy\" class=\"docClass\">destroy</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-beforehide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-beforehide' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-beforehide' class='name expandable'>beforehide</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires before the component is hidden when calling the hide method. ...</div><div class='long'><p>Fires before the component is hidden when calling the <a href=\"#!/api/Ext.AbstractComponent-event-hide\" rel=\"Ext.AbstractComponent-event-hide\" class=\"docClass\">hide</a> method. Return false from an event\nhandler to stop the hide.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-beforerender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-beforerender' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-beforerender' class='name expandable'>beforerender</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires before the component is rendered. ...</div><div class='long'><p>Fires before the component is <a href=\"#!/api/Ext.AbstractComponent-property-rendered\" rel=\"Ext.AbstractComponent-property-rendered\" class=\"docClass\">rendered</a>. Return false from an event handler to stop the\n<a href=\"#!/api/Ext.AbstractComponent-event-render\" rel=\"Ext.AbstractComponent-event-render\" class=\"docClass\">render</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-beforeshow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-beforeshow' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-beforeshow' class='name expandable'>beforeshow</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires before the component is shown when calling the show method. ...</div><div class='long'><p>Fires before the component is shown when calling the <a href=\"#!/api/Ext.AbstractComponent-event-show\" rel=\"Ext.AbstractComponent-event-show\" class=\"docClass\">show</a> method. Return false from an event\nhandler to stop the show.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-beforestaterestore' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.state.Stateful' rel='Ext.state.Stateful' class='definedIn docClass'>Ext.state.Stateful</a><br/><a href='source/Stateful.html#Ext-state-Stateful-event-beforestaterestore' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.state.Stateful-event-beforestaterestore' class='name expandable'>beforestaterestore</a>( <span class='pre'><a href=\"#!/api/Ext.state.Stateful\" rel=\"Ext.state.Stateful\" class=\"docClass\">Ext.state.Stateful</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> state, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires before the state of the object is restored. ...</div><div class='long'><p>Fires before the state of the object is restored. Return false from an event handler to stop the restore.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.state.Stateful\" rel=\"Ext.state.Stateful\" class=\"docClass\">Ext.state.Stateful</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The hash of state values returned from the StateProvider. If this\nevent is not vetoed, then the state object is passed to <b><tt>applyState</tt></b>. By default,\nthat simply copies property values into this object. The method maybe overriden to\nprovide custom state restoration.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-beforestatesave' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.state.Stateful' rel='Ext.state.Stateful' class='definedIn docClass'>Ext.state.Stateful</a><br/><a href='source/Stateful.html#Ext-state-Stateful-event-beforestatesave' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.state.Stateful-event-beforestatesave' class='name expandable'>beforestatesave</a>( <span class='pre'><a href=\"#!/api/Ext.state.Stateful\" rel=\"Ext.state.Stateful\" class=\"docClass\">Ext.state.Stateful</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> state, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires before the state of the object is saved to the configured state provider. ...</div><div class='long'><p>Fires before the state of the object is saved to the configured state provider. Return false to stop the save.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.state.Stateful\" rel=\"Ext.state.Stateful\" class=\"docClass\">Ext.state.Stateful</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The hash of state values. This is determined by calling\n<b><tt>getState()</tt></b> on the object. This method must be provided by the\ndeveloper to return whetever representation of state is required, by default, <a href=\"#!/api/Ext.state.Stateful\" rel=\"Ext.state.Stateful\" class=\"docClass\">Ext.state.Stateful</a>\nhas a null implementation.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-deactivate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-deactivate' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-deactivate' class='name expandable'>deactivate</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after a Component has been visually deactivated. ...</div><div class='long'><p>Fires after a Component has been visually deactivated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-destroy' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-destroy' class='name expandable'>destroy</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after the component is destroyed. ...</div><div class='long'><p>Fires after the component is <a href=\"#!/api/Ext.AbstractComponent-event-destroy\" rel=\"Ext.AbstractComponent-event-destroy\" class=\"docClass\">destroy</a>ed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-disable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-disable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-disable' class='name expandable'>disable</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after the component is disabled. ...</div><div class='long'><p>Fires after the component is disabled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-enable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-enable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-enable' class='name expandable'>enable</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after the component is enabled. ...</div><div class='long'><p>Fires after the component is enabled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-hide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-hide' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-hide' class='name expandable'>hide</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after the component is hidden. ...</div><div class='long'><p>Fires after the component is hidden. Fires after the component is hidden when calling the <a href=\"#!/api/Ext.AbstractComponent-event-hide\" rel=\"Ext.AbstractComponent-event-hide\" class=\"docClass\">hide</a>\nmethod.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-move' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-move' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-move' class='name expandable'>move</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> x, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> y, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after the component is moved. ...</div><div class='long'><p>Fires after the component is moved.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-removed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-removed' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-removed' class='name expandable'>removed</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a> ownerCt, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires when a component is removed from an Ext.container.Container ...</div><div class='long'><p>Fires when a component is removed from an <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>ownerCt</span> : <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a><div class='sub-desc'><p>Container which holds the component</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-render' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-render' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-render' class='name expandable'>render</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after the component markup is rendered. ...</div><div class='long'><p>Fires after the component markup is <a href=\"#!/api/Ext.AbstractComponent-property-rendered\" rel=\"Ext.AbstractComponent-property-rendered\" class=\"docClass\">rendered</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-resize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-resize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-resize' class='name expandable'>resize</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> adjWidth, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> adjHeight, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after the component is resized. ...</div><div class='long'><p>Fires after the component is resized.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>adjWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted width that was set</p>\n</div></li><li><span class='pre'>adjHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted height that was set</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-show' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.AbstractComponent' rel='Ext.AbstractComponent' class='definedIn docClass'>Ext.AbstractComponent</a><br/><a href='source/AbstractComponent.html#Ext-AbstractComponent-event-show' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.AbstractComponent-event-show' class='name expandable'>show</a>( <span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after the component is shown when calling the show method. ...</div><div class='long'><p>Fires after the component is shown when calling the <a href=\"#!/api/Ext.AbstractComponent-event-show\" rel=\"Ext.AbstractComponent-event-show\" class=\"docClass\">show</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-staterestore' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.state.Stateful' rel='Ext.state.Stateful' class='definedIn docClass'>Ext.state.Stateful</a><br/><a href='source/Stateful.html#Ext-state-Stateful-event-staterestore' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.state.Stateful-event-staterestore' class='name expandable'>staterestore</a>( <span class='pre'><a href=\"#!/api/Ext.state.Stateful\" rel=\"Ext.state.Stateful\" class=\"docClass\">Ext.state.Stateful</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> state, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after the state of the object is restored. ...</div><div class='long'><p>Fires after the state of the object is restored.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.state.Stateful\" rel=\"Ext.state.Stateful\" class=\"docClass\">Ext.state.Stateful</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The hash of state values returned from the StateProvider. This is passed\nto <b><tt>applyState</tt></b>. By default, that simply copies property values into this\nobject. The method maybe overriden to provide custom state restoration.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div><div id='event-statesave' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.state.Stateful' rel='Ext.state.Stateful' class='definedIn docClass'>Ext.state.Stateful</a><br/><a href='source/Stateful.html#Ext-state-Stateful-event-statesave' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.state.Stateful-event-statesave' class='name expandable'>statesave</a>( <span class='pre'><a href=\"#!/api/Ext.state.Stateful\" rel=\"Ext.state.Stateful\" class=\"docClass\">Ext.state.Stateful</a> this, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> state, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eOpts</span> )</div><div class='description'><div class='short'>Fires after the state of the object is saved to the configured state provider. ...</div><div class='long'><p>Fires after the state of the object is saved to the configured state provider.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.state.Stateful\" rel=\"Ext.state.Stateful\" class=\"docClass\">Ext.state.Stateful</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The hash of state values. This is determined by calling\n<b><tt>getState()</tt></b> on the object. This method must be provided by the\ndeveloper to return whetever representation of state is required, by default, <a href=\"#!/api/Ext.state.Stateful\" rel=\"Ext.state.Stateful\" class=\"docClass\">Ext.state.Stateful</a>\nhas a null implementation.</p>\n</div></li><li><span class='pre'>eOpts</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The options object passed to <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">Ext.util.Observable.addListener</a>.</p>\n\n\n\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":["Ext.util.Floating","Ext.util.Observable","Ext.util.Animate","Ext.state.Stateful"],"meta":{},"requires":["Ext.util.DelayedTask"],"deprecated":null,"extends":"Ext.AbstractComponent","inheritable":false,"static":false,"superclasses":["Ext.Base","Ext.AbstractComponent","Ext.Component"],"singleton":false,"code_type":"ext_define","alias":null,"statics":{"property":[],"css_var":[],"css_mixin":[],"cfg":[],"method":[{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"addStatics","id":"static-method-addStatics"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"borrow","id":"static-method-borrow"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"create","id":"static-method-create"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"createAlias","id":"static-method-createAlias"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"getName","id":"static-method-getName"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"implement","id":"static-method-implement"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"override","id":"static-method-override"}],"event":[]},"subclasses":["Ext.button.Button","Ext.Editor","Ext.flash.Component","Ext.form.field.Base","Ext.form.field.HtmlEditor","Ext.form.Label","Ext.grid.Scroller","Ext.Img","Ext.LoadMask","Ext.menu.Item","Ext.panel.Tool","Ext.picker.Color","Ext.picker.Date","Ext.picker.Month","Ext.ProgressBar","Ext.resizer.Handle","Ext.resizer.Splitter","Ext.toolbar.Fill","Ext.toolbar.Item","Ext.toolbar.Spacer","Ext.container.AbstractContainer","Ext.draw.Component","Ext.view.AbstractView"],"uses":["Ext.Layer","Ext.resizer.Resizer","Ext.util.ComponentDragger"],"protected":false,"mixins":["Ext.util.Floating"],"members":{"property":[{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"draggable","id":"property-draggable"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Component","template":null,"required":null,"protected":false,"name":"floatParent","id":"property-floatParent"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"frameSize","id":"property-frameSize"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"maskOnDisable","id":"property-maskOnDisable"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"ownerCt","id":"property-ownerCt"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"rendered","id":"property-rendered"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Base","template":null,"required":null,"protected":true,"name":"self","id":"property-self"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Component","template":null,"required":null,"protected":false,"name":"zIndexManager","id":"property-zIndexManager"}],"css_var":[],"css_mixin":[],"cfg":[{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"autoEl","id":"cfg-autoEl"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"autoRender","id":"cfg-autoRender"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.Component","template":null,"required":false,"protected":false,"name":"autoScroll","id":"cfg-autoScroll"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"autoShow","id":"cfg-autoShow"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"baseCls","id":"cfg-baseCls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"border","id":"cfg-border"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"childEls","id":"cfg-childEls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"cls","id":"cfg-cls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"componentCls","id":"cfg-componentCls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"componentLayout","id":"cfg-componentLayout"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"contentEl","id":"cfg-contentEl"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"data","id":"cfg-data"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"disabled","id":"cfg-disabled"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"disabledCls","id":"cfg-disabledCls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.Component","template":null,"required":false,"protected":false,"name":"draggable","id":"cfg-draggable"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.Component","template":null,"required":false,"protected":false,"name":"floating","id":"cfg-floating"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.util.Floating","template":null,"required":false,"protected":false,"name":"focusOnToFront","id":"cfg-focusOnToFront"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"frame","id":"cfg-frame"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"height","id":"cfg-height"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"hidden","id":"cfg-hidden"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"hideMode","id":"cfg-hideMode"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"html","id":"cfg-html"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"id","id":"cfg-id"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"itemId","id":"cfg-itemId"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":null,"required":false,"protected":false,"name":"listeners","id":"cfg-listeners"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"loader","id":"cfg-loader"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.Component","template":null,"required":false,"protected":false,"name":"maintainFlex","id":"cfg-maintainFlex"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"margin","id":"cfg-margin"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"maxHeight","id":"cfg-maxHeight"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"maxWidth","id":"cfg-maxWidth"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"minHeight","id":"cfg-minHeight"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"minWidth","id":"cfg-minWidth"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"overCls","id":"cfg-overCls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"padding","id":"cfg-padding"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"plugins","id":"cfg-plugins"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"renderData","id":"cfg-renderData"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"renderSelectors","id":"cfg-renderSelectors"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"renderTo","id":"cfg-renderTo"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"renderTpl","id":"cfg-renderTpl"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.Component","template":null,"required":false,"protected":false,"name":"resizable","id":"cfg-resizable"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.Component","template":null,"required":false,"protected":false,"name":"resizeHandles","id":"cfg-resizeHandles"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.state.Stateful","template":null,"required":false,"protected":false,"name":"saveDelay","id":"cfg-saveDelay"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.util.Floating","template":null,"required":false,"protected":false,"name":"shadow","id":"cfg-shadow"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.state.Stateful","template":null,"required":false,"protected":false,"name":"stateEvents","id":"cfg-stateEvents"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.state.Stateful","template":null,"required":false,"protected":false,"name":"stateId","id":"cfg-stateId"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.state.Stateful","template":null,"required":false,"protected":false,"name":"stateful","id":"cfg-stateful"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"style","id":"cfg-style"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"styleHtmlCls","id":"cfg-styleHtmlCls"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"styleHtmlContent","id":"cfg-styleHtmlContent"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.Component","template":null,"required":false,"protected":false,"name":"toFrontOnShow","id":"cfg-toFrontOnShow"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"tpl","id":"cfg-tpl"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"tplWriteMode","id":"cfg-tplWriteMode"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"ui","id":"cfg-ui"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"width","id":"cfg-width"},{"tagname":"cfg","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":false,"protected":false,"name":"xtype","id":"cfg-xtype"}],"method":[{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"constructor","id":"method-constructor"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"addChildEls","id":"method-addChildEls"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"addClass","id":"method-addClass"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"addCls","id":"method-addCls"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"addClsWithUI","id":"method-addClsWithUI"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"addEvents","id":"method-addEvents"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"addListener","id":"method-addListener"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"addManagedListener","id":"method-addManagedListener"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.state.Stateful","template":false,"required":null,"protected":false,"name":"addStateEvents","id":"method-addStateEvents"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"addUIClsToElement","id":"method-addUIClsToElement"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"afterComponentLayout","id":"method-afterComponentLayout"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Floating","template":false,"required":null,"protected":false,"name":"alignTo","id":"method-alignTo"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Animate","template":false,"required":null,"protected":false,"name":"animate","id":"method-animate"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.state.Stateful","template":false,"required":null,"protected":false,"name":"applyState","id":"method-applyState"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"beforeComponentLayout","id":"method-beforeComponentLayout"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"bubble","id":"method-bubble"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callOverridden","id":"method-callOverridden"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callParent","id":"method-callParent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Floating","template":false,"required":null,"protected":false,"name":"center","id":"method-center"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"clearListeners","id":"method-clearListeners"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"clearManagedListeners","id":"method-clearManagedListeners"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"cloneConfig","id":"method-cloneConfig"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"constructPlugins","id":"method-constructPlugins"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"destroy","id":"method-destroy"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"disable","id":"method-disable"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"doAutoRender","id":"method-doAutoRender"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"doComponentLayout","id":"method-doComponentLayout"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Floating","template":false,"required":null,"protected":false,"name":"doConstrain","id":"method-doConstrain"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"enable","id":"method-enable"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"findLayoutController","id":"method-findLayoutController"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"findParentBy","id":"method-findParentBy"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"findParentByType","id":"method-findParentByType"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"focus","id":"method-focus"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"forceComponentLayout","id":"method-forceComponentLayout"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Animate","template":false,"required":null,"protected":false,"name":"getActiveAnimation","id":"method-getActiveAnimation"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"getBox","id":"method-getBox"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"getBubbleTarget","id":"method-getBubbleTarget"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"getEl","id":"method-getEl"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"getHeight","id":"method-getHeight"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"getId","id":"method-getId"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"getInsertPosition","id":"method-getInsertPosition"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"getLoader","id":"method-getLoader"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"getPlugin","id":"method-getPlugin"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"getPosition","id":"method-getPosition"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"getSize","id":"method-getSize"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"getState","id":"method-getState"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.state.Stateful","template":false,"required":null,"protected":false,"name":"getStateId","id":"method-getStateId"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"getWidth","id":"method-getWidth"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"getXType","id":"method-getXType"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"getXTypes","id":"method-getXTypes"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Replaced by <a href=\"#!/api/Ext.util.Animate-method-getActiveAnimation\" rel=\"Ext.util.Animate-method-getActiveAnimation\" class=\"docClass\">getActiveAnimation</a></p>\n","version":"4.0"},"static":false,"owner":"Ext.util.Animate","template":false,"required":null,"protected":false,"name":"hasActiveFx","id":"method-hasActiveFx"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"hasListener","id":"method-hasListener"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"hasUICls","id":"method-hasUICls"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"hide","id":"method-hide"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":true,"required":null,"protected":false,"name":"initComponent","id":"method-initComponent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"initConfig","id":"method-initConfig"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"is","id":"method-is"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"isDescendantOf","id":"method-isDescendantOf"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"isDisabled","id":"method-isDisabled"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"isDraggable","id":"method-isDraggable"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"isDroppable","id":"method-isDroppable"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"isFloating","id":"method-isFloating"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"isHidden","id":"method-isHidden"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"isVisible","id":"method-isVisible"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"isXType","id":"method-isXType"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"mon","id":"method-mon"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"mun","id":"method-mun"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"nextNode","id":"method-nextNode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"nextSibling","id":"method-nextSibling"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"on","id":"method-on"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"previousNode","id":"method-previousNode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"previousSibling","id":"method-previousSibling"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"removeChildEls","id":"method-removeChildEls"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"removeCls","id":"method-removeCls"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"removeClsWithUI","id":"method-removeClsWithUI"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"removeListener","id":"method-removeListener"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"removeManagedListener","id":"method-removeManagedListener"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"removeUIClsFromElement","id":"method-removeUIClsFromElement"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.state.Stateful","template":false,"required":null,"protected":false,"name":"savePropToState","id":"method-savePropToState"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Animate","template":false,"required":null,"protected":false,"name":"sequenceFx","id":"method-sequenceFx"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Floating","template":false,"required":null,"protected":false,"name":"setActive","id":"method-setActive"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"setAutoScroll","id":"method-setAutoScroll"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"setDisabled","id":"method-setDisabled"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"setDocked","id":"method-setDocked"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"setHeight","id":"method-setHeight"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"setLoading","id":"method-setLoading"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"setPagePosition","id":"method-setPagePosition"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"setPosition","id":"method-setPosition"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"setSize","id":"method-setSize"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"setUI","id":"method-setUI"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"setVisible","id":"method-setVisible"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"setWidth","id":"method-setWidth"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"show","id":"method-show"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"showAt","id":"method-showAt"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"statics","id":"method-statics"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Animate","template":false,"required":null,"protected":false,"name":"stopAnimation","id":"method-stopAnimation"},{"tagname":"method","deprecated":{"doc":"Stops any running effects and clears this object's internal effects queue if it contains\nany additional effects that haven't started yet.","tagname":"deprecated","text":"<p>Replaced by <a href=\"#!/api/Ext.util.Animate-method-stopAnimation\" rel=\"Ext.util.Animate-method-stopAnimation\" class=\"docClass\">stopAnimation</a></p>\n","version":"4.0"},"static":false,"owner":"Ext.util.Animate","template":false,"required":null,"protected":false,"name":"stopFx","id":"method-stopFx"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Animate","template":false,"required":null,"protected":false,"name":"syncFx","id":"method-syncFx"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Floating","template":false,"required":null,"protected":false,"name":"toBack","id":"method-toBack"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Floating","template":false,"required":null,"protected":false,"name":"toFront","id":"method-toFront"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.util.Observable","template":false,"required":null,"protected":false,"name":"un","id":"method-un"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"up","id":"method-up"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":false,"required":null,"protected":false,"name":"update","id":"method-update"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Component","template":false,"required":null,"protected":false,"name":"updateBox","id":"method-updateBox"}],"event":[{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"activate","id":"event-activate"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"added","id":"event-added"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"afterrender","id":"event-afterrender"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"beforeactivate","id":"event-beforeactivate"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"beforedeactivate","id":"event-beforedeactivate"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"beforedestroy","id":"event-beforedestroy"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"beforehide","id":"event-beforehide"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"beforerender","id":"event-beforerender"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"beforeshow","id":"event-beforeshow"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.state.Stateful","template":null,"required":null,"protected":false,"name":"beforestaterestore","id":"event-beforestaterestore"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.state.Stateful","template":null,"required":null,"protected":false,"name":"beforestatesave","id":"event-beforestatesave"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"deactivate","id":"event-deactivate"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"destroy","id":"event-destroy"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"disable","id":"event-disable"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"enable","id":"event-enable"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"hide","id":"event-hide"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"move","id":"event-move"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"removed","id":"event-removed"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"render","id":"event-render"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"resize","id":"event-resize"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.AbstractComponent","template":null,"required":null,"protected":false,"name":"show","id":"event-show"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.state.Stateful","template":null,"required":null,"protected":false,"name":"staterestore","id":"event-staterestore"},{"tagname":"event","deprecated":null,"static":false,"owner":"Ext.state.Stateful","template":null,"required":null,"protected":false,"name":"statesave","id":"event-statesave"}]},"private":false,"component":true,"name":"Ext.Component","alternateClassNames":[],"id":"class-Ext.Component","mixedInto":[],"xtypes":{"widget":["component","box"]},"files":[{"href":"Component.html#Ext-Component","filename":"Component.js"}]});