Ext.data.JsonP.Ext_dd_DDProxy({"tagname":"class","html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.Base' rel='Ext.Base' class='docClass'>Ext.Base</a><div class='subclass '><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='docClass'>Ext.dd.DragDrop</a><div class='subclass '><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='docClass'>Ext.dd.DD</a><div class='subclass '><strong>Ext.dd.DDProxy</strong></div></div></div></div><h4>Files</h4><div class='dependency'><a href='source/DDProxy.html#Ext-dd-DDProxy' target='_blank'>DDProxy.js</a></div></pre><div class='doc-contents'><p>A DragDrop implementation that inserts an empty, bordered div into\nthe document that follows the cursor during drag operations.  At the time of\nthe click, the frame div is resized to the dimensions of the linked html\nelement, and moved to the exact location of the linked element.</p>\n\n<p>References to the \"frame\" element refer to the single proxy element that\nwas created to be dragged in place of all DDProxy elements on the\npage.</p>\n</div><div class='members'><div id='m-property'><h3 class='members-title'>Properties</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Properties</h3><div id='property-available' class='member first-child inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-available' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-available' class='name not-expandable'>available</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>The available property is false until the linked dom element is accessible.</p>\n</div><div class='long'><p>The available property is false until the linked dom element is accessible.</p>\n</div></div></div><div id='property-centerFrame' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DDProxy' rel='Ext.dd.DDProxy' class='definedIn docClass'>Ext.dd.DDProxy</a><br/><a href='source/DDProxy.html#Ext-dd-DDProxy-property-centerFrame' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DDProxy-property-centerFrame' class='name expandable'>centerFrame</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>By default the frame is positioned exactly where the drag element is, so\nwe use the cursor offset provided by Ext.dd.DD. ...</div><div class='long'><p>By default the frame is positioned exactly where the drag element is, so\nwe use the cursor offset provided by <a href=\"#!/api/Ext.dd.DD\" rel=\"Ext.dd.DD\" class=\"docClass\">Ext.dd.DD</a>.  Another option that works only if\nyou do not have constraints on the obj is to have the drag frame centered\naround the cursor.  Set centerFrame to true for this effect.</p>\n</div></div></div><div id='property-config' class='member  inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-config' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-config' class='name not-expandable'>config</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'><p>Configuration attributes passed into the constructor</p>\n</div><div class='long'><p>Configuration attributes passed into the constructor</p>\n</div></div></div><div id='property-defaultPadding' class='member  inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-defaultPadding' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-defaultPadding' class='name not-expandable'>defaultPadding</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'><p>Provides default constraint padding to \"constrainTo\" elements.</p>\n</div><div class='long'><p>Provides default constraint padding to \"constrainTo\" elements.</p>\n</div></div></div><div id='property-groups' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-groups' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-groups' class='name expandable'>groups</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>The group defines a logical collection of DragDrop objects that are\nrelated. ...</div><div class='long'><p>The group defines a logical collection of DragDrop objects that are\nrelated.  Instances only get events when interacting with other\nDragDrop object in the same group.  This lets us define multiple\ngroups using a single DragDrop subclass if we want. An object in the format {'group1':true, 'group2':true}</p>\n</div></div></div><div id='property-hasOuterHandles' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-hasOuterHandles' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-hasOuterHandles' class='name expandable'>hasOuterHandles</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>By default, drags can only be initiated if the mousedown occurs in the\nregion the linked element is. ...</div><div class='long'><p>By default, drags can only be initiated if the mousedown occurs in the\nregion the linked element is.  This is done in part to work around a\nbug in some browsers that mis-report the mousedown if the previous\nmouseup happened outside of the window.  This property is set to true\nif outer handles are defined. Defaults to false.</p>\n</div></div></div><div id='property-id' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-id' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-id' class='name expandable'>id</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The id of the element associated with this object. ...</div><div class='long'><p>The id of the element associated with this object.  This is what we\nrefer to as the \"linked element\" because the size and position of\nthis element is used to determine when the drag and drop objects have\ninteracted.</p>\n</div></div></div><div id='property-ignoreSelf' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-ignoreSelf' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-ignoreSelf' class='name expandable'>ignoreSelf</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Set to false to enable a DragDrop object to fire drag events while dragging\nover its own Element. ...</div><div class='long'><p>Set to false to enable a DragDrop object to fire drag events while dragging\nover its own Element. Defaults to true - DragDrop objects do not by default\nfire drag events to themselves.</p>\n</div></div></div><div id='property-invalidHandleClasses' class='member  inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-invalidHandleClasses' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-invalidHandleClasses' class='name not-expandable'>invalidHandleClasses</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</span></div><div class='description'><div class='short'><p>An Array of CSS class names for elements to be considered in valid as drag handles.</p>\n</div><div class='long'><p>An Array of CSS class names for elements to be considered in valid as drag handles.</p>\n</div></div></div><div id='property-invalidHandleIds' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-invalidHandleIds' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-invalidHandleIds' class='name expandable'>invalidHandleIds</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>An object who's property names identify the IDs of elements to be considered invalid as drag handles. ...</div><div class='long'><p>An object who's property names identify the IDs of elements to be considered invalid as drag handles.\nA non-null property value identifies the ID as invalid. For example, to prevent\ndragging from being initiated on element ID \"foo\", use:</p>\n\n<pre><code>{\n    foo: true\n}</code></pre>\n\n</div></div></div><div id='property-invalidHandleTypes' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-invalidHandleTypes' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-invalidHandleTypes' class='name expandable'>invalidHandleTypes</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>An object who's property names identify HTML tags to be considered invalid as drag handles. ...</div><div class='long'><p>An object who's property names identify HTML tags to be considered invalid as drag handles.\nA non-null property value identifies the tag as invalid. Defaults to the\nfollowing value which prevents drag operations from being initiated by &lt;a> elements:</p>\n\n<pre><code>{\n    A: \"A\"\n}</code></pre>\n\n</div></div></div><div id='property-isTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-isTarget' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-isTarget' class='name expandable'>isTarget</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>By default, all instances can be a drop target. ...</div><div class='long'><p>By default, all instances can be a drop target.  This can be disabled by\nsetting isTarget to false.</p>\n</div></div></div><div id='property-maintainOffset' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-maintainOffset' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-maintainOffset' class='name expandable'>maintainOffset</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Maintain offsets when we resetconstraints. ...</div><div class='long'><p>Maintain offsets when we resetconstraints.  Set to true when you want\nthe position of the element relative to its parent to stay the same\nwhen the page changes</p>\n</div></div></div><div id='property-moveOnly' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-moveOnly' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-moveOnly' class='name expandable'>moveOnly</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>When set to true, other DD objects in cooperating DDGroups do not receive\nnotification events when this DD object is ...</div><div class='long'><p>When set to true, other DD objects in cooperating DDGroups do not receive\nnotification events when this DD object is dragged over them. Defaults to false.</p>\n</div></div></div><div id='property-padding' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-padding' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-padding' class='name expandable'>padding</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</span></div><div class='description'><div class='short'>The padding configured for this drag and drop object for calculating\nthe drop zone intersection with this object. ...</div><div class='long'><p>The padding configured for this drag and drop object for calculating\nthe drop zone intersection with this object.\nAn array containing the 4 padding values: [top, right, bottom, left]</p>\n</div></div></div><div id='property-primaryButtonOnly' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-primaryButtonOnly' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-primaryButtonOnly' class='name expandable'>primaryButtonOnly</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>By default the drag and drop instance will only respond to the primary\nbutton click (left button for a right-handed m...</div><div class='long'><p>By default the drag and drop instance will only respond to the primary\nbutton click (left button for a right-handed mouse).  Set to true to\nallow drag and drop to start with any mouse click that is propogated\nby the browser</p>\n</div></div></div><div id='property-resizeFrame' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DDProxy' rel='Ext.dd.DDProxy' class='definedIn docClass'>Ext.dd.DDProxy</a><br/><a href='source/DDProxy.html#Ext-dd-DDProxy-property-resizeFrame' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DDProxy-property-resizeFrame' class='name expandable'>resizeFrame</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>By default we resize the drag frame to be the same size as the element\nwe want to drag (this is to get the frame effe...</div><div class='long'><p>By default we resize the drag frame to be the same size as the element\nwe want to drag (this is to get the frame effect).  We can turn it off\nif we want a different behavior.</p>\n</div></div></div><div id='property-scroll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='definedIn docClass'>Ext.dd.DD</a><br/><a href='source/DD.html#Ext-dd-DD-property-scroll' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DD-property-scroll' class='name expandable'>scroll</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>When set to true, the utility automatically tries to scroll the browser\nwindow when a drag and drop element is dragge...</div><div class='long'><p>When set to true, the utility automatically tries to scroll the browser\nwindow when a drag and drop element is dragged near the viewport boundary.\nDefaults to true.</p>\n</div></div></div><div id='property-self' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-property-self' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-property-self' class='name expandable'>self</a><span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the current class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>\nfor a detailed comparison</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); / dependent on 'this'\n\n        return this;\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n</div></div></div><div id='property-xTicks' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-xTicks' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-xTicks' class='name expandable'>xTicks</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</span></div><div class='description'><div class='short'>Array of pixel locations the element will snap to if we specified a\nhorizontal graduation/interval. ...</div><div class='long'><p>Array of pixel locations the element will snap to if we specified a\nhorizontal graduation/interval.  This array is generated automatically\nwhen you define a tick interval.</p>\n</div></div></div><div id='property-yTicks' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-property-yTicks' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-yTicks' class='name expandable'>yTicks</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>[]</span></div><div class='description'><div class='short'>Array of pixel locations the element will snap to if we specified a\nvertical graduation/interval. ...</div><div class='long'><p>Array of pixel locations the element will snap to if we specified a\nvertical graduation/interval.  This array is generated automatically\nwhen you define a tick interval.</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Properties</h3><div id='static-property-dragElId' class='member first-child not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DDProxy' rel='Ext.dd.DDProxy' class='definedIn docClass'>Ext.dd.DDProxy</a><br/><a href='source/DDProxy.html#Ext-dd-DDProxy-static-property-dragElId' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DDProxy-static-property-dragElId' class='name not-expandable'>dragElId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='static-signature'>static</strong></div><div class='description'><div class='short'><p>The default drag frame div id</p>\n</div><div class='long'><p>The default drag frame div id</p>\n</div></div></div></div></div><div id='m-method'><h3 class='members-title'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DDProxy' rel='Ext.dd.DDProxy' class='definedIn docClass'>Ext.dd.DDProxy</a><br/><a href='source/DDProxy.html#Ext-dd-DDProxy-method-constructor' target='_blank' class='viewSource'>view source</a></div><strong class='constructor-signature'>new</strong><a href='#!/api/Ext.dd.DDProxy-method-constructor' class='name expandable'>Ext.dd.DDProxy</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> sGroup, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Creates new DDProxy. ...</div><div class='long'><p>Creates new DDProxy.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the id of the linked html element</p>\n</div></li><li><span class='pre'>sGroup</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the group of related DragDrop objects</p>\n</div></li><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>an object containing configurable attributes.\nValid properties for DDProxy in addition to those in DragDrop:</p>\n\n<ul>\n<li>resizeFrame</li>\n<li>centerFrame</li>\n<li>dragElId</li>\n</ul>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addInvalidHandleClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-addInvalidHandleClass' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-addInvalidHandleClass' class='name expandable'>addInvalidHandleClass</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> cssClass</span> )</div><div class='description'><div class='short'>Lets you specify a css class of elements that will not initiate a drag ...</div><div class='long'><p>Lets you specify a css class of elements that will not initiate a drag</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cssClass</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the class of the elements you wish to ignore</p>\n</div></li></ul></div></div></div><div id='method-addInvalidHandleId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-addInvalidHandleId' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-addInvalidHandleId' class='name expandable'>addInvalidHandleId</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id</span> )</div><div class='description'><div class='short'>Lets you to specify an element id for a child of a drag handle\nthat should not initiate a drag ...</div><div class='long'><p>Lets you to specify an element id for a child of a drag handle\nthat should not initiate a drag</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the element id of the element you wish to ignore</p>\n</div></li></ul></div></div></div><div id='method-addInvalidHandleType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-addInvalidHandleType' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-addInvalidHandleType' class='name expandable'>addInvalidHandleType</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> tagName</span> )</div><div class='description'><div class='short'>Allows you to specify a tag name that should not start a drag operation\nwhen clicked. ...</div><div class='long'><p>Allows you to specify a tag name that should not start a drag operation\nwhen clicked.  This is designed to facilitate embedding links within a\ndrag handle that do something other than start the drag.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tagName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the type of element to exclude</p>\n</div></li></ul></div></div></div><div id='method-addToGroup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-addToGroup' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-addToGroup' class='name expandable'>addToGroup</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> sGroup</span> )</div><div class='description'><div class='short'>Adds this instance to a group of related drag/drop objects. ...</div><div class='long'><p>Adds this instance to a group of related drag/drop objects.  All\ninstances belong to at least one group, and can belong to as many\ngroups as needed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sGroup</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the name of the group</p>\n</div></li></ul></div></div></div><div id='method-alignElWithMouse' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='definedIn docClass'>Ext.dd.DD</a><br/><a href='source/DD.html#Ext-dd-DD-method-alignElWithMouse' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DD-method-alignElWithMouse' class='name expandable'>alignElWithMouse</a>( <span class='pre'>HTMLElement el, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iPageX, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iPageY</span> )</div><div class='description'><div class='short'>Sets the element to the location of the mousedown or click event,\nmaintaining the cursor location relative to the loc...</div><div class='long'><p>Sets the element to the location of the mousedown or click event,\nmaintaining the cursor location relative to the location on the element\nthat was clicked.  Override this if you want to place the element in a\nlocation other than where the cursor is.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : HTMLElement<div class='sub-desc'><p>the element to move</p>\n</div></li><li><span class='pre'>iPageX</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the X coordinate of the mousedown or drag event</p>\n</div></li><li><span class='pre'>iPageY</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the Y coordinate of the mousedown or drag event</p>\n</div></li></ul></div></div></div><div id='method-applyConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='definedIn docClass'>Ext.dd.DD</a><br/><a href='source/DD.html#Ext-dd-DD-method-applyConfig' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DD-method-applyConfig' class='name expandable'>applyConfig</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Sets up config options specific to this class. ...</div><div class='long'><p>Sets up config options specific to this class. Overrides\nExt.dd.DragDrop, but all versions of this method through the\ninheritance chain are called</p>\n</div></div></div><div id='method-autoOffset' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='definedIn docClass'>Ext.dd.DD</a><br/><a href='source/DD.html#Ext-dd-DD-method-autoOffset' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DD-method-autoOffset' class='name expandable'>autoOffset</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iPageX, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iPageY</span> )</div><div class='description'><div class='short'>Sets the pointer offset to the distance between the linked element's top\nleft corner and the location the element was...</div><div class='long'><p>Sets the pointer offset to the distance between the linked element's top\nleft corner and the location the element was clicked</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iPageX</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the X coordinate of the click</p>\n</div></li><li><span class='pre'>iPageY</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the Y coordinate of the click</p>\n</div></li></ul></div></div></div><div id='method-b4Drag' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='definedIn docClass'>Ext.dd.DD</a><br/><a href='source/DD.html#Ext-dd-DD-method-b4Drag' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DD-method-b4Drag' class='name expandable'>b4Drag</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> e</span> )</div><div class='description'><div class='short'>Event that fires prior to the onDrag event. ...</div><div class='long'><p>Event that fires prior to the onDrag event.  Overrides\nExt.dd.DragDrop.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-b4MouseDown' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='definedIn docClass'>Ext.dd.DD</a><br/><a href='source/DD.html#Ext-dd-DD-method-b4MouseDown' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DD-method-b4MouseDown' class='name expandable'>b4MouseDown</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> e</span> )</div><div class='description'><div class='short'>Event that fires prior to the onMouseDown event. ...</div><div class='long'><p>Event that fires prior to the onMouseDown event.  Overrides\nExt.dd.DragDrop.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-cachePosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='definedIn docClass'>Ext.dd.DD</a><br/><a href='source/DD.html#Ext-dd-DD-method-cachePosition' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DD-method-cachePosition' class='name expandable'>cachePosition</a>( <span class='pre'>[<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iPageX], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iPageY]</span> )</div><div class='description'><div class='short'>Saves the most recent position so that we can reset the constraints and\ntick marks on-demand. ...</div><div class='long'><p>Saves the most recent position so that we can reset the constraints and\ntick marks on-demand.  We need to know this so that we can calculate the\nnumber of pixels the element is offset from its original position.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iPageX</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>the current x position (this just makes it so we\ndon't have to look it up again)</p>\n</div></li><li><span class='pre'>iPageY</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>the current y position (this just makes it so we\ndon't have to look it up again)</p>\n</div></li></ul></div></div></div><div id='method-callOverridden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callOverridden' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callOverridden' class='name expandable'>callOverridden</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the original method that was previously overridden with override\n\nExt.define('My.Cat', {\n    constructor: functi...</div><div class='long'><p>Call the original method that was previously overridden with <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">override</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result after calling the overridden method</p>\n</div></li></ul></div></div></div><div id='method-callParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callParent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callParent' class='name expandable'>callParent</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the parent's overridden method. ...</div><div class='long'><p>Call the parent's overridden method. For example:</p>\n\n<pre><code>Ext.define('My.own.A', {\n    constructor: function(test) {\n        alert(test);\n    }\n});\n\nExt.define('My.own.B', {\n    extend: 'My.own.A',\n\n    constructor: function(test) {\n        alert(test);\n\n        this.callParent([test + 1]);\n    }\n});\n\nExt.define('My.own.C', {\n    extend: 'My.own.B',\n\n    constructor: function() {\n        alert(\"Going to call parent's overriden constructor...\");\n\n        this.callParent(arguments);\n    }\n});\n\nvar a = new My.own.A(1); // alerts '1'\nvar b = new My.own.B(1); // alerts '1', then alerts '2'\nvar c = new My.own.C(2); // alerts \"Going to call parent's overriden constructor...\"\n                         // alerts '2', then alerts '3'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callParent(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result from the superclass' method</p>\n</div></li></ul></div></div></div><div id='method-clearConstraints' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-clearConstraints' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-clearConstraints' class='name expandable'>clearConstraints</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Clears any constraints applied to this instance. ...</div><div class='long'><p>Clears any constraints applied to this instance.  Also clears ticks\nsince they can't exist independent of a constraint at this time.</p>\n</div></div></div><div id='method-clearTicks' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-clearTicks' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-clearTicks' class='name expandable'>clearTicks</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Clears any tick interval defined for this instance ...</div><div class='long'><p>Clears any tick interval defined for this instance</p>\n</div></div></div><div id='method-constrainTo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-constrainTo' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-constrainTo' class='name expandable'>constrainTo</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> constrainTo, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> pad], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> inContent]</span> )</div><div class='description'><div class='short'>Initializes the drag drop object's constraints to restrict movement to a certain element. ...</div><div class='long'><p>Initializes the drag drop object's constraints to restrict movement to a certain element.</p>\n\n<p>Usage:</p>\n\n<pre><code>var dd = new Ext.dd.DDProxy(\"dragDiv1\", \"proxytest\",\n               { dragElId: \"existingProxyDiv\" });\ndd.startDrag = function(){\n    this.constrainTo(\"parent-id\");\n};\n</code></pre>\n\n<p>Or you can initalize it using the <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> object:</p>\n\n<pre><code>Ext.get(\"dragDiv1\").initDDProxy(\"proxytest\", {dragElId: \"existingProxyDiv\"}, {\n    startDrag : function(){\n        this.constrainTo(\"parent-id\");\n    }\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>constrainTo</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The element or element ID to constrain to.</p>\n</div></li><li><span class='pre'>pad</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Pad provides a way to specify \"padding\" of the constraints,\nand can be either a number for symmetrical padding (4 would be equal to <code>{left:4, right:4, top:4, bottom:4}</code>) or\nan object containing the sides to pad. For example: <code>{right:10, bottom:10}</code></p>\n</div></li><li><span class='pre'>inContent</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>Constrain the draggable in the content box of the element (inside padding and borders)</p>\n</div></li></ul></div></div></div><div id='method-createFrame' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DDProxy' rel='Ext.dd.DDProxy' class='definedIn docClass'>Ext.dd.DDProxy</a><br/><a href='source/DDProxy.html#Ext-dd-DDProxy-method-createFrame' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DDProxy-method-createFrame' class='name expandable'>createFrame</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Creates the proxy element if it does not yet exist ...</div><div class='long'><p>Creates the proxy element if it does not yet exist</p>\n</div></div></div><div id='method-endDrag' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-endDrag' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-endDrag' class='name expandable'>endDrag</a>( <span class='pre'>Event e</span> )</div><div class='description'><div class='short'>Called when we are done dragging the object ...</div><div class='long'><p>Called when we are done dragging the object</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mouseup event</p>\n</div></li></ul></div></div></div><div id='method-getDragEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-getDragEl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-getDragEl' class='name expandable'>getDragEl</a>( <span class='pre'></span> ) : HTMLElement</div><div class='description'><div class='short'>Returns a reference to the actual element to drag. ...</div><div class='long'><p>Returns a reference to the actual element to drag.  By default this is\nthe same as the html element, but it can be assigned to another\nelement. An example of this can be found in <a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a></p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>the html element</p>\n</div></li></ul></div></div></div><div id='method-getEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-getEl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-getEl' class='name expandable'>getEl</a>( <span class='pre'></span> ) : HTMLElement</div><div class='description'><div class='short'>Returns a reference to the linked element ...</div><div class='long'><p>Returns a reference to the linked element</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>the html element</p>\n</div></li></ul></div></div></div><div id='method-init' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-init' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-init' class='name expandable'>init</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> sGroup, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> )</div><div class='description'><div class='short'>Sets up the DragDrop object. ...</div><div class='long'><p>Sets up the DragDrop object.  Must be called in the constructor of any\n<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a> subclass</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the id of the linked element</p>\n</div></li><li><span class='pre'>sGroup</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the group of related items</p>\n</div></li><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>configuration attributes</p>\n</div></li></ul></div></div></div><div id='method-initConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-initConfig' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-initConfig' class='name expandable'>initConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Initialize configuration for this class. ...</div><div class='long'><p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code>Ext.define('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n\n        return this;\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>mixins The mixin prototypes as key - value pairs</p>\n</div></li></ul></div></div></div><div id='method-initFrame' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DDProxy' rel='Ext.dd.DDProxy' class='definedIn docClass'>Ext.dd.DDProxy</a><br/><a href='source/DDProxy.html#Ext-dd-DDProxy-method-initFrame' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DDProxy-method-initFrame' class='name expandable'>initFrame</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Initialization for the drag frame element. ...</div><div class='long'><p>Initialization for the drag frame element.  Must be called in the\nconstructor of all subclasses</p>\n</div></div></div><div id='method-initTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-initTarget' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-initTarget' class='name expandable'>initTarget</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> sGroup, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> )</div><div class='description'><div class='short'>Initializes Targeting functionality only... ...</div><div class='long'><p>Initializes Targeting functionality only... the object does not\nget a mousedown handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the id of the linked element</p>\n</div></li><li><span class='pre'>sGroup</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the group of related items</p>\n</div></li><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>configuration attributes</p>\n</div></li></ul></div></div></div><div id='method-isLocked' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-isLocked' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-isLocked' class='name expandable'>isLocked</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if this instance is locked, or the drag drop mgr is locked\n(meaning that all drag/drop is disabled on th...</div><div class='long'><p>Returns true if this instance is locked, or the drag drop mgr is locked\n(meaning that all drag/drop is disabled on the page.)</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>true if this obj or all drag/drop is locked, else\nfalse</p>\n</div></li></ul></div></div></div><div id='method-isValidHandleChild' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-isValidHandleChild' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-isValidHandleChild' class='name expandable'>isValidHandleChild</a>( <span class='pre'>HTMLElement node</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks the tag exclusion list to see if this click should be ignored ...</div><div class='long'><p>Checks the tag exclusion list to see if this click should be ignored</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : HTMLElement<div class='sub-desc'><p>the HTMLElement to evaluate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>true if this is a valid tag type, false if not</p>\n</div></li></ul></div></div></div><div id='method-lock' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-lock' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-lock' class='name expandable'>lock</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Locks this instance ...</div><div class='long'><p>Locks this instance</p>\n</div></div></div><div id='method-onAvailable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-onAvailable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onAvailable' class='name expandable'>onAvailable</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Override the onAvailable method to do what is needed after the initial\nposition was determined. ...</div><div class='long'><p>Override the onAvailable method to do what is needed after the initial\nposition was determined.</p>\n</div></div></div><div id='method-onDrag' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-onDrag' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onDrag' class='name expandable'>onDrag</a>( <span class='pre'>Event e</span> )</div><div class='description'><div class='short'>Abstract method called during the onMouseMove event while dragging an\nobject. ...</div><div class='long'><p>Abstract method called during the onMouseMove event while dragging an\nobject.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mousemove event</p>\n</div></li></ul></div></div></div><div id='method-onDragDrop' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-onDragDrop' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onDragDrop' class='name expandable'>onDragDrop</a>( <span class='pre'>Event e, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>[] id</span> )</div><div class='description'><div class='short'>Abstract method called when this item is dropped on another DragDrop\nobj ...</div><div class='long'><p>Abstract method called when this item is dropped on another DragDrop\nobj</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mouseup event</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>[]<div class='sub-desc'><p>In POINT mode, the element\nid this was dropped on.  In INTERSECT mode, an array of dd items this\nwas dropped on.</p>\n</div></li></ul></div></div></div><div id='method-onDragEnter' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-onDragEnter' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onDragEnter' class='name expandable'>onDragEnter</a>( <span class='pre'>Event e, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>[] id</span> )</div><div class='description'><div class='short'>Abstract method called when this element fist begins hovering over\nanother DragDrop obj ...</div><div class='long'><p>Abstract method called when this element fist begins hovering over\nanother DragDrop obj</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mousemove event</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>[]<div class='sub-desc'><p>In POINT mode, the element\nid this is hovering over.  In INTERSECT mode, an array of one or more\ndragdrop items being hovered over.</p>\n</div></li></ul></div></div></div><div id='method-onDragOut' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-onDragOut' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onDragOut' class='name expandable'>onDragOut</a>( <span class='pre'>Event e, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>[] id</span> )</div><div class='description'><div class='short'>Abstract method called when we are no longer hovering over an element ...</div><div class='long'><p>Abstract method called when we are no longer hovering over an element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mousemove event</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>[]<div class='sub-desc'><p>In POINT mode, the element\nid this was hovering over.  In INTERSECT mode, an array of dd items\nthat the mouse is no longer over.</p>\n</div></li></ul></div></div></div><div id='method-onDragOver' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-onDragOver' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onDragOver' class='name expandable'>onDragOver</a>( <span class='pre'>Event e, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>[] id</span> )</div><div class='description'><div class='short'>Abstract method called when this element is hovering over another\nDragDrop obj ...</div><div class='long'><p>Abstract method called when this element is hovering over another\nDragDrop obj</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mousemove event</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>[]<div class='sub-desc'><p>In POINT mode, the element\nid this is hovering over.  In INTERSECT mode, an array of dd items\nbeing hovered over.</p>\n</div></li></ul></div></div></div><div id='method-onInvalidDrop' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-onInvalidDrop' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onInvalidDrop' class='name expandable'>onInvalidDrop</a>( <span class='pre'>Event e</span> )</div><div class='description'><div class='short'>Abstract method called when this item is dropped on an area with no\ndrop target ...</div><div class='long'><p>Abstract method called when this item is dropped on an area with no\ndrop target</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mouseup event</p>\n</div></li></ul></div></div></div><div id='method-onMouseDown' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-onMouseDown' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onMouseDown' class='name expandable'>onMouseDown</a>( <span class='pre'>Event e</span> )</div><div class='description'><div class='short'>Called when a drag/drop obj gets a mousedown ...</div><div class='long'><p>Called when a drag/drop obj gets a mousedown</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mousedown event</p>\n</div></li></ul></div></div></div><div id='method-onMouseUp' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-onMouseUp' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onMouseUp' class='name expandable'>onMouseUp</a>( <span class='pre'>Event e</span> )</div><div class='description'><div class='short'>Called when a drag/drop obj gets a mouseup ...</div><div class='long'><p>Called when a drag/drop obj gets a mouseup</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mouseup event</p>\n</div></li></ul></div></div></div><div id='method-removeFromGroup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-removeFromGroup' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-removeFromGroup' class='name expandable'>removeFromGroup</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> sGroup</span> )</div><div class='description'><div class='short'>Removes this instance from the supplied interaction group ...</div><div class='long'><p>Removes this instance from the supplied interaction group</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sGroup</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The group to drop</p>\n</div></li></ul></div></div></div><div id='method-removeInvalidHandleClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-removeInvalidHandleClass' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-removeInvalidHandleClass' class='name expandable'>removeInvalidHandleClass</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> cssClass</span> )</div><div class='description'><div class='short'>Unsets an invalid css class ...</div><div class='long'><p>Unsets an invalid css class</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cssClass</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the class of the element(s) you wish to\nre-enable</p>\n</div></li></ul></div></div></div><div id='method-removeInvalidHandleId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-removeInvalidHandleId' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-removeInvalidHandleId' class='name expandable'>removeInvalidHandleId</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id</span> )</div><div class='description'><div class='short'>Unsets an invalid handle id ...</div><div class='long'><p>Unsets an invalid handle id</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the id of the element to re-enable</p>\n</div></li></ul></div></div></div><div id='method-removeInvalidHandleType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-removeInvalidHandleType' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-removeInvalidHandleType' class='name expandable'>removeInvalidHandleType</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> tagName</span> )</div><div class='description'><div class='short'>Unsets an excluded tag name set by addInvalidHandleType ...</div><div class='long'><p>Unsets an excluded tag name set by addInvalidHandleType</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tagName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the type of element to unexclude</p>\n</div></li></ul></div></div></div><div id='method-resetConstraints' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-resetConstraints' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-resetConstraints' class='name expandable'>resetConstraints</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> maintainOffset</span> )</div><div class='description'><div class='short'>Must be called if you manually reposition a dd element. ...</div><div class='long'><p>Must be called if you manually reposition a dd element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maintainOffset</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setDelta' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='definedIn docClass'>Ext.dd.DD</a><br/><a href='source/DD.html#Ext-dd-DD-method-setDelta' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DD-method-setDelta' class='name expandable'>setDelta</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iDeltaX, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iDeltaY</span> )</div><div class='description'><div class='short'>Sets the pointer offset. ...</div><div class='long'><p>Sets the pointer offset.  You can call this directly to force the\noffset to be in a particular location (e.g., pass in 0,0 to set it\nto the center of the object)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iDeltaX</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the distance from the left</p>\n</div></li><li><span class='pre'>iDeltaY</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the distance from the top</p>\n</div></li></ul></div></div></div><div id='method-setDragElId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-setDragElId' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setDragElId' class='name expandable'>setDragElId</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id</span> )</div><div class='description'><div class='short'>Allows you to specify that an element other than the linked element\nwill be moved with the cursor during a drag ...</div><div class='long'><p>Allows you to specify that an element other than the linked element\nwill be moved with the cursor during a drag</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the id of the element that will be used to initiate the drag</p>\n</div></li></ul></div></div></div><div id='method-setDragElPos' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='definedIn docClass'>Ext.dd.DD</a><br/><a href='source/DD.html#Ext-dd-DD-method-setDragElPos' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DD-method-setDragElPos' class='name expandable'>setDragElPos</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iPageX, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iPageY</span> )</div><div class='description'><div class='short'>Sets the drag element to the location of the mousedown or click event,\nmaintaining the cursor location relative to th...</div><div class='long'><p>Sets the drag element to the location of the mousedown or click event,\nmaintaining the cursor location relative to the location on the element\nthat was clicked.  Override this if you want to place the element in a\nlocation other than where the cursor is.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iPageX</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the X coordinate of the mousedown or drag event</p>\n</div></li><li><span class='pre'>iPageY</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the Y coordinate of the mousedown or drag event</p>\n</div></li></ul></div></div></div><div id='method-setHandleElId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-setHandleElId' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setHandleElId' class='name expandable'>setHandleElId</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id</span> )</div><div class='description'><div class='short'>Allows you to specify a child of the linked element that should be\nused to initiate the drag operation. ...</div><div class='long'><p>Allows you to specify a child of the linked element that should be\nused to initiate the drag operation.  An example of this would be if\nyou have a content div with text and links.  Clicking anywhere in the\ncontent area would normally start the drag operation.  Use this method\nto specify that an element inside of the content div is the element\nthat starts the drag operation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the id of the element that will be used to\ninitiate the drag.</p>\n</div></li></ul></div></div></div><div id='method-setInitPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-setInitPosition' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setInitPosition' class='name expandable'>setInitPosition</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> diffX, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> diffY</span> )</div><div class='description'><div class='short'>Stores the initial placement of the linked element. ...</div><div class='long'><p>Stores the initial placement of the linked element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>diffX</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the X offset, default 0</p>\n</div></li><li><span class='pre'>diffY</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the Y offset, default 0</p>\n</div></li></ul></div></div></div><div id='method-setOuterHandleElId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-setOuterHandleElId' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setOuterHandleElId' class='name expandable'>setOuterHandleElId</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id</span> )</div><div class='description'><div class='short'>Allows you to set an element outside of the linked element as a drag\nhandle ...</div><div class='long'><p>Allows you to set an element outside of the linked element as a drag\nhandle</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the id of the element that will be used to initiate the drag</p>\n</div></li></ul></div></div></div><div id='method-setPadding' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-setPadding' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setPadding' class='name expandable'>setPadding</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iTop, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iRight, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iBot, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iLeft</span> )</div><div class='description'><div class='short'>Configures the padding for the target zone in px. ...</div><div class='long'><p>Configures the padding for the target zone in px.  Effectively expands\n(or reduces) the virtual object size for targeting calculations.\nSupports css-style shorthand; if only one parameter is passed, all sides\nwill have that padding, and if only two are passed, the top and bottom\nwill have the first param, the left and right the second.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iTop</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Top pad</p>\n</div></li><li><span class='pre'>iRight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Right pad</p>\n</div></li><li><span class='pre'>iBot</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Bot pad</p>\n</div></li><li><span class='pre'>iLeft</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Left pad</p>\n</div></li></ul></div></div></div><div id='method-setXConstraint' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-setXConstraint' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setXConstraint' class='name expandable'>setXConstraint</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iLeft, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iRight, [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iTickSize]</span> )</div><div class='description'><div class='short'>By default, the element can be dragged any place on the screen. ...</div><div class='long'><p>By default, the element can be dragged any place on the screen.  Use\nthis method to limit the horizontal travel of the element.  Pass in\n0,0 for the parameters if you want to lock the drag to the y axis.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iLeft</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the number of pixels the element can move to the left</p>\n</div></li><li><span class='pre'>iRight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the number of pixels the element can move to the\nright</p>\n</div></li><li><span class='pre'>iTickSize</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>parameter for specifying that the\nelement should move iTickSize pixels at a time.</p>\n</div></li></ul></div></div></div><div id='method-setYConstraint' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-setYConstraint' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setYConstraint' class='name expandable'>setYConstraint</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iUp, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iDown, [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> iTickSize]</span> )</div><div class='description'><div class='short'>By default, the element can be dragged any place on the screen. ...</div><div class='long'><p>By default, the element can be dragged any place on the screen.  Set\nthis to limit the vertical travel of the element.  Pass in 0,0 for the\nparameters if you want to lock the drag to the x axis.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iUp</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the number of pixels the element can move up</p>\n</div></li><li><span class='pre'>iDown</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the number of pixels the element can move down</p>\n</div></li><li><span class='pre'>iTickSize</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>parameter for specifying that the\nelement should move iTickSize pixels at a time.</p>\n</div></li></ul></div></div></div><div id='method-startDrag' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-startDrag' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-startDrag' class='name expandable'>startDrag</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> X, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> Y</span> )</div><div class='description'><div class='short'>Abstract method called after a drag/drop object is clicked\nand the drag or mousedown time thresholds have beeen met. ...</div><div class='long'><p>Abstract method called after a drag/drop object is clicked\nand the drag or mousedown time thresholds have beeen met.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>X</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>click location</p>\n</div></li><li><span class='pre'>Y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>click location</p>\n</div></li></ul></div></div></div><div id='method-statics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-statics' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-statics' class='name expandable'>statics</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n\n        return this;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-toString' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-toString' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-toString' class='name expandable'>toString</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>toString method ...</div><div class='long'><p>toString method</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>string representation of the dd obj</p>\n</div></li></ul></div></div></div><div id='method-unlock' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-unlock' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-unlock' class='name expandable'>unlock</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Unlocks this instace ...</div><div class='long'><p>Unlocks this instace</p>\n</div></div></div><div id='method-unreg' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='definedIn docClass'>Ext.dd.DragDrop</a><br/><a href='source/DragDrop.html#Ext-dd-DragDrop-method-unreg' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-unreg' class='name expandable'>unreg</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all drag and drop hooks for this element ...</div><div class='long'><p>Removes all drag and drop hooks for this element</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-addStatics' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-addStatics' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-addStatics' class='name expandable'>addStatics</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Add / override static properties of this class. ...</div><div class='long'><p>Add / override static properties of this class.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.addStatics({\n    someProperty: 'someValue',      // My.cool.Class.someProperty = 'someValue'\n    method1: function() { ... },    // My.cool.Class.method1 = function() { ... };\n    method2: function() { ... }     // My.cool.Class.method2 = function() { ... };\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-borrow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-borrow' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-borrow' class='name expandable'>borrow</a>( <span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a> fromClass, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Borrow another class' members to the prototype of this class. ...</div><div class='long'><p>Borrow another class' members to the prototype of this class.</p>\n\n<pre><code>Ext.define('Bank', {\n    money: '$$$',\n    printMoney: function() {\n        alert('$$$$$$$');\n    }\n});\n\nExt.define('Thief', {\n    ...\n});\n\nThief.borrow(Bank, ['money', 'printMoney']);\n\nvar steve = new Thief();\n\nalert(steve.money); // alerts '$$$'\nsteve.printMoney(); // alerts '$$$$$$$'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fromClass</span> : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><div class='sub-desc'><p>The class to borrow members from</p>\n</div></li><li><span class='pre'>members</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The names of the members to borrow</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-create' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-create' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-create' class='name expandable'>create</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Create a new instance of this Class. ...</div><div class='long'><p>Create a new instance of this Class.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.create({\n    someConfig: true\n});\n</code></pre>\n\n<p>All parameters are passed to the constructor of the class.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>the created instance.</p>\n</div></li></ul></div></div></div><div id='static-method-createAlias' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-createAlias' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-createAlias' class='name expandable'>createAlias</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> alias, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> origin</span> )<strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Create aliases for existing prototype methods. ...</div><div class='long'><p>Create aliases for existing prototype methods. Example:</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    method1: function() { ... },\n    method2: function() { ... }\n});\n\nvar test = new My.cool.Class();\n\nMy.cool.Class.createAlias({\n    method3: 'method1',\n    method4: 'method2'\n});\n\ntest.method3(); // test.method1()\n\nMy.cool.Class.createAlias('method5', 'method3');\n\ntest.method5(); // test.method3() -&gt; test.method1()\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>alias</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The new method name, or an object to set multiple aliases. See\n<a href=\"#!/api/Ext.Function-method-flexSetter\" rel=\"Ext.Function-method-flexSetter\" class=\"docClass\">flexSetter</a></p>\n</div></li><li><span class='pre'>origin</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The original method name</p>\n</div></li></ul></div></div></div><div id='static-method-getName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-getName' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-getName' class='name expandable'>getName</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Get the current class' name in string format. ...</div><div class='long'><p>Get the current class' name in string format.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    constructor: function() {\n        alert(this.self.getName()); // alerts 'My.cool.Class'\n    }\n});\n\nMy.cool.Class.getName(); // 'My.cool.Class'\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>className</p>\n</div></li></ul></div></div></div><div id='static-method-implement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-implement' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-implement' class='name expandable'>implement</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> )<strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Add methods / properties to the prototype of this class. ...</div><div class='long'><p>Add methods / properties to the prototype of this class.</p>\n\n<pre><code>Ext.define('My.awesome.Cat', {\n    constructor: function() {\n        ...\n    }\n});\n\n My.awesome.Cat.implement({\n     meow: function() {\n        alert('Meowww...');\n     }\n });\n\n var kitty = new My.awesome.Cat;\n kitty.meow();\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-override' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-static-method-override' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-static-method-override' class='name expandable'>override</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static-signature'>static</strong></div><div class='description'><div class='short'>Override prototype members of this class. ...</div><div class='long'><p>Override prototype members of this class. Overridden methods can be invoked via\n<a href=\"#!/api/Ext.Base-method-callOverridden\" rel=\"Ext.Base-method-callOverridden\" class=\"docClass\">callOverridden</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"meta":{},"requires":[],"deprecated":null,"extends":"Ext.dd.DD","inheritable":false,"static":false,"superclasses":["Ext.Base","Ext.dd.DragDrop","Ext.dd.DD","Ext.dd.DDProxy"],"singleton":false,"code_type":"ext_define","alias":null,"statics":{"property":[{"tagname":"property","deprecated":null,"static":true,"owner":"Ext.dd.DDProxy","template":null,"required":null,"protected":false,"name":"dragElId","id":"static-property-dragElId"}],"css_var":[],"css_mixin":[],"cfg":[],"method":[{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"addStatics","id":"static-method-addStatics"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"borrow","id":"static-method-borrow"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"create","id":"static-method-create"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"createAlias","id":"static-method-createAlias"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"getName","id":"static-method-getName"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"implement","id":"static-method-implement"},{"tagname":"method","deprecated":null,"static":true,"owner":"Ext.Base","template":false,"required":null,"protected":false,"name":"override","id":"static-method-override"}],"event":[]},"subclasses":["Ext.dd.DragSource"],"uses":[],"protected":false,"mixins":[],"members":{"property":[{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"available","id":"property-available"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DDProxy","template":null,"required":null,"protected":false,"name":"centerFrame","id":"property-centerFrame"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"config","id":"property-config"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"defaultPadding","id":"property-defaultPadding"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"groups","id":"property-groups"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"hasOuterHandles","id":"property-hasOuterHandles"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"id","id":"property-id"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"ignoreSelf","id":"property-ignoreSelf"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"invalidHandleClasses","id":"property-invalidHandleClasses"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"invalidHandleIds","id":"property-invalidHandleIds"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"invalidHandleTypes","id":"property-invalidHandleTypes"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"isTarget","id":"property-isTarget"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"maintainOffset","id":"property-maintainOffset"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"moveOnly","id":"property-moveOnly"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"padding","id":"property-padding"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"primaryButtonOnly","id":"property-primaryButtonOnly"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DDProxy","template":null,"required":null,"protected":false,"name":"resizeFrame","id":"property-resizeFrame"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DD","template":null,"required":null,"protected":false,"name":"scroll","id":"property-scroll"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Base","template":null,"required":null,"protected":true,"name":"self","id":"property-self"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"xTicks","id":"property-xTicks"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":null,"required":null,"protected":false,"name":"yTicks","id":"property-yTicks"}],"css_var":[],"css_mixin":[],"cfg":[],"method":[{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DDProxy","template":false,"required":null,"protected":false,"name":"constructor","id":"method-constructor"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"addInvalidHandleClass","id":"method-addInvalidHandleClass"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"addInvalidHandleId","id":"method-addInvalidHandleId"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"addInvalidHandleType","id":"method-addInvalidHandleType"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"addToGroup","id":"method-addToGroup"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DD","template":false,"required":null,"protected":false,"name":"alignElWithMouse","id":"method-alignElWithMouse"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DD","template":false,"required":null,"protected":false,"name":"applyConfig","id":"method-applyConfig"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DD","template":false,"required":null,"protected":false,"name":"autoOffset","id":"method-autoOffset"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DD","template":false,"required":null,"protected":false,"name":"b4Drag","id":"method-b4Drag"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DD","template":false,"required":null,"protected":false,"name":"b4MouseDown","id":"method-b4MouseDown"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DD","template":false,"required":null,"protected":false,"name":"cachePosition","id":"method-cachePosition"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callOverridden","id":"method-callOverridden"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callParent","id":"method-callParent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"clearConstraints","id":"method-clearConstraints"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"clearTicks","id":"method-clearTicks"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"constrainTo","id":"method-constrainTo"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DDProxy","template":false,"required":null,"protected":false,"name":"createFrame","id":"method-createFrame"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"endDrag","id":"method-endDrag"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"getDragEl","id":"method-getDragEl"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"getEl","id":"method-getEl"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"init","id":"method-init"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"initConfig","id":"method-initConfig"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DDProxy","template":false,"required":null,"protected":false,"name":"initFrame","id":"method-initFrame"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"initTarget","id":"method-initTarget"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"isLocked","id":"method-isLocked"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"isValidHandleChild","id":"method-isValidHandleChild"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"lock","id":"method-lock"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"onAvailable","id":"method-onAvailable"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"onDrag","id":"method-onDrag"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"onDragDrop","id":"method-onDragDrop"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"onDragEnter","id":"method-onDragEnter"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"onDragOut","id":"method-onDragOut"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"onDragOver","id":"method-onDragOver"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"onInvalidDrop","id":"method-onInvalidDrop"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"onMouseDown","id":"method-onMouseDown"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"onMouseUp","id":"method-onMouseUp"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"removeFromGroup","id":"method-removeFromGroup"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"removeInvalidHandleClass","id":"method-removeInvalidHandleClass"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"removeInvalidHandleId","id":"method-removeInvalidHandleId"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"removeInvalidHandleType","id":"method-removeInvalidHandleType"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"resetConstraints","id":"method-resetConstraints"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DD","template":false,"required":null,"protected":false,"name":"setDelta","id":"method-setDelta"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"setDragElId","id":"method-setDragElId"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DD","template":false,"required":null,"protected":false,"name":"setDragElPos","id":"method-setDragElPos"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"setHandleElId","id":"method-setHandleElId"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"setInitPosition","id":"method-setInitPosition"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"setOuterHandleElId","id":"method-setOuterHandleElId"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"setPadding","id":"method-setPadding"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"setXConstraint","id":"method-setXConstraint"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"setYConstraint","id":"method-setYConstraint"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"startDrag","id":"method-startDrag"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"statics","id":"method-statics"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"toString","id":"method-toString"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"unlock","id":"method-unlock"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDrop","template":false,"required":null,"protected":false,"name":"unreg","id":"method-unreg"}],"event":[]},"private":false,"component":false,"name":"Ext.dd.DDProxy","alternateClassNames":[],"id":"class-Ext.dd.DDProxy","mixedInto":[],"xtypes":{},"files":[{"href":"DDProxy.html#Ext-dd-DDProxy","filename":"DDProxy.js"}]});