/*
 * Components.hpp
 * Copyright (C) 2017-2018  Belledonne Communications, Grenoble, France
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *  Created on: April 6, 2017
 *      Author: Ronan Abhamon
 */

#ifndef COMPONENTS_H_
#define COMPONENTS_H_

#include "assistant/AssistantModel.hpp"
#include "authentication/AuthenticationNotifier.hpp"
#include "calls/CallsListModel.hpp"
#include "calls/CallsListProxyModel.hpp"
#include "camera/Camera.hpp"
#include "camera/CameraPreview.hpp"
#include "chat/ChatProxyModel.hpp"
#include "codecs/AudioCodecsModel.hpp"
#include "codecs/VideoCodecsModel.hpp"
#include "conference/ConferenceAddModel.hpp"
#include "conference/ConferenceModel.hpp"
#include "contacts/ContactsListProxyModel.hpp"
#include "core/CoreManager.hpp"
#include "file/FileDownloader.hpp"
#include "file/FileExtractor.hpp"
#include "presence/OwnPresenceModel.hpp"
#include "settings/AccountSettingsModel.hpp"
#include "sip-addresses/SipAddressesProxyModel.hpp"
#include "sound-player/SoundPlayer.hpp"
#include "telephone-numbers/TelephoneNumbersModel.hpp"
#include "timeline/TimelineModel.hpp"
#include "url-handlers/UrlHandlers.hpp"

#include "other/colors/Colors.hpp"
#include "other/clipboard/Clipboard.hpp"
#include "other/text-to-speech/TextToSpeech.hpp"
#include "other/units/Units.hpp"

#endif // COMPONENTS_H_
