import QtQuick 2.7

import Linphone.Styles 1.0

// ===================================================================

Column {
  property alias sipAddress: sipAddress.text
  property alias username: username.text
  property color sipAddressColor: ContactDescriptionStyle.sipAddress.color
  property color usernameColor: ContactDescriptionStyle.username.color
  property int horizontalTextAlignment

  // Username.
  Text {
    id: username

    color: usernameColor
    elide: Text.ElideRight
    font.bold: true
    font.pointSize: ContactDescriptionStyle.username.fontSize
    height: parent.height / 2
    horizontalAlignment: horizontalTextAlignment
    verticalAlignment: Text.AlignBottom
    width: parent.width
  }

  // Sip address.
  Text {
    id: sipAddress

    color: sipAddressColor
    elide: Text.ElideRight
    font.pointSize: ContactDescriptionStyle.sipAddress.fontSize
    height: parent.height / 2
    horizontalAlignment: horizontalTextAlignment
    verticalAlignment: Text.AlignTop
    width: parent.width
  }
}
