<?php

namespace App\Models\Faqs;

use Illuminate\Database\Eloquent\Model;
use App\Models\Faqs\Traits\Attribute\FaqAttribute;
use Illuminate\Database\Eloquent\SoftDeletes;

class Faq extends Model
{
    use FaqAttribute, SoftDeletes;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['question','answer','status'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    	$this->table = config("access.faqs_table");
    }
}
