<?php

namespace App\Models\Module\Traits\Attribute;

/**
 * Class ModuleAttribute.
 */
trait ModuleAttribute
{
    /**
     * @return string
     */
    public function getEditButtonAttribute()
    {
        // if(access()->allow('edit-blog'))
        // {
            return '<a href="'.route('admin.modules.edit', $this).'" class="btn btn-flat btn-default">
                    <i data-toggle="tooltip" data-placement="top" title="Edit" class="fa fa-pencil"></i>
                </a>';
        // }
    }

    /**
     * @return string
     */
    public function getDeleteButtonAttribute()
    {
        // if(access()->allow('delete-blog'))
        // {
            return '<a href="'.route('admin.blogs.destroy', $this).'" 
                    class="btn btn-flat btn-default" data-method="delete"
                    data-trans-button-cancel="'.trans('buttons.general.cancel').'"
                    data-trans-button-confirm="'.trans('buttons.general.crud.delete').'"
                    data-trans-title="'.trans('strings.backend.general.are_you_sure').'">
                        <i data-toggle="tooltip" data-placement="top" title="Delete" class="fa fa-trash"></i>
                </a>';
        // }
    }

    /**
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return '<div class="btn-group action-btn">'.
                $this->getEditButtonAttribute().
                // $this->getDeleteButtonAttribute().
                '</div>';
    }
}
