<?php

namespace App\Models\BlogTags\Traits\Attribute;

/**
 * Class BlogTagAttribute.
 */
trait BlogTagAttribute
{
    /**
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return '<div class="btn-group action-btn">
                    '.$this->getEditButtonAttribute('edit-blog-tag', 'admin.blogtags.edit').'
                    '.$this->getDeleteButtonAttribute('delete-blog-tag', 'admin.blogtags.destroy').'
                </div>';
    }
    
    /**
     * @return string
     */
    public function getStatusLabelAttribute()
    {
        if ($this->isActive()) {
            return "<label class='label label-success'>".trans('labels.general.active').'</label>';
        }

        return "<label class='label label-danger'>".trans('labels.general.inactive').'</label>';
    }

    /**
     * @return bool
     */
    public function isActive()
    {
        return $this->status == 1;
    }
}
