<?php

namespace App\Api\V1\Requests;
use Config;
use Dingo\Api\Http\FormRequest;

class RegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {    
        return Config::get('api_validation.register.rules');
    }
    /**
     * Get the validation massages that apply to the rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'state_id.required' => trans('validation.api.register.state_required'),
            'city_id.required' => trans('validation.api.register.city_required'),
        ];
    }
}
