---
title: Overview
sort_rank: 1
---

# Overview

## What is Prometheus?

[Prometheus](https://github.com/prometheus) is an open-source systems
monitoring and alerting toolkit built at [SoundCloud](http://soundcloud.com).
Since its inception in 2012, it has become the standard for instrumenting new
services at SoundCloud and is seeing growing external usage and contributions.

### Features

Prometheus's main features are:

* a multi-dimensional [data model](/docs/concepts/data_model/) (time series identified by metric name and key/value pairs)
* a [flexible query language](/docs/querying/basics/)
  to leverage this dimensionality
* no reliance on distributed storage; single server nodes are autonomous
* time series collection happens via a pull model over HTTP
* [pushing time series](/docs/instrumenting/pushing/) is supported via an intermediary gateway
* targets are discovered via service discovery or static configuration
* multiple modes of graphing and dashboarding support

### Components

The Prometheus ecosystem consists of multiple components, many of which are
optional:

* the main [Prometheus server](https://github.com/prometheus/prometheus) which scrapes and stores time series data
* [client libraries](/docs/instrumenting/clientlibs/) for instrumenting application code
* a [push gateway](https://github.com/prometheus/pushgateway) for supporting short-lived jobs
* a [GUI-based dashboard builder](/docs/visualization/promdash/) based on Rails/SQL
* special-purpose [exporters](/docs/instrumenting/exporters/) (for HAProxy, StatsD, Ganglia, etc.)
* an (experimental) [alert manager](https://github.com/prometheus/alertmanager)
* a [command-line querying tool](https://github.com/prometheus/prometheus_cli)
* various support tools

Most Prometheus components are written in [Go](https://golang.org/), making
them easy to build and deploy as static binaries.

### Architecture

This diagram illustrates the overall architecture of Prometheus and some of
its ecosystem components:

![Prometheus architecture](/assets/architecture.svg)

Prometheus servers scrape metrics from instrumented jobs, either directly or
via an intermediary push gateway for short-lived jobs. They store all scraped
samples locally and run rules over this data to either record new timeseries
from existing data or generate alerts. PromDash or other API consumers can be
used to visualize the collected data.

## When does it fit?

Prometheus works well for recording any purely numeric time series. It fits
both machine-centric monitoring as well as monitoring of highly dynamic
service-oriented architectures. In a world of microservices, its support for
multi-dimensional data collection and querying is a particular strength.

Prometheus is designed for reliability, to be the system you go to
during an outage to allow you to quickly diagnose problems. Each Prometheus
server is standalone, not depending on network storage or other remote services.
You can rely on it when other parts of your infrastructure are broken, and
you don't have to set up complex infrastructure to use it.

## When does it not fit?

Prometheus values reliability. You can always view what statistics are
available about your system, even under failure conditions. If you need 100%
accuracy, such as for per-request billing, Prometheus is not a good choice as
the collected data will likely not be detailed and complete enough. In such a
case you would be best off using some other system to collect and analyse the
data for billing, and Prometheus for the rest of your monitoring.
