---
title: PromCon 2016 - It's a wrap!
created_at: 2016-09-04
kind: article
author_name: Julius Volz
---

## What happened

Last week, eighty Prometheus users and developers from around the world came
together for two days in Berlin for the first-ever conference about the
Prometheus monitoring system: [PromCon 2016](https://promcon.io/). The goal of
this conference was to exchange knowledge, best practices, and experience
gained using Prometheus. We also wanted to grow the community and help people
build professional connections around service monitoring. Here are some
impressions from the first morning:

<!-- more -->

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">Just landed at <a href="https://twitter.com/hashtag/promcon?src=hash">#promcon</a>. This is gonna be an exciting conference. <a href="https://t.co/2hsFaS32IK">pic.twitter.com/2hsFaS32IK</a></p>&mdash; Till Backhaus (@backhaus) <a href="https://twitter.com/backhaus/status/768705298940956672">August 25, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">The foodening is over, so let&#39;s have some talks. <a href="https://twitter.com/hashtag/promcon2016?src=hash">#promcon2016</a> <a href="https://t.co/GUGq8eLEdQ">pic.twitter.com/GUGq8eLEdQ</a></p>&mdash; Richard Hartmann (@TwitchiH) <a href="https://twitter.com/TwitchiH/status/769074566601777152">August 26, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

At PromCon, speakers from a variety of large and small companies talked about
how they were using Prometheus or are building solutions around it. For example,
[DigitalOcean](https://www.digitalocean.com/) spoke about their challenges of
using Prometheus at massive scale, while
[ShuttleCloud](https://www.shuttlecloud.com/) explained how it was a great fit
for monitoring their small startup.  Our furthest-traveled speaker came all the
way from Tokyo to present how [LINE](https://linecorp.com/en/) is monitoring
their systems using Prometheus. [Weaveworks](https://www.weave.works/)
explained how they built a scalable multi-tenant version of Prometheus.

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">.<a href="https://twitter.com/cagedmantis">@cagedmantis</a> about how they are deploying <a href="https://twitter.com/PrometheusIO">@PrometheusIO</a> at <a href="https://twitter.com/digitalocean">@digitalocean</a> <a href="https://twitter.com/hashtag/promcon2016?src=hash">#promcon2016</a> <a href="https://t.co/fc7yggVtyY">pic.twitter.com/fc7yggVtyY</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/769161605045161988">August 26, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">.<a href="https://twitter.com/Carretops">@Carretops</a> from <a href="https://twitter.com/ShuttleCloud">@ShuttleCloud</a> is explaining how <a href="https://twitter.com/PrometheusIO">@PrometheusIO</a> works well for small companies <a href="https://twitter.com/hashtag/promcon2016?src=hash">#promcon2016</a> <a href="https://t.co/5ccvGY4fQy">pic.twitter.com/5ccvGY4fQy</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/768724543062024192">August 25, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">Directly from Japan, <a href="https://twitter.com/wyukawa">@wyukawa</a> from <a href="https://twitter.com/LINEjp_official">@LINEjp_official</a> about Hadoop/Fluentd monitoring with <a href="https://twitter.com/PrometheusIO">@PrometheusIO</a> <a href="https://twitter.com/hashtag/promcon2016?src=hash">#promcon2016</a> <a href="https://t.co/irJswioxMf">pic.twitter.com/irJswioxMf</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/769171613577310208">August 26, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">It&#39;s getting spooky! <a href="https://twitter.com/tom_wilkie">@tom_wilkie</a> from <a href="https://twitter.com/weaveworks">@weaveworks</a> introduces Frankenstein, a distributed Prometheus. <a href="https://twitter.com/hashtag/promcon2016?src=hash">#promcon2016</a> <a href="https://t.co/6xgvlYv6Tw">pic.twitter.com/6xgvlYv6Tw</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/768826444575309824">August 25, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

Several Prometheus core developers also talked about the the design decisions
behind the monitoring system, presented upcoming features, or shared best
practices. On a lighter note, two lightning talks explained the correct plural
of Prometheus, as well as an implementation of [Conway's Game of Life](https://en.wikipedia.org/wiki/Conway%27s_Game_of_Life)
in the Prometheus query language.

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">Prometheus Design and Philosophy - Why It Is the Way It Is by <a href="https://twitter.com/juliusvolz">@juliusvolz</a> <a href="https://twitter.com/hashtag/promcon2016?src=hash">#promcon2016</a> <a href="https://t.co/XrPhXasb9k">pic.twitter.com/XrPhXasb9k</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/768715959926489088">August 25, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">. <a href="https://twitter.com/fabxc">@fabxc</a>, one of our maintainer working at <a href="https://twitter.com/coreoslinux">@coreoslinux</a>, shows us the depth of alerts in <a href="https://twitter.com/PrometheusIO">@PrometheusIO</a>  <a href="https://twitter.com/hashtag/promcon2016?src=hash">#promcon2016</a> <a href="https://t.co/Wvuc8eUpwg">pic.twitter.com/Wvuc8eUpwg</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/769138985432190976">August 26, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

To see the entire program, have a look at [the schedule](https://promcon.io/schedule).

In the breaks between talks, there was a lot of fun (and food) to be had:

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">Having a blast at <a href="https://twitter.com/hashtag/promcon2016?src=hash">#promcon2016</a> ! <a href="https://twitter.com/PrometheusIO">@PrometheusIO</a> <a href="https://twitter.com/google">@google</a> <a href="https://twitter.com/hashtag/monitoring?src=hash">#monitoring</a> <a href="https://twitter.com/hashtag/alerting?src=hash">#alerting</a> <a href="https://twitter.com/hashtag/ops?src=hash">#ops</a> <a href="https://twitter.com/hashtag/womenintech?src=hash">#womenintech</a> <a href="https://twitter.com/hashtag/womenwhocode?src=hash">#womenwhocode</a> <a href="https://twitter.com/hashtag/SRE?src=hash">#SRE</a> <a href="https://t.co/A5J4X6ScsO">pic.twitter.com/A5J4X6ScsO</a></p>&mdash; Vanesa (@vanesacodes) <a href="https://twitter.com/vanesacodes/status/769164579859492864">August 26, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

After wrapping up talks on the first evening, we enjoyed a warm summer night
with food and drinks on Gendarmenmarkt, one of Berlin's nicest plazas. This
gave people a chance to mingle even more and exchange thoughts and ideas around
Prometheus.

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">Had a great evening event at <a href="https://twitter.com/hashtag/promcon2016?src=hash">#promcon2016</a>... thanks everyone :) <a href="https://t.co/GoQtm9Q76d">pic.twitter.com/GoQtm9Q76d</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/768908811339964417">August 25, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

Overall, we were blown away by the quality of talks, the wide diversity of use
cases, as well as the friendly community coming together in this way and
forming new connections!

## Talk recordings

At PromCon 2016, we made it a priority to record all talks professionally.
Especially for a small conference like this, recording and sharing talks was
important, as it dramatically increases the reach of the talks and helps
Prometheus users and developers around the world to participate and learn.

Today, we are pleased to announce that all talk recordings are now ready and
publicly available. You can enjoy them [in this Youtube playlist](https://www.youtube.com/playlist?list=PLoz-W_CUquUlCq-Q0hy53TolAhaED9vmU)!

## Reception

The feedback we got from speakers and attendees at PromCon 2016 was incredibly
encouraging and positive. A lot of people loved the friendly community feeling
of the conference, but also learned a lot from the focused talks and
interesting conversations. Here is what some attendees had to say:

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">I had to admit as well - one of the best tech conf I have ever attended. <a href="https://twitter.com/PrometheusIO">@PrometheusIO</a> <a href="https://twitter.com/Percona">@Percona</a> <a href="https://twitter.com/hashtag/promcon2016?src=hash">#promcon2016</a> <a href="https://t.co/5HgKt0r9cu">pic.twitter.com/5HgKt0r9cu</a></p>&mdash; Roman Vynar (@rvynar) <a href="https://twitter.com/rvynar/status/769260722496954368">August 26, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">Sad that <a href="https://twitter.com/hashtag/PromCon2016?src=hash">#PromCon2016</a> is over. Best tech conference I&#39;ve been to yet!</p>&mdash; Nick Cabatoff (@NickCabatoff) <a href="https://twitter.com/NickCabatoff/status/769223981882900481">August 26, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr"><a href="https://twitter.com/PrometheusIO">@PrometheusIO</a>  I can&#39;t remember the last time I learned so much(or laughed so much) at a tech conference Thanks to all! So glad I attended!</p>&mdash; cliff-ops (@cliff_ops) <a href="https://twitter.com/cliff_ops/status/769239347828822016">August 26, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">For two days it was tangible that we already have something amazing and that many more, even greater things are still to come. <a href="https://twitter.com/hashtag/PromCon2016?src=hash">#PromCon2016</a></p>&mdash; Hynek Schlawack (@hynek) <a href="https://twitter.com/hynek/status/769245966847373312">August 26, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr"><a href="https://twitter.com/hashtag/promcon2016?src=hash">#promcon2016</a> was amazing. Thanks to everybody involved <a href="https://twitter.com/PrometheusIO">@PrometheusIO</a> <a href="https://twitter.com/juliusvolz">@juliusvolz</a></p>&mdash; tex (@texds) <a href="https://twitter.com/texds/status/769213616541298688">August 26, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

Overall, we were very happy with how PromCon turned out - no event is perfect,
but for a small community conference organized in free time, it exceeded most
people's expectations.

## Thanks

PromCon 2016 would not have been possible without the help of its sponsors,
speakers, attendees, and organizers. Thanks so much to all of you! Our Diamond
and Platinum sponsors deserve a special mention at this point, since they did
the most to support us and made all the food, drinks, video recordings, and
swag possible:

<h3>Diamond</h3>
<div class="sponsor-logos">
  <a href="http://www.robustperception.io/"><img src="/assets/blog/2016-09-02/robust_perception_logo.png"/></a>
  <a href="https://www.weave.works/"><img src="/assets/blog/2016-09-02/weave_logo.png"/></a>
</div>

<h3>Platinum</h3>
<div class="sponsor-logos">
  <a href="https://cncf.io/"><img src="/assets/blog/2016-09-02/cncf_logo.png"/></a>
  <a href="https://coreos.com/"><img src="/assets/blog/2016-09-02/coreos_logo.svg"/></a>
</div>

We would also like to thank Google for hosting the conference at their office
in Berlin!

## Outlook

If PromCon 2016 went so well, when will the next one happen?

<blockquote class="twitter-tweet tw-align-center" data-lang="en"><p lang="en" dir="ltr">Promcon was nice. Looking forward to next time. Bye Berlin. <a href="https://twitter.com/hashtag/promcon2016?src=hash">#promcon2016</a> <a href="https://t.co/XInN9OR3pL">pic.twitter.com/XInN9OR3pL</a></p>&mdash; Robert Jacob (@xperimental) <a href="https://twitter.com/xperimental/status/769520813385117697">August 27, 2016</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

The answer is that we don't know for sure yet. This first PromCon was organized
entirely in people's free time, with most of it handled by one person. This
will surely have to change, especially as we also expect a next Prometheus
conference to be much larger (even this year, the limited tickets sold out
within seconds). In the next months, we will discuss within the community what we
want PromCon to be, who should run it, and where it should take place. Perhaps
there is even space for multiple Prometheus conferences around the world. We will
report back when we know more. Stay tuned!
