---
title: Media
sort_rank: 7
---

# Media

There is a [subreddit](https://www.reddit.com/r/prometheusmonitoring)
collecting all Prometheus-related resources on the internet.

The following selection of resources are particularly useful to get started
with Prometheus.

## Blogs

* This site has its own [blog](http://prometheus.io/blog/).
* [SoundCloud's blog post announcing Prometheus](https://developers.soundcloud.com/blog/prometheus-monitoring-at-soundcloud)
  – a more elaborate overview than the one given on this site.
* Prometheus-related posts on the
  [Robust Perception blog](http://www.robustperception.io/tag/prometheus/).
* The [monitoring series](http://www.boxever.com/tag/monitoring) on Boxever's
  tech blog.

## Tutorials

* [Instructions and example code for a Prometheus workshop](https://github.com/juliusv/prometheus_workshop).
* [How To Install Prometheus using Docker on Ubuntu 14.04](https://www.digitalocean.com/community/tutorials/how-to-install-prometheus-using-docker-on-ubuntu-14-04).

## Podcasts and interviews

* [Prometheus on FLOSS Weekly 357](https://twit.tv/shows/floss-weekly/episodes/357) - Julius Volz on the [FLOSS Weekly TWiT.tv](https://twit.tv/shows/floss-weekly/) show.
* [Prometheus and Service Monitoring](https://changelog.com/168/) - Julius Volz on the [Changelog](https://changelog.com/) podcast.

## Recorded talks

* [Prometheus: A Next-Generation Monitoring System](https://www.usenix.org/conference/srecon15europe/program/presentation/rabenstein) – Julius Volz and Björn Rabenstein at SREcon15 Europe, Dublin.
* [Prometheus: A Next-Generation Monitoring System](https://www.youtube.com/watch?v=cwRmXqXKGtk) - Brian Brazil at FOSDEM 2016 ([slides](http://www.slideshare.net/brianbrazil/prometheus-a-next-generation-monitoring-system-fosdem-2016)).
* [What is your application doing right now?](http://youtu.be/Z0LlilNpX1U) – Matthias Gruter, Transmode, at DevOps Stockholm Meetup.
* [Prometheus workshop](https://vimeo.com/131581353) – Jamie Wilkinson at Monitorama PDX 2015 ([slides](https://docs.google.com/presentation/d/1X1rKozAUuF2MVc1YXElFWq9wkcWv3Axdldl8LOH9Vik/edit)).
* [Monitoring Hadoop with Prometheus](https://www.youtube.com/watch?v=qs2sqOLNGtw) – Brian Brazil at the Hadoop User Group Ireland ([slides](http://www.slideshare.net/brianbrazil/monitoring-hadoop-with-prometheus-hadoop-user-group-ireland-december-2015)).
* In German: [Monitoring mit Prometheus](https://entropia.de/GPN15:Monitoring_mit_Prometheus) – Michael Stapelberg at Gulaschprogrammiernacht 15.

## Presentation slides

### General

* [Prometheus Overview](http://www.slideshare.net/brianbrazil/prometheus-overview) – by Brian Brazil.
* [Systems Monitoring with Prometheus](http://www.slideshare.net/brianbrazil/devops-ireland-systems-monitoring-with-prometheus) – Brian Brazil at Devops Ireland Meetup, Dublin.
* [OMG! Prometheus](https://www.dropbox.com/s/0l7kxhjqjbabtb0/prometheus%20site-ops%20preso.pdf?dl=0) – Benjamin Staffin, Fitbit Site Operations, explains the case for Prometheus to his team.

### Docker

* [Prometheus and Docker](http://www.slideshare.net/brianbrazil/prometheus-and-docker-docker-galway-november-2015) – Brian Brazil at Docker Galway.

### Python

* [Better Monitoring for Python](http://www.slideshare.net/brianbrazil/better-monitoring-for-python-inclusive-monitoring-with-prometheus-pycon-ireland-lightning-talk) – Brian Brazil at Pycon Ireland.
* [Monitoring your Python with Prometheus](http://www.slideshare.net/brianbrazil/python-ireland-monitoring-your-python-with-prometheus) – Brian Brazil at Python Ireland Meetup, Dublin.
