---
title: Prometheus reaches 1.0
created: 2016-07-18
kind: article
author_name: Fabian Reinartz on behalf of the Prometheus team
---

In January, we published a blog post on [Prometheus’s first year of public existence](https://prometheus.io/blog/2016/01/26/one-year-of-open-prometheus-development/), summarizing what has been an amazing journey for us, and hopefully an innovative and useful monitoring solution for you.
Since then, [Prometheus has also joined the Cloud Native Computing Foundation](https://prometheus.io/blog/2016/05/09/prometheus-to-join-the-cloud-native-computing-foundation/), where we are in good company, as the second charter project after [Kubernetes](http://kubernetes.io/).

Our recent work has focused on delivering a stable API and user interface, marked by version 1.0 of Prometheus.
We’re thrilled to announce that we’ve reached this goal, and [Prometheus 1.0 is available today](https://github.com/prometheus/prometheus/releases/tag/v1.0.0).

## What does 1.0 mean for you?

If you have been using Prometheus for a while, you may have noticed that the rate and impact of breaking changes significantly decreased over the past year.
In the same spirit, reaching 1.0 means that subsequent 1.x releases will remain API stable. Upgrades won’t break programs built atop the Prometheus API, and updates won’t require storage re-initialization or deployment changes. Custom dashboards and alerts will remain intact across 1.x version updates as well. 
We’re confident Prometheus 1.0 is a solid monitoring solution. Now that the Prometheus server has reached a stable API state, other modules will follow it to their own stable version 1.0 releases over time.

### Fine print

So what does API stability mean? Prometheus has a large surface area and some parts are certainly more mature than others.
There are two simple categories, _stable_ and _unstable_:

* Stable as of v1.0 and throughout the 1.x series:
* The query language and data model
* Alerting and recording rules
* The ingestion exposition formats
* Configuration flag names
* HTTP API (used by dashboards and UIs)
* Configuration file format (minus the non-stable service discovery integrations, see below)
* Alerting integration with Alertmanager 0.1+ for the foreseeable future
* Console template syntax and semantics

Unstable and may change within 1.x:

* The remote storage integrations (InfluxDB, OpenTSDB, Graphite) are still experimental and will at some point be removed in favor of a generic, more sophisticated API that allows storing samples in arbitrary storage systems.
* Several service discovery integrations are new and need to keep up with fast evolving systems. Hence, integrations with Kubernetes, Marathon, Azure, and EC2 remain in beta status and are subject to change. However, changes will be clearly announced.
* Exact flag meanings may change as necessary. However, changes will never cause the server to not start with previous flag configurations.
* Go APIs of packages that are part of the server.
* HTML generated by the web UI.
* The metrics in the `/metrics` endpoint of Prometheus itself.
* Exact on-disk format. Potential changes however, will be forward compatible and transparently handled by Prometheus.

## So Prometheus is complete now?

Absolutely not. We have a long roadmap ahead of us, full of great features to implement. Prometheus will not stay in 1.x for years to come. The infrastructure space is evolving rapidly and we fully intend for Prometheus to evolve with it.
This means that we will remain willing to question what we did in the past and are open to leave behind things that have lost relevance. There will be new major versions of Prometheus to facilitate future plans like persistent long-term storage, newer iterations of Alertmanager, internal storage improvements, and many things we don’t even know about yet.

## Closing thoughts

We want to thank our fantastic community for field testing new versions, filing bug reports, contributing code, helping out other community members, and shaping Prometheus by participating in countless productive discussions.
In the end, you are the ones who make Prometheus successful.

Thank you, and keep up the great work!

