---
title: Integrations
sort_rank: 5
---

# Integrations

In addition to [client libraries](/docs/instrumenting/clientlibs/) and
[exporters and related libraries](/docs/instrumenting/exporters/), there are
numerous other generic integration points in Prometheus. This page lists some
of the integrations with these.


Not all integrations are listed here, due to overlapping functionality or still
being in development. The [exporter default
port](https://github.com/prometheus/prometheus/wiki/Default-port-allocations)
wiki page also happens to include a few non-exporter integrations that fit in
these categories.

## File Service Discovery

For service discovery mechanisms not natively supported by Prometheus,
[file-based service discovery](/docs/operating/configuration/#<file_sd_config>) provides an interface for integrating.

 * [Docker Swarm](https://github.com/ContainerSolutions/prometheus-swarm-discovery)

## Remote Endpoints and Storage

The [remote write](/docs/operating/configuration/#<remote_write>) and [remote read](/docs/operating/configuration/#remote_read)
features of Prometheus allow transparently sending and receiving samples. This
is primarily intended for long term storage. It is recommended that you perform
careful evaulation of any solution in this space to confirm it can handle your
data volumes.

  * [Chronix](https://github.com/ChronixDB/chronix.ingester): write
  * [Graphite](https://github.com/prometheus/prometheus/tree/master/documentation/examples/remote_storage/remote_storage_adapter): write
  * [InfluxDB](https://github.com/prometheus/prometheus/tree/master/documentation/examples/remote_storage/remote_storage_adapter): read and write
  * [OpenTSDB](https://github.com/prometheus/prometheus/tree/master/documentation/examples/remote_storage/remote_storage_adapter): write
  * [PostgreSQL/TimescaleDB](https://github.com/timescale/prometheus-postgresql-adapter): read and write

## Alertmanager Webhook Receiver

For notification mechanisms not natively supported by the Alertmanager, the
[webhook receiver](/docs/alerting/configuration/#webhook_config) allows for integration.

  * [JIRA example](https://github.com/fabxc/jiralerts)
  * [SMS](https://github.com/messagebird/sachet): supports [multiple providers](https://github.com/messagebird/sachet/blob/master/examples/config.yaml)
  * [Telegram bot](https://github.com/inCaller/prometheus_bot)

## Management

Prometheus does not include configuration management functionality, allowing
you to integrate it with your existing systems or build on top of it.

  * [Prometheus Operator](https://github.com/coreos/prometheus-operator): Manages Prometheus on top of Kubernetes
  * [Promgen](https://github.com/line/promgen): Web UI and configuration generator for Prometheus and Alertmanager

## Other

  * [PushProx](https://github.com/RobustPerception/PushProx): Proxy to transverse NAT and similar network setups
