---
title: PromCon 2017 Recap
created_at: 2017-09-04
kind: article
author_name: Julius Volz
---

## What happened

Two weeks ago, Prometheus users and developers from all over the world came together in Munich for [PromCon 2017](https://promcon.io/2017-munich/), the second conference around the Prometheus monitoring system. The purpose of this event was to exchange knowledge and best practices and build professional connections around monitoring with Prometheus. Google's Munich office offered us a much larger space this year, which allowed us to grow from 80 to 220 attendees while still selling out!

Take a look at the recap video to get an impression of the event:

<iframe width="560" height="315" src="https://www.youtube.com/embed/4Pr-z8-r1eo" frameborder="0" allowfullscreen></iframe>

<!-- more -->

At PromCon, speakers from a variety of organizations talked about how they are using Prometheus and building solutions around it. For example, [Cloudflare](https://cloudflare.com/) and [DigitalOcean](https://www.digitalocean.com/) both explained how they use Prometheus to monitor their large-scale networks and datacenters:

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">Cloudflare is a large user of Prometheus. Lorenz Bauer explains how they handle alerts and dashboards across 115 data centers <a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> <a href="https://t.co/IXs09Lp6z6">pic.twitter.com/IXs09Lp6z6</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/898461326191861760">August 18, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">DigitalOcean uses Prometheus to monitor <a href="https://twitter.com/kubernetesio">@kubernetesio</a> deployed services. <a href="https://twitter.com/snehainguva">@snehainguva</a> talks about their setup and pitfalls <a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> <a href="https://t.co/dPaSIMybjO">pic.twitter.com/dPaSIMybjO</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/898455013281984512">August 18, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

Speakers from [Grafana](https://grafana.com/) and [InfluxData](https://www.influxdata.com/) brought us up to date with new features and Prometheus integrations:

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">Next, <a href="https://twitter.com/CarlBergquist">@CarlBergquist</a> from <a href="https://twitter.com/raintanksaas">@raintanksaas</a> shows cool tricks and new features in <a href="https://twitter.com/grafana">@grafana</a>. <a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> <a href="https://t.co/aXCbOAA1dp">pic.twitter.com/aXCbOAA1dp</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/898119125540765697">August 17, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">You like Prometheus but have a need for long-term storage? <a href="https://twitter.com/pauldix">@pauldix</a> presents how <a href="https://twitter.com/InfluxDB">@InfluxDB</a> integrates with Prometheus at <a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> <a href="https://t.co/hpsO95mPVL">pic.twitter.com/hpsO95mPVL</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/898476044327497728">August 18, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

Several Prometheus core developers also spoke about best practices and new features and developments in Prometheus:

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">Our own <a href="https://twitter.com/juliusvolz">@juliusvolz</a> gives a lecture on best practices and pitfalls when starting with <a href="https://twitter.com/PrometheusIO">@PrometheusIO</a> <a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> <a href="https://t.co/gTNrxeaxK7">pic.twitter.com/gTNrxeaxK7</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/898098812761362432">August 17, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">. <a href="https://twitter.com/mxinden">@mxinden</a> from <a href="https://twitter.com/coreos">@coreos</a> talks about how and why the alertmanager got it&#39;s shiny new UI. <a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> <a href="https://t.co/zXaZS9rXqc">pic.twitter.com/zXaZS9rXqc</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/898525224924327936">August 18, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">Prometheus 2.0 will be immensely more performant! 😎 <a href="https://twitter.com/fabxc">@fabxc</a> explains how he rewrote the storage from the ground up for that <a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> <a href="https://t.co/wzDZWMrvGB">pic.twitter.com/wzDZWMrvGB</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/898491951820963840">August 18, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">A core requirement of alertmanager is high availability. <a href="https://twitter.com/fredbrancz">@fredbrancz</a> is now explaining the design and implementation <a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> <a href="https://t.co/UKng19PyiO">pic.twitter.com/UKng19PyiO</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/898160978952671233">August 17, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

To see the entire program, have a look at [the schedule](https://promcon.io/2017-munich/schedule).

In the breaks and after-parties, we had a lot of fun:

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">I&#39;m supposed to tweet anything from this account. Um. <a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> is awesome! Also, FOOD! <a href="https://twitter.com/AnotherKamila">@AnotherKamila</a> is happy. <a href="https://t.co/VeXjBYwXgj">pic.twitter.com/VeXjBYwXgj</a></p>&mdash; PrometheusMonitoring (@PrometheusIO) <a href="https://twitter.com/PrometheusIO/status/898235438904872961">August 17, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr"><a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> first day after party! Amazing people &lt;3 <a href="https://t.co/y8BlVzYA89">pic.twitter.com/y8BlVzYA89</a></p>&mdash; Laushinka (@laushinka) <a href="https://twitter.com/laushinka/status/898228997854814209">August 17, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">Wrapping up <a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> at the Biergarten <a href="https://t.co/BpgsOPHRZi">pic.twitter.com/BpgsOPHRZi</a></p>&mdash; Fabian Reinartz (@fabxc) <a href="https://twitter.com/fabxc/status/898600092260806656">August 18, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

...and one lucky participant finally had her childhood dream come true:

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">🎊 🎉Congrats to 🏆 <a href="https://twitter.com/AnotherKamila">@AnotherKamila</a> 🏆! Winner of the <a href="https://twitter.com/hashtag/LegoMindstorm?src=hash">#LegoMindstorm</a>! Let us know what you end up creating!! 🤖 <a href="https://twitter.com/hashtag/PromCon?src=hash">#PromCon</a> 🎊 🎉 <a href="https://t.co/gFO7UcLIN1">pic.twitter.com/gFO7UcLIN1</a></p>&mdash; Weaveworks (@weaveworks) <a href="https://twitter.com/weaveworks/status/898538917925990400">August 18, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

## Talk recordings

Today, we are pleased to announce that all talk recordings are now ready and
publicly available. You can enjoy them [in this YouTube playlist](https://www.youtube.com/playlist?list=PLoz-W_CUquUlnvoEBbqChb7A0ZEZsWSXt)!

## Reception

Again, we received incredibly positive and encouraging feedback from speakers and attendees this year. Here is what some had to say:

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr"><a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> was a blast. Lovely people talking about Monitoring, SRE and hacking. That&#39;s exactly my kind of thing. See you next time! <a href="https://t.co/pKcIiupFHK">pic.twitter.com/pKcIiupFHK</a></p>&mdash; Mic 🐧 (@nomaster) <a href="https://twitter.com/nomaster/status/898605980245741568">August 18, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr"><a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> was fantastic and I hope to see everyone next year! Not just amazing talks, also awesome attendees and organizers! Thank you!</p>&mdash; Kamila Součková (@AnotherKamila) <a href="https://twitter.com/AnotherKamila/status/898652581353766912">August 18, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">Not even close to the end of the year but I can already say, <a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> was the best and most fun conference of the year!</p>&mdash; Frederic Branczyk (@fredbrancz) <a href="https://twitter.com/fredbrancz/status/898601276895789057">August 18, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">We had a blast at <a href="https://twitter.com/hashtag/PromCon?src=hash">#PromCon</a>! Thx <a href="https://twitter.com/juliusvolz">@juliusvolz</a>, Richard Hartman &amp; the <a href="https://twitter.com/hashtag/PromCon?src=hash">#PromCon</a> team for an amazing conference! Auf Wiedersehen! Til next year! <a href="https://t.co/b4DwJdqQcs">pic.twitter.com/b4DwJdqQcs</a></p>&mdash; Weaveworks (@weaveworks) <a href="https://twitter.com/weaveworks/status/898576990797746178">August 18, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet" data-lang="en"><p lang="en" dir="ltr">pretty stoked from <a href="https://twitter.com/hashtag/PromCon2017?src=hash">#PromCon2017</a> ! it was probably the best conference i&#39;ve been to yet! Hope work more with the community in the future =)</p>&mdash; Lukas (@1uk4sh) <a href="https://twitter.com/1uk4sh/status/898616723762532356">August 18, 2017</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

While there were things going wrong here and there, we think that the event turned out super well overall for a community-organized conference, and we're happy to see that our attendees felt similarly!

## Thanks

PromCon 2017 would not have been possible without the help of its sponsors,
speakers, attendees, and organizers. Thanks so much to all of you! Our Diamond
and Venue sponsors deserve a special mention at this point, since they did
the most to support us and made all the food, drinks, video recordings, and
swag possible:

<h3>Diamond</h3>
<div class="sponsor-logos">
  <a href="https://www.weave.works/"><img src="/assets/blog/2017-09-04/weave_logo.png"/></a>
  <a href="https://about.gitlab.com/"><img src="/assets/blog/2017-09-04/gitlab_logo.svg"/></a>
  <a href="https://www.influxdata.com/"><img src="/assets/blog/2017-09-04/influxdata_logo.svg"/></a>
  <a href="https://www.cncf.io/"><img src="/assets/blog/2017-09-04/cncf_logo.png"/></a>
  <a href="https://www.robustperception.io/"><img src="/assets/blog/2017-09-04/robust_perception_logo.png"/></a>
</div>

<h3>Venue</h3>
<div class="sponsor-logos">
  <a href="https://google.com/"><img src="/assets/blog/2017-09-04/google_cloud_platform_logo.png"/></a>
</div>

We would also like to thank [all our other sponsors](https://promcon.io/2017-munich/#our-sponsors)!

A special thank you to the [Cloud Native Computing Foundation](https://cncf.io) for helping us handle financials and the registration system!

## Outlook

With PromCon 2017, the Prometheus community organized its second successful Prometheus conference. Since all attendees really appreciated the community character of the event, we definitely aim to keep this special feeling for PromCon in the future. PromCon 2017 was still organized mainly in people's free time, but we started distributing the work load over more people this year. For the next iterations of PromCon, we still need to discuss how to make this community-organized model more sustainable. We don't know yet when, where, and how PromCon 2018 will happen, but we will report back when we do, and we hope to welcome you back!

Stay tuned!
