---
title: Clients
sort_rank: 6
nav_icon: sliders
---

# Sending alerts

__**Disclaimer**: Prometheus automatically takes care of sending alerts
generated by its configured [alerting rules](../../prometheus/latest/configuration/alerting_rules/). It is highly
recommended to configure alerting rules in Prometheus based on time series
data rather than implementing a direct client.__

The Alertmanager listens for alerts on an API endpoint at `/api/v1/alerts`.
Clients are expected to continuously re-send alerts as long as they are still
active (usually on the order of 30 seconds to 3 minutes).
Clients can push a list of alerts to that endpoint via a POST request of
the following format:

```
[
  {
    "labels": {
      "<labelname>": "<labelvalue>",
      ...
    },
    "annotations": {
      "<labelname>": "<labelvalue>",
    },
    "startsAt": "<rfc3339>",
    "endsAt": "<rfc3339>",
    "generatorURL": "<generator_url>"
  },
  ...
]
```

The labels are used to identify identical instances of an alert and to perform
deduplication. The annotations are always set to those received most recently
and are not identifying an alert.

Both timestamps are optional. If `startsAt` is omitted, the current time
is assigned by the Alertmanager. `endsAt` is only set if the end time of an
alert is known. Otherwise it will be set to a configurable timeout period from
the time since the alert was last received.

The `generatorURL` field is a unique back-link which identifies the causing
entity of this alert in the client.
