<?php namespace Modules\Menu\Services;

use Modules\Menu\Repositories\MenuItemRepository;

class MenuService
{
    /**
     * Current Menu Item being looped over
     * @var
     */
    protected $menuItem;
    /**
     * @var MenuItemRepository
     */
    private $menuItemRepository;

    /**
     * @param MenuItemRepository $menuItem
     */
    public function __construct(MenuItemRepository $menuItem)
    {
        $this->menuItemRepository = $menuItem;
    }

    /**
     * Perform needed operations on given menu item and set its position
     * @param $item
     * @param int $position
     */
    public function handle($item, $position)
    {
        $this->menuItem = $this->menuItemRepository->find($item['id']);
        $this->savePosition($this->menuItem, $position);
        $this->menuItem->makeRoot();

        if ($this->hasChildren($item)) {
            $this->setChildrenRecursively($item, $this->menuItem);
        }
    }

    /**
     * Sets the children of the given item
     * @param $item
     * @param $parent
     */
    private function setChildrenRecursively($item, $parent)
    {
        foreach ($item['children'] as $childPosition => $childItem) {
            $childMenuItem = $this->menuItemRepository->find($childItem['id']);
            $this->savePosition($childMenuItem, $childPosition);
            $childMenuItem->makeChildOf($parent);
            if ($this->hasChildren($childItem)) $this->setChildrenRecursively($childItem, $childMenuItem);
        }
    }

    /**
     * Check if the item has children
     * @param $item
     * @return bool
     */
    private function hasChildren($item)
    {
        return isset($item['children']);
    }

    /**
     * Save the position of the given item
     * @param $item
     * @param $position
     */
    private function savePosition($item, $position)
    {
        $item->position = $position;
        $item->save();
    }
}
