/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.out;

import java.util.ArrayList;
import pl.mn.communicator.IOutgoingMessage;
import pl.mn.communicator.packet.GGConversion;
import pl.mn.communicator.packet.GGMessageClass;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.out.GGOutgoingPackage;

public class GGSendMsg
implements GGOutgoingPackage,
GGMessageClass {
    public static final int GG_SEND_MSG = 11;
    private static int m_seq = -1;
    private int m_recipientUin = -1;
    private ArrayList m_additionalRecipients = new ArrayList();
    private String m_text = "";
    private int m_protocolMessageClass = 4;

    public GGSendMsg(IOutgoingMessage outgoingMessage) {
        if (outgoingMessage == null) {
            throw new NullPointerException("outgoingMessage cannot be null");
        }
        this.m_text = outgoingMessage.getMessageBody();
        m_seq = outgoingMessage.getMessageID();
        this.m_recipientUin = outgoingMessage.getRecipientUin();
        this.m_protocolMessageClass = GGConversion.getProtocolMessageClass(outgoingMessage.getMessageClass());
    }

    public void addAdditionalRecipient(int uin) {
        if (uin != this.m_recipientUin) {
            this.m_additionalRecipients.add(new Integer(uin));
        }
    }

    public void removeAdditionalRecipient(int uin) {
        if (uin != this.m_recipientUin) {
            this.m_additionalRecipients.remove(new Integer(uin));
        }
    }

    public int getPacketType() {
        return 11;
    }

    public int getLength() {
        return 12 + this.m_text.length() + 1 + 5 + this.m_additionalRecipients.size() * 4;
    }

    public byte[] getContents() {
        byte[] toSend = new byte[this.getLength()];
        toSend[0] = (byte)(this.m_recipientUin & 0xFF);
        toSend[1] = (byte)(this.m_recipientUin >> 8 & 0xFF);
        toSend[2] = (byte)(this.m_recipientUin >> 16 & 0xFF);
        toSend[3] = (byte)(this.m_recipientUin >> 24 & 0xFF);
        toSend[4] = (byte)(m_seq & 0xFF);
        toSend[5] = (byte)(m_seq >> 8 & 0xFF);
        toSend[6] = (byte)(m_seq >> 16 & 0xFF);
        toSend[7] = (byte)(m_seq >> 24 & 0xFF);
        toSend[8] = (byte)(this.m_protocolMessageClass & 0xFF);
        toSend[9] = (byte)(this.m_protocolMessageClass >> 8 & 0xFF);
        toSend[10] = (byte)(this.m_protocolMessageClass >> 16 & 0xFF);
        toSend[11] = (byte)(this.m_protocolMessageClass >> 24 & 0xFF);
        byte[] textBytes = GGUtils.stringToBytes(this.m_text);
        for (int i = 0; i < this.m_text.length(); ++i) {
            toSend[12 + i] = textBytes[i];
        }
        int recipientCount = this.m_additionalRecipients.size();
        if (recipientCount > 0) {
            toSend[12 + this.m_text.length() + 1] = 1;
            toSend[12 + this.m_text.length() + 2] = (byte)(recipientCount & 0xFF);
            toSend[12 + this.m_text.length() + 3] = (byte)(recipientCount >> 8 & 0xFF);
            toSend[12 + this.m_text.length() + 4] = (byte)(recipientCount >> 16 & 0xFF);
            toSend[12 + this.m_text.length() + 5] = (byte)(recipientCount >> 24 & 0xFF);
            for (int i = 0; i < recipientCount; ++i) {
                int recipientUin = (Integer)this.m_additionalRecipients.get(i);
                toSend[12 + this.m_text.length() + 6 + i] = (byte)(recipientUin & 0xFF);
                toSend[12 + this.m_text.length() + 7 + i] = (byte)(recipientUin >> 8 & 0xFF);
                toSend[12 + this.m_text.length() + 8 + i] = (byte)(recipientUin >> 16 & 0xFF);
                toSend[12 + this.m_text.length() + 9 + i] = (byte)(recipientUin >> 24 & 0xFF);
            }
        }
        return toSend;
    }
}

