/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.GenericObject;
import gov.nist.javax.sip.header.ExtensionHeaderList;
import gov.nist.javax.sip.header.Indentation;
import gov.nist.javax.sip.header.SIPHeader;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.sip.header.Header;

public class SIPHeaderList
extends SIPHeader
implements List,
Header {
    protected List hlist;
    private Class myClass;

    public String getName() {
        return this.headerName;
    }

    protected SIPHeaderList(List list, String string) {
        this.headerName = string;
        this.hlist = list;
    }

    protected SIPHeaderList(String string) {
        this.headerName = string;
        this.hlist = new LinkedList();
    }

    protected SIPHeaderList(Class clazz, String string) {
        this.headerName = string;
        this.hlist = new LinkedList();
        this.myClass = clazz;
    }

    public boolean add(Object object) {
        this.hlist.add(object);
        return true;
    }

    public void addFirst(Object object) {
        this.hlist.add(0, object);
    }

    public void add(Object object, boolean bl) {
        if (bl) {
            this.addFirst(object);
        } else {
            this.add(object);
        }
    }

    public void concatenate(SIPHeaderList sIPHeaderList, boolean bl) throws IllegalArgumentException {
        if (!bl) {
            this.addAll((Collection)sIPHeaderList);
        } else {
            this.addAll(0, (Collection)sIPHeaderList);
        }
    }

    public void concatenate(SIPHeaderList sIPHeaderList) throws IllegalArgumentException {
        this.concatenate(sIPHeaderList, false);
    }

    public String encode() {
        return this.encode(new StringBuffer()).toString();
    }

    public StringBuffer encode(StringBuffer stringBuffer) {
        if (this.hlist.isEmpty()) {
            stringBuffer.append(this.headerName).append(':').append("\r\n");
        } else if (this.headerName.equals("WWW-Authenticate") || this.headerName.equals("Proxy-Authenticate") || this.headerName.equals("Authorization") || this.headerName.equals("Proxy-Authorization") || this instanceof ExtensionHeaderList) {
            ListIterator listIterator = this.hlist.listIterator();
            while (listIterator.hasNext()) {
                SIPHeader sIPHeader = (SIPHeader)listIterator.next();
                sIPHeader.encode(stringBuffer);
            }
        } else {
            stringBuffer.append(this.headerName).append(":").append(" ");
            this.encodeBody(stringBuffer);
            stringBuffer.append("\r\n");
        }
        return stringBuffer;
    }

    public List getHeadersAsEncodedStrings() {
        LinkedList<String> linkedList = new LinkedList<String>();
        ListIterator listIterator = this.hlist.listIterator();
        while (listIterator.hasNext()) {
            SIPHeader sIPHeader = (SIPHeader)listIterator.next();
            linkedList.add(sIPHeader.encode());
        }
        return linkedList;
    }

    public SIPHeader getFirst() {
        if (this.hlist == null || this.hlist.isEmpty()) {
            return null;
        }
        return (SIPHeader)this.hlist.get(0);
    }

    public SIPHeader getLast() {
        if (this.hlist == null || this.hlist.isEmpty()) {
            return null;
        }
        return (SIPHeader)this.hlist.get(this.hlist.size() - 1);
    }

    public Class getMyClass() {
        return this.myClass;
    }

    public boolean isEmpty() {
        return this.hlist.isEmpty();
    }

    public ListIterator listIterator() {
        return this.hlist.listIterator(0);
    }

    public List getHeaderList() {
        return this.hlist;
    }

    public ListIterator listIterator(int n) {
        return this.hlist.listIterator(n);
    }

    public void removeFirst() {
        if (this.hlist.size() != 0) {
            this.hlist.remove(0);
        }
    }

    public void removeLast() {
        if (this.hlist.size() != 0) {
            this.hlist.remove(this.hlist.size() - 1);
        }
    }

    public boolean remove(SIPHeader sIPHeader) {
        if (this.hlist.size() == 0) {
            return false;
        }
        return this.hlist.remove(sIPHeader);
    }

    protected void setMyClass(Class clazz) {
        this.myClass = clazz;
    }

    public String debugDump(int n) {
        this.stringRepresentation = "";
        String string = new Indentation(n).getIndentation();
        String string2 = this.getClass().getName();
        this.sprint(string + string2);
        this.sprint(string + "{");
        Iterator iterator = this.hlist.iterator();
        while (iterator.hasNext()) {
            SIPHeader sIPHeader = (SIPHeader)iterator.next();
            this.sprint(string + sIPHeader.debugDump());
        }
        this.sprint(string + "}");
        return this.stringRepresentation;
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public Object[] toArray() {
        return this.hlist.toArray();
    }

    public int indexOf(GenericObject genericObject) {
        return this.hlist.indexOf(genericObject);
    }

    public void add(int n, Object object) throws IndexOutOfBoundsException {
        this.hlist.add(n, object);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SIPHeaderList) {
            SIPHeaderList sIPHeaderList = (SIPHeaderList)object;
            if (this.hlist == sIPHeaderList.hlist) {
                return true;
            }
            if (this.hlist == null) {
                return sIPHeaderList.hlist == null || sIPHeaderList.hlist.size() == 0;
            }
            return ((Object)this.hlist).equals(sIPHeaderList.hlist);
        }
        return false;
    }

    public boolean match(SIPHeaderList sIPHeaderList) {
        if (sIPHeaderList == null) {
            return true;
        }
        if (!this.getClass().equals(sIPHeaderList.getClass())) {
            return false;
        }
        SIPHeaderList sIPHeaderList2 = sIPHeaderList;
        if (this.hlist == sIPHeaderList2.hlist) {
            return true;
        }
        if (this.hlist == null) {
            return false;
        }
        Iterator iterator = sIPHeaderList.hlist.iterator();
        while (iterator.hasNext()) {
            SIPHeader sIPHeader = (SIPHeader)iterator.next();
            boolean bl = false;
            Iterator iterator2 = this.hlist.iterator();
            while (iterator2.hasNext() && !bl) {
                SIPHeader sIPHeader2 = (SIPHeader)iterator2.next();
                bl = sIPHeader2.match(sIPHeader);
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public void merge(SIPHeaderList sIPHeaderList) {
        if (sIPHeaderList == null) {
            return;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = sIPHeaderList.listIterator();
        while (listIterator.hasNext()) {
            GenericObject genericObject = (GenericObject)listIterator.next();
            while (listIterator2.hasNext()) {
                Object e = listIterator2.next();
                genericObject.merge(e);
            }
        }
    }

    public Object clone() {
        try {
            Class<?> clazz = this.getClass();
            Constructor<?> constructor = clazz.getConstructor(null);
            SIPHeaderList sIPHeaderList = (SIPHeaderList)constructor.newInstance(null);
            return sIPHeaderList.clonehlist(this.hlist);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not clone!", exception);
        }
    }

    protected final SIPHeaderList clonehlist(List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SIPHeader sIPHeader = (SIPHeader)iterator.next();
                this.hlist.add(sIPHeader.clone());
            }
        }
        return this;
    }

    public int size() {
        return this.hlist.size();
    }

    public boolean isHeaderList() {
        return true;
    }

    protected String encodeBody() {
        return this.encodeBody(new StringBuffer()).toString();
    }

    protected StringBuffer encodeBody(StringBuffer stringBuffer) {
        ListIterator listIterator = this.listIterator();
        while (true) {
            SIPHeader sIPHeader;
            if ((sIPHeader = (SIPHeader)listIterator.next()) == this) {
                throw new RuntimeException("Unexpected circularity in SipHeaderList");
            }
            sIPHeader.encodeBody(stringBuffer);
            if (!listIterator.hasNext()) break;
            if (!this.headerName.equals("Privacy")) {
                stringBuffer.append(",");
                continue;
            }
            stringBuffer.append(";");
        }
        return stringBuffer;
    }

    public boolean addAll(Collection collection) {
        return this.hlist.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        return this.hlist.addAll(n, collection);
    }

    public void clear() {
        this.hlist.clear();
    }

    public boolean contains(Object object) {
        return this.hlist.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.hlist.containsAll(collection);
    }

    public Object get(int n) {
        return this.hlist.get(n);
    }

    public int indexOf(Object object) {
        return this.hlist.indexOf(object);
    }

    public Iterator iterator() {
        return this.hlist.listIterator();
    }

    public int lastIndexOf(Object object) {
        return this.hlist.lastIndexOf(object);
    }

    public boolean remove(Object object) {
        return this.hlist.remove(object);
    }

    public Object remove(int n) {
        return this.hlist.remove(n);
    }

    public boolean removeAll(Collection collection) {
        return this.hlist.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.hlist.retainAll(collection);
    }

    public List subList(int n, int n2) {
        return this.hlist.subList(n, n2);
    }

    public int hashCode() {
        return this.headerName.hashCode();
    }

    public Object set(int n, Object object) {
        return this.hlist.set(n, object);
    }

    public Object[] toArray(Object[] objectArray) {
        return this.hlist.toArray(objectArray);
    }
}

