/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MiscTools;
import org.jetbrains.annotations.Nullable;

public class SsiItem
implements LiveWritable,
Serializable {
    public static final int GROUP_ROOT = 0;
    public static final int TYPE_BUDDY = 0;
    public static final int TYPE_GROUP = 1;
    public static final int TYPE_PERMIT = 2;
    public static final int TYPE_DENY = 3;
    public static final int TYPE_PRIVACY = 4;
    public static final int TYPE_VISIBILITY = 5;
    public static final int TYPE_ICON_INFO = 20;
    private final String name;
    private final int parentid;
    private final int id;
    private final int type;
    private final ByteBlock data;
    private final transient int totalSize;

    @Nullable
    protected static SsiItem readSsiItem(ByteBlock block) {
        DefensiveTools.checkNull((Object)block, (String)"block");
        if (block.getLength() < 10) {
            return null;
        }
        int nameLen = BinaryTools.getUShort((ByteBlock)block, (int)0);
        if (block.getLength() < 2 + nameLen) {
            return null;
        }
        ByteBlock nameBlock = block.subBlock(2, nameLen);
        String name = BinaryTools.getUtf8String((ByteBlock)nameBlock);
        ByteBlock rest = block.subBlock(2 + nameLen);
        if (rest.getLength() < 8) {
            return null;
        }
        int groupid = BinaryTools.getUShort((ByteBlock)rest, (int)0);
        int buddyid = BinaryTools.getUShort((ByteBlock)rest, (int)2);
        int type = BinaryTools.getUShort((ByteBlock)rest, (int)4);
        int datalen = BinaryTools.getUShort((ByteBlock)rest, (int)6);
        if (rest.getLength() < 1 + datalen) {
            return null;
        }
        ByteBlock data = rest.subBlock(8, datalen);
        int size = data.getOffset() + data.getLength() - block.getOffset();
        return new SsiItem(name, groupid, buddyid, type, data, size);
    }

    private SsiItem(String name, int parentid, int id, int type, ByteBlock data, int totalSize) {
        DefensiveTools.checkNull((Object)name, (String)"name");
        DefensiveTools.checkRange((int)parentid, (String)"parentid", (int)0);
        DefensiveTools.checkRange((int)id, (String)"id", (int)0);
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        DefensiveTools.checkRange((int)totalSize, (String)"totalSize", (int)-1);
        this.name = name;
        this.parentid = parentid;
        this.id = id;
        this.type = type;
        this.data = data;
        this.totalSize = totalSize;
    }

    public SsiItem(int parentid, int id, int type) {
        this("", parentid, id, type, null);
    }

    public SsiItem(String name, int parentid, int id, int type, ByteBlock data) {
        this(name, parentid, id, type, data, -1);
    }

    public final String getName() {
        return this.name;
    }

    public final int getParentId() {
        return this.parentid;
    }

    public final int getId() {
        return this.id;
    }

    public final int getItemType() {
        return this.type;
    }

    public final ByteBlock getData() {
        return this.data;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public final boolean matches(SsiItem other) {
        DefensiveTools.checkNull((Object)other, (String)"item");
        return this.getId() == other.getId() && this.getParentId() == other.getParentId() && this.getItemType() == other.getItemType();
    }

    public void write(OutputStream out) throws IOException {
        byte[] namebytes = BinaryTools.getUtf8Bytes((String)this.name);
        BinaryTools.writeUShort((OutputStream)out, (int)namebytes.length);
        out.write(namebytes);
        BinaryTools.writeUShort((OutputStream)out, (int)this.parentid);
        BinaryTools.writeUShort((OutputStream)out, (int)this.id);
        BinaryTools.writeUShort((OutputStream)out, (int)this.type);
        int len = this.data == null ? 0 : this.data.getLength();
        BinaryTools.writeUShort((OutputStream)out, (int)len);
        if (this.data != null) {
            this.data.write(out);
        }
    }

    public String toString() {
        return "SsiItem '" + this.name + "', type=0x" + Integer.toHexString(this.type) + " (" + MiscTools.findIntField(SsiItem.class, this.type, "TYPE_.*") + "), parentid=0x" + Integer.toHexString(this.parentid) + ", id=0x" + Integer.toHexString(this.id);
    }
}

