/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets;

import java.nio.ByteBuffer;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._03InPacket;
import net.sf.jqql.packets._08OutPacket;

public abstract class _03OutPacket
extends _08OutPacket {
    protected byte totalFragment;
    protected byte currentFragment;
    protected int serialNumber;

    public _03OutPacket(char c, boolean bl, QQUser qQUser) {
        super((byte)3, c, bl, qQUser);
        this.totalFragment = 1;
        this.currentFragment = 0;
    }

    public _03OutPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    protected int getLength(int n) {
        return 46 + n;
    }

    protected boolean validateHeader() {
        return true;
    }

    protected int getHeadLength() {
        return 46;
    }

    protected int getTailLength() {
        return 0;
    }

    protected void postFill(ByteBuffer byteBuffer, int n) {
    }

    protected void putHead(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)3);
        byteBuffer.put((byte)this.command);
        byteBuffer.putChar(this.sequence);
        byteBuffer.putInt(this.serialNumber);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.put(this.totalFragment);
        byteBuffer.put(this.currentFragment);
        byteBuffer.put((byte)0);
        byteBuffer.putChar(this.source);
        byteBuffer.put((byte)0);
    }

    protected byte[] getBodyBytes(ByteBuffer byteBuffer, int n) {
        int n2 = n - 46;
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return byArray;
    }

    protected void putTail(ByteBuffer byteBuffer) {
    }

    protected int getEncryptStart() {
        return -1;
    }

    protected int getDecryptStart() {
        return -1;
    }

    protected void parseHeader(ByteBuffer byteBuffer) throws PacketParseException {
        this.header = byteBuffer.get();
        this.command = (char)byteBuffer.get();
        this.sequence = byteBuffer.getChar();
        byteBuffer.position(byteBuffer.position() + 36);
        this.totalFragment = byteBuffer.get();
        this.currentFragment = byteBuffer.get();
        byteBuffer.get();
        this.source = byteBuffer.getChar();
        byteBuffer.get();
    }

    protected void parseTail(ByteBuffer byteBuffer) throws PacketParseException {
    }

    public byte getCurrentFragment() {
        return this.currentFragment;
    }

    public void setCurrentFragment(byte by) {
        this.currentFragment = by;
    }

    public byte getTotalFragment() {
        return this.totalFragment;
    }

    public void setTotalFragment(byte by) {
        this.totalFragment = by;
    }

    public boolean equals(Object object) {
        if (object instanceof _03InPacket) {
            _03InPacket _03InPacket2 = (_03InPacket)object;
            return this.command == _03InPacket2.command && this.serialNumber == _03InPacket2.serialNumber;
        }
        if (object instanceof _03OutPacket) {
            _03OutPacket _03OutPacket2 = (_03OutPacket)object;
            return this.command == _03OutPacket2.command && this.serialNumber == _03OutPacket2.serialNumber;
        }
        return false;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(int n) {
        this.serialNumber = n;
    }

    public int getFamily() {
        return 4;
    }
}

