/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.support;

import java.util.Hashtable;
import org.openymsg.support.MessageDecoder;

public class AntiSpam {
    public static final int REPEAT = 1;
    public static final int FLOOD = 2;
    public static final int CAPS = 4;
    private Hashtable<String, UserHistory> users = new Hashtable();
    private static MessageDecoder decoder = new MessageDecoder();
    private static final int MEMORY_SZ = 5;
    private static final int MIN_MESG_SZ = 10;

    public int getViolations(String u, String m) {
        UserHistory h = this.users.get(u);
        int ret = 0;
        m = decoder.decodeToText(m);
        if (h == null) {
            h = new UserHistory();
            this.users.put(u, h);
        } else {
            if (this.isRepeat(h, m)) {
                ret |= 1;
            }
            if (this.isFlood(h, m)) {
                ret |= 2;
            }
            if (this.isCaps(h, m)) {
                ret |= 4;
            }
        }
        h.update(m, ret);
        return ret;
    }

    boolean isRepeat(UserHistory h, String m) {
        if (m.length() <= 10) {
            return false;
        }
        for (int i = 0; i < h.memory.length; ++i) {
            if (h.memory[i] == null || !h.memory[i].equals(m)) continue;
            return true;
        }
        return false;
    }

    boolean isFlood(UserHistory h, String m) {
        return false;
    }

    boolean isCaps(UserHistory h, String m) {
        if (m.length() <= 10) {
            return false;
        }
        int high = 0;
        int low = 0;
        for (int i = 0; i < m.length(); ++i) {
            char c = m.charAt(i);
            if (Character.isLowerCase(c)) {
                ++low;
                continue;
            }
            if (!Character.isUpperCase(c)) continue;
            ++high;
        }
        float f = low > 0 ? (float)high / (float)low * (100.0f / (float)(high + low)) : 100.0f;
        return (double)f >= 75.0;
    }

    private static class UserHistory {
        String[] memory = new String[5];
        int memoryPos = 0;
        int bytesSent = 0;

        UserHistory() {
        }

        void update(String m, int flags) {
            if ((flags & 1) == 0) {
                this.memory[this.memoryPos] = m;
                ++this.memoryPos;
                this.memoryPos %= this.memory.length;
            }
            this.bytesSent += m.length();
        }
    }
}

