/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.tcp.PacketReader;
import com.hazelcast.nio.tcp.SocketReader;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import java.nio.ByteBuffer;

class SocketPacketReader
implements SocketReader {
    final PacketReader packetReader;
    final TcpIpConnection connection;
    final IOService ioService;
    final ILogger logger;

    public SocketPacketReader(TcpIpConnection connection) {
        this.connection = connection;
        TcpIpConnectionManager connectionManager = connection.getConnectionManager();
        this.ioService = connectionManager.ioService;
        this.logger = this.ioService.getLogger(this.getClass().getName());
        this.packetReader = connectionManager.createPacketReader(connection);
    }

    @Override
    public void read(ByteBuffer inBuffer) throws Exception {
        this.packetReader.readPacket(inBuffer);
    }
}

