/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl;

import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.MultiMapWrapper;
import com.hazelcast.multimap.impl.ValueCollectionFactory;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class MultiMapContainerSupport {
    protected final String name;
    protected final NodeEngine nodeEngine;
    protected final MultiMapConfig config;
    protected final ConcurrentMap<Data, MultiMapWrapper> multiMapWrappers = new ConcurrentHashMap<Data, MultiMapWrapper>(1000);

    protected MultiMapContainerSupport(String name, NodeEngine nodeEngine) {
        this.name = name;
        this.nodeEngine = nodeEngine;
        this.config = nodeEngine.getConfig().findMultiMapConfig(name);
    }

    public MultiMapWrapper getOrCreateMultiMapWrapper(Data dataKey) {
        MultiMapWrapper wrapper = (MultiMapWrapper)this.multiMapWrappers.get(dataKey);
        if (wrapper != null) {
            return wrapper;
        }
        MultiMapConfig.ValueCollectionType valueCollectionType = this.config.getValueCollectionType();
        Collection<MultiMapRecord> collection = ValueCollectionFactory.createCollection(valueCollectionType);
        wrapper = new MultiMapWrapper(collection);
        this.multiMapWrappers.put(dataKey, wrapper);
        return wrapper;
    }

    public MultiMapWrapper getMultiMapWrapperOrNull(Data dataKey) {
        return (MultiMapWrapper)this.multiMapWrappers.get(dataKey);
    }

    public ConcurrentMap<Data, MultiMapWrapper> getMultiMapWrappers() {
        return this.multiMapWrappers;
    }

    public MultiMapConfig getConfig() {
        return this.config;
    }
}

