/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.voxeo.utils.Dates;
import java.lang.reflect.Type;
import org.joda.time.DateMidnight;
import org.joda.time.ReadableDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateMidnightGsonAdapter
implements JsonSerializer<DateMidnight>,
JsonDeserializer<DateMidnight> {
    public DateMidnight deserialize(JsonElement json, Type genericType, JsonDeserializationContext context) throws JsonParseException {
        DateMidnight result = null;
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            String string = primitive.getAsString();
            try {
                result = Dates.getDateTime(string, "yyyy-MM-dd").toDateMidnight();
            }
            catch (IllegalArgumentException e) {
                result = Dates.getDateTime(string, "yyyyMMdd").toDateMidnight();
            }
        }
        return result;
    }

    public JsonElement serialize(DateMidnight dateTime, Type sourceType, JsonSerializationContext context) {
        return dateTime != null ? new JsonPrimitive(Dates.format("yyyy-MM-dd", (ReadableDateTime)dateTime)) : new JsonNull();
    }
}

