/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.version.util;

import org.jitsi.service.version.Version;

public abstract class AbstractVersion
implements Version {
    private int versionMajor;
    private int versionMinor;
    private String nightlyBuildID;

    protected AbstractVersion(int majorVersion, int minorVersion, String nightlyBuildID) {
        this.versionMajor = majorVersion;
        this.versionMinor = minorVersion;
        this.nightlyBuildID = nightlyBuildID;
    }

    @Override
    public int getVersionMajor() {
        return this.versionMajor;
    }

    @Override
    public int getVersionMinor() {
        return this.versionMinor;
    }

    @Override
    public String getNightlyBuildID() {
        if (!this.isNightly()) {
            return null;
        }
        return this.nightlyBuildID;
    }

    @Override
    public int compareTo(Version version) {
        if (version == null) {
            return -1;
        }
        if (this.getVersionMajor() != version.getVersionMajor()) {
            return this.getVersionMajor() - version.getVersionMajor();
        }
        if (this.getVersionMinor() != version.getVersionMinor()) {
            return this.getVersionMinor() - version.getVersionMinor();
        }
        try {
            return AbstractVersion.compareNightlyBuildIDByComponents(this.getNightlyBuildID(), version.getNightlyBuildID());
        }
        catch (Throwable throwable) {
            return this.getNightlyBuildID().compareTo(version.getNightlyBuildID());
        }
    }

    private static int compareNightlyBuildIDByComponents(String v1, String v2) {
        String[] s1 = v1.split("\\.");
        String[] s2 = v2.split("\\.");
        int len = Math.max(s1.length, s2.length);
        for (int i = 0; i < len; ++i) {
            int n1 = 0;
            int n2 = 0;
            if (i < s1.length) {
                n1 = Integer.valueOf(s1[i]);
            }
            if (i < s2.length) {
                n2 = Integer.valueOf(s2[i]);
            }
            if (n1 == n2) continue;
            return n1 - n2;
        }
        return 0;
    }

    @Override
    public boolean equals(Object version) {
        return this.toString().equals(version == null ? "null" : version.toString());
    }

    @Override
    public String toString() {
        StringBuffer versionStringBuff = new StringBuffer();
        versionStringBuff.append(Integer.toString(this.getVersionMajor()));
        versionStringBuff.append(".");
        versionStringBuff.append(Integer.toString(this.getVersionMinor()));
        if (this.isPreRelease()) {
            versionStringBuff.append("-");
            versionStringBuff.append(this.getPreReleaseID());
        }
        if (this.isNightly()) {
            versionStringBuff.append(".");
            versionStringBuff.append(this.getNightlyBuildID());
        }
        return versionStringBuff.toString();
    }
}

