/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jitsi.util.Logger;

public class BlockCipherAdapter
implements BlockCipher {
    private static final Logger logger = Logger.getLogger(BlockCipherAdapter.class);
    private final String algorithmName;
    private final int blockSize;
    private final Cipher cipher;

    public BlockCipherAdapter(Cipher cipher) {
        if (cipher == null) {
            throw new NullPointerException("cipher");
        }
        this.cipher = cipher;
        String algorithmName = cipher.getAlgorithm();
        if (algorithmName != null) {
            int len;
            int endIndex = algorithmName.indexOf(47);
            if (endIndex > 0) {
                algorithmName = algorithmName.substring(0, endIndex);
            }
            if ((len = algorithmName.length()) > 4 && (algorithmName.endsWith("_128") || algorithmName.endsWith("_192") || algorithmName.endsWith("_256"))) {
                algorithmName = algorithmName.substring(0, len - 4);
            }
        }
        this.algorithmName = algorithmName;
        this.blockSize = cipher.getBlockSize();
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        byte[] bytes;
        SecretKeySpec key = null;
        if (params instanceof KeyParameter && (bytes = ((KeyParameter)params).getKey()) != null) {
            key = new SecretKeySpec(bytes, this.getAlgorithmName());
        }
        try {
            this.cipher.init(forEncryption ? 1 : 2, key);
        }
        catch (InvalidKeyException ike) {
            logger.error(ike, ike);
            throw new IllegalArgumentException(ike);
        }
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        try {
            return this.cipher.update(in, inOff, this.getBlockSize(), out, outOff);
        }
        catch (ShortBufferException sbe) {
            logger.error(sbe, sbe);
            DataLengthException dle = new DataLengthException();
            dle.initCause((Throwable)sbe);
            throw dle;
        }
    }

    public void reset() {
        try {
            this.cipher.doFinal();
        }
        catch (GeneralSecurityException gse) {
            logger.error(gse, gse);
        }
    }
}

