/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.media.Format;
import javax.media.rtp.ReceiveStreamListener;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorDesc;

class StreamRTPManagerDesc {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    public RTPConnectorDesc connectorDesc;
    private final Map<Integer, Format> formats = new HashMap<Integer, Format>();
    private int[] receiveSSRCs = EMPTY_INT_ARRAY;
    private final List<ReceiveStreamListener> receiveStreamListeners = new LinkedList<ReceiveStreamListener>();
    public final StreamRTPManager streamRTPManager;

    public StreamRTPManagerDesc(StreamRTPManager streamRTPManager) {
        this.streamRTPManager = streamRTPManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormat(Format format, int payloadType) {
        Map<Integer, Format> map = this.formats;
        synchronized (map) {
            this.formats.put(payloadType, format);
        }
    }

    public synchronized void addReceiveSSRC(int receiveSSRC) {
        if (!this.containsReceiveSSRC(receiveSSRC)) {
            int receiveSSRCCount = this.receiveSSRCs.length;
            int[] newReceiveSSRCs = new int[receiveSSRCCount + 1];
            System.arraycopy(this.receiveSSRCs, 0, newReceiveSSRCs, 0, receiveSSRCCount);
            newReceiveSSRCs[receiveSSRCCount] = receiveSSRC;
            this.receiveSSRCs = newReceiveSSRCs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReceiveStreamListener(ReceiveStreamListener listener) {
        List<ReceiveStreamListener> list = this.receiveStreamListeners;
        synchronized (list) {
            if (!this.receiveStreamListeners.contains(listener)) {
                this.receiveStreamListeners.add(listener);
            }
        }
    }

    public synchronized boolean containsReceiveSSRC(int receiveSSRC) {
        for (int i = 0; i < this.receiveSSRCs.length; ++i) {
            if (this.receiveSSRCs[i] != receiveSSRC) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Format getFormat(int payloadType) {
        Map<Integer, Format> map = this.formats;
        synchronized (map) {
            return this.formats.get(payloadType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Format[] getFormats() {
        Map<Integer, Format> map = this.formats;
        synchronized (map) {
            Collection<Format> formats = this.formats.values();
            return formats.toArray(new Format[formats.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getPayloadType(Format format) {
        Map<Integer, Format> map = this.formats;
        synchronized (map) {
            for (Map.Entry<Integer, Format> entry : this.formats.entrySet()) {
                Format entryFormat = entry.getValue();
                if (!entryFormat.matches(format) && !format.matches(entryFormat)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceiveStreamListener[] getReceiveStreamListeners() {
        List<ReceiveStreamListener> list = this.receiveStreamListeners;
        synchronized (list) {
            return this.receiveStreamListeners.toArray(new ReceiveStreamListener[this.receiveStreamListeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReceiveStreamListener(ReceiveStreamListener listener) {
        List<ReceiveStreamListener> list = this.receiveStreamListeners;
        synchronized (list) {
            this.receiveStreamListeners.remove(listener);
        }
    }
}

