/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp.termination.strategies;

import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPReportBuilder;
import net.sf.fmj.media.rtp.RTCPTransmitter;
import net.sf.fmj.media.rtp.SSRCCache;
import org.jitsi.service.neomedia.RTCPTerminationStrategy;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.Transformer;

public abstract class AbstractRTCPTerminationStrategy
implements RTCPTerminationStrategy,
Transformer<RTCPCompoundPacket>,
RTCPReportBuilder {
    private RTCPTransmitter rtcpTransmitter;
    private RTPTranslator translator;
    private Transformer<RTCPCompoundPacket>[] transformerChain;

    @Override
    public void reset() {
    }

    @Override
    public void setRTCPTransmitter(RTCPTransmitter rtcpTransmitter) {
        if (rtcpTransmitter != this.rtcpTransmitter) {
            this.rtcpTransmitter = rtcpTransmitter;
            this.onRTCPTransmitterChanged();
        }
    }

    private void onRTCPTransmitterChanged() {
        SSRCCache c;
        RTCPTransmitter t = this.rtcpTransmitter;
        if (t != null && (c = t.cache) != null) {
            c.audio = false;
        }
    }

    @Override
    public RTCPTransmitter getRTCPTransmitter() {
        return this.rtcpTransmitter;
    }

    @Override
    public Transformer<RTCPCompoundPacket> getRTCPCompoundPacketTransformer() {
        return this;
    }

    @Override
    public RTCPCompoundPacket reverseTransform(RTCPCompoundPacket inPacket) {
        Transformer<RTCPCompoundPacket>[] transformers = this.transformerChain;
        if (transformers != null && transformers.length != 0) {
            for (Transformer<RTCPCompoundPacket> transformer : transformers) {
                inPacket = transformer.reverseTransform(inPacket);
            }
        }
        return inPacket;
    }

    @Override
    public RTCPCompoundPacket transform(RTCPCompoundPacket inPacket) {
        Transformer<RTCPCompoundPacket>[] transformers = this.transformerChain;
        if (transformers != null && transformers.length != 0) {
            for (Transformer<RTCPCompoundPacket> transformer : transformers) {
                inPacket = transformer.transform(inPacket);
            }
        }
        return inPacket;
    }

    @Override
    public void close() {
    }

    public void setTransformerChain(Transformer<RTCPCompoundPacket>[] transformers) {
        this.transformerChain = transformers;
    }

    @Override
    public RTCPReportBuilder getRTCPReportBuilder() {
        return this;
    }

    @Override
    public void setRTPTranslator(RTPTranslator translator) {
        this.translator = translator;
    }

    @Override
    public RTPTranslator getRTPTranslator() {
        return this.translator;
    }
}

