/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import org.jitsi.impl.neomedia.codec.audio.silk.AnaFiltBank1;
import org.jitsi.impl.neomedia.codec.audio.silk.Inlines;
import org.jitsi.impl.neomedia.codec.audio.silk.Lin2log;
import org.jitsi.impl.neomedia.codec.audio.silk.Macros;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_VAD_state;
import org.jitsi.impl.neomedia.codec.audio.silk.SigProcFIX;
import org.jitsi.impl.neomedia.codec.audio.silk.SigmQ15;

public class VAD {
    static int[] tiltWeights = new int[]{30000, 6000, -12000, -12000};

    static int SKP_Silk_VAD_Init(SKP_Silk_VAD_state psSilk_VAD) {
        int b;
        int ret = 0;
        for (b = 0; b < 4; ++b) {
            psSilk_VAD.NoiseLevelBias[b] = Math.max(50 / (b + 1), 1);
        }
        for (b = 0; b < 4; ++b) {
            psSilk_VAD.NL[b] = 100 * psSilk_VAD.NoiseLevelBias[b];
            psSilk_VAD.inv_NL[b] = Integer.MAX_VALUE / psSilk_VAD.NL[b];
        }
        psSilk_VAD.counter = 15;
        for (b = 0; b < 4; ++b) {
            psSilk_VAD.NrgRatioSmth_Q8[b] = 25600;
        }
        return ret;
    }

    static int SKP_Silk_VAD_GetSA_Q8(SKP_Silk_VAD_state psSilk_VAD, int[] pSA_Q8, int[] pSNR_dB_Q7, int[] pQuality_Q15, int[] pTilt_Q15, short[] pIn, int pIn_offset, int framelength) {
        int SNR_Q7;
        int speech_nrg;
        int b;
        int i;
        int[] scratch = new int[720];
        int sumSquared = 0;
        short[][] X = new short[4][240];
        int[] Xnrg = new int[4];
        int[] NrgToNoiseRatio_Q8 = new int[4];
        int ret = 0;
        assert (480 >= framelength);
        assert (framelength <= 512);
        AnaFiltBank1.SKP_Silk_ana_filt_bank_1(pIn, pIn_offset, psSilk_VAD.AnaState, 0, X[0], 0, X[3], 0, scratch, framelength);
        AnaFiltBank1.SKP_Silk_ana_filt_bank_1(X[0], 0, psSilk_VAD.AnaState1, 0, X[0], 0, X[2], 0, scratch, framelength >> 1);
        AnaFiltBank1.SKP_Silk_ana_filt_bank_1(X[0], 0, psSilk_VAD.AnaState2, 0, X[0], 0, X[1], 0, scratch, framelength >> 2);
        int decimated_framelength = framelength >> 3;
        X[0][decimated_framelength - 1] = (short)(X[0][decimated_framelength - 1] >> 1);
        short HPstateTmp = X[0][decimated_framelength - 1];
        for (i = decimated_framelength - 1; i > 0; --i) {
            X[0][i - 1] = (short)(X[0][i - 1] >> 1);
            short[] sArray = X[0];
            int n = i;
            sArray[n] = (short)(sArray[n] - X[0][i - 1]);
        }
        short[] sArray = X[0];
        sArray[0] = (short)(sArray[0] - psSilk_VAD.HPstate);
        psSilk_VAD.HPstate = HPstateTmp;
        for (b = 0; b < 4; ++b) {
            decimated_framelength = framelength >> Math.min(4 - b, 3);
            int dec_subframe_length = decimated_framelength >> 2;
            int dec_subframe_offset = 0;
            Xnrg[b] = psSilk_VAD.XnrgSubfr[b];
            for (int s = 0; s < 4; ++s) {
                sumSquared = 0;
                for (i = 0; i < dec_subframe_length; ++i) {
                    int x_tmp = X[b][i + dec_subframe_offset] >> 3;
                    sumSquared = Macros.SKP_SMLABB(sumSquared, x_tmp, x_tmp);
                    assert (sumSquared >= 0);
                }
                Xnrg[b] = s < 3 ? SigProcFIX.SKP_ADD_POS_SAT32(Xnrg[b], sumSquared) : SigProcFIX.SKP_ADD_POS_SAT32(Xnrg[b], sumSquared >> 1);
                dec_subframe_offset += dec_subframe_length;
            }
            psSilk_VAD.XnrgSubfr[b] = sumSquared;
        }
        VAD.SKP_Silk_VAD_GetNoiseLevels(Xnrg, psSilk_VAD);
        sumSquared = 0;
        int input_tilt = 0;
        for (b = 0; b < 4; ++b) {
            speech_nrg = Xnrg[b] - psSilk_VAD.NL[b];
            if (speech_nrg > 0) {
                NrgToNoiseRatio_Q8[b] = (Xnrg[b] & 0xFF800000) == 0 ? (Xnrg[b] << 8) / (psSilk_VAD.NL[b] + 1) : Xnrg[b] / ((psSilk_VAD.NL[b] >> 8) + 1);
                SNR_Q7 = Lin2log.SKP_Silk_lin2log(NrgToNoiseRatio_Q8[b]) - 1024;
                sumSquared = Macros.SKP_SMLABB(sumSquared, SNR_Q7, SNR_Q7);
                if (speech_nrg < 0x100000) {
                    SNR_Q7 = Macros.SKP_SMULWB(Inlines.SKP_Silk_SQRT_APPROX(speech_nrg) << 6, SNR_Q7);
                }
                input_tilt = Macros.SKP_SMLAWB(input_tilt, tiltWeights[b], SNR_Q7);
                continue;
            }
            NrgToNoiseRatio_Q8[b] = 256;
        }
        pSNR_dB_Q7[0] = (short)(3 * Inlines.SKP_Silk_SQRT_APPROX(sumSquared /= 4));
        int SA_Q15 = SigmQ15.SKP_Silk_sigm_Q15(Macros.SKP_SMULWB(45000, pSNR_dB_Q7[0]) - 128);
        pTilt_Q15[0] = SigmQ15.SKP_Silk_sigm_Q15(input_tilt) - 16384 << 1;
        speech_nrg = 0;
        for (b = 0; b < 4; ++b) {
            speech_nrg += (b + 1) * (Xnrg[b] - psSilk_VAD.NL[b] >> 4);
        }
        if (speech_nrg <= 0) {
            SA_Q15 >>= 1;
        } else if (speech_nrg < 32768) {
            speech_nrg = Inlines.SKP_Silk_SQRT_APPROX(speech_nrg << 15);
            SA_Q15 = Macros.SKP_SMULWB(32768 + speech_nrg, SA_Q15);
        }
        pSA_Q8[0] = Math.min(SA_Q15 >> 7, 255);
        int smooth_coef_Q16 = Macros.SKP_SMULWB(4096, Macros.SKP_SMULWB(SA_Q15, SA_Q15));
        for (b = 0; b < 4; ++b) {
            psSilk_VAD.NrgRatioSmth_Q8[b] = Macros.SKP_SMLAWB(psSilk_VAD.NrgRatioSmth_Q8[b], NrgToNoiseRatio_Q8[b] - psSilk_VAD.NrgRatioSmth_Q8[b], smooth_coef_Q16);
            SNR_Q7 = 3 * (Lin2log.SKP_Silk_lin2log(psSilk_VAD.NrgRatioSmth_Q8[b]) - 1024);
            pQuality_Q15[b] = SigmQ15.SKP_Silk_sigm_Q15(SNR_Q7 - 2048 >> 4);
        }
        return ret;
    }

    static void SKP_Silk_VAD_GetNoiseLevels(int[] pX, SKP_Silk_VAD_state psSilk_VAD) {
        int min_coef = psSilk_VAD.counter < 1000 ? Short.MAX_VALUE / ((psSilk_VAD.counter >> 4) + 1) : 0;
        for (int k = 0; k < 4; ++k) {
            int nl = psSilk_VAD.NL[k];
            assert (nl >= 0);
            int nrg = SigProcFIX.SKP_ADD_POS_SAT32(pX[k], psSilk_VAD.NoiseLevelBias[k]);
            assert (nrg > 0);
            int inv_nrg = Integer.MAX_VALUE / nrg;
            assert (inv_nrg >= 0);
            int coef = nrg > nl << 3 ? 128 : (nrg < nl ? 1024 : Macros.SKP_SMULWB(Macros.SKP_SMULWW(inv_nrg, nl), 2048));
            coef = Math.max(coef, min_coef);
            psSilk_VAD.inv_NL[k] = Macros.SKP_SMLAWB(psSilk_VAD.inv_NL[k], inv_nrg - psSilk_VAD.inv_NL[k], coef);
            assert (psSilk_VAD.inv_NL[k] >= 0);
            nl = Integer.MAX_VALUE / psSilk_VAD.inv_NL[k];
            assert (nl >= 0);
            psSilk_VAD.NL[k] = nl = Math.min(nl, 0xFFFFFF);
        }
        ++psSilk_VAD.counter;
    }
}

