/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.ArrayIOUtils;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.audio.AbstractFFmpegAudioCodec;

public class FFmpegAudioDecoder
extends AbstractFFmpegAudioCodec {
    private long avpkt;
    private final boolean[] got_frame = new boolean[1];
    private long frame;

    public static void assertFindAVCodec(int codecID) {
        if (FFmpeg.avcodec_find_decoder(codecID) == 0L) {
            throw new RuntimeException("Could not find FFmpeg decoder " + FFmpegAudioDecoder.codecIDToString(codecID) + "!");
        }
    }

    protected FFmpegAudioDecoder(String name, int codecID, Format[] supportedOutputFormats) {
        super(name, codecID, supportedOutputFormats);
    }

    @Override
    protected synchronized void doClose() {
        long frame;
        super.doClose();
        long avpkt = this.avpkt;
        if (avpkt != 0L) {
            this.avpkt = 0L;
            FFmpeg.avcodec_free_packet(avpkt);
        }
        if ((frame = this.frame) != 0L) {
            this.frame = 0L;
            FFmpeg.avcodec_free_frame(frame);
        }
    }

    @Override
    protected synchronized void doOpen() throws ResourceUnavailableException {
        super.doOpen();
        long avpkt = this.avpkt;
        if (avpkt != 0L) {
            this.avpkt = 0L;
            FFmpeg.avcodec_free_packet(avpkt);
        }
        if ((avpkt = FFmpeg.avcodec_alloc_packet(0)) == 0L) {
            this.doClose();
            throw new ResourceUnavailableException("Failed to allocate a new AVPacket for FFmpeg codec " + FFmpegAudioDecoder.codecIDToString(this.codecID) + "!");
        }
        this.avpkt = avpkt;
        long frame = this.frame;
        if (frame != 0L) {
            this.frame = 0L;
            FFmpeg.avcodec_free_frame(frame);
        }
        if ((frame = FFmpeg.avcodec_alloc_frame()) == 0L) {
            this.doClose();
            throw new ResourceUnavailableException("Failed to allocate a new AVFrame for FFmpeg codec " + FFmpegAudioDecoder.codecIDToString(this.codecID) + "!");
        }
        this.frame = frame;
    }

    @Override
    protected synchronized int doProcess(Buffer inBuf, Buffer outBuf) {
        byte[] in = (byte[])inBuf.getData();
        int inLen = inBuf.getLength();
        int inOff = inBuf.getOffset();
        long avpkt = this.avpkt;
        long frame = this.frame;
        FFmpeg.avpacket_set_data(avpkt, in, inOff, inLen);
        int consumedInLen = FFmpeg.avcodec_decode_audio4(this.avctx, frame, this.got_frame, avpkt);
        if (consumedInLen < 0 || consumedInLen > inLen) {
            return 1;
        }
        int doProcess = 0;
        inBuf.setLength(inLen -= consumedInLen);
        if (inLen > 0) {
            doProcess |= 2;
        }
        if (this.got_frame[0]) {
            long data0 = FFmpeg.avframe_get_data0(frame);
            int linesize0 = FFmpeg.avframe_get_linesize0(frame);
            if (data0 == 0L) {
                doProcess = 1;
            } else {
                byte[] bytes = new byte[linesize0];
                FFmpeg.memcpy(bytes, 0, bytes.length, data0);
                FloatBuffer floats = ByteBuffer.wrap(bytes).order(ByteOrder.nativeOrder()).asFloatBuffer();
                int outLen = floats.limit() * 2;
                byte[] out = FFmpegAudioDecoder.validateByteArraySize(outBuf, outLen, false);
                outLen = 0;
                int floatEnd = floats.limit();
                for (int floatI = 0; floatI < floatEnd; ++floatI) {
                    int s16 = Math.round(floats.get(floatI) * 32767.0f);
                    if (s16 < Short.MIN_VALUE) {
                        s16 = Short.MIN_VALUE;
                    } else if (s16 > Short.MAX_VALUE) {
                        s16 = Short.MAX_VALUE;
                    }
                    ArrayIOUtils.writeInt16(s16, out, outLen);
                    outLen += 2;
                }
                outBuf.setDuration(20000000L);
                outBuf.setFormat(this.getOutputFormat());
                outBuf.setLength(outLen);
                outBuf.setOffset(0);
            }
        } else {
            doProcess |= 4;
        }
        return doProcess;
    }

    @Override
    protected long findAVCodec(int codecID) {
        return FFmpeg.avcodec_find_decoder(codecID);
    }

    @Override
    protected AudioFormat getAVCodecContextFormat() {
        return (AudioFormat)this.getOutputFormat();
    }
}

