/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.registry;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.fmj.registry.RegistryContents;
import net.sf.fmj.registry.RegistryIO;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.SerializationUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLRegistryIO
implements RegistryIO {
    private static final Logger logger = LoggerSingleton.logger;
    private final RegistryContents registryContents;
    private static final String version = "0.1";
    private static final String ELEMENT_REGISTRY = "registry";
    private static final String ATTR_VERSION = "version";
    private static final String ELEMENT_PROTO_PREFIX = "protocol-prefixes";
    private static final String ELEMENT_CONTENT_PREFIX = "content-prefixes";
    private static final String ELEMENT_PLUGINS = "plugins";
    private static final String ELEMENT_MIMETYPES = "mime-types";
    private static final String ELEMENT_MIMETYPE = "type";
    private static final String ELEMENT_CAPTURE_DEVICES = "capture-devices";
    private static final String ELEMENT_CODECS = "codecs";
    private static final String ELEMENT_DEMUXES = "demuxes";
    private static final String ELEMENT_MUXES = "muxes";
    private static final String ELEMENT_EFFECTS = "effects";
    private static final String ELEMENT_RENDERERS = "renderers";
    private static final String ELEMENT_PREFIX = "prefix";
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_DEVICE = "device";
    private static final String ELEMENT_DEVICE_NAME = "name";
    private static final String ELEMENT_DEVICE_LOCATOR = "locator";
    private static final String ELEMENT_DEVICE_FORMAT = "format";
    private static final String ELEMENT_DEVICE_FORMAT_CLASS = "class";
    private static final String ELEMENT_DEVICE_FORMAT_DESCRIPTION = "description";
    private static final String ELEMENT_DEVICE_FORMAT_SERIALIZED = "serialized";

    public XMLRegistryIO(RegistryContents registryContents) {
        this.registryContents = registryContents;
    }

    private Document buildDocument() throws IOException {
        Document document;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pce) {
            IOException ioe = new IOException();
            ioe.initCause(pce);
            throw ioe;
        }
        Element rootElement = document.createElement(ELEMENT_REGISTRY);
        rootElement.setAttribute(ATTR_VERSION, version);
        document.appendChild(rootElement);
        rootElement.appendChild(this.getPluginsElement(document));
        rootElement.appendChild(this.getContentElement(document));
        rootElement.appendChild(this.getProtocolElement(document));
        rootElement.appendChild(this.getMimeElement(document));
        rootElement.appendChild(this.getCaptureDeviceElement(document));
        return document;
    }

    private Element getCaptureDeviceElement(Document document) throws IOException {
        Element captureDeviceElement = document.createElement(ELEMENT_CAPTURE_DEVICES);
        for (CaptureDeviceInfo info : this.registryContents.captureDeviceInfoList) {
            if (info.getLocator() == null) continue;
            Element deviceElement = document.createElement(ELEMENT_DEVICE);
            Element deviceNameElement = document.createElement(ELEMENT_DEVICE_NAME);
            deviceNameElement.setTextContent(info.getName());
            deviceElement.appendChild(deviceNameElement);
            Element e = document.createElement(ELEMENT_DEVICE_LOCATOR);
            e.setTextContent(info.getLocator().toExternalForm());
            deviceElement.appendChild(e);
            Format[] formats = info.getFormats();
            for (int i = 0; i < formats.length; ++i) {
                Element formatElement = document.createElement(ELEMENT_DEVICE_FORMAT);
                Element e2 = document.createElement("class");
                e2.setTextContent(formats[i].getClass().getName());
                formatElement.appendChild(e2);
                e2 = document.createElement(ELEMENT_DEVICE_FORMAT_DESCRIPTION);
                e2.setTextContent(formats[i].toString());
                formatElement.appendChild(e2);
                e2 = document.createElement(ELEMENT_DEVICE_FORMAT_SERIALIZED);
                e2.setTextContent(SerializationUtils.serialize(formats[i]));
                formatElement.appendChild(e2);
                deviceElement.appendChild(formatElement);
            }
            captureDeviceElement.appendChild(deviceElement);
        }
        return captureDeviceElement;
    }

    private Element getChild(Element element, String name) {
        NodeList childNodes = element.getChildNodes();
        int childNodeCount = childNodes.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals(name)) continue;
            return (Element)childNode;
        }
        return null;
    }

    private List<Element> getChildren(Element element, String name) {
        NodeList childNodes = element.getChildNodes();
        int childNodeCount = childNodes.getLength();
        ArrayList<Element> children = new ArrayList<Element>(childNodeCount);
        for (int i = 0; i < childNodeCount; ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals(name)) continue;
            children.add((Element)childNode);
        }
        return children;
    }

    private Element getCodecElement(Document document) {
        return this.getPluginElement(2, ELEMENT_CODECS, document);
    }

    private Element getContentElement(Document document) {
        Element contentElement = document.createElement(ELEMENT_CONTENT_PREFIX);
        for (String prefix : this.registryContents.contentPrefixList) {
            Element prefixElement = document.createElement(ELEMENT_PREFIX);
            prefixElement.setTextContent(prefix);
            contentElement.appendChild(prefixElement);
        }
        return contentElement;
    }

    private Element getDemuxElement(Document document) {
        return this.getPluginElement(1, ELEMENT_DEMUXES, document);
    }

    private Element getEffectElement(Document document) {
        return this.getPluginElement(3, ELEMENT_EFFECTS, document);
    }

    private Element getMimeElement(Document document) {
        Element mimeElement = document.createElement(ELEMENT_MIMETYPES);
        for (String type : this.registryContents.mimeTable.getMimeTypes()) {
            List<String> extensions = this.registryContents.mimeTable.getExtensions(type);
            Element typeElement = document.createElement(ELEMENT_MIMETYPE);
            typeElement.setAttribute("value", type);
            typeElement.setAttribute("default-ext", this.registryContents.mimeTable.getDefaultExtension(type));
            mimeElement.appendChild(typeElement);
            for (int i = 0; i < extensions.size(); ++i) {
                String ext = extensions.get(i);
                Element extElement = document.createElement("ext");
                extElement.setTextContent(ext);
                typeElement.appendChild(extElement);
            }
        }
        return mimeElement;
    }

    private Element getMuxElement(Document document) {
        return this.getPluginElement(5, ELEMENT_MUXES, document);
    }

    private Element getPluginElement(int pluginType, String typeName, Document document) {
        Element pluginsElement = document.createElement(typeName);
        Vector<String> plugins = this.registryContents.plugins[pluginType - 1];
        if (plugins != null) {
            for (String classname : plugins) {
                Element pluginElement = document.createElement("class");
                pluginElement.setTextContent(classname);
                pluginsElement.appendChild(pluginElement);
            }
        }
        return pluginsElement;
    }

    private Element getPluginsElement(Document document) {
        Element pluginElement = document.createElement(ELEMENT_PLUGINS);
        pluginElement.appendChild(this.getCodecElement(document));
        pluginElement.appendChild(this.getDemuxElement(document));
        pluginElement.appendChild(this.getEffectElement(document));
        pluginElement.appendChild(this.getMuxElement(document));
        pluginElement.appendChild(this.getRendererElement(document));
        return pluginElement;
    }

    private Element getProtocolElement(Document document) {
        Element protocolElement = document.createElement(ELEMENT_PROTO_PREFIX);
        for (String prefix : this.registryContents.protocolPrefixList) {
            Element prefixElement = document.createElement(ELEMENT_PREFIX);
            prefixElement.setTextContent(prefix);
            protocolElement.appendChild(prefixElement);
        }
        return protocolElement;
    }

    private Element getRendererElement(Document document) {
        return this.getPluginElement(4, ELEMENT_RENDERERS, document);
    }

    private String getTextTrim(Element element) {
        String text = element.getTextContent();
        return text == null ? null : text.trim();
    }

    @Override
    public void load(InputStream is) throws IOException {
        Exception t = null;
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            this.loadDocument(document);
        }
        catch (ParserConfigurationException pce) {
            t = pce;
        }
        catch (SAXException saxe) {
            t = saxe;
        }
        if (t != null) {
            IOException ioe = new IOException();
            ioe.initCause(t);
            throw ioe;
        }
    }

    private void loadCaptureDevices(Element element) throws IOException, ClassNotFoundException {
        this.registryContents.captureDeviceInfoList.clear();
        List<Element> list = this.getChildren(element, ELEMENT_DEVICE);
        for (int i = 0; i < list.size(); ++i) {
            Element deviceElement = list.get(i);
            Element deviceNameElement = this.getChild(deviceElement, ELEMENT_DEVICE_NAME);
            Element deviceLocatorElement = this.getChild(deviceElement, ELEMENT_DEVICE_LOCATOR);
            List<Element> formatElementsList = this.getChildren(deviceElement, ELEMENT_DEVICE_FORMAT);
            Format[] formats = new Format[formatElementsList.size()];
            for (int j = 0; j < formatElementsList.size(); ++j) {
                Element formatElement = formatElementsList.get(j);
                Element serializedElement = this.getChild(formatElement, ELEMENT_DEVICE_FORMAT_SERIALIZED);
                formats[j] = SerializationUtils.deserialize(this.getTextTrim(serializedElement));
            }
            CaptureDeviceInfo info = new CaptureDeviceInfo(this.getTextTrim(deviceNameElement), new MediaLocator(this.getTextTrim(deviceLocatorElement)), formats);
            this.registryContents.captureDeviceInfoList.add(info);
        }
    }

    private void loadContentPrefixes(Element element) {
        this.registryContents.contentPrefixList.clear();
        List<Element> list = this.getChildren(element, ELEMENT_PREFIX);
        for (int i = 0; i < list.size(); ++i) {
            Element prefixElement = list.get(i);
            this.registryContents.contentPrefixList.add(this.getTextTrim(prefixElement));
        }
    }

    private void loadDocument(Document document) throws IOException {
        Element rootElement = (Element)document.getFirstChild();
        String versionString = rootElement.getAttribute(ATTR_VERSION);
        logger.info("FMJ registry document version " + versionString);
        Element pluginsElement = this.getChild(rootElement, ELEMENT_PLUGINS);
        this.loadPlugins(pluginsElement);
        Element contentPrefixesElement = this.getChild(rootElement, ELEMENT_CONTENT_PREFIX);
        this.loadContentPrefixes(contentPrefixesElement);
        Element protocolPrefixesElement = this.getChild(rootElement, ELEMENT_PROTO_PREFIX);
        this.loadProtocolPrefixes(protocolPrefixesElement);
        Element mimetypesElement = this.getChild(rootElement, ELEMENT_MIMETYPES);
        this.loadMimeTypes(mimetypesElement);
        Element captureDevicesElement = this.getChild(rootElement, ELEMENT_CAPTURE_DEVICES);
        try {
            this.loadCaptureDevices(captureDevicesElement);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void loadMimeTypes(Element element) {
        this.registryContents.mimeTable.clear();
        List<Element> list = this.getChildren(element, ELEMENT_MIMETYPE);
        for (int i = 0; i < list.size(); ++i) {
            Element typeElement = list.get(i);
            String type = typeElement.getAttribute("value");
            String defaultExtension = typeElement.getAttribute("default-ext");
            List<Element> list2 = this.getChildren(typeElement, "ext");
            for (int j = 0; j < list2.size(); ++j) {
                Element extElement = list2.get(j);
                String ext = extElement.getTextContent();
                this.registryContents.mimeTable.addMimeType(ext, type);
            }
            this.registryContents.mimeTable.addMimeType(defaultExtension, type);
        }
    }

    private void loadPlugins(Element element) {
        Element codecsElement = this.getChild(element, ELEMENT_CODECS);
        this.loadPlugins(codecsElement, 2);
        Element effectsElement = this.getChild(element, ELEMENT_EFFECTS);
        this.loadPlugins(effectsElement, 3);
        Element renderersElement = this.getChild(element, ELEMENT_RENDERERS);
        this.loadPlugins(renderersElement, 4);
        Element muxesElement = this.getChild(element, ELEMENT_MUXES);
        this.loadPlugins(muxesElement, 5);
        Element demuxesElement = this.getChild(element, ELEMENT_DEMUXES);
        this.loadPlugins(demuxesElement, 1);
    }

    private void loadPlugins(Element element, int type) {
        if (element == null) {
            return;
        }
        Vector<String> vector = this.registryContents.plugins[type - 1];
        for (Element pluginElement : this.getChildren(element, "class")) {
            String classname = this.getTextTrim(pluginElement);
            vector.add(classname);
        }
    }

    private void loadProtocolPrefixes(Element element) {
        this.registryContents.protocolPrefixList.clear();
        for (Element prefixElement : this.getChildren(element, ELEMENT_PREFIX)) {
            this.registryContents.protocolPrefixList.add(this.getTextTrim(prefixElement));
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        Transformer serializer;
        Document document = this.buildDocument();
        DOMSource domSource = new DOMSource(document);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            tf.setAttribute("indent-number", 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            serializer = tf.newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            IOException ioe = new IOException();
            ioe.initCause(tce);
            throw ioe;
        }
        try {
            serializer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        }
        catch (Exception tce) {
            // empty catch block
        }
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputProperty("indent", "yes");
        try {
            serializer.transform(domSource, new StreamResult(new OutputStreamWriter(os, "UTF-8")));
        }
        catch (TransformerException te) {
            IOException ioe = new IOException();
            ioe.initCause(te);
            throw ioe;
        }
    }
}

