/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import net.sf.fmj.ui.wizard.WizardController;
import net.sf.fmj.ui.wizard.WizardModel;
import net.sf.fmj.ui.wizard.WizardPanelDescriptor;

public class Wizard
extends WindowAdapter
implements PropertyChangeListener {
    public static final int FINISH_RETURN_CODE = 0;
    public static final int CANCEL_RETURN_CODE = 1;
    public static final int ERROR_RETURN_CODE = 2;
    public static final String NEXT_BUTTON_ACTION_COMMAND = "NextButtonActionCommand";
    public static final String BACK_BUTTON_ACTION_COMMAND = "BackButtonActionCommand";
    public static final String CANCEL_BUTTON_ACTION_COMMAND = "CancelButtonActionCommand";
    static String BACK_TEXT = "< Back";
    static String NEXT_TEXT = "Next >";
    static String FINISH_TEXT = "Finish";
    static String CANCEL_TEXT = "Cancel";
    private WizardModel wizardModel = new WizardModel();
    private WizardController wizardController;
    private JDialog wizardDialog;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JButton backButton;
    private JButton nextButton;
    private JButton cancelButton;
    private int returnCode;

    public Wizard(Dialog dialog) {
        this.wizardDialog = new JDialog(dialog);
        this.initComponents();
    }

    public Wizard(Frame frame) {
        this.wizardDialog = new JDialog(frame);
        this.initComponents();
    }

    void close(int n) {
        WizardPanelDescriptor wizardPanelDescriptor = this.wizardModel.getCurrentPanelDescriptor();
        if (wizardPanelDescriptor != null && n == 0 && !wizardPanelDescriptor.aboutToHidePanel(WizardPanelDescriptor.FINISH)) {
            return;
        }
        this.returnCode = n;
        this.wizardDialog.dispose();
    }

    public boolean getBackButtonEnabled() {
        return this.wizardModel.getBackButtonEnabled();
    }

    public boolean getCancelButtonEnabled() {
        return this.wizardModel.getCancelButtonEnabled();
    }

    public JDialog getDialog() {
        return this.wizardDialog;
    }

    public WizardModel getModel() {
        return this.wizardModel;
    }

    public boolean getNextFinishButtonEnabled() {
        return this.wizardModel.getNextFinishButtonEnabled();
    }

    public Component getOwner() {
        return this.wizardDialog.getOwner();
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getTitle() {
        return this.wizardDialog.getTitle();
    }

    private void initComponents() {
        this.wizardModel.addPropertyChangeListener(this);
        this.wizardController = new WizardController(this);
        this.wizardDialog.getContentPane().setLayout(new BorderLayout());
        this.wizardDialog.addWindowListener(this);
        JPanel jPanel = new JPanel();
        JSeparator jSeparator = new JSeparator();
        Box box = new Box(0);
        this.cardPanel = new JPanel();
        this.cardPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.cancelButton = new JButton();
        this.backButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        this.nextButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        this.cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        this.backButton.addActionListener(this.wizardController);
        this.nextButton.addActionListener(this.wizardController);
        this.cancelButton.addActionListener(this.wizardController);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jSeparator, "North");
        box.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        box.add(this.backButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.nextButton);
        box.add(Box.createHorizontalStrut(30));
        box.add(this.cancelButton);
        jPanel.add((Component)box, "East");
        this.wizardDialog.getContentPane().add((Component)jPanel, "South");
        this.wizardDialog.getContentPane().add((Component)this.cardPanel, "Center");
    }

    public boolean isModal() {
        return this.wizardDialog.isModal();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("currentPanelDescriptorProperty")) {
            this.wizardController.resetButtonsToPanelRules();
        } else if (propertyChangeEvent.getPropertyName().equals("nextButtonTextProperty")) {
            this.nextButton.setText(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals("backButtonTextProperty")) {
            this.backButton.setText(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals("cancelButtonTextProperty")) {
            this.cancelButton.setText(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals("nextButtonEnabledProperty")) {
            this.nextButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("backButtonEnabledProperty")) {
            this.backButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("cancelButtonEnabledProperty")) {
            this.cancelButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("nextButtonIconProperty")) {
            this.nextButton.setIcon((Icon)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("backButtonIconProperty")) {
            this.backButton.setIcon((Icon)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("cancelButtonIconProperty")) {
            this.cancelButton.setIcon((Icon)propertyChangeEvent.getNewValue());
        }
    }

    public void registerWizardPanel(Object object, WizardPanelDescriptor wizardPanelDescriptor) {
        this.cardPanel.add(wizardPanelDescriptor.getPanelComponent(), object);
        wizardPanelDescriptor.setWizard(this);
        this.wizardModel.registerPanel(object, wizardPanelDescriptor);
    }

    public void setBackButtonEnabled(boolean bl) {
        this.wizardModel.setBackButtonEnabled(new Boolean(bl));
    }

    public void setCancelButtonEnabled(boolean bl) {
        this.wizardModel.setCancelButtonEnabled(new Boolean(bl));
    }

    public void setCurrentPanel(Object object) {
        Object object2;
        WizardPanelDescriptor wizardPanelDescriptor;
        if (object == null) {
            this.close(2);
        }
        if ((wizardPanelDescriptor = this.wizardModel.getCurrentPanelDescriptor()) != null && !wizardPanelDescriptor.aboutToHidePanel(object)) {
            return;
        }
        Object object3 = object2 = wizardPanelDescriptor != null ? wizardPanelDescriptor.getPanelDescriptorIdentifier() : null;
        if (!this.wizardModel.getPanelDescriptor(object).aboutToDisplayPanel(object2)) {
            return;
        }
        this.wizardModel.setCurrentPanel(object);
        this.cardLayout.show(this.cardPanel, object.toString());
        this.wizardModel.getCurrentPanelDescriptor().displayingPanel();
    }

    public void setModal(boolean bl) {
        this.wizardDialog.setModal(bl);
    }

    public void setNextFinishButtonEnabled(boolean bl) {
        this.wizardModel.setNextFinishButtonEnabled(new Boolean(bl));
    }

    public void setTitle(String string) {
        this.wizardDialog.setTitle(string);
    }

    public int showModalDialog() {
        this.wizardDialog.setModal(true);
        this.wizardDialog.pack();
        this.wizardDialog.setLocationRelativeTo(this.wizardDialog.getOwner());
        this.wizardDialog.setVisible(true);
        return this.returnCode;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.returnCode = 1;
    }
}

