/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSRCTable<T> {
    static final int INCR = 16;
    Object[] objList;
    int[] ssrcList = new int[16];
    int total = 0;

    public SSRCTable() {
        this.objList = new Object[this.ssrcList.length];
    }

    public Enumeration<T> elements() {
        return new Enumeration<T>(){
            private int next = 0;

            @Override
            public boolean hasMoreElements() {
                return this.next < SSRCTable.this.total;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T nextElement() {
                SSRCTable sSRCTable = SSRCTable.this;
                synchronized (sSRCTable) {
                    if (this.next < SSRCTable.this.total) {
                        Object object = SSRCTable.this.objList[this.next++];
                        return object;
                    }
                }
                throw new NoSuchElementException("SSRCTable Enumeration");
            }
        };
    }

    public synchronized T get(int n) {
        int n2 = this.indexOf(n);
        if (n2 < 0) {
            return null;
        }
        Object object = this.objList[n2];
        return (T)object;
    }

    public synchronized int getSSRC(T t) {
        for (int i = 0; i < this.total; ++i) {
            if (this.objList[i] != t) continue;
            return this.ssrcList[i];
        }
        return 0;
    }

    private int indexOf(int n) {
        if (this.total <= 3) {
            if (this.total > 0 && this.ssrcList[0] == n) {
                return 0;
            }
            if (this.total > 1 && this.ssrcList[1] == n) {
                return 1;
            }
            return this.total <= 2 || this.ssrcList[2] != n ? -1 : 2;
        }
        if (this.ssrcList[0] == n) {
            return 0;
        }
        if (this.ssrcList[this.total - 1] == n) {
            return this.total - 1;
        }
        int n2 = 0;
        int n3 = this.total - 1;
        do {
            int n4;
            if (this.ssrcList[n4 = (n3 - n2) / 2 + n2] == n) {
                return n4;
            }
            if (n > this.ssrcList[n4]) {
                n2 = n4 + 1;
                continue;
            }
            if (n >= this.ssrcList[n4]) continue;
            n3 = n4;
        } while (n2 < n3);
        return -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized int[] keysToArray(int[] nArray) {
        int n = this.size();
        if (nArray == null || nArray.length < n) {
            nArray = new int[n];
        }
        System.arraycopy(this.ssrcList, 0, nArray, 0, n);
        if (n < nArray.length) {
            Arrays.fill(nArray, n, nArray.length, 0);
        }
        return nArray;
    }

    public synchronized void put(int n, T t) {
        int n2;
        if (this.total == 0) {
            this.ssrcList[0] = n;
            this.objList[0] = t;
            this.total = 1;
            return;
        }
        for (n2 = 0; n2 < this.total; ++n2) {
            if (this.ssrcList[n2] < n) continue;
            if (this.ssrcList[n2] != n) break;
            this.objList[n2] = t;
            return;
        }
        int[] nArray = this.ssrcList;
        Object[] objectArray = this.objList;
        if (this.total == this.ssrcList.length) {
            nArray = new int[this.ssrcList.length + 16];
            objectArray = new Object[this.objList.length + 16];
        }
        if (this.ssrcList != nArray && n2 > 0) {
            System.arraycopy(this.ssrcList, 0, nArray, 0, n2);
            System.arraycopy(this.objList, 0, objectArray, 0, n2);
        }
        if (n2 < this.total) {
            System.arraycopy(this.ssrcList, n2, nArray, n2 + 1, this.total - n2);
            System.arraycopy(this.objList, n2, objectArray, n2 + 1, this.total - n2);
        }
        this.ssrcList = nArray;
        this.objList = objectArray;
        this.ssrcList[n2] = n;
        this.objList[n2] = t;
        ++this.total;
    }

    public synchronized T remove(int n) {
        int n2 = this.indexOf(n);
        if (n2 < 0) {
            return null;
        }
        Object object = this.objList[n2];
        while (n2 < this.total - 1) {
            this.ssrcList[n2] = this.ssrcList[n2 + 1];
            this.objList[n2] = this.objList[n2 + 1];
            ++n2;
        }
        this.ssrcList[this.total - 1] = 0;
        this.objList[this.total - 1] = null;
        --this.total;
        return (T)object;
    }

    public synchronized void removeAll() {
        for (int i = 0; i < this.total; ++i) {
            this.ssrcList[i] = 0;
            this.objList[i] = null;
        }
        this.total = 0;
    }

    public synchronized void removeObj(T t) {
        int n;
        if (t == null) {
            return;
        }
        for (n = 0; n < this.total && this.objList[n] != t; ++n) {
        }
        if (n >= this.total) {
            return;
        }
        while (n < this.total - 1) {
            this.ssrcList[n] = this.ssrcList[n + 1];
            this.objList[n] = this.objList[n + 1];
            ++n;
        }
        this.ssrcList[this.total - 1] = 0;
        this.objList[this.total - 1] = null;
        --this.total;
    }

    public int size() {
        return this.total;
    }

    public synchronized T[] valuesToArray(T[] objectArray) {
        int n = this.size();
        Class clazz = objectArray == null ? Object.class : (objectArray.length < n ? objectArray.getClass().getComponentType() : null);
        if (clazz != null) {
            objectArray = (Object[])Array.newInstance(clazz, n);
        }
        System.arraycopy(this.objList, 0, objectArray, 0, n);
        if (n < objectArray.length) {
            Arrays.fill(objectArray, n, objectArray.length, null);
        }
        return objectArray;
    }
}

