/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.rtp.RTPPushDataSource;
import net.sf.fmj.media.CircularBuffer;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketSource;
import net.sf.fmj.media.rtp.util.UDPPacket;

public class RTPPacketReceiver
implements PacketSource,
SourceTransferHandler {
    private static final String PUSH_BUFFER_STREAM_CLASS_NAME = PushBufferStream.class.getName();
    RTPPushDataSource rtpsource = null;
    CircularBuffer bufQue = new CircularBuffer(2);
    boolean closed = false;
    boolean dataRead = false;

    public RTPPacketReceiver(PushSourceStream pushSourceStream) {
        pushSourceStream.setTransferHandler(this);
    }

    public RTPPacketReceiver(RTPPushDataSource rTPPushDataSource) {
        this.rtpsource = rTPPushDataSource;
        PushSourceStream pushSourceStream = rTPPushDataSource.getOutputStream();
        pushSourceStream.setTransferHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSource() {
        CircularBuffer circularBuffer = this.bufQue;
        synchronized (circularBuffer) {
            this.closed = true;
            this.bufQue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet receiveFrom() throws IOException {
        int n;
        int n2;
        Buffer buffer;
        Object object = this.bufQue;
        synchronized (object) {
            if (this.dataRead) {
                this.bufQue.readReport();
                this.bufQue.notify();
            }
            while (!this.bufQue.canRead() && !this.closed) {
                try {
                    this.bufQue.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.closed) {
                buffer = null;
                this.dataRead = false;
            } else {
                buffer = this.bufQue.read();
                this.dataRead = true;
            }
        }
        if (buffer != null) {
            object = (byte[])buffer.getData();
            n2 = buffer.getFlags();
            n = buffer.getLength();
        } else {
            object = new byte[1];
            n2 = 0;
            n = 0;
        }
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.receiptTime = System.currentTimeMillis();
        uDPPacket.data = (byte[])object;
        uDPPacket.flags = n2;
        uDPPacket.length = n;
        uDPPacket.offset = 0;
        return uDPPacket;
    }

    public String sourceString() {
        String string = "RTPPacketReceiver for " + this.rtpsource;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferData(PushSourceStream pushSourceStream) {
        Buffer buffer;
        Object object = this.bufQue;
        synchronized (object) {
            while (!this.bufQue.canWrite() && !this.closed) {
                try {
                    this.bufQue.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.closed) {
                return;
            }
            buffer = this.bufQue.getEmptyBuffer();
        }
        buffer.setFlags(0);
        buffer.setOffset(0);
        object = (PushBufferStream)pushSourceStream.getControl(PUSH_BUFFER_STREAM_CLASS_NAME);
        if (object == null) {
            int n = pushSourceStream.getMinimumTransferSize();
            byte[] byArray = (byte[])buffer.getData();
            int n2 = 0;
            if (byArray == null || byArray.length < n) {
                byArray = new byte[n];
                buffer.setData(byArray);
            }
            try {
                n2 = pushSourceStream.read(byArray, 0, n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            buffer.setLength(n2);
        } else {
            try {
                object.read(buffer);
            }
            catch (IOException iOException) {
                buffer.setLength(0);
            }
        }
        CircularBuffer circularBuffer = this.bufQue;
        synchronized (circularBuffer) {
            this.bufQue.writeReport();
            this.bufQue.notify();
        }
    }
}

