/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.SendStream;
import javax.media.rtp.TransmissionStats;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTPSinkStream;
import net.sf.fmj.media.rtp.RTPTransStats;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.TrueRandom;

public class SendSSRCInfo
extends SSRCInfo
implements SenderReport,
SendStream {
    private boolean inited = false;
    protected int packetsize = 0;
    protected Format myformat;
    private long totalSamples = 0L;
    private long lastSeq = -1L;
    private long lastBufSeq = -1L;
    protected RTPTransStats stats;
    static AudioFormat dviAudio = new AudioFormat("dvi/rtp");
    static AudioFormat gsmAudio = new AudioFormat("gsm/rtp");
    static AudioFormat g723Audio = new AudioFormat("g723/rtp");
    static AudioFormat ulawAudio = new AudioFormat("ULAW/rtp");
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");

    public SendSSRCInfo(SSRCCache sSRCCache, int n) {
        super(sSRCCache, n);
        this.init();
    }

    public SendSSRCInfo(SSRCInfo sSRCInfo) {
        super(sSRCInfo);
        this.init();
    }

    private void init() {
        this.maxseq = this.baseseq = TrueRandom.nextInt();
        this.lasttimestamp = TrueRandom.nextLong();
        this.sender = true;
        this.wassender = true;
        this.sinkstream = new RTPSinkStream();
        this.stats = new RTPTransStats();
    }

    private int calculateSampleCount(Buffer buffer) {
        AudioFormat audioFormat = (AudioFormat)buffer.getFormat();
        if (audioFormat == null) {
            return -1;
        }
        long l = audioFormat.computeDuration(buffer.getLength());
        if (l == -1L) {
            return -1;
        }
        if (audioFormat.getSampleRate() != -1.0) {
            return (int)((double)l * audioFormat.getSampleRate() / 1.0E9);
        }
        if (audioFormat.getFrameRate() != -1.0) {
            return (int)((double)l * audioFormat.getFrameRate() / 1.0E9);
        }
        return -1;
    }

    public void close() {
        try {
            this.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SSRCCache sSRCCache = this.getSSRCCache();
        sSRCCache.sm.removeSendStream(this);
    }

    public DataSource getDataSource() {
        return this.pds;
    }

    public long getNTPTimeStampLSW() {
        return this.lastSRntptimestamp;
    }

    public long getNTPTimeStampMSW() {
        return this.lastSRntptimestamp >> 32;
    }

    public Participant getParticipant() {
        SSRCCache sSRCCache = this.getSSRCCache();
        if (this.sourceInfo instanceof LocalParticipant && sSRCCache.sm.IsNonParticipating()) {
            return null;
        }
        return this.sourceInfo;
    }

    public long getRTPTimeStamp() {
        return this.lastSRrtptimestamp;
    }

    public long getSenderByteCount() {
        return this.lastSRoctetcount;
    }

    public Feedback getSenderFeedback() {
        SSRCCache sSRCCache = this.getSSRCCache();
        Report report = null;
        Vector vector = null;
        Vector vector2 = null;
        Feedback feedback = null;
        try {
            LocalParticipant localParticipant = sSRCCache.sm.getLocalParticipant();
            vector = localParticipant.getReports();
            for (int i = 0; i < vector.size(); ++i) {
                report = (Report)vector.elementAt(i);
                vector2 = report.getFeedbackReports();
                for (int j = 0; j < vector2.size(); ++j) {
                    feedback = (Feedback)vector2.elementAt(j);
                    long l = feedback.getSSRC();
                    if (l != this.getSSRC()) continue;
                    return feedback;
                }
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public long getSenderPacketCount() {
        return this.lastSRpacketcount;
    }

    public SenderReport getSenderReport() {
        SSRCCache sSRCCache = this.getSSRCCache();
        Report report = null;
        Vector vector = null;
        Vector vector2 = null;
        Feedback feedback = null;
        try {
            LocalParticipant localParticipant = sSRCCache.sm.getLocalParticipant();
            vector = localParticipant.getReports();
            for (int i = 0; i < vector.size(); ++i) {
                report = (Report)vector.elementAt(i);
                vector2 = report.getFeedbackReports();
                for (int j = 0; j < vector2.size(); ++j) {
                    feedback = (Feedback)vector2.elementAt(j);
                    long l = feedback.getSSRC();
                    if (l != this.getSSRC()) continue;
                    return (SenderReport)report;
                }
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public long getSequenceNumber(Buffer buffer) {
        long l = buffer.getSequenceNumber();
        if (this.lastSeq == -1L) {
            this.lastSeq = (long)((double)System.currentTimeMillis() * Math.random());
            this.lastBufSeq = l;
            return this.lastSeq;
        }
        this.lastSeq = l - this.lastBufSeq > 1L ? (this.lastSeq += l - this.lastBufSeq) : ++this.lastSeq;
        this.lastBufSeq = l;
        return this.lastSeq;
    }

    public TransmissionStats getSourceTransmissionStats() {
        return this.stats;
    }

    public RTPStream getStream() {
        return this;
    }

    public long getTimeStamp(Buffer buffer) {
        long l = buffer.getTimeStamp();
        Format format = buffer.getFormat();
        if ((buffer.getFlags() & 0x1000) != 0 && l != -1L) {
            return l;
        }
        if (format instanceof AudioFormat) {
            if (mpegAudio.matches(format)) {
                if (l >= 0L) {
                    return l * 90L / 1000000L;
                }
                return System.currentTimeMillis() * 90L;
            }
            this.totalSamples += (long)this.calculateSampleCount(buffer);
            return this.totalSamples;
        }
        if (format instanceof VideoFormat) {
            if (l >= 0L) {
                return l * 90L / 1000000L;
            }
            return System.currentTimeMillis() * 90L;
        }
        return l;
    }

    public int setBitRate(int n) {
        if (this.sinkstream != null) {
            this.sinkstream.rate = n;
        }
        return n;
    }

    protected void setFormat(Format format) {
        this.myformat = format;
        if (this.sinkstream != null) {
            int n = 0;
            if (format instanceof AudioFormat) {
                if (ulawAudio.matches(format) || dviAudio.matches(format) || mpegAudio.matches(format)) {
                    n = (int)((AudioFormat)format).getSampleRate() * ((AudioFormat)format).getSampleSizeInBits();
                } else if (gsmAudio.matches(format)) {
                    n = 13200;
                } else if (g723Audio.matches(format)) {
                    n = 6300;
                }
                this.sinkstream.rate = n;
            }
        } else {
            System.err.println("RTPSinkStream is NULL");
        }
    }

    public void setSourceDescription(SourceDescription[] sourceDescriptionArray) {
        super.setSourceDescription(sourceDescriptionArray);
    }

    public void start() throws IOException {
        if (!this.inited) {
            this.inited = true;
            this.probation = 0;
            this.initsource(TrueRandom.nextInt());
            this.lasttimestamp = TrueRandom.nextLong();
        }
        if (this.pds != null) {
            this.pds.start();
        }
        if (this.sinkstream != null) {
            this.sinkstream.start();
        }
    }

    public void stop() throws IOException {
        if (this.pds != null) {
            this.pds.stop();
        }
        if (this.sinkstream != null) {
            this.sinkstream.stop();
        }
    }
}

