/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.JPEGFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.media.format.GIFFormat;
import net.sf.fmj.media.format.PNGFormat;
import net.sf.fmj.utility.LoggerSingleton;

public class MultipartMixedReplaceParser
extends AbstractDemultiplexer {
    public static final String TIMESTAMP_KEY = "X-FMJ-Timestamp";
    private static final Logger logger = LoggerSingleton.logger;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("multipart.x_mixed_replace")};
    private static final String[] supportedFrameContentTypes = new String[]{"image/jpeg", "image/gif", "image/png"};
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;

    private static String toPrintable(String string) {
        return MultipartMixedReplaceParser.toPrintable(string, 32);
    }

    private static String toPrintable(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length() && i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '~') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    private static final boolean isSupportedFrameContentType(String string) {
        for (String string2 : supportedFrameContentTypes) {
            if (!string2.equals(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void close() {
        if (this.tracks != null) {
            for (int i = 0; i < this.tracks.length; ++i) {
                if (this.tracks[i] == null) continue;
                this.tracks[i].deallocate();
                this.tracks[i] = null;
            }
            this.tracks = null;
        }
        super.close();
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public boolean isPositionable() {
        return false;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    public void open() throws ResourceUnavailableException {
        try {
            this.source.start();
            PullSourceStream[] pullSourceStreamArray = this.source.getStreams();
            this.tracks = new PullSourceStreamTrack[pullSourceStreamArray.length];
            for (int i = 0; i < pullSourceStreamArray.length; ++i) {
                this.tracks[i] = new VideoTrack(pullSourceStreamArray[i]);
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
            throw new ResourceUnavailableException("" + iOException);
        }
        super.open();
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        String string = dataSource.getLocator().getProtocol();
        if (!(dataSource instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)dataSource;
    }

    public void start() throws IOException {
    }

    private class VideoTrack
    extends PullSourceStreamTrack {
        private final PullSourceStream stream;
        private final VideoFormat format;
        private byte[] pushbackBuffer;
        private int pushbackBufferLen;
        private int pushbackBufferOffset;
        private static final int MAX_LINE_LENGTH = 255;
        private final int MAX_IMAGE_SIZE = 1000000;
        private String boundary;
        private int framesRead;
        private String frameContentType;

        public VideoTrack(PullSourceStream pullSourceStream) throws ResourceUnavailableException {
            BufferedImage bufferedImage;
            this.MAX_IMAGE_SIZE = 1000000;
            this.stream = pullSourceStream;
            Buffer buffer = new Buffer();
            this.readFrame(buffer);
            if (buffer.isDiscard() || buffer.isEOM()) {
                throw new ResourceUnavailableException("Unable to read first frame");
            }
            try {
                bufferedImage = ImageIO.read(new ByteArrayInputStream((byte[])buffer.getData(), buffer.getOffset(), buffer.getLength()));
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                throw new ResourceUnavailableException("Error reading image: " + iOException);
            }
            if (bufferedImage == null) {
                logger.log(Level.WARNING, "Failed to read image (ImageIO.read returned null).");
                throw new ResourceUnavailableException();
            }
            if (this.frameContentType.equals("image/jpeg")) {
                this.format = new JPEGFormat(new Dimension(((Image)bufferedImage).getWidth(null), ((Image)bufferedImage).getHeight(null)), -1, Format.byteArray, -1.0f, -1, -1);
            } else if (this.frameContentType.equals("image/gif")) {
                this.format = new GIFFormat(new Dimension(((Image)bufferedImage).getWidth(null), ((Image)bufferedImage).getHeight(null)), -1, Format.byteArray, -1.0f);
            } else if (this.frameContentType.equals("image/png")) {
                this.format = new PNGFormat(new Dimension(((Image)bufferedImage).getWidth(null), ((Image)bufferedImage).getHeight(null)), -1, Format.byteArray, -1.0f);
            } else {
                throw new ResourceUnavailableException("Unsupported frame content type: " + this.frameContentType);
            }
        }

        public void deallocate() {
        }

        private int eatUntil(String string) throws IOException {
            int n = 0;
            byte[] byArray = string.getBytes();
            byte[] byArray2 = new byte[byArray.length];
            int n2 = 0;
            while (true) {
                int n3;
                if ((n3 = this.read(byArray2, n2, 1)) < 0) {
                    return -1 + -1 * n;
                }
                ++n;
                if (byArray2[n2] == byArray[n2]) {
                    if (n2 == byArray.length - 1) break;
                    ++n2;
                    continue;
                }
                if (n2 <= 0) continue;
                n2 = 0;
            }
            this.pushback(byArray2, n2 + 1);
            return n -= n2 + 1;
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }

        public Format getFormat() {
            return this.format;
        }

        public Time mapFrameToTime(int n) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time time) {
            return Integer.MAX_VALUE;
        }

        private boolean parseProperty(String string, Properties properties) {
            int n = string.indexOf(58);
            if (n < 0) {
                return false;
            }
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            properties.setProperty(string2.toUpperCase(), string3);
            return true;
        }

        private void pushback(byte[] byArray, int n) {
            if (this.pushbackBufferLen == 0) {
                this.pushbackBuffer = byArray;
                this.pushbackBufferLen = n;
                this.pushbackBufferOffset = 0;
            } else {
                byte[] byArray2 = new byte[this.pushbackBufferLen + n];
                System.arraycopy(this.pushbackBuffer, 0, byArray2, 0, this.pushbackBufferLen);
                System.arraycopy(byArray, 0, byArray2, this.pushbackBufferLen, n);
                this.pushbackBuffer = byArray2;
                this.pushbackBufferLen += n;
                this.pushbackBufferOffset = 0;
            }
        }

        private int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.pushbackBufferLen > 0) {
                int n3 = n2 < this.pushbackBufferLen ? n2 : this.pushbackBufferLen;
                System.arraycopy(this.pushbackBuffer, this.pushbackBufferOffset, byArray, n, n3);
                this.pushbackBufferLen -= n3;
                this.pushbackBufferOffset += n3;
                return n3;
            }
            return this.stream.read(byArray, n, n2);
        }

        public void readFrame(Buffer buffer) {
            try {
                byte[] byArray;
                Properties properties;
                block23: {
                    String string;
                    do {
                        if ((string = this.readLine(255)) != null) continue;
                        buffer.setEOM(true);
                        buffer.setLength(0);
                        return;
                    } while (string.trim().equals(""));
                    if (this.boundary == null) {
                        this.boundary = string.trim();
                    } else if (!string.trim().equals(this.boundary)) {
                        logger.warning("Expected boundary (frame " + this.framesRead + "): " + MultipartMixedReplaceParser.toPrintable(string));
                        int n = this.eatUntil(this.boundary);
                        logger.info("Ignored bytes (eom after=" + (n < 0) + "): " + (n < 0 ? -1 * n - 1 : n));
                        if (n < 0) {
                            buffer.setEOM(true);
                            buffer.setLength(0);
                            return;
                        }
                        string = this.readLine(255);
                        if (!string.trim().equals(this.boundary)) {
                            throw new RuntimeException("No boundary found after eatUntil(boundary)");
                        }
                    }
                    properties = new Properties();
                    do {
                        if ((string = this.readLine(255)) == null) {
                            buffer.setEOM(true);
                            buffer.setLength(0);
                            return;
                        }
                        if (string.trim().equals("")) break block23;
                    } while (this.parseProperty(string, properties));
                    throw new IOException("Expected property: " + MultipartMixedReplaceParser.toPrintable(string));
                }
                String string = properties.getProperty("Content-Type".toUpperCase());
                if (string == null) {
                    logger.warning("Header properties: " + properties);
                    throw new IOException("Expected Content-Type in header");
                }
                if (!MultipartMixedReplaceParser.isSupportedFrameContentType(string)) {
                    throw new IOException("Unsupported Content-Type: " + string);
                }
                if (this.frameContentType == null) {
                    this.frameContentType = string;
                } else if (!string.equals(this.frameContentType)) {
                    throw new IOException("Content type changed during stream from " + this.frameContentType + " to " + string);
                }
                String string2 = properties.getProperty("Content-Length".toUpperCase());
                if (string2 != null) {
                    int n;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Invalid content length: " + string2);
                    }
                    byArray = this.readFully(n);
                } else {
                    byArray = this.readUntil(this.boundary);
                }
                String string3 = properties.getProperty(MultipartMixedReplaceParser.TIMESTAMP_KEY.toUpperCase());
                if (string3 != null) {
                    try {
                        long l = Long.parseLong(string3);
                        buffer.setTimeStamp(l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.log(Level.WARNING, "" + numberFormatException, numberFormatException);
                    }
                }
                if (byArray == null) {
                    buffer.setEOM(true);
                    buffer.setLength(0);
                    return;
                }
                buffer.setData(byArray);
                buffer.setOffset(0);
                buffer.setLength(byArray.length);
                ++this.framesRead;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        private byte[] readFully(int n) throws IOException {
            byte[] byArray = new byte[n];
            int n2 = 0;
            int n3 = n;
            int n4;
            while ((n4 = this.read(byArray, n2, n3)) >= 0) {
                if (n4 == n3) {
                    return byArray;
                }
                n3 -= n4;
                n2 += n4;
            }
            return null;
        }

        private String readLine(int n) throws IOException {
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    throw new MaxLengthExceededException("No newline found in " + n + " bytes");
                }
                int n3 = this.read(byArray, n2, 1);
                if (n3 < 0) {
                    return null;
                }
                if (byArray[n2] == 10) {
                    if (n2 > 0 && byArray[n2 - 1] == 13) {
                        --n2;
                    }
                    return new String(byArray, 0, n2);
                }
                ++n2;
            }
        }

        private byte[] readUntil(String string) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = string.getBytes();
            byte[] byArray2 = new byte[byArray.length];
            int n = 0;
            while (true) {
                if (byteArrayOutputStream.size() >= 1000000) {
                    throw new IOException("No boundary found in 1000000 bytes.");
                }
                int n2 = this.read(byArray2, n, 1);
                if (n2 < 0) {
                    return null;
                }
                if (byArray2[n] == byArray[n]) {
                    if (n == byArray.length - 1) break;
                    ++n;
                    continue;
                }
                if (n > 0) {
                    byteArrayOutputStream.write(byArray2, 0, n + 1);
                    n = 0;
                    continue;
                }
                byteArrayOutputStream.write(byArray2, 0, 1);
            }
            this.pushback(byArray2, n + 1);
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            return byArray3;
        }

        private class MaxLengthExceededException
        extends IOException {
            public MaxLengthExceededException(String string) {
                super(string);
            }
        }
    }

    private abstract class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStreamTrack() {
        }

        public abstract void deallocate();
    }
}

