/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import java.awt.Component;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Multiplexer;
import javax.media.Owned;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.StreamWriterControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.media.BasicClock;
import net.sf.fmj.media.BasicPlugIn;
import net.sf.fmj.media.MediaTimeBase;
import net.sf.fmj.media.Syncable;
import net.sf.fmj.media.control.MonitorAdapter;
import net.sf.fmj.media.datasink.RandomAccess;

public abstract class BasicMux
extends BasicPlugIn
implements Multiplexer,
Clock {
    protected Format[] supportedInputs;
    protected ContentDescriptor[] supportedOutputs;
    protected int numTracks = 0;
    protected Format[] inputs;
    protected BasicMuxDataSource source;
    protected BasicMuxPushStream stream;
    protected ContentDescriptor outputCD;
    protected boolean flushing = false;
    protected Integer sourceLock = new Integer(0);
    protected boolean eos = false;
    protected boolean firstBuffer = true;
    protected int fileSize = 0;
    protected int filePointer = 0;
    protected long fileSizeLimit = -1L;
    protected boolean streamSizeLimitSupported = true;
    protected boolean fileSizeLimitReached = false;
    protected SourceTransferHandler sth = null;
    protected boolean isLiveData = false;
    protected StreamWriterControl swc = null;
    protected MonitorAdapter[] mc = null;
    protected BasicMuxTimeBase timeBase = null;
    Object startup = new Integer(0);
    boolean readyToStart = false;
    long[] mediaTime;
    boolean[] ready;
    protected BasicClock clock = null;
    int master = 0;
    boolean mClosed = false;
    boolean dataReady = false;
    boolean startCompensated = false;
    Object dataLock = new Object();
    Buffer[] firstBuffers;
    boolean[] firstBuffersDone;
    int[] nonKeyCount;
    long masterTime = -1L;
    VideoFormat jpegFmt = new VideoFormat("jpeg");
    VideoFormat mjpgFmt = new VideoFormat("mjpg");
    VideoFormat rgbFmt = new VideoFormat("rgb");
    VideoFormat yuvFmt = new VideoFormat("yuv");
    protected int maxBufSize = 32768;
    protected byte[] buf = new byte[this.maxBufSize];
    protected int bufOffset;
    protected int bufLength;
    Object timeSetSync = new Object();
    boolean started = false;
    long systemStartTime = System.currentTimeMillis() * 1000000L;

    public BasicMux() {
        this.timeBase = new BasicMuxTimeBase();
        this.clock = new BasicClock();
        try {
            this.clock.setTimeBase(this.timeBase);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.swc = new SWC(this);
        this.controls = new Control[]{this.swc};
    }

    protected void bufClear() {
        this.bufOffset = 0;
        this.bufLength = 0;
    }

    protected void bufFlush() {
        this.filePointer -= this.bufLength;
        this.write(this.buf, 0, this.bufLength);
    }

    protected void bufSkip(int n) {
        this.bufOffset += n;
        this.bufLength += n;
        this.filePointer += n;
    }

    protected void bufWriteByte(byte by) {
        this.buf[this.bufOffset] = by;
        ++this.bufOffset;
        ++this.bufLength;
        ++this.filePointer;
    }

    protected void bufWriteBytes(byte[] byArray) {
        System.arraycopy(byArray, 0, this.buf, this.bufOffset, byArray.length);
        this.bufOffset += byArray.length;
        this.bufLength += byArray.length;
        this.filePointer += byArray.length;
    }

    protected void bufWriteBytes(String string) {
        byte[] byArray = string.getBytes();
        this.bufWriteBytes(byArray);
    }

    protected void bufWriteInt(int n) {
        this.buf[this.bufOffset + 0] = (byte)(n >> 24 & 0xFF);
        this.buf[this.bufOffset + 1] = (byte)(n >> 16 & 0xFF);
        this.buf[this.bufOffset + 2] = (byte)(n >> 8 & 0xFF);
        this.buf[this.bufOffset + 3] = (byte)(n >> 0 & 0xFF);
        this.bufOffset += 4;
        this.bufLength += 4;
        this.filePointer += 4;
    }

    protected void bufWriteIntLittleEndian(int n) {
        this.buf[this.bufOffset + 3] = (byte)(n >>> 24 & 0xFF);
        this.buf[this.bufOffset + 2] = (byte)(n >>> 16 & 0xFF);
        this.buf[this.bufOffset + 1] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.bufOffset + 0] = (byte)(n >>> 0 & 0xFF);
        this.bufOffset += 4;
        this.bufLength += 4;
        this.filePointer += 4;
    }

    protected void bufWriteShort(short s) {
        this.buf[this.bufOffset + 0] = (byte)(s >> 8 & 0xFF);
        this.buf[this.bufOffset + 1] = (byte)(s >> 0 & 0xFF);
        this.bufOffset += 2;
        this.bufLength += 2;
        this.filePointer += 2;
    }

    protected void bufWriteShortLittleEndian(short s) {
        this.buf[this.bufOffset + 1] = (byte)(s >> 8 & 0xFF);
        this.buf[this.bufOffset + 0] = (byte)(s >> 0 & 0xFF);
        this.bufOffset += 2;
        this.bufLength += 2;
        this.filePointer += 2;
    }

    private boolean checkReady() {
        if (this.readyToStart) {
            return true;
        }
        for (int i = 0; i < this.ready.length; ++i) {
            if (this.ready[i]) continue;
            return false;
        }
        this.readyToStart = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.sth != null) {
            this.writeFooter();
            this.write(null, 0, -1);
        }
        for (int i = 0; i < this.mc.length; ++i) {
            if (this.mc[i] == null) continue;
            this.mc[i].close();
        }
        Object object = this.dataLock;
        synchronized (object) {
            this.mClosed = true;
            this.dataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compensateStart(Buffer buffer, int n) {
        Object object = this.dataLock;
        synchronized (object) {
            int n2;
            if (this.dataReady) {
                if (this.firstBuffersDone[n]) return true;
                if (buffer.getTimeStamp() < this.masterTime) {
                    return false;
                }
                if (buffer.getFormat() instanceof VideoFormat) {
                    boolean bl;
                    Format format = buffer.getFormat();
                    boolean bl2 = bl = this.jpegFmt.matches(format) || this.mjpgFmt.matches(format) || this.rgbFmt.matches(format) || this.yuvFmt.matches(format);
                    if (!bl && (buffer.getFlags() & 0x10) == 0) {
                        int n3 = n;
                        int n4 = this.nonKeyCount[n3];
                        this.nonKeyCount[n3] = n4 + 1;
                        if (n4 <= 30) return false;
                    }
                    buffer.setTimeStamp(this.masterTime);
                    this.firstBuffersDone[n] = true;
                } else {
                    buffer.setTimeStamp(this.masterTime);
                    this.firstBuffersDone[n] = true;
                }
                for (int i = 0; i < this.firstBuffersDone.length; ++i) {
                    if (this.firstBuffersDone[i]) continue;
                    return true;
                }
                this.startCompensated = true;
                return true;
            }
            if (buffer.getTimeStamp() < 0L) {
                this.startCompensated = true;
                this.dataReady = true;
                this.dataLock.notifyAll();
                return true;
            }
            this.firstBuffers[n] = buffer;
            boolean bl = true;
            for (n2 = 0; n2 < this.firstBuffers.length; ++n2) {
                if (this.firstBuffers[n2] != null) continue;
                bl = false;
            }
            if (!bl) {
                while (!this.dataReady && !this.mClosed) {
                    try {
                        this.dataLock.wait();
                    }
                    catch (Exception exception) {}
                }
                if (this.mClosed) return false;
                if (this.firstBuffers[n] != null) return true;
                return false;
            }
            this.masterTime = this.firstBuffers[0].getTimeStamp();
            for (n2 = 0; n2 < this.firstBuffers.length; ++n2) {
                if (this.firstBuffers[n2].getFormat() instanceof AudioFormat) {
                    this.masterTime = this.firstBuffers[n2].getTimeStamp();
                    break;
                }
                if (this.firstBuffers[n2].getTimeStamp() >= this.masterTime) continue;
                this.masterTime = this.firstBuffers[n2].getTimeStamp();
            }
            this.startCompensated = true;
            for (n2 = 0; n2 < this.firstBuffers.length; ++n2) {
                if (this.firstBuffers[n2].getTimeStamp() >= this.masterTime) {
                    this.firstBuffers[n2].setTimeStamp(this.masterTime);
                    this.firstBuffersDone[n2] = true;
                    continue;
                }
                this.firstBuffers[n2] = null;
                this.startCompensated = false;
            }
            Object object2 = this.dataLock;
            synchronized (object2) {
                this.dataReady = true;
                this.dataLock.notifyAll();
            }
            if (this.firstBuffers[n] == null) return false;
            return true;
        }
    }

    protected int doProcess(Buffer buffer, int n) {
        byte[] byArray = (byte[])buffer.getData();
        int n2 = buffer.getLength();
        if (!buffer.isEOM()) {
            this.write(byArray, buffer.getOffset(), n2);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataOutput() {
        if (this.source == null) {
            this.source = new BasicMuxDataSource(this, this.outputCD);
            Integer n = this.sourceLock;
            synchronized (n) {
                this.sourceLock.notifyAll();
            }
        }
        return this.source;
    }

    private long getDuration(Buffer buffer) {
        AudioFormat audioFormat = (AudioFormat)buffer.getFormat();
        long l = audioFormat.computeDuration(buffer.getLength());
        if (l < 0L) {
            return 0L;
        }
        return l;
    }

    public long getMediaNanoseconds() {
        return this.clock.getMediaNanoseconds();
    }

    public Time getMediaTime() {
        return this.clock.getMediaTime();
    }

    public float getRate() {
        return this.clock.getRate();
    }

    public Time getStopTime() {
        return this.clock.getStopTime();
    }

    long getStreamSize() {
        return this.fileSize;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputs;
    }

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] formatArray) {
        return this.supportedOutputs;
    }

    public Time getSyncTime() {
        return this.clock.getSyncTime();
    }

    public TimeBase getTimeBase() {
        return this.clock.getTimeBase();
    }

    boolean isEOS() {
        return this.eos;
    }

    public Time mapToTimeBase(Time time) throws ClockStoppedException {
        return this.clock.mapToTimeBase(time);
    }

    boolean needsSeekable() {
        return false;
    }

    public void open() {
        int n;
        this.firstBuffer = true;
        this.firstBuffers = new Buffer[this.inputs.length];
        this.firstBuffersDone = new boolean[this.inputs.length];
        this.nonKeyCount = new int[this.inputs.length];
        this.mediaTime = new long[this.inputs.length];
        for (n = 0; n < this.inputs.length; ++n) {
            this.firstBuffers[n] = null;
            this.firstBuffersDone[n] = false;
            this.nonKeyCount[n] = 0;
            this.mediaTime[n] = 0L;
        }
        this.ready = new boolean[this.inputs.length];
        this.resetReady();
        int n2 = 0;
        this.mc = new MonitorAdapter[this.inputs.length];
        for (n = 0; n < this.inputs.length; ++n) {
            if (!(this.inputs[n] instanceof VideoFormat) && !(this.inputs[n] instanceof AudioFormat)) continue;
            this.mc[n] = new MonitorAdapter(this.inputs[n], this);
            if (this.mc[n] == null) continue;
            ++n2;
        }
        int n3 = 0;
        this.controls = new Control[n2 + 1];
        for (n = 0; n < this.mc.length; ++n) {
            if (this.mc[n] == null) continue;
            this.controls[n3++] = this.mc[n];
        }
        this.controls[n3] = this.swc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer buffer, int n) {
        Object object;
        if (buffer.isDiscard()) {
            return 0;
        }
        if (!this.isLiveData && (buffer.getFlags() & 0x8000) > 0) {
            this.isLiveData = true;
        }
        while (this.source == null || !this.source.isConnected() || !this.source.isStarted()) {
            object = this.sourceLock;
            synchronized (object) {
                try {
                    this.sourceLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.flushing) {
                    this.flushing = false;
                    buffer.setLength(0);
                    return 0;
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this.firstBuffer) {
                this.writeHeader();
                this.firstBuffer = false;
            }
        }
        if (this.numTracks > 1) {
            if ((buffer.getFlags() & 0x1000) != 0 && buffer.getTimeStamp() <= 0L) {
                return 0;
            }
            if (!this.startCompensated && !this.compensateStart(buffer, n)) {
                return 0;
            }
        }
        this.updateClock(buffer, n);
        if (this.mc[n] != null && this.mc[n].isEnabled()) {
            this.mc[n].process(buffer);
        }
        int n2 = this.doProcess(buffer, n);
        if (this.fileSizeLimitReached) {
            n2 |= 8;
        }
        return n2;
    }

    public boolean requireTwoPass() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        for (int i = 0; i < this.mediaTime.length; ++i) {
            this.mediaTime[i] = 0L;
            if (this.mc[i] == null) continue;
            this.mc[i].reset();
        }
        this.timeBase.update();
        this.resetReady();
        Integer n = this.sourceLock;
        synchronized (n) {
            this.flushing = true;
            this.sourceLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetReady() {
        for (int i = 0; i < this.ready.length; ++i) {
            this.ready[i] = false;
        }
        this.readyToStart = false;
        Object object = this.startup;
        synchronized (object) {
            this.startup.notifyAll();
        }
    }

    protected int seek(int n) {
        if (this.source == null || !this.source.isConnected()) {
            return n;
        }
        this.filePointer = this.stream.seek(n);
        return this.filePointer;
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor contentDescriptor) {
        if (BasicMux.matches(contentDescriptor, this.supportedOutputs) == null) {
            return null;
        }
        this.outputCD = contentDescriptor;
        return contentDescriptor;
    }

    public Format setInputFormat(Format format, int n) {
        this.inputs[n] = format;
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaTime(Time time) {
        Object object = this.timeSetSync;
        synchronized (object) {
            this.clock.setMediaTime(time);
            for (int i = 0; i < this.mediaTime.length; ++i) {
                this.mediaTime[i] = time.getNanoseconds();
            }
            this.timeBase.update();
        }
    }

    public int setNumTracks(int n) {
        this.numTracks = n;
        if (this.inputs == null) {
            this.inputs = new Format[n];
        } else {
            Format[] formatArray = new Format[n];
            for (int i = 0; i < this.inputs.length; ++i) {
                formatArray[i] = this.inputs[i];
            }
            this.inputs = formatArray;
        }
        return n;
    }

    public float setRate(float f) {
        if (f == this.clock.getRate()) {
            return f;
        }
        return this.clock.setRate(1.0f);
    }

    public void setStopTime(Time time) {
        this.clock.setStopTime(time);
    }

    void setStream(BasicMuxPushStream basicMuxPushStream) {
        this.stream = basicMuxPushStream;
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        if (timeBase != this.timeBase) {
            throw new IncompatibleTimeBaseException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            this.clock.stop();
            this.timeBase.mediaStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStart(Time time) {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.clock.syncStart(time);
            this.timeBase.mediaStarted();
            this.systemStartTime = System.currentTimeMillis() * 1000000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClock(Buffer buffer, int n) {
        long l;
        if (!this.readyToStart && this.numTracks > 1) {
            Object object = this.startup;
            synchronized (object) {
                this.ready[n] = true;
                if (this.checkReady()) {
                    this.startup.notifyAll();
                } else {
                    try {
                        while (!this.readyToStart) {
                            this.startup.wait(1000L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if ((l = buffer.getTimeStamp()) <= 0L && buffer.getFormat() instanceof AudioFormat) {
            l = this.mediaTime[n];
            int n2 = n;
            this.mediaTime[n2] = this.mediaTime[n2] + this.getDuration(buffer);
        } else {
            this.mediaTime[n] = l <= 0L ? System.currentTimeMillis() * 1000000L - this.systemStartTime : l;
        }
        this.timeBase.update();
    }

    protected int write(byte[] byArray, int n, int n2) {
        if (this.source == null || !this.source.isConnected()) {
            return n2;
        }
        if (n2 > 0) {
            this.filePointer += n2;
            if (this.filePointer > this.fileSize) {
                this.fileSize = this.filePointer;
            }
            if (this.fileSizeLimit > 0L && (long)this.fileSize >= this.fileSizeLimit) {
                this.fileSizeLimitReached = true;
            }
        }
        return this.stream.write(byArray, n, n2);
    }

    protected void writeFooter() {
    }

    protected void writeHeader() {
    }

    class SWC
    implements StreamWriterControl,
    Owned {
        private BasicMux bmx;

        public SWC(BasicMux basicMux2) {
            this.bmx = basicMux2;
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return this.bmx;
        }

        public long getStreamSize() {
            return this.bmx.getStreamSize();
        }

        public boolean setStreamSizeLimit(long l) {
            this.bmx.fileSizeLimit = l;
            return BasicMux.this.streamSizeLimitSupported;
        }
    }

    class BasicMuxTimeBase
    extends MediaTimeBase {
        long ticks = 0L;
        boolean updated = false;

        BasicMuxTimeBase() {
        }

        public long getMediaTime() {
            if (!this.updated) {
                return this.ticks;
            }
            if (BasicMux.this.mediaTime.length == 1) {
                this.ticks = BasicMux.this.mediaTime[0];
            } else {
                this.ticks = BasicMux.this.mediaTime[0];
                for (int i = 1; i < BasicMux.this.mediaTime.length; ++i) {
                    if (BasicMux.this.mediaTime[i] >= this.ticks) continue;
                    this.ticks = BasicMux.this.mediaTime[i];
                }
            }
            this.updated = false;
            return this.ticks;
        }

        public void update() {
            this.updated = true;
        }
    }

    class BasicMuxPushStream
    implements PushSourceStream {
        private ContentDescriptor cd;
        private byte[] data;
        private int dataLen;
        private int dataOff;
        private Integer writeLock = new Integer(0);

        public BasicMuxPushStream(ContentDescriptor contentDescriptor) {
            this.cd = contentDescriptor;
        }

        public boolean endOfStream() {
            return BasicMux.this.isEOS();
        }

        public ContentDescriptor getContentDescriptor() {
            return this.cd;
        }

        public long getContentLength() {
            return -1L;
        }

        public Object getControl(String string) {
            return null;
        }

        public Object[] getControls() {
            return new Control[0];
        }

        public int getMinimumTransferSize() {
            return this.dataLen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            Integer n4 = this.writeLock;
            synchronized (n4) {
                if (this.dataLen == -1) {
                    n3 = -1;
                } else {
                    n3 = n2 >= this.dataLen ? this.dataLen : n2;
                    System.arraycopy(this.data, this.dataOff, byArray, n, n3);
                    this.dataLen -= n3;
                    this.dataOff += n3;
                }
                this.writeLock.notifyAll();
                return n3;
            }
        }

        synchronized int seek(int n) {
            if (BasicMux.this.sth != null) {
                ((Seekable)((Object)BasicMux.this.sth)).seek(n);
                int n2 = (int)((Seekable)((Object)BasicMux.this.sth)).tell();
                return n2;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTransferHandler(SourceTransferHandler sourceTransferHandler) {
            Integer n = this.writeLock;
            synchronized (n) {
                BasicMux.this.sth = sourceTransferHandler;
                if (sourceTransferHandler != null && BasicMux.this.needsSeekable() && !(sourceTransferHandler instanceof Seekable)) {
                    throw new Error("SourceTransferHandler needs to be seekable");
                }
                boolean bl = BasicMux.this.requireTwoPass();
                if (bl && sourceTransferHandler != null && sourceTransferHandler instanceof RandomAccess) {
                    RandomAccess randomAccess = (RandomAccess)((Object)sourceTransferHandler);
                    randomAccess.setEnabled(true);
                }
                this.writeLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized int write(byte[] byArray, int n, int n2) {
            if (BasicMux.this.sth == null) {
                return 0;
            }
            if (BasicMux.this.isLiveData && BasicMux.this.sth instanceof Syncable) {
                ((Syncable)((Object)BasicMux.this.sth)).setSyncEnabled();
            }
            Integer n3 = this.writeLock;
            synchronized (n3) {
                this.data = byArray;
                this.dataOff = n;
                this.dataLen = n2;
                BasicMux.this.sth.transferData(this);
                while (this.dataLen > 0) {
                    if (this.dataLen == n2) {
                        try {
                            this.writeLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (BasicMux.this.sth == null) break;
                    if (this.dataLen <= 0 || this.dataLen == n2) continue;
                    n2 = this.dataLen;
                    BasicMux.this.sth.transferData(this);
                }
            }
            return n2;
        }
    }

    class BasicMuxDataSource
    extends PushDataSource {
        private BasicMux mux;
        private ContentDescriptor cd;
        private BasicMuxPushStream[] streams;
        private BasicMuxPushStream stream;
        private boolean connected = false;
        private boolean started = false;

        public BasicMuxDataSource(BasicMux basicMux2, ContentDescriptor contentDescriptor) {
            this.cd = contentDescriptor;
            this.mux = basicMux2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect() throws IOException {
            if (this.streams == null) {
                this.getStreams();
            }
            this.connected = true;
            Integer n = BasicMux.this.sourceLock;
            synchronized (n) {
                BasicMux.this.sourceLock.notifyAll();
            }
        }

        public void disconnect() {
            this.connected = false;
        }

        public String getContentType() {
            return this.cd.getContentType();
        }

        public Object getControl(String string) {
            return null;
        }

        public Object[] getControls() {
            return new Control[0];
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }

        public PushSourceStream[] getStreams() {
            if (this.streams == null) {
                this.streams = new BasicMuxPushStream[1];
                this.streams[0] = this.stream = new BasicMuxPushStream(this.cd);
                BasicMux.this.setStream(this.stream);
            }
            return this.streams;
        }

        boolean isConnected() {
            return this.connected;
        }

        boolean isStarted() {
            return this.started;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() throws IOException {
            if (this.streams == null || !this.connected) {
                throw new IOException("Source not connected yet!");
            }
            this.started = true;
            Integer n = BasicMux.this.sourceLock;
            synchronized (n) {
                BasicMux.this.sourceLock.notifyAll();
            }
        }

        public void stop() {
            this.started = false;
        }
    }
}

