/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import net.sf.fmj.media.AbstractMultiplexer;
import net.sf.fmj.media.multiplexer.BigPipedInputStream;
import net.sf.fmj.media.multiplexer.InputStreamPushDataSource;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class AbstractInputStreamMux
extends AbstractMultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private PipedInputStream pipedInputStream;
    private PipedOutputStream pipedOutputStream;
    private InputStreamPushDataSource dataOutput;
    private final ContentDescriptor contentDescriptor;
    private static final int PIPE_SIZE = 200000;

    public AbstractInputStreamMux(ContentDescriptor contentDescriptor) {
        this.contentDescriptor = contentDescriptor;
    }

    public void close() {
        logger.finer(this.getClass().getSimpleName() + " close");
        super.close();
        if (this.dataOutput != null) {
            try {
                this.dataOutput.stop();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
            }
            this.dataOutput.disconnect();
        }
    }

    protected InputStreamPushDataSource createInputStreamPushDataSource(ContentDescriptor contentDescriptor, int n, InputStream[] inputStreamArray) {
        return new InputStreamPushDataSource(contentDescriptor, n, inputStreamArray);
    }

    protected void doProcess(Buffer buffer, int n, OutputStream outputStream) throws IOException {
        if (buffer.isEOM()) {
            outputStream.close();
            return;
        }
        outputStream.write((byte[])buffer.getData(), buffer.getOffset(), buffer.getLength());
    }

    public DataSource getDataOutput() {
        if (this.dataOutput == null) {
            this.dataOutput = this.createInputStreamPushDataSource(this.outputContentDescriptor, 1, new InputStream[]{this.pipedInputStream});
        }
        logger.finer(this.getClass().getSimpleName() + " getDataOutput");
        return this.dataOutput;
    }

    protected InputStreamPushDataSource getDataOutputNoInit() {
        return this.dataOutput;
    }

    protected OutputStream getOutputStream() {
        return this.pipedOutputStream;
    }

    public abstract Format[] getSupportedInputFormats();

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] formatArray) {
        return new ContentDescriptor[]{this.contentDescriptor};
    }

    public void open() throws ResourceUnavailableException {
        logger.finer(this.getClass().getSimpleName() + " open");
        super.open();
    }

    public int process(Buffer buffer, int n) {
        logger.finer(this.getClass().getSimpleName() + " process " + buffer + " " + n + " length " + buffer.getLength());
        try {
            this.doProcess(buffer, n, this.pipedOutputStream);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "" + iOException, iOException);
            return 1;
        }
        if (this.dataOutput != null) {
            this.dataOutput.notifyDataAvailable(0);
        }
        return 0;
    }

    public int setNumTracks(int n) {
        n = super.setNumTracks(n);
        try {
            this.pipedInputStream = new BigPipedInputStream(200000);
            this.pipedOutputStream = new PipedOutputStream(this.pipedInputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return n;
    }

    protected void writeInt(OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[]{(byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        outputStream.write(byArray, 0, byArray.length);
    }
}

